/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.ArrayNodeList;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeList;
import com.adobe.xfa.Obj;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.ResId;

public final class ElementNodeList
extends NodeList {
    private final Element mElement;
    private Node mLastNode;
    private int mLastPosn;
    private int mLength;

    ElementNodeList(Element e) {
        this.mElement = e;
        this.reset();
    }

    @Override
    public void append(Obj newNode) {
        if (this.isReadOnly() || newNode == null) {
            return;
        }
        if (!(newNode instanceof Node)) {
            throw new ExFull(ResId.ArgumentMismatchException);
        }
        this.mElement.appendChild((Node)newNode, true);
        this.reset();
    }

    @Override
    public Object clone() {
        return new ArrayNodeList(this.mElement);
    }

    @Override
    public String getClassAtom() {
        return "nodeList";
    }

    @Override
    public String getClassName() {
        return "nodeList";
    }

    @Override
    public Node getNamedItem(String name) {
        if (name == null) {
            return null;
        }
        String aName = name.intern();
        for (Node child = this.mElement.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (aName != child.getName()) continue;
            return child;
        }
        return null;
    }

    @Override
    public Node getNamedItem(String aName, String aClassName, int nTargetOccurrence) {
        if (aName == null && aClassName == null) {
            return null;
        }
        int nOccurrence = 0;
        for (Node tmp = this.mElement.getFirstXFAChild(); tmp != null; tmp = tmp.getNextXFASibling()) {
            boolean bMatched = false;
            if (aName != null && aClassName != null) {
                if (aClassName == tmp.getClassAtom() && aName == tmp.getPrivateName()) {
                    bMatched = true;
                }
            } else if (aClassName != null && aClassName == tmp.getClassAtom()) {
                bMatched = true;
            } else if (aName != null && aName == tmp.getPrivateName()) {
                bMatched = true;
            }
            if (!bMatched) continue;
            if (nOccurrence == nTargetOccurrence) {
                return tmp;
            }
            ++nOccurrence;
        }
        return null;
    }

    @Override
    Integer getOccurrence(Node oNode) {
        int nOccurrence = 0;
        String aName = oNode.getName();
        String aClassName = oNode.getClassAtom();
        for (Node child = this.mElement.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (aClassName != child.getClassAtom() || aName != child.getName()) continue;
            if (oNode == child) {
                return nOccurrence;
            }
            ++nOccurrence;
        }
        return null;
    }

    @Override
    public void insert(Obj newNode, Obj refNode) {
        if (this.isReadOnly() || newNode == null) {
            return;
        }
        if (refNode == null) {
            throw new ExFull(ResId.InsertFailedException);
        }
        if (!(newNode instanceof Node)) {
            throw new ExFull(ResId.ArgumentMismatchException);
        }
        if (!(refNode instanceof Node)) {
            throw new ExFull(ResId.ArgumentMismatchException);
        }
        this.mElement.insertChild((Node)newNode, (Node)refNode, true);
        this.reset();
    }

    @Override
    public Obj item(int index) {
        if (index < this.mLastPosn) {
            this.mLastPosn = 0;
            this.mLastNode = this.mElement.getFirstXFAChild();
        }
        while (index >= this.mLastPosn) {
            if (index == this.mLastPosn) {
                return this.mLastNode;
            }
            this.mLastNode = this.mLastNode.getNextXFASibling();
            ++this.mLastPosn;
        }
        return null;
    }

    @Override
    public int length() {
        if (this.mLength == -1) {
            this.mLength = 0;
            for (Node child = this.mElement.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                ++this.mLength;
            }
        }
        return this.mLength;
    }

    @Override
    public void remove(Obj removeNode) {
        if (this.isReadOnly() || removeNode == null) {
            return;
        }
        if (!(removeNode instanceof Node)) {
            throw new ExFull(ResId.ArgumentMismatchException);
        }
        Node node = (Node)removeNode;
        if (node.getXFAParent() != this.mElement) {
            throw new ExFull(ResId.RemoveFailedException);
        }
        node.remove();
        this.reset();
    }

    private void reset() {
        this.mLastNode = this.mElement.getFirstXFAChild();
        this.mLastPosn = 0;
        this.mLength = -1;
    }

    @Override
    boolean appendPermsCheck() {
        return this.mElement == null || this.mElement.checkAncestorPerms();
    }

    @Override
    boolean removePermsCheck(Obj obj) {
        Node node;
        if (this.mElement != null && !this.mElement.checkAncestorPerms()) {
            return false;
        }
        return !(obj instanceof Node) || (node = (Node)obj).checkDescendentPerms();
    }

    @Override
    boolean insertPermsCheck() {
        return this.mElement == null || this.mElement.checkAncestorPerms();
    }
}

