/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.Obj;
import com.adobe.xfa.ut.DoubleHolder;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.IntegerHolder;
import com.adobe.xfa.ut.MsgFormat;
import com.adobe.xfa.ut.Numeric;
import com.adobe.xfa.ut.ResId;

public final class Arg {
    public static final int NULL = 2;
    public static final int BOOL = 3;
    public static final int DOUBLE = 5;
    public static final int EMPTY = 1;
    public static final int EXCEPTION = 8;
    public static final int INTEGER = 4;
    static final String gsEmpty = "Empty";
    static final String gsError = "Error:";
    static final String gsFalse = "False";
    static final String gsNull = "Null";
    static final String gsObject = "Object";
    static final String gsTrue = "True";
    static final String gsVoidPtr = "Pointer:";
    public static final int INVALID = 0;
    public static final int OBJECT = 7;
    public static final int STRING = 6;
    public static final int VOIDPTR = 9;
    private Object mArg;
    private int mType;
    private boolean mbIsRef = false;
    private boolean mbIsXFAProp = false;

    public Arg() {
        this.mType = 1;
    }

    public Arg(Arg src) {
        this.assign(src);
    }

    public void assign(Arg src) {
        if (this.mType != 1) {
            this.empty();
        }
        this.mType = src.mType;
        this.mArg = src.mArg;
        this.mbIsRef = src.mbIsRef;
    }

    private boolean coerceToDouble(DoubleHolder n, boolean bStrongTyping) {
        if (this.mType != 5) {
            if (this.mType == 4) {
                n.value = ((Integer)this.mArg).doubleValue();
                return true;
            }
            if (this.mType == 6) {
                n.value = Numeric.stringToDouble((String)this.mArg, false);
                return !bStrongTyping || !Double.isNaN(n.value) && !Double.isInfinite(n.value);
            }
            return false;
        }
        n.value = (Double)this.mArg;
        return true;
    }

    private boolean coerceToInt(IntegerHolder n) {
        if (this.mType != 4) {
            if (this.mType == 5 && (Double)this.mArg == (double)((Double)this.mArg).intValue()) {
                n.value = ((Double)this.mArg).intValue();
                return true;
            }
            if (this.mType == 6) {
                try {
                    n.value = Integer.parseInt((String)this.mArg);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            return false;
        }
        n.value = (Integer)this.mArg;
        return true;
    }

    public void empty() {
        this.mArg = null;
        this.mType = 1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        Arg src = (Arg)object;
        if (this.mType != src.mType) {
            return false;
        }
        return this.mArg.equals(src);
    }

    public int hashCode() {
        int hash = 79;
        if (this.mArg != null) {
            hash = hash * 31 ^ this.mArg.hashCode();
        }
        hash = hash * 31 ^ this.mType;
        return hash;
    }

    public int getArgType() {
        return this.mType;
    }

    public Boolean getAsBool(boolean bThrowException) {
        switch (this.getArgType()) {
            case 1: 
            case 2: {
                return Boolean.FALSE;
            }
            case 3: {
                return this.getBool();
            }
            case 4: {
                return this.getInteger() != 0;
            }
            case 5: {
                return this.getDouble(false) != 0.0;
            }
            case 6: {
                String sTmp = this.getString();
                if (sTmp.length() == 0) {
                    return Boolean.FALSE;
                }
                try {
                    int nNum = Integer.parseInt(sTmp);
                    return nNum != 0;
                }
                catch (NumberFormatException n) {
                    return Boolean.FALSE;
                }
            }
            case 7: {
                return this.getObject() != null;
            }
            case 9: {
                return this.getVoid(false) != null;
            }
            case 8: {
                if (!bThrowException) {
                    return Boolean.FALSE;
                }
                String sException = this.getException().toString();
                throw new ExFull(new MsgFormat(gsError, sException));
            }
        }
        assert (false);
        return Boolean.FALSE;
    }

    public String getAsString(boolean bThrowException) {
        switch (this.getArgType()) {
            case 1: {
                return gsEmpty;
            }
            case 2: {
                return gsNull;
            }
            case 3: {
                return this.getBool() != false ? gsTrue : gsFalse;
            }
            case 4: {
                return ((Integer)this.mArg).toString();
            }
            case 5: {
                return Numeric.doubleToString((Double)this.mArg, 8, true);
            }
            case 6: {
                return this.getString();
            }
            case 7: {
                int h = System.identityHashCode(this.mArg);
                return gsObject + h;
            }
            case 9: {
                return this.getVoid(false).toString();
            }
            case 8: {
                String sException = this.getException().toString();
                if (!bThrowException) {
                    return gsError + sException;
                }
                throw new ExFull(new MsgFormat(gsError, sException));
            }
        }
        assert (false);
        return "";
    }

    public Boolean getBool() {
        if (this.mType != 3) {
            boolean bRet = this.getDouble(false) != 0.0;
            return bRet;
        }
        return (Boolean)this.mArg;
    }

    public Double getDouble(boolean bStrongTyping) {
        DoubleHolder d = new DoubleHolder();
        if (!this.coerceToDouble(d, bStrongTyping)) {
            throw new ExFull(ResId.ArgumentMismatchException);
        }
        return d.value;
    }

    public ExFull getException() {
        if (this.mType != 8) {
            throw new ExFull(ResId.ArgumentMismatchException);
        }
        return (ExFull)this.mArg;
    }

    public Integer getInteger() {
        IntegerHolder n = new IntegerHolder();
        if (!this.coerceToInt(n)) {
            throw new ExFull(ResId.ArgumentMismatchException);
        }
        return n.value;
    }

    public Obj getObject() {
        if (this.mType != 7) {
            throw new ExFull(ResId.ArgumentMismatchException);
        }
        return (Obj)this.mArg;
    }

    public String getString() {
        if (this.mType == 6) {
            return (String)this.mArg;
        }
        if (this.mType == 1) {
            return "";
        }
        throw new ExFull(ResId.ArgumentMismatchException);
    }

    public Object getVoid(boolean bThrowException) {
        if (this.mType != 9) {
            if (bThrowException) {
                throw new ExFull(ResId.ArgumentMismatchException);
            }
            return null;
        }
        return this.mArg;
    }

    public boolean isCompatibleWith(int eType) {
        if (this.mType == eType) {
            return true;
        }
        DoubleHolder d = new DoubleHolder();
        IntegerHolder i = new IntegerHolder();
        switch (eType) {
            case 9: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
            case 7: {
                return false;
            }
            case 8: {
                return false;
            }
            case 6: {
                return this.mType == 1;
            }
            case 3: {
                return this.coerceToDouble(d, false);
            }
            case 4: {
                return this.coerceToInt(i);
            }
            case 5: {
                return this.coerceToDouble(d, false);
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.mType == 1;
    }

    public void setBool(Boolean b) {
        this.empty();
        this.mType = 3;
        this.mArg = b;
    }

    public void setDouble(Double d) {
        this.empty();
        this.mType = 5;
        this.mArg = d;
    }

    public void setException(ExFull ex) {
        this.empty();
        this.mType = 8;
        this.mArg = ex;
    }

    public void setInteger(Integer i) {
        this.empty();
        this.mType = 4;
        this.mArg = i;
    }

    public void setNull() {
        this.empty();
        this.mType = 2;
    }

    public void setObject(Obj obj) {
        this.setObject(obj, false);
    }

    public void setObject(Obj obj, boolean bIsRef) {
        this.setObject(obj, bIsRef, false);
    }

    public void setObject(Obj obj, boolean bIsRef, boolean bIsProp) {
        this.empty();
        this.mType = 7;
        this.mArg = obj;
        this.mbIsRef = bIsRef;
        this.mbIsXFAProp = bIsProp;
    }

    public void setString(String s) {
        this.empty();
        this.mType = 6;
        this.mArg = s;
    }

    public void setVoid(Object oData) {
        this.empty();
        this.mType = 9;
        this.mArg = oData;
    }

    public boolean isRefObject() {
        return this.mType == 7 && this.mbIsRef;
    }

    public boolean isXFAProperty() {
        return this.mType == 7 && this.mbIsXFAProp;
    }
}

