/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.util;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Random;

public final class UUID {
    private static String mFakeMACAddress = null;
    private static Random mSeeder = null;

    private UUID() {
    }

    public static String createUUID() {
        if (mFakeMACAddress == null) {
            byte[] macBytes = new byte[6];
            mSeeder.nextBytes(macBytes);
            BigInteger bi = new BigInteger(1, macBytes);
            String macStr = bi.toString(16);
            mFakeMACAddress = UUID.padHex(macStr, 12) + macStr;
        }
        byte[] timeLow = new byte[4];
        byte[] timeMid = new byte[2];
        byte[] timeHighAndVersion = new byte[2];
        byte[] clockSeqHiAndReserved = new byte[1];
        byte[] clockSeqLow = new byte[1];
        mSeeder.nextBytes(timeLow);
        mSeeder.nextBytes(timeMid);
        mSeeder.nextBytes(timeHighAndVersion);
        mSeeder.nextBytes(clockSeqHiAndReserved);
        mSeeder.nextBytes(clockSeqLow);
        clockSeqHiAndReserved[0] = (byte)(clockSeqHiAndReserved[0] & 0x3F);
        clockSeqHiAndReserved[0] = (byte)(clockSeqHiAndReserved[0] | 0x50);
        timeHighAndVersion[0] = (byte)(timeHighAndVersion[0] & 0xF);
        timeHighAndVersion[0] = (byte)(timeHighAndVersion[0] | 0x28);
        StringBuilder uuid = new StringBuilder("uuid:").append(UUID.hexFormat(UUID.getInt(timeLow), 8)).append('-').append(UUID.hexFormat(UUID.getInt(timeMid), 4)).append('-').append(UUID.hexFormat(UUID.getInt(timeHighAndVersion), 4)).append('-').append(UUID.hexFormat(UUID.getInt(clockSeqHiAndReserved), 2)).append(UUID.hexFormat(UUID.getInt(clockSeqLow), 2)).append('-').append(mFakeMACAddress);
        return uuid.toString();
    }

    private static int getInt(byte[] bytes) {
        int i = 0;
        int j = 8 * (bytes.length - 1);
        int k = 0;
        while (j >= 0) {
            int l = bytes[k] & 0xFF;
            i += l << j;
            j -= 8;
            ++k;
        }
        return i;
    }

    private static String hexFormat(int i, int j) {
        String s = Integer.toHexString(i);
        return UUID.padHex(s, j) + s;
    }

    private static String padHex(String s, int i) {
        StringBuilder tmpBuffer = new StringBuilder();
        if (s.length() < i) {
            for (int j = 0; j < i - s.length(); ++j) {
                tmpBuffer.append('0');
            }
        }
        return tmpBuffer.toString();
    }

    static {
        try {
            mSeeder = SecureRandom.getInstance("FIPS186PRNG", "JsafeJCE");
        }
        catch (NoSuchAlgorithmException e) {
            mSeeder = new SecureRandom();
        }
        catch (NoSuchProviderException e) {
            mSeeder = new SecureRandom();
        }
    }
}

