/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.util;

import com.adobe.internal.util.ArrayListStack;
import com.adobe.internal.util.BitwiseOperandEvaluator;
import com.adobe.internal.util.InvalidOperandException;
import com.adobe.internal.util.MalformedExpressionException;
import java.util.EmptyStackException;
import java.util.StringTokenizer;

public class BitwiseExpression {
    private BitwiseOperandEvaluator m_OperandEvaluator;
    private ArrayListStack m_OperandStack = new ArrayListStack();
    private ArrayListStack m_OperatorStack = new ArrayListStack();

    public BitwiseExpression(BitwiseOperandEvaluator operandEval) {
        this.m_OperandEvaluator = operandEval;
    }

    public boolean evaluateExpression(String expression) throws MalformedExpressionException, InvalidOperandException {
        StringTokenizer value = new StringTokenizer(expression, "|&()", true);
        int paranthesisCount = 0;
        int result = 48;
        while (value.hasMoreTokens()) {
            String token = value.nextToken();
            if (" ".equals(token)) continue;
            if ("|".equals(token)) {
                this.m_OperatorStack.push(Character.valueOf('|'));
                continue;
            }
            if ("&".equals(token)) {
                this.m_OperatorStack.push(Character.valueOf('&'));
                continue;
            }
            if ("(".equals(token)) {
                ++paranthesisCount;
                continue;
            }
            if (")".equals(token)) {
                result = this.evaluteExp();
                --paranthesisCount;
                continue;
            }
            boolean bRet = this.m_OperandEvaluator.evaluate(token);
            if (bRet) {
                this.m_OperandStack.push(Character.valueOf('1'));
                continue;
            }
            this.m_OperandStack.push(Character.valueOf('0'));
        }
        if (paranthesisCount != 0) {
            throw new MalformedExpressionException("Invalid expression. Not well formed.");
        }
        while (this.m_OperatorStack.size() > 0) {
            result = this.evaluteExp();
        }
        if (this.m_OperandStack.size() > 0) {
            result = ((Character)this.m_OperandStack.pop()).charValue();
        }
        return result != 48;
    }

    private char evaluteExp() throws MalformedExpressionException {
        Character operand1 = null;
        Character operand2 = null;
        Character operator2 = null;
        char result = '0';
        try {
            operand1 = (Character)this.m_OperandStack.pop();
        }
        catch (EmptyStackException e) {
            throw new MalformedExpressionException("Invalid expression. Not well formed.", e);
        }
        try {
            operator2 = (Character)this.m_OperatorStack.pop();
            try {
                operand2 = (Character)this.m_OperandStack.pop();
            }
            catch (EmptyStackException e) {
                throw new MalformedExpressionException("Invalid expression. Not well formed.", e);
            }
            if (operator2.charValue() == '|') {
                result = (char)(operand1.charValue() | operand2.charValue());
            }
            if (operator2.charValue() == '&') {
                result = (char)(operand1.charValue() & operand2.charValue());
            }
        }
        catch (EmptyStackException e) {
            result = ((Character)this.m_OperandStack.pop()).charValue();
        }
        if (result == '0') {
            this.m_OperandStack.push(Character.valueOf('0'));
        } else {
            this.m_OperandStack.push(Character.valueOf('1'));
        }
        return result;
    }
}

