/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.types;

import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import java.io.IOException;

public class ASMatrix
extends ASObject {
    protected double a;
    protected double b;
    protected double c;
    protected double d;
    protected double x;
    protected double y;
    protected ASMatrix inverseTransform;
    private static ASMatrix gIdentityMatrix = new ASMatrix();
    private static final double Deg2Rad = Math.PI / 180;

    public static ASMatrix createIdentityMatrix() {
        return gIdentityMatrix;
    }

    private ASMatrix() {
        this.d = 1.0;
        this.a = 1.0;
        this.y = 0.0;
        this.x = 0.0;
        this.c = 0.0;
        this.b = 0.0;
        this.inverseTransform = this;
    }

    public ASMatrix(double a, double b, double c, double d, double x, double y) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.x = x;
        this.y = y;
        this.inverseTransform = null;
    }

    public ASMatrix(double[] array) {
        this.a = array[0];
        this.b = array[1];
        this.c = array[2];
        this.d = array[3];
        this.x = array[4];
        this.y = array[5];
        this.inverseTransform = null;
    }

    public ASMatrix(ASMatrix B) {
        this.a = B.a;
        this.b = B.b;
        this.c = B.c;
        this.d = B.d;
        this.x = B.x;
        this.y = B.y;
        this.inverseTransform = B.inverseTransform;
    }

    public double geta() {
        return this.a;
    }

    public double getb() {
        return this.b;
    }

    public double getc() {
        return this.c;
    }

    public double getd() {
        return this.d;
    }

    public double getx() {
        return this.x;
    }

    public double gety() {
        return this.y;
    }

    public double[] getValues() {
        double[] matrix = new double[]{this.a, this.b, this.c, this.d, this.x, this.y};
        return matrix;
    }

    public boolean equals(ASMatrix t) {
        return t != null && this.a == t.a && this.b == t.b && this.c == t.c && this.d == t.d && this.x == t.x && this.y == t.y;
    }

    public boolean isIdentity() {
        return this.a == 1.0 && this.d == 1.0 && this.b == 0.0 && this.c == 0.0;
    }

    public boolean isIdentity6x6() {
        return this.a == 1.0 && this.d == 1.0 && this.b == 0.0 && this.c == 0.0 && this.x == 0.0 && this.y == 0.0;
    }

    public boolean isInvertable() {
        double descrim = this.b * this.c - this.a * this.d;
        return !Double.isNaN(descrim) && !Double.isInfinite(descrim) && descrim != 0.0;
    }

    public ASMatrix rotate(double angle) {
        double co = Math.cos(angle);
        double si = Math.sin(angle);
        return this.concat(new ASMatrix(co, si, -si, co, 0.0, 0.0));
    }

    public ASMatrix scale(double sx, double sy) {
        return new ASMatrix(this.a * sx, this.b * sy, this.c * sx, this.d * sy, this.x * sx, this.y * sy);
    }

    public ASMatrix scale(double x) {
        return this.scale(x, x);
    }

    public ASMatrix preScale(double sx, double sy) {
        return new ASMatrix(this.a * sx, this.b * sx, this.c * sy, this.d * sy, this.x, this.y);
    }

    public ASMatrix preScale(double x) {
        return this.preScale(x, x);
    }

    public ASMatrix translate(double h, double v) {
        return new ASMatrix(this.a, this.b, this.c, this.d, this.x + h, this.y + v);
    }

    public ASMatrix preMultiply(double h, double v) {
        return new ASMatrix(this.a, this.b, this.c, this.d, this.x + this.a * h + this.c * v, this.y + this.b * h + this.d * v);
    }

    public ASMatrix setTranslate(double h, double v) {
        return new ASMatrix(this.a, this.b, this.c, this.d, h, v);
    }

    public ASMatrix setItalicDegrees(double angle) {
        if (angle == 0.0) {
            return this;
        }
        return new ASMatrix(this.a, this.b, Math.sin(angle * (Math.PI / 180)) * this.a + this.c, this.d, this.x, this.y);
    }

    public void mult(double px, double py, double[] output) {
        output[0] = this.a * px + this.c * py + this.x;
        output[1] = this.b * px + this.d * py + this.y;
    }

    public double multGetX(double px, double py) {
        return this.a * px + this.c * py + this.x;
    }

    public double multGetY(double px, double py) {
        return this.b * px + this.d * py + this.y;
    }

    public ASMatrix concat(ASMatrix A) {
        double newa = this.a * A.a + this.b * A.c;
        double newc = this.c * A.a + this.d * A.c;
        double newx = this.x * A.a + this.y * A.c + A.x;
        double newb = this.a * A.b + this.b * A.d;
        double newd = this.c * A.b + this.d * A.d;
        double newy = this.x * A.b + this.y * A.d + A.y;
        return new ASMatrix(newa, newb, newc, newd, newx, newy);
    }

    public ASMatrix getInverse() throws PDFInvalidParameterException {
        if (this.inverseTransform == null) {
            double descrim = 1.0 / (this.b * this.c - this.a * this.d);
            double newa = -this.d * descrim;
            double newb = this.b * descrim;
            double newc = this.c * descrim;
            double newd = -this.a * descrim;
            double newx = -(this.x * newa + this.y * newc);
            double newy = -(this.x * newb + this.y * newd);
            if (Double.isNaN(newa) || Double.isInfinite(newa) || Double.isNaN(newb) || Double.isInfinite(newb) || Double.isNaN(newc) || Double.isInfinite(newc) || Double.isNaN(newd) || Double.isInfinite(newd) || Double.isNaN(newx) || Double.isInfinite(newx) || Double.isNaN(newy) || Double.isInfinite(newy)) {
                throw new PDFInvalidParameterException("Singular matrix passed to invert: " + this.a + " " + this.b + " " + this.c + " " + this.d + " " + this.x + " " + this.y);
            }
            this.inverseTransform = new ASMatrix(newa, newb, newc, newd, newx, newy);
            this.inverseTransform.inverseTransform = this;
        }
        return this.inverseTransform;
    }

    public String toString() {
        return "[ " + this.a + " " + this.b + " " + this.c + " " + this.d + " " + this.x + " " + this.y + " ]";
    }

    @Override
    public void write(OutputByteStream outputByteStream) throws PDFIOException {
        try {
            outputByteStream.write(this.toString().getBytes());
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public ASMatrix getUnitRotationMatrix() {
        double xDenominator = Math.sqrt(this.a * this.a + this.c * this.c);
        double yDenominator = Math.sqrt(this.b * this.b + this.d * this.d);
        if (xDenominator != 0.0 && yDenominator != 0.0) {
            return new ASMatrix(this.a / xDenominator, this.b / yDenominator, this.c / xDenominator, this.d / yDenominator, 0.0, 0.0);
        }
        return this;
    }
}

