/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.types;

import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import java.io.IOException;

public class ASBoolean
extends ASObject {
    private boolean value;

    public ASBoolean(boolean value) {
        this.value = value;
    }

    public boolean isTrue() {
        return this.value;
    }

    public boolean isFalse() {
        return !this.value;
    }

    @Override
    public void write(OutputByteStream outputByteStream) throws PDFIOException {
        try {
            if (this.isTrue()) {
                outputByteStream.write("true".getBytes());
            } else {
                outputByteStream.write("false".getBytes());
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public String toString() {
        return this.value ? "true" : "false";
    }
}

