/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.filter;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.SimpleByteWriterFactory;
import com.adobe.internal.io.stream.IO;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.io.stream.StreamManager;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.filter.FilterParams;
import com.adobe.internal.pdftoolkit.core.filter.FilterStream;
import com.adobe.internal.pdftoolkit.core.filter.TIFFInputStream;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class TIFFCountingStreamWrapper {
    private Inflater mInflater = new Inflater();
    private FilterInputStream mFilterStream;

    public TIFFCountingStreamWrapper(InputStream inStm, CosDictionary paramsDict) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        FilterInputStream filterStream = new InflaterInputStream(inStm, this.mInflater);
        if (paramsDict != null) {
            FilterParams filterParams = FilterStream.buildFilterParams(paramsDict);
            filterStream = new TIFFInputStream(filterStream, filterParams);
        }
        this.mFilterStream = filterStream;
    }

    public TIFFCountingStreamWrapper(InputStream inStm, ASDictionary paramsDict) throws PDFInvalidParameterException {
        FilterInputStream filterStream = new InflaterInputStream(inStm, this.mInflater);
        if (paramsDict != null) {
            FilterParams filterParams = FilterStream.buildFilterParams(paramsDict);
            filterStream = new TIFFInputStream(filterStream, filterParams);
        }
        this.mFilterStream = filterStream;
    }

    public void copyData(OutputStream outStm) throws IOException {
        IO.copy((InputStream)this.mFilterStream, outStm);
        outStm.flush();
    }

    public InputByteStream getData() throws IOException {
        StreamManager streamManager = StreamManager.newInstance(new SimpleByteWriterFactory(), null);
        OutputByteStream outByteStm = streamManager.getUnregisteredOutputByteStream(ByteWriterFactory.Fixed.GROWABLE, 0);
        this.copyData(outByteStm.toOutputStream());
        return outByteStm.closeAndConvert();
    }

    public int getTotalIn() {
        return this.mInflater.getTotalIn();
    }

    public void close() throws IOException {
        this.mInflater.end();
        this.mFilterStream.close();
    }
}

