/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.filter;

class FlateTree {
    int[] freq;
    int[] code;
    int[] dad;
    int[] len;
    int elems;
    int max_code;
    int max_length;
    int opt_len;
    int[] extra_bits;
    int extra_base;
    FlateTree static_tree;
    short[] heap;
    short[] depth;
    int heap_len;
    int heap_max;

    public FlateTree(FlateTree s_tree, int treeSize, int elemSize, int maxlength, int[] bits, int base) {
        this.elems = elemSize;
        this.max_length = maxlength;
        this.static_tree = s_tree;
        this.extra_bits = bits;
        this.extra_base = base;
        this.code = new int[treeSize];
        this.freq = this.code;
        this.len = new int[treeSize];
        this.dad = this.len;
        this.heap = null;
        this.depth = null;
    }

    void InitStaticLTree() {
        int[] bl_count = new int[this.max_length + 1];
        for (int bits = 0; bits <= this.max_length; ++bits) {
            bl_count[bits] = 0;
        }
        int n = 0;
        while (n <= 143) {
            this.len[n++] = 8;
            bl_count[8] = bl_count[8] + 1;
        }
        while (n <= 255) {
            this.len[n++] = 9;
            bl_count[9] = bl_count[9] + 1;
        }
        while (n <= 279) {
            this.len[n++] = 7;
            bl_count[7] = bl_count[7] + 1;
        }
        while (n <= 287) {
            this.len[n++] = 8;
            bl_count[8] = bl_count[8] + 1;
        }
        this.max_code = this.elems + 1;
        this.gen_codes(bl_count);
    }

    void InitStaticDTree() {
        for (int n = 0; n < this.elems; ++n) {
            this.code[n] = this.bi_reverse(n, 5);
            this.len[n] = 5;
        }
    }

    void InitTree() {
        for (int i = 0; i < this.elems; ++i) {
            this.freq[i] = 0;
        }
        if (this.elems > 256) {
            this.freq[256] = 1;
        }
        this.opt_len = 0;
        if (this.static_tree != null) {
            this.static_tree.opt_len = 0;
        }
    }

    private int bi_reverse(int code, int len) {
        int res = 0;
        code <<= 1;
        while (len-- > 0) {
            res <<= 1;
            res |= (code >>>= 1) & 1;
        }
        return res;
    }

    private void gen_codes(int[] bl_count) {
        int[] next_code = new int[this.max_length + 1];
        int cv = 0;
        next_code[0] = 0;
        for (int bits = 1; bits <= this.max_length; ++bits) {
            next_code[bits] = cv = cv + bl_count[bits - 1] << 1;
        }
        for (int n = 0; n <= this.max_code; ++n) {
            int l = this.len[n];
            if (l == 0) continue;
            int n2 = l;
            int n3 = next_code[n2];
            next_code[n2] = n3 + 1;
            this.code[n] = this.bi_reverse(n3, l);
        }
    }

    private void gen_bitlen(int[] bl_count) {
        int n;
        int h;
        int overflow = 0;
        int bits = bl_count.length;
        while (bits-- > 0) {
            bl_count[bits] = 0;
        }
        this.len[this.heap[this.heap_max]] = 0;
        for (h = this.heap_max + 1; h < this.heap.length; ++h) {
            n = this.heap[h];
            bits = this.len[this.dad[n]] + 1;
            if (bits > this.max_length) {
                bits = this.max_length;
                ++overflow;
            }
            this.len[n] = bits;
            if (n > this.max_code) continue;
            int n2 = bits;
            bl_count[n2] = bl_count[n2] + 1;
            int xbits = 0;
            if (n >= this.extra_base) {
                xbits = this.extra_bits[n - this.extra_base];
            }
            int f = this.freq[n];
            this.opt_len += f * (bits + xbits);
            if (this.static_tree == null) continue;
            this.static_tree.opt_len += f * (this.static_tree.len[n] + xbits);
        }
        if (overflow == 0) {
            return;
        }
        do {
            bits = this.max_length - 1;
            while (bl_count[bits] == 0) {
                --bits;
            }
            int n3 = bits;
            bl_count[n3] = bl_count[n3] - 1;
            int n4 = bits + 1;
            bl_count[n4] = bl_count[n4] + 2;
            int n5 = this.max_length;
            bl_count[n5] = bl_count[n5] - 1;
        } while ((overflow -= 2) > 0);
        for (bits = this.max_length; bits != 0; --bits) {
            n = bl_count[bits];
            while (n != 0) {
                short m;
                if ((m = this.heap[--h]) > this.max_code) continue;
                if (this.len[m] != bits) {
                    this.opt_len += (bits - this.len[m]) * this.freq[m];
                    this.len[m] = bits;
                }
                --n;
            }
        }
    }

    private int pqremove() {
        short top = this.heap[1];
        this.heap[1] = this.heap[this.heap_len--];
        this.pqdownheap(1);
        return top;
    }

    private boolean smaller(int n, int m) {
        return this.freq[n] < this.freq[m] || this.freq[n] == this.freq[m] && this.depth[n] <= this.depth[m];
    }

    private void pqdownheap(int k) {
        short v = this.heap[k];
        for (int j = k << 1; j <= this.heap_len; j <<= 1) {
            if (j < this.heap_len && this.smaller(this.heap[j + 1], this.heap[j])) {
                ++j;
            }
            if (this.smaller(v, this.heap[j])) break;
            this.heap[k] = this.heap[j];
            k = j;
        }
        this.heap[k] = v;
    }

    void build_tree() {
        int node;
        int n;
        this.max_code = -1;
        this.heap_len = 0;
        this.heap_max = 2 * this.elems + 1;
        this.heap = new short[this.heap_max];
        this.depth = new short[this.heap_max];
        for (n = 0; n < this.elems; ++n) {
            if (this.freq[n] != 0) {
                this.max_code = n;
                this.heap[++this.heap_len] = (short)this.max_code;
                this.depth[n] = 0;
                continue;
            }
            this.len[n] = 0;
        }
        while (this.heap_len < 2) {
            int n2;
            ++this.heap_len;
            if (this.max_code < 2) {
                n2 = this.max_code + 1;
                this.max_code = this.max_code;
            } else {
                n2 = 0;
            }
            this.heap[this.heap_len] = (short)n2;
            node = this.heap[this.heap_len];
            this.freq[node] = 1;
            this.depth[node] = 0;
            --this.opt_len;
            if (this.static_tree == null) continue;
            this.static_tree.opt_len -= this.static_tree.len[node];
        }
        for (n = this.heap_len / 2; n >= 1; --n) {
            this.pqdownheap(n);
        }
        node = this.elems;
        do {
            n = this.pqremove();
            short m = this.heap[1];
            this.heap[--this.heap_max] = (short)n;
            this.heap[--this.heap_max] = m;
            this.freq[node] = this.freq[n] + this.freq[m];
            this.depth[node] = (short)(Math.max(this.depth[n], this.depth[m]) + 1);
            this.dad[n] = this.dad[m] = node;
            this.heap[1] = (short)node++;
            this.pqdownheap(1);
        } while (this.heap_len >= 2);
        this.heap[--this.heap_max] = this.heap[1];
        int[] bl_count = new int[this.max_length + 1];
        this.gen_bitlen(bl_count);
        this.gen_codes(bl_count);
        this.heap = null;
        this.depth = null;
    }
}

