/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.cos;

final class CosListLong {
    private static final int NUM_LOW_BITS = 5;
    private static final int BLOCK_SIZE = 32;
    private static final int BLOCK_SIZE_MASK = 31;
    private int mMasterBlockSize = 32;
    private long[][] mBlockList = new long[this.mMasterBlockSize][];

    CosListLong() {
    }

    void add(int index, long value) {
        long[] block;
        int blockIndex = index >> 5;
        if (blockIndex >= this.mMasterBlockSize) {
            int newSize;
            for (newSize = this.mMasterBlockSize; blockIndex >= newSize; newSize *= 2) {
            }
            long[][] newList = new long[newSize][];
            for (int i = 0; i < this.mMasterBlockSize; ++i) {
                newList[i] = this.mBlockList[i];
            }
            this.mMasterBlockSize = newSize;
            this.mBlockList = newList;
        }
        if ((block = this.mBlockList[blockIndex]) == null) {
            block = new long[32];
            this.mBlockList[blockIndex] = block;
        }
        block[index & 0x1F] = value;
    }

    long get(int index) {
        int blockIndex = index >> 5;
        if (blockIndex >= this.mMasterBlockSize) {
            return 0L;
        }
        long[] block = this.mBlockList[blockIndex];
        if (block == null) {
            return 0L;
        }
        return block[index & 0x1F];
    }
}

