/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io.stream;

import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.io.stream.ByteReaderInputByteStream;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStreamImpl;
import com.adobe.internal.io.stream.OutputStreamImpl;
import com.adobe.internal.io.stream.SkippingOutputStream;
import com.adobe.internal.io.stream.StreamManager;
import java.io.IOException;

class ByteWriterOutputByteStream
extends OutputByteStreamImpl {
    private ByteWriter byteWriter = null;
    private StreamManager streamManager;
    private boolean registered = false;

    ByteWriterOutputByteStream(StreamManager streamManager, ByteWriter byteWriter, boolean register) throws IOException {
        if (byteWriter == null) {
            throw new IOException("Null ByteWriter parameter.");
        }
        this.streamManager = streamManager;
        this.byteWriter = byteWriter;
        this.registered = register;
        if (register) {
            this.streamManager.registerOutputByteStream(this, byteWriter);
        }
    }

    ByteWriter getByteWriter() {
        return this.byteWriter;
    }

    @Override
    public void write(int b) throws IOException {
        this.byteWriter.write(this.getPosition(), b);
        this.seek(this.getPosition() + 1L);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        this.byteWriter.write(this.getPosition(), bytes, offset, length);
        this.seek(this.getPosition() + (long)length);
    }

    @Override
    public long length() throws IOException {
        return this.byteWriter.length();
    }

    @Override
    public boolean eof() throws IOException {
        return this.getPosition() >= this.byteWriter.length();
    }

    @Override
    public void close() throws IOException {
        if (this.registered) {
            this.streamManager.deregisterOutputByteStream(this, this.byteWriter);
        } else {
            this.byteWriter.close();
        }
        this.byteWriter = null;
    }

    @Override
    public InputByteStream closeAndConvert() throws IOException {
        ByteWriter br = this.byteWriter;
        ByteReaderInputByteStream ibs = new ByteReaderInputByteStream(this.streamManager, br, this.registered);
        if (this.registered) {
            this.streamManager.deregisterOutputByteStream(this, this.byteWriter);
        }
        this.byteWriter = null;
        return ibs;
    }

    @Override
    public void flush() throws IOException {
        this.byteWriter.flush();
    }

    @Override
    public SkippingOutputStream toOutputStream() throws IOException {
        return new OutputStreamImpl(this);
    }

    public String toString() {
        StringBuilder message = null;
        try {
            byte[] buf = new byte[1000];
            long position = Math.max(this.getPosition() - 1000L, 0L);
            long bytesRead = this.byteWriter.read(position, buf, 0, buf.length);
            message = new StringBuilder("OutputByteStream [ position = ").append(this.getPosition()).append(", limit = ").append(this.length()).append(" ] ").append(bytesRead == -1L ? "" : new String(buf, 0, (int)bytesRead, "US-ASCII"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return message.toString();
    }

    public void write(String s) throws IOException {
        char[] chars = s.toCharArray();
        byte[] bytes = new byte[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            bytes[i] = (byte)chars[i];
        }
        this.write(bytes);
    }
}

