/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends FilterInputStream {
    private long offset;

    public CountingInputStream(InputStream is) {
        super(is);
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        if (b != -1) {
            ++this.offset;
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = super.read(b, off, len);
        if (bytesRead > 0) {
            this.offset += (long)bytesRead;
        }
        return bytesRead;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int bytesRead = super.read(b);
        if (bytesRead > 0) {
            this.offset += (long)bytesRead;
        }
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        long bytesSkipped = super.skip(n);
        if (bytesSkipped > 0L) {
            this.offset += bytesSkipped;
        }
        return bytesSkipped;
    }

    public long getOffset() {
        return this.offset;
    }
}

