/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.workflow.core.event;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.core.exec.WorkflowImpl;
import com.adobe.granite.workflow.core.util.WorkflowUtil;
import com.adobe.granite.workflow.event.WorkflowEvent;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.Workflow;
import com.adobe.granite.workflow.exec.WorkflowData;
import com.adobe.granite.workflow.job.AbsoluteTimeoutHandler;
import com.adobe.granite.workflow.job.AbsoluteTimeoutHandlerProxy;
import com.adobe.granite.workflow.job.ExternalProcessJob;
import com.adobe.granite.workflow.job.TimeoutJob;
import com.adobe.granite.workflow.job.WorkflowJob;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.sling.api.SlingException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventPublishUtil {
    private static final Logger log = LoggerFactory.getLogger(EventPublishUtil.class);
    private EventAdmin eventAdmin;
    public static final String WORKFLOW_PAYLOAD_MODIFIED_EVENT = "WorkflowPayloadModified";
    public static final String PROP_OLD_PAYLOAD_PATH = "oldPayloadPath";
    public static final String PROP_PAYLOAD_PATH = "payloadPath";

    public EventPublishUtil(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    private static boolean isTransient(Workflow workflow) {
        Boolean isTransient = Boolean.FALSE;
        MetaDataMap metaMap = workflow.getWorkflowData().getMetaDataMap();
        isTransient = (Boolean)((Object)metaMap.get("isTransient", Boolean.class));
        log.trace("workflow.data.MetaDataMap.isTransient: {}", (Object)isTransient);
        return isTransient == null ? false : isTransient;
    }

    private void sendEvent(Dictionary<String, Object> props) {
        if (log.isDebugEnabled()) {
            log.debug("Sending workflow event of type " + props.get("EventType") + (props.get("WorkflowInstanceId") != null ? " for " + props.get("WorkflowInstanceId") : ""));
        }
        this.eventAdmin.postEvent(new WorkflowEvent(props));
    }

    public void publishModelDeployedEvent(String id, String version, String user) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("TimeStamp", new Date());
        ((Dictionary)properties).put("User", user);
        ((Dictionary)properties).put("EventType", "ModelDeployed");
        ((Dictionary)properties).put("WorkflowName", id);
        if (version != null) {
            ((Dictionary)properties).put("WorkflowVersion", version);
        } else {
            log.warn("No version specified");
        }
        this.sendEvent(properties);
    }

    public void publishModelDeletedEvent(String id, String user) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("TimeStamp", new Date());
        ((Dictionary)properties).put("User", user);
        ((Dictionary)properties).put("EventType", "ModelDeleted");
        ((Dictionary)properties).put("WorkflowName", id);
        this.sendEvent(properties);
    }

    public void publishWorkflowStartedEvent(Workflow instance, Workflow parentWorkflow, String user, WorkflowData data) {
        if (EventPublishUtil.isTransient(instance)) {
            return;
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("TimeStamp", new Date());
        ((Dictionary)properties).put("User", user);
        ((Dictionary)properties).put("EventType", "WorkflowStarted");
        ((Dictionary)properties).put("WorkflowName", instance.getWorkflowModel().getTitle());
        ((Dictionary)properties).put("WorkflowVersion", instance.getWorkflowModel().getVersion());
        ((Dictionary)properties).put("WorkflowInstanceId", instance.getId());
        ((Dictionary)properties).put("Workdata", data);
        EventPublishUtil.addPayloadInfo(instance, properties);
        this.sendEvent(properties);
    }

    public void publishWorkflowAbortedEvent(Workflow instance, String userId) {
        if (EventPublishUtil.isTransient(instance)) {
            return;
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("TimeStamp", new Date());
        ((Dictionary)properties).put("User", userId);
        ((Dictionary)properties).put("EventType", "WorkflowAborted");
        ((Dictionary)properties).put("WorkflowName", instance.getWorkflowModel().getTitle());
        ((Dictionary)properties).put("WorkflowVersion", instance.getWorkflowModel().getVersion());
        ((Dictionary)properties).put("WorkflowInstanceId", instance.getId());
        EventPublishUtil.addPayloadInfo(instance, properties);
        this.sendEvent(properties);
    }

    public void publishWorkflowSuspendedEvent(Workflow instance, String user) {
        if (EventPublishUtil.isTransient(instance)) {
            return;
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("TimeStamp", new Date());
        ((Dictionary)properties).put("User", user);
        ((Dictionary)properties).put("EventType", "WorkflowSuspended");
        ((Dictionary)properties).put("WorkflowName", instance.getWorkflowModel().getTitle());
        ((Dictionary)properties).put("WorkflowVersion", instance.getWorkflowModel().getVersion());
        ((Dictionary)properties).put("WorkflowInstanceId", instance.getId());
        EventPublishUtil.addPayloadInfo(instance, properties);
        this.sendEvent(properties);
    }

    public void publishWorkflowResumedEvent(Workflow instance, String user) {
        if (EventPublishUtil.isTransient(instance)) {
            return;
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("TimeStamp", new Date());
        ((Dictionary)properties).put("User", user);
        ((Dictionary)properties).put("EventType", "WorkflowResumed");
        ((Dictionary)properties).put("WorkflowName", instance.getWorkflowModel().getTitle());
        ((Dictionary)properties).put("WorkflowVersion", instance.getWorkflowModel().getVersion());
        ((Dictionary)properties).put("WorkflowInstanceId", instance.getId());
        EventPublishUtil.addPayloadInfo(instance, properties);
        this.sendEvent(properties);
    }

    public void publishWorkflowCompletedEvent(Workflow instance, String user) throws WorkflowException {
        if (EventPublishUtil.isTransient(instance)) {
            return;
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("TimeStamp", new Date());
        ((Dictionary)properties).put("User", user);
        ((Dictionary)properties).put("EventType", "WorkflowCompleted");
        ((Dictionary)properties).put("WorkflowName", instance.getWorkflowModel().getTitle());
        ((Dictionary)properties).put("WorkflowVersion", instance.getWorkflowModel().getVersion());
        ((Dictionary)properties).put("WorkflowInstanceId", instance.getId());
        if (instance instanceof WorkflowImpl) {
            WorkflowImpl wf = (WorkflowImpl)instance;
            log.debug("publishWorkflowCompletedEvent parent id: {}", (Object)wf.getParentInstanceId());
            String parentId = wf.getParentInstanceId();
            if (StringUtils.isNotEmpty(parentId) && StringUtils.startsWithIgnoreCase(parentId, "/etc/")) {
                ((Dictionary)properties).put("ParentWorkflowId", parentId);
                log.debug("publishWorkflowCompletedEvent set PARENT_WORKFLOW_ID: {}", (Object)wf.getParentInstanceId());
            }
        }
        EventPublishUtil.addPayloadInfo(instance, properties);
        this.sendEvent(properties);
    }

    public void publishWorkflowPayloadModified(Workflow instance, String oldPath, String user) throws WorkflowException {
        if (EventPublishUtil.isTransient(instance)) {
            return;
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("TimeStamp", new Date());
        ((Dictionary)properties).put("User", user);
        ((Dictionary)properties).put("EventType", WORKFLOW_PAYLOAD_MODIFIED_EVENT);
        ((Dictionary)properties).put("WorkflowName", instance.getWorkflowModel().getTitle());
        ((Dictionary)properties).put("WorkflowVersion", instance.getWorkflowModel().getVersion());
        ((Dictionary)properties).put("WorkflowInstanceId", instance.getId());
        if (oldPath != null) {
            ((Dictionary)properties).put(PROP_OLD_PAYLOAD_PATH, oldPath);
        }
        EventPublishUtil.addPayloadInfo(instance, properties);
        this.sendEvent(properties);
    }

    private static void addPayloadInfo(Workflow instance, Dictionary<String, Object> properties) {
        if (instance != null && instance.getWorkflowData() != null && "JCR_PATH".equals(instance.getWorkflowData().getPayloadType())) {
            properties.put(PROP_PAYLOAD_PATH, instance.getWorkflowData().getPayload());
        }
    }

    public void publishNodeTransitionEvent(Workflow instance, String fromNodeName, String toNodeName, WorkItem workitem, String user) {
        if (EventPublishUtil.isTransient(instance)) {
            return;
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("TimeStamp", new Date());
        ((Dictionary)properties).put("User", user);
        ((Dictionary)properties).put("EventType", "NodeTransition");
        ((Dictionary)properties).put("WorkflowName", instance.getWorkflowModel().getTitle());
        ((Dictionary)properties).put("WorkflowVersion", instance.getWorkflowModel().getVersion());
        ((Dictionary)properties).put("WorkflowInstanceId", instance.getId());
        ((Dictionary)properties).put("fromNodeName", fromNodeName == null ? "" : fromNodeName);
        ((Dictionary)properties).put("toNodeName", toNodeName == null ? "" : toNodeName);
        ((Dictionary)properties).put("Workitem", workitem);
        EventPublishUtil.addPayloadInfo(instance, properties);
        this.sendEvent(properties);
    }

    public void publishVariableUpdatedEvent(Workflow instance, String variableName, Object variableValue, String user) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("TimeStamp", new Date());
        ((Dictionary)properties).put("User", user);
        ((Dictionary)properties).put("EventType", "VariableUpdate");
        ((Dictionary)properties).put("WorkflowName", instance.getWorkflowModel().getTitle());
        ((Dictionary)properties).put("WorkflowVersion", instance.getWorkflowModel().getVersion());
        ((Dictionary)properties).put("WorkflowInstanceId", instance.getId());
        ((Dictionary)properties).put("VariableName", variableName);
        ((Dictionary)properties).put("VariableValue", variableValue);
        EventPublishUtil.addPayloadInfo(instance, properties);
        this.sendEvent(properties);
    }

    public void publishProcessTimeoutEvent(Workflow instance, String processName) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("TimeStamp", new Date());
        ((Dictionary)properties).put("EventType", "ProcessTimeout");
        ((Dictionary)properties).put("WorkflowName", instance.getWorkflowModel().getTitle());
        ((Dictionary)properties).put("WorkflowVersion", instance.getWorkflowModel().getVersion());
        ((Dictionary)properties).put("WorkflowInstanceId", instance.getId());
        EventPublishUtil.addPayloadInfo(instance, properties);
        this.sendEvent(properties);
    }

    @Deprecated
    public void publishJobEvent(Map workItemMap, Integer retryCount, int numOfParallelProcs, String jobId) {
        WorkflowJob job = new WorkflowJob(workItemMap);
        this.eventAdmin.postEvent(job.createJobEvent(retryCount, numOfParallelProcs, jobId));
    }

    @Deprecated
    public void publishExternalProcessJobEvent(Map workItemMap, Integer retryCount, String jobId) {
        ExternalProcessJob job = new ExternalProcessJob(workItemMap);
        this.eventAdmin.postEvent(job.createJobEvent(retryCount, jobId));
    }

    public void publishJobFailedEvent(WorkItem item, String message) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("TimeStamp", new Date());
        ((Dictionary)properties).put("EventType", "JobFailed");
        ((Dictionary)properties).put("WorkflowNode", item.getNode().getId());
        ((Dictionary)properties).put("WorkflowName", item.getWorkflow().getWorkflowModel().getTitle());
        ((Dictionary)properties).put("WorkflowVersion", item.getWorkflow().getWorkflowModel().getVersion());
        ((Dictionary)properties).put("WorkflowInstanceId", item.getWorkflow().getId());
        EventPublishUtil.addPayloadInfo(item.getWorkflow(), properties);
        this.sendEvent(properties);
    }

    @Deprecated
    public Long publishTimeoutEvent(WorkItem item, WorkflowSession session) {
        AbsoluteTimeoutHandler handlerImpl;
        log.debug("entering publishTimeoutEvent..");
        String handler = null;
        Long timeout = null;
        boolean addOffset = true;
        for (String key : item.getNode().getMetaDataMap().keySet()) {
            if (key.equals("timeoutHandler")) {
                handler = (String)((Object)item.getNode().getMetaDataMap().get("timeoutHandler", String.class));
                continue;
            }
            if (!key.equals("timeoutMillis")) continue;
            timeout = (Long)((Object)item.getNode().getMetaDataMap().get("timeoutMillis", Long.class));
        }
        AbsoluteTimeoutHandler absoluteTimeoutHandler = handlerImpl = handler != null ? this.getHandler(handler, session) : null;
        if (handlerImpl != null) {
            long handlerTimeout = handlerImpl.getTimeoutDate(item);
            if (handlerTimeout > 0L) {
                timeout = handlerTimeout;
                addOffset = false;
            }
            if (timeout > 0L) {
                timeout = timeout / 1000L;
                log.debug("publishTimeoutEvent: Using AbsoluteTimeoutHandler. Timeout is: " + timeout + "s");
            } else {
                log.debug("publishTimeoutEvent: no time set");
                timeout = null;
            }
        }
        if (handler != null && timeout != null) {
            TimeoutJob job = new TimeoutJob(item, handler);
            this.eventAdmin.postEvent(job.createEvent(true, timeout, addOffset));
        }
        return timeout;
    }

    @Deprecated
    public void publishResetTimeoutEvent(WorkItem item) {
        String handler = null;
        for (String key : item.getNode().getMetaDataMap().keySet()) {
            if (!key.equals("timeoutHandler")) continue;
            handler = (String)((Object)item.getNode().getMetaDataMap().get("timeoutHandler", String.class));
        }
        if (handler != null) {
            TimeoutJob job = new TimeoutJob(item, handler);
            this.eventAdmin.postEvent(job.cancelEvent(true));
        }
    }

    public void publishDelegationEvent(Workflow instance, Authorizable participant, WorkItem item, String user) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("TimeStamp", new Date());
        ((Dictionary)properties).put("User", user);
        ((Dictionary)properties).put("EventType", "WorkItemDelegated");
        ((Dictionary)properties).put("WorkflowName", instance.getWorkflowModel().getTitle());
        ((Dictionary)properties).put("WorkflowVersion", instance.getWorkflowModel().getVersion());
        ((Dictionary)properties).put("WorkflowInstanceId", instance.getId());
        try {
            ((Dictionary)properties).put("Delagatee", participant.getID());
        }
        catch (RepositoryException e) {
            throw new SlingException(e.getMessage(), e);
        }
        ((Dictionary)properties).put("Workitem", item);
        EventPublishUtil.addPayloadInfo(instance, properties);
        this.sendEvent(properties);
    }

    public void publishUnclaimEvent(Workflow instance, Authorizable participant, WorkItem item, String user) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("TimeStamp", new Date());
        ((Dictionary)properties).put("User", user);
        ((Dictionary)properties).put("EventType", "WorkItemUnclaimed");
        ((Dictionary)properties).put("WorkflowName", instance.getWorkflowModel().getTitle());
        ((Dictionary)properties).put("WorkflowVersion", instance.getWorkflowModel().getVersion());
        ((Dictionary)properties).put("WorkflowInstanceId", instance.getId());
        try {
            ((Dictionary)properties).put("ReturnedTo", participant.getID());
        }
        catch (RepositoryException e) {
            throw new SlingException(e.getMessage(), e);
        }
        ((Dictionary)properties).put("Workitem", item);
        EventPublishUtil.addPayloadInfo(instance, properties);
        this.sendEvent(properties);
    }

    public void publishClaimEvent(Workflow instance, WorkItem item, String user) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("TimeStamp", new Date());
        ((Dictionary)properties).put("User", user);
        ((Dictionary)properties).put("EventType", "WorkItemClaimed");
        ((Dictionary)properties).put("WorkflowName", instance.getWorkflowModel().getTitle());
        ((Dictionary)properties).put("WorkflowVersion", instance.getWorkflowModel().getVersion());
        ((Dictionary)properties).put("WorkflowInstanceId", instance.getId());
        ((Dictionary)properties).put("Workitem", item);
        EventPublishUtil.addPayloadInfo(instance, properties);
        this.sendEvent(properties);
    }

    public void publishResourceCollectionModificationEvent(String path) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("Path", path);
        ((Dictionary)properties).put("EventType", "ResourceCollectionModified");
        this.sendEvent(properties);
    }

    private AbsoluteTimeoutHandler getHandler(String handler, WorkflowSession session) {
        ComponentContext context = (ComponentContext)WorkflowUtil.getServiceConfig((WorkflowSession)session, (String)"componentContext");
        if (context != null && context.getBundleContext() != null) {
            try {
                Object service;
                ServiceReference[] refs = context.getBundleContext().getServiceReferences(AbsoluteTimeoutHandler.class.getName(), null);
                ServiceReference ref = this.getServiceRef(refs, handler);
                if (ref != null && (service = context.getBundleContext().getService(ref)) instanceof AbsoluteTimeoutHandler) {
                    return (AbsoluteTimeoutHandler)service;
                }
                ServiceReference[] proxyRefs = context.getBundleContext().getServiceReferences(AbsoluteTimeoutHandlerProxy.class.getName(), null);
                if (proxyRefs != null) {
                    for (ServiceReference proxyRef : proxyRefs) {
                        AbsoluteTimeoutHandlerProxy absoluteTimeoutHandlerProxy;
                        AbsoluteTimeoutHandler handlerImpl;
                        Object service2 = context.getBundleContext().getService(proxyRef);
                        if (!(service2 instanceof AbsoluteTimeoutHandlerProxy) || (handlerImpl = (absoluteTimeoutHandlerProxy = (AbsoluteTimeoutHandlerProxy)service2).findHandler(handler)) == null) continue;
                        return handlerImpl;
                    }
                }
            }
            catch (InvalidSyntaxException e) {
                log.debug("Failed to retrieve AbsoluteTimeoutHandler", e);
            }
        }
        return null;
    }

    private ServiceReference getServiceRef(ServiceReference[] refs, String handler) {
        for (ServiceReference ref : refs) {
            String componentName = (String)ref.getProperty("component.name");
            if (!componentName.equals(handler)) continue;
            return ref;
        }
        return null;
    }
}

