/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.FormData;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public class Value {
    @Deprecated
    public static final String FORM_VALUESS_ATTRIBUTE = "granite.ui.form.values";
    @Deprecated
    public static final String CONTENTPATH_ATTRIBUTE = "granite.ui.form.contentpath";
    @Nonnull
    private Config config;
    private FormData formData;

    public Value(@Nonnull SlingHttpServletRequest request, @Nonnull Config config) {
        Resource contentResource;
        String contentPath;
        this.config = config;
        this.formData = FormData.from(request);
        if (this.formData != null) {
            return;
        }
        ValueMap values = (ValueMap)request.getAttribute(FORM_VALUESS_ATTRIBUTE);
        if (values == null && (contentPath = (String)request.getAttribute(CONTENTPATH_ATTRIBUTE)) != null && (contentResource = request.getResourceResolver().getResource(contentPath)) != null) {
            values = contentResource.getValueMap();
        }
        if (values != null) {
            this.formData = new FormData(values, FormData.NameNotFoundMode.IGNORE_FRESHNESS);
        }
    }

    @Nonnull
    public String get(@CheckForNull String name) {
        return this.get(name, "");
    }

    @Nonnull
    public <T> T get(@CheckForNull String name, @Nonnull T defaultValue) {
        T fieldValue = this.config.get("value", defaultValue);
        if (this.formData == null || this.config.get("ignoreData", false).booleanValue()) {
            return fieldValue;
        }
        if (name != null) {
            return this.formData.get(name, fieldValue, defaultValue);
        }
        return fieldValue;
    }

    @CheckForNull
    public <T> T get(@CheckForNull String name, @Nonnull Class<T> type) {
        T fieldValue = this.config.get("value", type);
        if (this.formData == null || this.config.get("ignoreData", false).booleanValue()) {
            return fieldValue;
        }
        if (name != null) {
            return (T)this.formData.get(name, fieldValue, type);
        }
        return fieldValue;
    }

    @CheckForNull
    public <T> T val(@Nonnull T fieldValue) {
        return this.val(this.config.get("name", String.class), fieldValue);
    }

    @CheckForNull
    public <T> T val(@CheckForNull String name, @Nonnull T fieldValue) {
        if (this.formData == null || this.config.get("ignoreData", false).booleanValue()) {
            return fieldValue;
        }
        if (name != null) {
            return (T)this.formData.get(name, fieldValue, fieldValue.getClass());
        }
        return fieldValue;
    }

    public boolean isSelected(@CheckForNull String value, boolean isFieldOptionSelected) {
        return this.isSelected(value, isFieldOptionSelected, false);
    }

    public boolean isSelected(@CheckForNull String value, boolean isFieldOptionSelected, boolean forceIgnoreFreshness) {
        return this.isSelected(this.config.get("name", String.class), value, isFieldOptionSelected, forceIgnoreFreshness);
    }

    public boolean isSelected(@CheckForNull String name, @CheckForNull String value, boolean isFieldOptionSelected) {
        return this.isSelected(name, value, isFieldOptionSelected, false);
    }

    public boolean isSelected(@CheckForNull String name, @CheckForNull String value, boolean isFieldOptionSelected, boolean forceIgnoreFreshness) {
        if (this.formData == null || this.config.get("ignoreData", false).booleanValue()) {
            return isFieldOptionSelected;
        }
        if (name != null) {
            return this.formData.isSelected(name, value, isFieldOptionSelected, forceIgnoreFreshness);
        }
        return isFieldOptionSelected;
    }

    @Nonnull
    public String getContentValue(@CheckForNull String name) {
        return this.getContentValue(name, "");
    }

    @Nonnull
    public <T> T getContentValue(@CheckForNull String name, @Nonnull T defaultValue) {
        if (this.formData == null || name == null) {
            return defaultValue;
        }
        return this.formData.getValueMap().get(name, defaultValue);
    }

    @CheckForNull
    public <T> T getContentValue(@CheckForNull String name, @Nonnull Class<T> type) {
        if (this.formData == null || name == null) {
            return null;
        }
        return (T)this.formData.getValueMap().get(name, type);
    }
}

