/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import com.adobe.granite.ui.components.AttrBuilder;
import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.ExpressionHelper;
import com.adobe.granite.ui.components.LayoutBuilder;
import com.adobe.granite.ui.components.State;
import com.adobe.granite.ui.components.Tag;
import com.adobe.granite.ui.components.Value;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.impl.BaseComponentHelper;
import com.adobe.granite.ui.components.impl.SlingIncludeObjectFactory;
import com.adobe.granite.ui.components.rendercondition.RenderCondition;
import com.adobe.granite.ui.components.rendercondition.RenderConditionHelper;
import com.adobe.granite.ui.components.rendercondition.SimpleRenderCondition;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.i18n.I18n;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.jsp.PageContext;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.scripting.jsp.util.JspSlingHttpServletResponseWrapper;

public class ComponentHelper {
    private static final String DEFAULT_LAYOUT_RT = "granite/ui/components/foundation/layouts/container";
    private final BaseComponentHelper base;
    private Config config;
    private Value value;
    private State state;
    private RenderConditionHelper renderConditionHelper;
    private SlingIncludeObjectFactory dataFetcher;

    public ComponentHelper(@Nonnull PageContext pageContext) {
        SlingBindings bindings = (SlingBindings)pageContext.getRequest().getAttribute(SlingBindings.class.getName());
        SlingScriptHelper sling = bindings.getSling();
        if (sling == null) {
            throw new RuntimeException("SlingScriptHelper is not available");
        }
        SlingHttpServletRequest request = bindings.getRequest();
        if (request == null) {
            throw new RuntimeException("SlingHttpServletRequest is not available");
        }
        this.base = new BaseComponentHelper(sling, request, (SlingHttpServletResponse)new JspSlingHttpServletResponseWrapper(pageContext));
    }

    @Nonnull
    public I18n getI18n() {
        return this.base.getI18n();
    }

    @Nonnull
    public XSSAPI getXss() {
        return this.base.getXss();
    }

    @Nonnull
    public Config getConfig() {
        if (this.config == null) {
            this.config = new Config(this.base.getRequest().getResource());
        }
        return this.config;
    }

    @Nonnull
    public Value getValue() {
        if (this.value == null) {
            this.value = new Value(this.base.getRequest(), this.getConfig());
        }
        return this.value;
    }

    @Nonnull
    public ExpressionHelper getExpressionHelper() {
        return this.base.getExpressionHelper();
    }

    @Nonnull
    public State getState() {
        if (this.state == null) {
            this.state = new State(this.base.getRequest());
        }
        return this.state;
    }

    @Nonnull
    private RenderConditionHelper getRenderConditionHelper() {
        if (this.renderConditionHelper == null) {
            this.renderConditionHelper = new RenderConditionHelper(this.base.getRequest(), this.base.getResponse());
        }
        return this.renderConditionHelper;
    }

    @Nonnull
    private SlingIncludeObjectFactory getSlingIncludeObjectFactory() {
        if (this.dataFetcher == null) {
            this.dataFetcher = new SlingIncludeObjectFactory(this.base.getRequest(), this.base.getResponse());
        }
        return this.dataFetcher;
    }

    @Nonnull
    public Tag consumeTag() {
        return this.base.consumeTag();
    }

    @CheckForNull
    public Resource consumeLayoutResource() {
        Resource layout = this.getOptions().layoutResource();
        return layout == null ? this.base.getRequest().getResource().getChild(Config.LAYOUT) : layout;
    }

    public void populateCommonAttrs(@Nonnull AttrBuilder attrs) {
        this.base.populateCommonAttrs(attrs);
    }

    public void populateCommonAttrs(@Nonnull AttrBuilder attrs, @Nonnull Resource src) {
        this.base.populateCommonAttrs(attrs, src);
    }

    @Nonnull
    public Options getOptions() {
        com.adobe.granite.ui.components.Options baseOptions = this.base.getOptions();
        if (Options.class.isAssignableFrom(baseOptions.getClass())) {
            return (Options)baseOptions;
        }
        return new Options().tag(baseOptions.tag()).rootField(baseOptions.rootField());
    }

    @Nonnull
    public LayoutBuilder getLayout() {
        return LayoutBuilder.from(this.consumeLayoutResource(), DEFAULT_LAYOUT_RT);
    }

    @CheckForNull
    public String getReadOnlyResourceType() {
        return this.base.getReadOnlyResourceType();
    }

    @CheckForNull
    public String getReadOnlyResourceType(@Nonnull Resource resource) {
        return this.base.getReadOnlyResourceType(resource);
    }

    @Nonnull
    public DataSource getItemDataSource() throws ServletException, IOException {
        return this.base.getItemDataSource();
    }

    @Nonnull
    public DataSource getItemDataSource(@Nonnull Resource resource) throws ServletException, IOException {
        return this.base.getItemDataSource(resource);
    }

    public DataSource asDataSource(@CheckForNull Resource datasource) throws ServletException, IOException {
        return this.base.asDataSource(datasource);
    }

    public DataSource asDataSource(@CheckForNull Resource datasource, @CheckForNull Resource context) throws ServletException, IOException {
        return this.base.asDataSource(datasource, context);
    }

    @Nonnull
    public RenderCondition getRenderCondition() throws ServletException, IOException {
        return this.getRenderCondition(this.base.getRequest().getResource());
    }

    @Nonnull
    public RenderCondition getRenderCondition(@Nonnull Resource resource) throws ServletException, IOException {
        RenderCondition rc = null;
        Resource condition = resource.getChild("granite:rendercondition");
        if (condition == null) {
            condition = resource.getChild(Config.RENDERCONDITION);
        }
        if (condition != null) {
            String resourceType = ComponentHelper.getResourceType(condition, "granite/ui/components/foundation/renderconditions/simple");
            rc = (RenderCondition)this.getSlingIncludeObjectFactory().get(condition, resourceType, RenderCondition.class);
        }
        if (rc == null) {
            rc = SimpleRenderCondition.TRUE;
        }
        return rc;
    }

    @Nonnull
    public RenderCondition getRenderCondition(@Nonnull Resource resource, boolean cache) throws ServletException, IOException {
        return this.getRenderConditionHelper().getRenderCondition(resource, cache);
    }

    public String getIconClass(@CheckForNull String icon) {
        if (icon == null) {
            return null;
        }
        if (!icon.startsWith("icon-")) {
            return icon;
        }
        return "coral-Icon--" + ComponentHelper.toCamel(icon.substring(5));
    }

    @Nonnull
    private static String toCamel(@Nonnull String s) {
        String[] parts = s.split("-");
        StringBuilder b = new StringBuilder();
        b.append(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            b.append(parts[i].substring(0, 1).toUpperCase());
            b.append(parts[i].substring(1));
        }
        return b.toString();
    }

    @CheckForNull
    private static String getResourceType(@Nonnull Resource resource) {
        return (String)((Object)resource.getValueMap().get("sling:resourceType", String.class));
    }

    @Nonnull
    private static String getResourceType(@Nonnull Resource resource, @Nonnull String defaultValue) {
        return resource.getValueMap().get("sling:resourceType", defaultValue);
    }

    public void include(@Nonnull Resource resource, @Nonnull Tag tag) throws ServletException, IOException {
        this.include(resource, null, tag);
    }

    public void include(@Nonnull Resource resource, @Nonnull Options options) throws ServletException, IOException {
        this.include(resource, null, options);
    }

    public void include(@Nonnull Resource resource, @CheckForNull String resourceType, @Nonnull Tag tag) throws ServletException, IOException {
        this.include(resource, resourceType, new Options().tag(tag));
    }

    public void include(@Nonnull Resource resource, @CheckForNull String resourceType, @Nonnull Options options) throws ServletException, IOException {
        this.include(resource, resourceType, null, options);
    }

    public void include(@Nonnull Resource resource, @CheckForNull String resourceType, @CheckForNull String selectors, @Nonnull Options options) throws ServletException, IOException {
        this.base.include(resource, resourceType, selectors, (com.adobe.granite.ui.components.Options)options);
    }

    public void includeForLayout(@Nonnull Resource resource, @Nonnull Options options) throws ServletException, IOException {
        this.includeForLayout(resource, null, options);
    }

    public void includeForLayout(@Nonnull Resource resource, @CheckForNull Resource layoutResource, @Nonnull Options options) throws ServletException, IOException {
        String resourceType = null;
        if (layoutResource == null) {
            Resource r = resource.getChild(Config.LAYOUT);
            if (r != null) {
                resourceType = ComponentHelper.getResourceType(r);
            }
        } else {
            resourceType = ComponentHelper.getResourceType(layoutResource);
            options.layoutResource(layoutResource);
        }
        if (resourceType == null) {
            resourceType = DEFAULT_LAYOUT_RT;
        }
        this.include(resource, resourceType, options);
    }

    public void call(@Nonnull String script, @Nonnull Options options) throws ServletException, IOException {
        this.base.call(script, (com.adobe.granite.ui.components.Options)options);
    }

    public static class Options
    extends com.adobe.granite.ui.components.Options {
        private Resource layout;

        @Override
        @Nonnull
        public Options tag(@CheckForNull Tag tag) {
            super.tag(tag);
            return this;
        }

        @Override
        @Nonnull
        public Options rootField(boolean flag) {
            super.rootField(flag);
            return this;
        }

        @CheckForNull
        public Resource layoutResource() {
            return this.layout;
        }

        @Nonnull
        public Options layoutResource(@CheckForNull Resource r) {
            this.layout = r;
            return this;
        }
    }
}

