/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import com.adobe.granite.xss.XSSAPI;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class AttrBuilder {
    private final HttpServletRequest req;
    private final XSSAPI xssAPI;
    @Nonnull
    private Map<String, String> data = new LinkedHashMap<String, String>();
    private Map<String, Encoding> encodings = new LinkedHashMap<String, Encoding>();
    private Set<String> classes = new HashSet<String>();

    public AttrBuilder(@Nonnull HttpServletRequest req, @Nonnull XSSAPI xssAPI) {
        this.req = req;
        this.xssAPI = xssAPI;
    }

    @Nonnull
    public Map<String, String> getData() {
        return this.data;
    }

    public void addRel(@CheckForNull String value) {
        this.addClass(value);
    }

    public void addClass(@CheckForNull String value) {
        if (StringUtils.isBlank(value)) {
            return;
        }
        if (this.classes.add(value)) {
            this.add("class", value);
        }
    }

    public void addHref(@CheckForNull String name, @CheckForNull String value) {
        if (value == null || StringUtils.isBlank(value) || StringUtils.isBlank(name)) {
            return;
        }
        if (value.startsWith("/")) {
            value = this.req.getContextPath() + value;
        }
        this.data.put(name, value);
        this.encodings.put(name, Encoding.HREF);
    }

    public void addDisabled(boolean disabled) {
        this.addBoolean("disabled", disabled);
    }

    public void addChecked(boolean checked) {
        this.addBoolean("checked", checked);
    }

    public void addSelected(boolean selected) {
        this.addBoolean("selected", selected);
    }

    public void addMultiple(boolean multiple) {
        this.addBoolean("multiple", multiple);
    }

    public void addBoolean(@CheckForNull String name, boolean value) {
        if (!value) {
            return;
        }
        this.add(name, "");
    }

    public void addOther(@CheckForNull String name, @CheckForNull String value) {
        if (StringUtils.isBlank(name)) {
            return;
        }
        this.add("data-" + this.xssAPI.encodeForHTML(name), value);
    }

    public void addOthers(@Nonnull Map<String, Object> data, String ... exclusions) {
        List<String> blacklisted = Arrays.asList(exclusions);
        for (Map.Entry<String, Object> e : data.entrySet()) {
            String key = e.getKey();
            if (key.indexOf(":") >= 0 || blacklisted.indexOf(key) >= 0) continue;
            Object value = e.getValue();
            if (value.getClass().isArray()) {
                for (Object o : (Object[])value) {
                    this.addOther(key, o.toString());
                }
                continue;
            }
            this.addOther(key, value.toString());
        }
    }

    public void add(@CheckForNull String name, @CheckForNull Boolean value) {
        if (value == null || name == null || StringUtils.isBlank(name)) {
            return;
        }
        this.addNoCheck(name, value.toString());
    }

    public void add(@CheckForNull String name, @CheckForNull Integer value) {
        if (value == null || name == null || StringUtils.isBlank(name)) {
            return;
        }
        this.addNoCheck(name, value.toString());
    }

    public void add(@CheckForNull String name, @CheckForNull Double value) {
        if (value == null || name == null || StringUtils.isBlank(name)) {
            return;
        }
        this.addNoCheck(name, value.toString());
    }

    public void add(@CheckForNull String name, @CheckForNull String value) {
        if (value == null || name == null || StringUtils.isBlank(name)) {
            return;
        }
        this.addNoCheck(name, value);
        this.encodings.put(name, Encoding.HTML_ATTR);
    }

    public void set(@CheckForNull String name, @CheckForNull String value) {
        if (value == null || name == null || StringUtils.isBlank(name)) {
            return;
        }
        this.data.put(name, value);
        this.encodings.put(name, Encoding.HTML_ATTR);
    }

    private void addNoCheck(@Nonnull String name, @Nonnull String v) {
        if (this.data.containsKey(name)) {
            v = this.data.get(name) + " " + v;
        }
        this.data.put(name, v);
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public String build() {
        try {
            StringWriter out = new StringWriter();
            this.build(out);
            return out.toString();
        }
        catch (IOException impossible) {
            throw new RuntimeException(impossible);
        }
    }

    public void build(@Nonnull Writer out) throws IOException {
        for (Map.Entry<String, String> e : this.data.entrySet()) {
            String key = e.getKey();
            String value = e.getValue();
            Encoding encoding = this.encodings.get(key);
            if (encoding != null && value.length() > 0) {
                switch (encoding) {
                    case HREF: {
                        value = this.xssAPI.getValidHref(value);
                        break;
                    }
                    default: {
                        value = this.xssAPI.encodeForHTMLAttr(value);
                    }
                }
            }
            out.append(" ").append(key).append("=\"").append(value).append("\"");
        }
    }

    public String toString() {
        return this.build();
    }

    private static enum Encoding {
        HREF,
        HTML_ATTR;

    }
}

