/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.translation.core.common;

import com.adobe.granite.translation.api.TranslationConfig;
import com.adobe.granite.translation.api.TranslationConstants;
import com.adobe.granite.translation.api.TranslationException;
import com.adobe.granite.translation.api.TranslationService;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTranslationService
implements TranslationService {
    private static final Logger log = LoggerFactory.getLogger(AbstractTranslationService.class);
    protected TranslationService.TranslationServiceInfo translationInfo;
    protected TranslationConfig tc;
    protected String defaultCategory;
    protected Map<String, String> availableLanguageMap;
    protected Map<String, String> availableCategoryMap;

    protected AbstractTranslationService(Map<String, String> availableLanguageMap, Map<String, String> availableCategoryMap, String name, String label, String attribution, String translationCloudConfigRootPath, TranslationConstants.TranslationMethod supportedTranslationMethod, TranslationConfig tc) {
        log.trace("Starting Constructor for: AbstractTranslationService");
        this.tc = tc;
        this.availableLanguageMap = availableLanguageMap;
        this.availableCategoryMap = availableCategoryMap;
        this.translationInfo = new TranslationServiceInfoImpl(name, label, attribution, translationCloudConfigRootPath, supportedTranslationMethod);
    }

    @Override
    public TranslationService.TranslationServiceInfo getTranslationServiceInfo() {
        return this.translationInfo;
    }

    @Override
    public String getDefaultCategory() {
        return this.defaultCategory;
    }

    @Override
    public void setDefaultCategory(String defaultCategory) {
        this.defaultCategory = defaultCategory;
    }

    @Override
    public void updateDueDate(String strTranslationJobID, Date date) throws TranslationException {
        throw new TranslationException("Due date update is not supported", TranslationException.ErrorCode.SERVICE_NOT_IMPLEMENTED);
    }

    protected boolean validateLanguageCode(String langCode) throws TranslationException {
        log.debug("In function: validateLanguageCode");
        for (String languageKey : this.tc.getLanguages().keySet()) {
            if (!StringUtils.equalsIgnoreCase(langCode, languageKey)) continue;
            return true;
        }
        return false;
    }

    public class TranslationServiceInfoImpl
    implements TranslationService.TranslationServiceInfo {
        private String attribution;
        private String translationServiceName;
        private String translationServiceLabel;
        private String translationCloudConfigRootPath;
        private TranslationConstants.TranslationMethod supportedTranslationMethod;

        TranslationServiceInfoImpl(String name, String label, String attribution, String translationCloudConfigRootPath, TranslationConstants.TranslationMethod supportedTranslationMethod) {
            this.attribution = attribution;
            this.translationServiceName = name;
            this.translationServiceLabel = label;
            this.supportedTranslationMethod = supportedTranslationMethod;
            this.translationCloudConfigRootPath = translationCloudConfigRootPath;
        }

        @Override
        public String getTranslationServiceAttribution() {
            log.trace("Starting function: getAttribution");
            return this.attribution;
        }

        @Override
        public String getTranslationServiceLabel() {
            log.trace("Starting function: getTranslationServiceLabel");
            return this.translationServiceLabel;
        }

        @Override
        public String getTranslationServiceName() {
            log.trace("Starting function: getTranslationServiceName");
            return this.translationServiceName;
        }

        @Override
        public TranslationConstants.TranslationMethod getSupportedTranslationMethod() {
            return this.supportedTranslationMethod;
        }

        @Override
        public String getServiceCloudConfigRootPath() {
            return this.translationCloudConfigRootPath;
        }
    }
}

