/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.translation.connector.msft.core.ui.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicrosoftCloudServiceUtils {
    private static final Logger logger = LoggerFactory.getLogger(MicrosoftCloudServiceUtils.class);
    private static final String COPY_FROM = "@CopyFrom";
    private static final String CQ_PAGE_TYPE = "cq:Page";
    private static final String SLING_FOLDER_TYPE = "sling:Folder";
    private static final String MERGE_LIST = "mergeList";
    private static final String CONF_HOME = "/conf";
    public static final String CLOUDSERVICE_CONF_PATH = "/conf/global/settings/cloudconfigs/translation";
    public static final String CLOUDSERVICE_LIBS_PATH = "/libs/settings/cloudconfigs/translation";

    public static String getStringPropertyFromContent(Resource resource, String property) {
        try {
            Resource contentResource;
            Node content;
            if (resource != null && (content = (contentResource = resource.getChild("jcr:content")).adaptTo(Node.class)) != null && content.hasProperty(property)) {
                return content.getProperty(property).getString();
            }
        }
        catch (RepositoryException e) {
            logger.error("Error fetching Property {} from {}", (Object)property, (Object)resource.getPath());
        }
        return "";
    }

    public static String getConnectorProperty(ResourceResolver resourceResolver, String msConnectorPath, String propertyName) {
        String msConnectorBasePath = "";
        if (msConnectorPath.startsWith(CLOUDSERVICE_LIBS_PATH)) {
            msConnectorPath = msConnectorPath.substring(CLOUDSERVICE_LIBS_PATH.length() + 1);
            msConnectorBasePath = "/libs/settings/cloudconfigs/translation/" + StringUtils.substringBefore(msConnectorPath, "/");
        } else if (msConnectorPath.startsWith(CONF_HOME)) {
            msConnectorBasePath = Text.getRelativeParent(msConnectorPath, 1);
        }
        Resource msConnectorResource = resourceResolver.getResource(msConnectorBasePath);
        return MicrosoftCloudServiceUtils.getStringPropertyFromContent(msConnectorResource, propertyName);
    }

    public static String getConfOverlayPath(String path) {
        if (path.startsWith(CONF_HOME)) {
            return path;
        }
        if (path.startsWith(CLOUDSERVICE_LIBS_PATH)) {
            String overLayPath = CLOUDSERVICE_CONF_PATH;
            overLayPath = overLayPath + path.substring(CLOUDSERVICE_LIBS_PATH.length(), path.length());
            return overLayPath;
        }
        return "";
    }

    public static Map<String, String> getHiddenFields(SlingHttpServletRequest request) {
        LinkedHashMap<String, String> retVal = new LinkedHashMap<String, String>();
        String requestSuffix = request.getRequestPathInfo().getSuffix();
        String parentOfRequestSuffix = Text.getRelativeParent(requestSuffix, 1);
        String confOverLayPath = MicrosoftCloudServiceUtils.getConfOverlayPath(request.getRequestPathInfo().getSuffix());
        String parentConfOverLayPath = MicrosoftCloudServiceUtils.getConfOverlayPath(parentOfRequestSuffix);
        retVal.put(Text.getRelativeParent(parentConfOverLayPath, 2) + '/' + "jcr:primaryType", SLING_FOLDER_TYPE);
        retVal.put(Text.getRelativeParent(parentConfOverLayPath, 1) + '/' + "jcr:primaryType", SLING_FOLDER_TYPE);
        retVal.put(Text.getRelativeParent(parentConfOverLayPath, 1) + '/' + MERGE_LIST, "true");
        retVal.put(parentConfOverLayPath + '/' + "jcr:primaryType", CQ_PAGE_TYPE);
        retVal.put(parentConfOverLayPath + '/' + "jcr:content" + COPY_FROM, parentOfRequestSuffix + '/' + "jcr:content");
        retVal.put(confOverLayPath + '/' + "jcr:primaryType", CQ_PAGE_TYPE);
        retVal.put(confOverLayPath + COPY_FROM, requestSuffix);
        return retVal;
    }
}

