/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.translation.api;

public final class TranslationConstants {
    private TranslationConstants() {
        throw new AssertionError();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContentType {
        PLAIN("text/plain"),
        HTML("text/html");

        private String type;

        private ContentType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TranslationStatus {
        DRAFT,
        SUBMITTED,
        SCOPE_REQUESTED,
        SCOPE_COMPLETED,
        COMMITTED_FOR_TRANSLATION,
        TRANSLATION_IN_PROGRESS,
        TRANSLATED,
        READY_FOR_REVIEW,
        REJECTED,
        APPROVED,
        COMPLETE,
        CANCEL,
        ARCHIVE,
        ERROR_UPDATE,
        UNKNOWN_STATE;


        public static TranslationStatus fromString(String text) {
            if (text != null) {
                for (TranslationStatus b : TranslationStatus.values()) {
                    if (!text.equalsIgnoreCase(b.toString())) continue;
                    return b;
                }
            }
            return UNKNOWN_STATE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TranslationMethod {
        MACHINE_TRANSLATION,
        HUMAN_TRANSLATION;

    }

    public class TranslationRelationShips {
        public static final String SOURCE = "translation_object_relation_source";
        public static final String REFERENCE = "translation_object_relation_reference";
        public static final String RELATED = "translation_object_relation_related";
        public static final String DERIVED = "translation_object_relation_derived";
    }
}

