/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.security.user.util;

import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import com.adobe.granite.security.user.util.AuthorizableFilterPredicate;
import com.adobe.granite.security.user.util.PropConstants;
import com.adobe.granite.security.user.util.SkipIterator;
import com.adobe.granite.xss.JSONUtil;
import com.adobe.granite.xss.ProtectionContext;
import com.adobe.granite.xss.XSSFilter;
import com.day.cq.replication.ReplicationQueue;
import com.day.cq.replication.ReplicationStatus;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.QueryBuilder;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.iterator.RangeIteratorAdapter;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizableJSONWriter
implements PropConstants {
    private static final Logger log = LoggerFactory.getLogger(AuthorizableJSONWriter.class);
    private final Session session;
    private final UserPropertiesManager userPropertiesMgr;
    private final ResourceResolver resourceResolver;
    private final Set<String> outputProps;
    private final XSSFilter xss;
    private Map<String, Long> limits = new HashMap<String, Long>();
    private List<AuthorizableFilterPredicate> filterPredicates;
    private Predicate resultingAuthorizablePredicate;

    public AuthorizableJSONWriter(UserPropertiesManager userPropertiesMgr, ResourceResolver resourceResolver, Session session, Set<String> outputProps, XSSFilter xss) {
        this.session = session;
        this.userPropertiesMgr = userPropertiesMgr;
        this.resourceResolver = resourceResolver;
        this.outputProps = outputProps == null ? Collections.emptySet() : Collections.unmodifiableSet(outputProps);
        this.xss = xss;
    }

    public void setLimit(String key, long limit) {
        this.limits.put(key, limit);
    }

    public void setFilterPredicates(String[] filters) {
        if (filters != null && filters.length > 0) {
            this.filterPredicates = new ArrayList<AuthorizableFilterPredicate>();
            for (String filter : filters) {
                if (StringUtils.isBlank(filter)) continue;
                this.filterPredicates.add(new AuthorizableFilterPredicate(filter));
            }
            this.resultingAuthorizablePredicate = PredicateUtils.anyPredicate(this.filterPredicates);
        }
    }

    private long getLimit(String key) {
        if (this.limits.containsKey(key)) {
            return this.limits.get(key);
        }
        return -1L;
    }

    public void write(JSONWriter writer, Authorizable authorizable) throws JSONException {
        try {
            String id = authorizable.getID();
            String path = authorizable.getPath();
            Node n = null;
            if (this.session.nodeExists(path)) {
                n = this.session.getNode(path);
            }
            OutputProperties properties = OutputProperties.create(this.outputProps);
            writer.object();
            writer.key("type").value(authorizable.isGroup() ? "group" : "user");
            JSONUtil.writeWithProtected(writer, "authorizableId", id, this.xss);
            JSONUtil.writeWithProtected(writer, "name", this.getDisplayName(id), this.xss);
            writer.key("home").value(path);
            if (id.equals(this.session.getUserID())) {
                writer.key("isImpersonated").value(this.isImpersonated());
            }
            if (properties.wildcardOrDoInclude("principal")) {
                writer.key("principal").value(authorizable.getPrincipal().getName());
            }
            String memberOfCnt = "memberOfTotal";
            boolean includeMoCnt = properties.doInclude(memberOfCnt);
            if (properties.wildcardOrDoInclude("memberOf")) {
                this.writeAuthorizables("memberOf", this.filterAuthorizableIterator(authorizable.memberOf()), this.getLimit("offset"), this.getLimit("memberOf"), includeMoCnt, writer);
            } else if (includeMoCnt) {
                this.writeTotal(memberOfCnt, this.filterAuthorizableIterator(authorizable.memberOf()), writer);
            }
            String declaredMemberOfCnt = "declaredMemberOfTotal";
            boolean includeDmoCnt = properties.doInclude(declaredMemberOfCnt);
            if (properties.wildcardOrDoInclude("declaredMemberOf")) {
                this.writeAuthorizables("declaredMemberOf", this.filterAuthorizableIterator(authorizable.declaredMemberOf()), this.getLimit("offset"), this.getLimit("memberOf"), includeDmoCnt, writer);
            } else if (includeDmoCnt) {
                this.writeTotal(declaredMemberOfCnt, this.filterAuthorizableIterator(authorizable.declaredMemberOf()), writer);
            }
            if (!authorizable.isGroup()) {
                User user = (User)authorizable;
                String impersonatorsCnt = "impersonatorsTotal";
                boolean includeImpCnt = properties.doInclude(impersonatorsCnt);
                if (properties.wildcardOrDoInclude("impersonators")) {
                    this.writeAuthorizables("impersonators", this.filterAuthorizableIterator(this.getImpersonators(user)), this.getLimit("offset"), this.getLimit("impersonators"), includeImpCnt, writer);
                } else if (includeImpCnt) {
                    this.writeTotal(impersonatorsCnt, this.filterAuthorizableIterator(this.getImpersonators(user)), writer);
                }
                if (properties.wildcardOrDoInclude("disabled") && user.isDisabled()) {
                    writer.key("disabled").value(user.getDisabledReason());
                }
            } else {
                Group gr = (Group)authorizable;
                String membersCnt = "membersTotal";
                boolean includeMmbrsCnt = properties.doInclude(membersCnt);
                boolean isEveryone = "everyone".equalsIgnoreCase(gr.getPrincipal().getName());
                if (properties.wildcardOrDoInclude("members")) {
                    if (isEveryone) {
                        this.writeEveryoneAuthorizables("members", this.getLimit("offset"), this.getLimit("members"), includeMmbrsCnt, writer);
                    } else {
                        this.writeAuthorizables("members", this.filterAuthorizableIterator(gr.getMembers()), this.getLimit("offset"), this.getLimit("members"), includeMmbrsCnt, writer);
                    }
                } else if (includeMmbrsCnt) {
                    if (isEveryone) {
                        this.writeEveryoneTotal(membersCnt, this.getLimit("members"), writer);
                    } else {
                        this.writeTotal(membersCnt, this.filterAuthorizableIterator(gr.getMembers()), 0L, this.getLimit("members"), writer);
                    }
                }
                String declaredMembersCnt = "declaredMembersTotal";
                boolean includeDmmbrsCnt = properties.doInclude(declaredMembersCnt);
                if (properties.wildcardOrDoInclude("declaredMembers")) {
                    if (isEveryone) {
                        this.writeEveryoneAuthorizables("declaredMembers", this.getLimit("offset"), this.getLimit("members"), includeDmmbrsCnt, writer);
                    } else {
                        this.writeAuthorizables("declaredMembers", this.filterAuthorizableIterator(gr.getDeclaredMembers()), this.getLimit("offset"), this.getLimit("members"), includeDmmbrsCnt, writer);
                    }
                } else if (includeDmmbrsCnt) {
                    if (isEveryone) {
                        this.writeEveryoneTotal(declaredMembersCnt, this.getLimit("members"), writer);
                    } else {
                        this.writeTotal(declaredMembersCnt, this.filterAuthorizableIterator(gr.getDeclaredMembers()), 0L, this.getLimit("members"), writer);
                    }
                }
            }
            if (properties.wildcardOrDoInclude("image")) {
                this.writeImageInformation(id, writer);
            }
            if (properties.wildcardOrDoInclude("modification")) {
                this.writeModificationDates(n, writer);
            }
            if (properties.wildcardOrDoInclude("replication")) {
                Resource resource = this.resourceResolver.getResource(path);
                ReplicationStatus replicationStatus = null;
                if (resource != null) {
                    replicationStatus = resource.adaptTo(ReplicationStatus.class);
                }
                this.writeReplication(replicationStatus, writer);
            }
            if (!properties.isEmpty()) {
                HashMap<String, Object> propMap = new HashMap<String, Object>();
                for (String prop : properties) {
                    String name;
                    String relPath;
                    int pos = prop.lastIndexOf(47);
                    Map<String, Object> target = propMap;
                    if (pos == -1) {
                        relPath = "";
                        name = prop;
                    } else {
                        String[] keys;
                        relPath = prop.substring(0, pos);
                        name = prop.length() <= pos + 1 ? "" : prop.substring(pos + 1);
                        for (String key : keys = Text.explode(relPath, 47, false)) {
                            if (!target.containsKey(key)) {
                                HashMap t = new HashMap();
                                target.put(key, t);
                                target = t;
                                continue;
                            }
                            target = (Map)target.get(key);
                        }
                    }
                    if (!target.containsKey("*_" + relPath)) {
                        target.put("*_" + relPath, new HashSet());
                    }
                    Set props = (Set)target.get("*_" + relPath);
                    if ("*".equals(name)) {
                        props.clear();
                        props.add("*");
                        continue;
                    }
                    if (props.contains("*") || "".equals(name)) continue;
                    props.add(name);
                }
                this.writePropMap(writer, propMap, authorizable, n);
            }
            writer.endObject();
        }
        catch (RepositoryException e) {
            throw new JSONException(e);
        }
    }

    private void writeEveryoneAuthorizables(String key, long offset, long limit, boolean includeTotal, JSONWriter writer) throws JSONException, RepositoryException {
        Iterator<Object> allMembers = new SkipIterator(Collections.emptySet().iterator());
        if (offset < 0L) {
            offset = 0L;
        }
        try {
            UserManager userManager = this.resourceResolver.adaptTo(UserManager.class);
            allMembers = userManager.findAuthorizables(this.buildUserQuery(offset, limit));
        }
        catch (Exception e) {
            log.error("Error while getting members for 'everyone' group!", e);
        }
        this.writeAuthorizables(key, allMembers, 0L, limit, includeTotal, writer);
    }

    private void writeAuthorizables(String key, Iterator<? extends Authorizable> authorizables, long offset, long limit, boolean includeTotal, JSONWriter writer) throws JSONException, RepositoryException {
        writer.key(key);
        writer.array();
        int cnt = 0;
        long skipped = 0L;
        boolean noLimit = limit == -1L;
        SkipIterator<? extends Authorizable> skipAuthorizablesIterator = SkipIterator.create(authorizables);
        if (offset > 0L) {
            skipped = skipAuthorizablesIterator.skip(offset);
        }
        while (skipAuthorizablesIterator.hasNext() && (noLimit || (long)cnt < limit)) {
            Authorizable auth = skipAuthorizablesIterator.next();
            writer.object();
            String id = auth.getID();
            writer.key("authorizableId").value(id);
            JSONUtil.writeWithProtected(writer, "name", this.getDisplayName(id), this.xss);
            writer.key("home").value(auth.getPath());
            writer.endObject();
            ++cnt;
        }
        writer.endArray();
        if (includeTotal) {
            this.writeTotal(key + "Total", skipAuthorizablesIterator, skipped + (long)cnt, limit, writer);
        }
    }

    private void writeTotal(String key, Iterator<? extends Authorizable> authorizables, JSONWriter writer) throws JSONException {
        this.writeTotal(key, authorizables, 0L, -1L, writer);
    }

    private void writeEveryoneTotal(String key, long limit, JSONWriter writer) throws JSONException {
        Iterator<Object> allMembers = new SkipIterator(Collections.emptySet().iterator());
        try {
            UserManager userManager = this.resourceResolver.adaptTo(UserManager.class);
            allMembers = userManager.findAuthorizables(this.buildUserQuery(0L, limit));
        }
        catch (Exception e) {
            log.error("Error while getting members for 'everyone' group!", e);
        }
        this.writeTotal(key, allMembers, 0L, limit, writer);
    }

    private Query buildUserQuery(final long offset, final long limit) {
        return new Query(){

            @Override
            public <T> void build(QueryBuilder<T> builder) {
                try {
                    builder.setSelector(User.class);
                    long maxResults = limit;
                    if (maxResults > 0L) {
                        ++maxResults;
                    }
                    builder.setLimit(offset, maxResults);
                    if (AuthorizableJSONWriter.this.filterPredicates != null && AuthorizableJSONWriter.this.filterPredicates.size() > 0) {
                        AuthorizableFilterPredicate filterPredicate = (AuthorizableFilterPredicate)AuthorizableJSONWriter.this.filterPredicates.get(0);
                        if (AuthorizableJSONWriter.this.filterPredicates.size() > 1) {
                            T partialCondition = builder.or(builder.nameMatches(filterPredicate.getFilter()), builder.like("profile/givenName", filterPredicate.getFilter()));
                            for (int index = 1; index < AuthorizableJSONWriter.this.filterPredicates.size(); ++index) {
                                filterPredicate = (AuthorizableFilterPredicate)AuthorizableJSONWriter.this.filterPredicates.get(index);
                                partialCondition = builder.or(partialCondition, builder.or(builder.nameMatches(filterPredicate.getFilter()), builder.like("profile/givenName", filterPredicate.getFilter())));
                            }
                            builder.setCondition(partialCondition);
                        } else {
                            builder.setCondition(builder.or(builder.nameMatches(filterPredicate.getFilter()), builder.like("profile/givenName", filterPredicate.getFilter())));
                        }
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
        };
    }

    private Iterator<? extends Authorizable> filterAuthorizableIterator(Iterator<? extends Authorizable> authorizablesIterator) {
        if (this.resultingAuthorizablePredicate != null) {
            return IteratorUtils.filteredIterator(authorizablesIterator, this.resultingAuthorizablePredicate);
        }
        return authorizablesIterator;
    }

    private void writeTotal(String key, Iterator<? extends Authorizable> authorizables, long startCnt, long limit, JSONWriter writer) throws JSONException {
        long cnt;
        if (authorizables instanceof RangeIterator) {
            cnt = ((RangeIterator)authorizables).getSize();
        } else {
            boolean noLimit;
            boolean bl = noLimit = limit == -1L;
            for (cnt = startCnt; authorizables.hasNext() && (noLimit || cnt < limit); ++cnt) {
                authorizables.next();
            }
            if (authorizables.hasNext()) {
                cnt = -1L;
            }
        }
        writer.key(key).value(cnt);
    }

    private void writeModificationDates(Node n, JSONWriter writer) throws JSONException {
        writer.key("modification").object();
        if (n != null) {
            try {
                if (n.hasProperty("{http://www.jcp.org/jcr/1.0}lastModified")) {
                    Calendar lastMod = n.getProperty("{http://www.jcp.org/jcr/1.0}lastModified").getDate();
                    writer.key("lastModified").value(lastMod.getTimeInMillis());
                }
                if (n.hasProperty("{http://www.jcp.org/jcr/1.0}lastModifiedBy")) {
                    String lastModBy = n.getProperty("{http://www.jcp.org/jcr/1.0}lastModifiedBy").getString();
                    writer.key("lastModifiedBy").value(this.getDisplayName(lastModBy));
                }
            }
            catch (RepositoryException e) {
                log.error("Failed to retrieve modification information.", (Object)e.getMessage());
            }
        }
        writer.endObject();
    }

    private void writeReplication(ReplicationStatus replicationStatus, JSONWriter writer) throws JSONException {
        writer.key("replication").object();
        if (replicationStatus != null) {
            int maxQueuePos = -1;
            for (ReplicationQueue.Entry e : replicationStatus.getPending()) {
                if (e.getQueuePosition() <= maxQueuePos) continue;
                maxQueuePos = e.getQueuePosition();
            }
            writer.key("numQueued").value(maxQueuePos + 1);
            Calendar last = replicationStatus.getLastPublished();
            if (last != null) {
                writer.key("published").value(last.getTimeInMillis());
                String publishedBy = replicationStatus.getLastPublishedBy();
                try {
                    String authorizableId = replicationStatus.getLastPublishedBy();
                    UserProperties up = this.userPropertiesMgr.getUserProperties(authorizableId, "profile");
                    if (up != null) {
                        publishedBy = up.getDisplayName();
                    }
                }
                catch (RepositoryException e) {
                    log.warn("Failed to retrieve display name for {0}: Using publishedBy value instead.", (Object)publishedBy);
                }
                JSONUtil.writeWithProtected(writer, "publishedBy", publishedBy, this.xss);
                if (replicationStatus.getLastReplicationAction() != null) {
                    writer.key("action").value(replicationStatus.getLastReplicationAction().name());
                }
            }
        }
        writer.endObject();
    }

    private void writeImageInformation(String id, JSONWriter writer) throws JSONException {
        UserProperties profile = this.getProfile(id);
        if (profile != null) {
            try {
                Resource photo = profile.getResource("photos");
                if (photo != null) {
                    Resource image = photo.getResourceResolver().getResource(photo, "primary/image");
                    if (image != null) {
                        Node photoNode = photo.adaptTo(Node.class);
                        String ext = "png";
                        long ck = 0L;
                        String lmPath = "image/jcr:lastModified";
                        if (photoNode.hasProperty(lmPath)) {
                            ck = photoNode.getProperty(lmPath).getLong();
                            ck = ck / 1000L * 1000L;
                        }
                        writer.key("picturePath").value(photo.getPath());
                        writer.key("pictureExt").value(ext);
                        writer.key("pictureMod").value(ck);
                    }
                } else {
                    writer.key("thumbnail").value("");
                }
            }
            catch (RepositoryException e) {
                throw new JSONException(e);
            }
        }
    }

    private UserProperties getProfile(String id) {
        if (this.userPropertiesMgr != null) {
            try {
                return this.userPropertiesMgr.getUserProperties(id, "profile");
            }
            catch (RepositoryException e) {
                log.debug("Could not access Repository, when trying to access full name of {}: {}", (Object)id, (Object)e);
            }
        }
        return null;
    }

    private String getDisplayName(String id) {
        String name = id;
        UserProperties up = this.getProfile(id);
        if (up != null) {
            try {
                name = up.getDisplayName();
            }
            catch (RepositoryException e) {
                log.debug("Cannot retrieve display name for " + id);
            }
        }
        return name;
    }

    private Iterator<Authorizable> getImpersonators(User user) {
        HashSet<Authorizable> res = new HashSet<Authorizable>();
        if (this.session instanceof JackrabbitSession) {
            try {
                PrincipalIterator itr = user.getImpersonation().getImpersonators();
                while (itr.hasNext()) {
                    Principal pr = itr.nextPrincipal();
                    Authorizable authorizable = ((JackrabbitSession)this.session).getUserManager().getAuthorizable(pr);
                    if (authorizable != null) {
                        res.add(authorizable);
                        continue;
                    }
                    log.debug("Could not resolve impersonator principal {} -> ignoring", (Object)pr.getName());
                }
            }
            catch (AccessDeniedException e) {
                log.debug("Cannot retrieve impersonators : Access Denied.");
            }
            catch (RepositoryException e) {
                log.warn("Cannot retrieve impersonators", (Object)e.getMessage());
            }
        }
        return new RangeIteratorAdapter(res.iterator(), res.size());
    }

    private boolean isImpersonated() {
        return this.session != null && this.session.getAttribute("user.impersonator") != null;
    }

    private void writePropMap(JSONWriter writer, Map<String, Object> propMap, Authorizable authorizable, Node n) throws JSONException, RepositoryException {
        for (String key : propMap.keySet()) {
            if (key.startsWith("*_")) {
                String relPath = key.substring(2);
                this.writeProperties(writer, authorizable, n, relPath, (Set)propMap.get(key));
                continue;
            }
            Object v = propMap.get(key);
            writer.key(this.xss.filter(ProtectionContext.PLAIN_HTML_CONTENT, key));
            writer.object();
            this.writePropMap(writer, (Map)v, authorizable, n);
            writer.endObject();
        }
    }

    private void writeProperties(JSONWriter writer, Authorizable authorizable, Node n, String relPath, Set<String> names) throws JSONException, RepositoryException {
        block5: {
            block4: {
                String[] propNames;
                if (!names.contains("*")) break block4;
                UserProperties up = this.userPropertiesMgr.getUserProperties(authorizable.getID(), relPath);
                if (up == null) break block5;
                for (String propName : propNames = up.getPropertyNames()) {
                    String[] values = up.getProperty(propName, null, String[].class);
                    this.writeValues(writer, propName, values);
                }
                break block5;
            }
            for (String name : names) {
                String propPath;
                String string = propPath = "".equals(relPath) ? name : relPath + "/" + name;
                if (authorizable.hasProperty(propPath)) {
                    Value[] vs = authorizable.getProperty(propPath);
                    this.writeValues(writer, name, vs);
                    continue;
                }
                if (n == null || !n.hasProperty(propPath)) continue;
                Property p = n.getProperty(propPath);
                if (p.isMultiple()) {
                    this.writeValues(writer, name, p.getValues());
                    continue;
                }
                JSONUtil.writeWithProtected(writer, name, p.getString(), this.xss);
            }
        }
    }

    private void writeValues(JSONWriter writer, String key, String[] values) throws JSONException {
        if (values == null) {
            return;
        }
        switch (values.length) {
            case 0: {
                JSONUtil.writeWithProtected(writer, key, "", this.xss);
                break;
            }
            case 1: {
                JSONUtil.writeWithProtected(writer, key, values[0], this.xss);
                break;
            }
            default: {
                JSONUtil.writeWithProtected(writer, key, values, this.xss);
            }
        }
    }

    private void writeValues(JSONWriter writer, String key, Value[] values) throws JSONException, RepositoryException {
        if (values == null) {
            return;
        }
        switch (values.length) {
            case 0: {
                JSONUtil.writeWithProtected(writer, key, "", this.xss);
                break;
            }
            case 1: {
                JSONUtil.writeWithProtected(writer, key, values[0].getString(), this.xss);
                break;
            }
            default: {
                String[] strs = new String[values.length];
                for (int i = 0; i < values.length; ++i) {
                    strs[i] = values[i].getString();
                }
                JSONUtil.writeWithProtected(writer, key, strs, this.xss);
            }
        }
    }

    private static final class OutputProperties
    extends HashSet<String> {
        private final boolean wildcard;

        private OutputProperties(boolean wildcard, int size) {
            super(size);
            this.wildcard = wildcard;
        }

        private static OutputProperties create(Set<String> base) {
            if (base == null) {
                return new OutputProperties(false, 0);
            }
            OutputProperties props = new OutputProperties(base.contains("*"), base.size());
            for (String propName : base) {
                if ("*".equals(propName)) continue;
                props.add(propName);
            }
            return props;
        }

        private boolean doInclude(String propName) {
            return this.remove(propName);
        }

        private boolean wildcardOrDoInclude(String propName) {
            return this.wildcard || this.doInclude(propName);
        }
    }
}

