/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.jmx.annotation;

import com.adobe.granite.jmx.annotation.Description;
import com.adobe.granite.jmx.annotation.OpenTypeInfo;
import com.adobe.granite.jmx.annotation.TabularTypeInfo;
import com.adobe.granite.jmx.internal.Utils;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;

public abstract class OpenTypeUtils {
    private static final Map<Class<?>, SimpleType> SIMPLE_TYPES = new HashMap();

    public static OpenType createOpenType(Class<?> clazz, OpenTypeInfo info) throws OpenDataException {
        if (clazz.isArray()) {
            return new ArrayType(Utils.getArrayDim(clazz), OpenTypeUtils.createOpenType(Utils.getArrayType(clazz), info));
        }
        if (CompositeData.class.isAssignableFrom(clazz)) {
            return OpenTypeUtils.createCompositeType(info.value());
        }
        if (TabularData.class.isAssignableFrom(clazz)) {
            return OpenTypeUtils.createTabularType(info.value());
        }
        SimpleType type = OpenTypeUtils.getSimpleType(clazz);
        if (type == null) {
            throw new OpenDataException("Illegal class for open type: " + clazz);
        }
        return type;
    }

    public static SimpleType getSimpleType(Class<?> clazz) {
        return SIMPLE_TYPES.get(clazz);
    }

    public static CompositeType createCompositeType(Class<?> clazz) throws OpenDataException {
        try {
            PropertyDescriptor[] properties = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
            if (properties == null) {
                properties = new PropertyDescriptor[]{};
            }
            ArrayList<String> itemNames = new ArrayList<String>();
            ArrayList<OpenType> itemTypes = new ArrayList<OpenType>();
            List<String> allowedClasses = Arrays.asList(OpenType.ALLOWED_CLASSNAMES);
            for (int i = 0; i < properties.length; ++i) {
                PropertyDescriptor p = properties[i];
                if (!allowedClasses.contains(p.getPropertyType().getName())) continue;
                OpenTypeInfo childInfo = OpenTypeUtils.getAnnotation(p, OpenTypeInfo.class);
                OpenType openType = OpenTypeUtils.createOpenType(p.getPropertyType(), childInfo);
                itemNames.add(p.getName());
                itemTypes.add(openType);
            }
            Description description = clazz.getAnnotation(Description.class);
            String desc = description == null ? clazz.getName() : description.value();
            String[] names = itemNames.toArray(new String[itemNames.size()]);
            return new CompositeType(clazz.getName(), desc, names, names, itemTypes.toArray(new OpenType[itemTypes.size()]));
        }
        catch (IntrospectionException e) {
            throw new OpenDataException(e.toString());
        }
    }

    public static TabularType createTabularType(Class<?> clazz) throws OpenDataException {
        Description description = clazz.getAnnotation(Description.class);
        String desc = description == null ? clazz.getName() : description.value();
        TabularTypeInfo rowTypeInfo = clazz.getAnnotation(TabularTypeInfo.class);
        CompositeType rowType = OpenTypeUtils.createCompositeType(rowTypeInfo.rowType());
        return new TabularType(clazz.getName(), desc, rowType, rowTypeInfo.indexNames());
    }

    private static <T extends Annotation> T getAnnotation(PropertyDescriptor p, Class<T> a) {
        if (p.getReadMethod() != null) {
            T result = p.getReadMethod().getAnnotation(a);
            if (result != null) {
                return result;
            }
            if (p.getWriteMethod() == null) {
                return null;
            }
        }
        return p.getWriteMethod().getAnnotation(a);
    }

    static {
        SIMPLE_TYPES.put(BigDecimal.class, SimpleType.BIGDECIMAL);
        SIMPLE_TYPES.put(BigInteger.class, SimpleType.BIGINTEGER);
        SIMPLE_TYPES.put(Boolean.class, SimpleType.BOOLEAN);
        SIMPLE_TYPES.put(Boolean.TYPE, SimpleType.BOOLEAN);
        SIMPLE_TYPES.put(Byte.class, SimpleType.BYTE);
        SIMPLE_TYPES.put(Byte.TYPE, SimpleType.BYTE);
        SIMPLE_TYPES.put(Character.class, SimpleType.CHARACTER);
        SIMPLE_TYPES.put(Character.TYPE, SimpleType.CHARACTER);
        SIMPLE_TYPES.put(Date.class, SimpleType.DATE);
        SIMPLE_TYPES.put(Double.class, SimpleType.DOUBLE);
        SIMPLE_TYPES.put(Double.TYPE, SimpleType.DOUBLE);
        SIMPLE_TYPES.put(Float.class, SimpleType.FLOAT);
        SIMPLE_TYPES.put(Float.TYPE, SimpleType.FLOAT);
        SIMPLE_TYPES.put(Integer.class, SimpleType.INTEGER);
        SIMPLE_TYPES.put(Integer.TYPE, SimpleType.INTEGER);
        SIMPLE_TYPES.put(Long.class, SimpleType.LONG);
        SIMPLE_TYPES.put(Long.TYPE, SimpleType.LONG);
        SIMPLE_TYPES.put(ObjectName.class, SimpleType.OBJECTNAME);
        SIMPLE_TYPES.put(Short.class, SimpleType.SHORT);
        SIMPLE_TYPES.put(Short.TYPE, SimpleType.SHORT);
        SIMPLE_TYPES.put(String.class, SimpleType.STRING);
        SIMPLE_TYPES.put(Void.class, SimpleType.VOID);
        SIMPLE_TYPES.put(Void.TYPE, SimpleType.VOID);
    }
}

