/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.auth.ims;

public final class IMSInstance {
    private final String instanceId;
    private final String owningEntity;
    private final String serviceCode;

    public IMSInstance(String instanceId, String owningEntity, String serviceCode) {
        if (owningEntity == null || serviceCode == null) {
            throw new IllegalArgumentException(String.format("null owningEntity or serviceCode are not allowed (instanceId: %s, owningEntity: %s, serviceCode: %s", instanceId, owningEntity, serviceCode));
        }
        this.instanceId = instanceId;
        this.owningEntity = owningEntity;
        this.serviceCode = serviceCode;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getOwningEntity() {
        return this.owningEntity;
    }

    public String getServiceCode() {
        return this.serviceCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IMSInstance other = (IMSInstance)obj;
        if (this.instanceId == null ? other.instanceId != null : !this.instanceId.equals(other.instanceId)) {
            return false;
        }
        if (this.owningEntity == null ? other.owningEntity != null : !this.owningEntity.equals(other.owningEntity)) {
            return false;
        }
        return !(this.serviceCode == null ? other.serviceCode != null : !this.serviceCode.equals(other.serviceCode));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.instanceId == null ? 0 : this.instanceId.hashCode());
        result = 31 * result + (this.owningEntity == null ? 0 : this.owningEntity.hashCode());
        result = 31 * result + (this.serviceCode == null ? 0 : this.serviceCode.hashCode());
        return result;
    }

    public String toString() {
        return "IMSInstance{instanceId='" + this.instanceId + '\'' + ", owningEntity='" + this.owningEntity + '\'' + ", serviceCode='" + this.serviceCode + '\'' + '}';
    }
}

