/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.activitystreams.serversidetests;

import com.adobe.granite.activitystreams.ActivityManager;
import com.adobe.granite.activitystreams.ActivityStream;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.junit.annotations.SlingAnnotationsTestRunner;
import org.apache.sling.junit.annotations.TestReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SlingAnnotationsTestRunner.class)
public class ActivityStreamsSST {
    private ResourceResolver resolver;
    public static final String TEST_USER = "admin";
    public static final String TEST_STREAM_NAME = "TestStream" + ActivityStreamsSST.class.getName();
    @TestReference
    private ActivityManager activityManager;
    @TestReference
    private ResourceResolverFactory resolverFactory;

    @Before
    public void setup() throws Exception {
        this.resolver = this.resolverFactory.getAdministrativeResourceResolver(null);
    }

    @After
    public void cleanup() throws Exception {
        this.resolver.close();
    }

    @Test
    public void activityManagerPresent() {
        Assert.assertNotNull((Object)this.activityManager.newActivity());
    }

    @Test
    public void canCreateActivityStream() {
        ActivityStream s = this.activityManager.getUserStream(this.resolver, TEST_USER, TEST_STREAM_NAME, true);
        Assert.assertNotNull((String)("Expecting stream " + TEST_STREAM_NAME + " to be created for user " + TEST_USER), (Object)s);
        Assert.assertEquals((Object)TEST_STREAM_NAME, (Object)s.getName());
    }

    @Test
    public void unknownStreamNotFound() {
        String nonExistentStream = "NOSTREAM_" + System.currentTimeMillis();
        ActivityStream s = this.activityManager.getUserStream(this.resolver, TEST_USER, nonExistentStream, false);
        Assert.assertNull((String)("Expecting null when getting stream " + nonExistentStream), (Object)s);
    }
}

