/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.forms.foundation.transfer;

import com.adobe.forms.foundation.service.FormsAssetType;
import com.adobe.forms.foundation.transfer.AssetInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;

public class AssetScanInfo
extends AssetInfo {
    private String scannedBy;
    private FormsAssetType type;
    private String schemaRef;
    private List<Issue> issues;
    private volatile Object schema;

    public AssetScanInfo(String path) {
        this.setAssetPath(path);
    }

    public AssetScanInfo(String assetPath, String title, long lastModifiedTime, long publishedTime, String lastModifiedBy, String publishedBy, String lastReplicateAction, boolean publsihed) {
        super(assetPath, title, lastModifiedTime, publishedTime, lastModifiedBy, publishedBy, lastReplicateAction, publsihed);
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    public void setIssues(List<Issue> issues) {
        this.issues = issues;
    }

    public String getSchemaRef() {
        return this.schemaRef;
    }

    public void setSchemaRef(String schemaRef) {
        this.schemaRef = schemaRef;
    }

    public FormsAssetType getType() {
        return this.type;
    }

    public void setType(FormsAssetType type) {
        this.type = type;
    }

    public String getScannedBy() {
        return this.scannedBy;
    }

    public void setScannedBy(String scannedBy) {
        this.scannedBy = scannedBy;
    }

    @JsonIgnore
    public Object getSchema() {
        return this.schema;
    }

    public void setSchema(Object schema) {
        this.schema = schema;
    }

    public void addIssue(String message, IssueType issueType) {
        if (this.issues == null) {
            this.issues = new ArrayList<Issue>();
        }
        Issue issue = new Issue();
        issue.type = issueType;
        issue.message = message;
        this.issues.add(issue);
    }

    public void addIssue(String message) {
        this.addIssue(message, IssueType.ERROR);
    }

    public static enum IssueType {
        WARN,
        ERROR;

    }

    public class Issue {
        public String message;
        public IssueType type;
    }
}

