/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.forms.foundation.service.util;

import com.adobe.forms.foundation.service.FormsAssetType;
import com.adobe.forms.foundation.service.FormsFoundationException;
import com.adobe.forms.foundation.transfer.CopiedAssetInfo;
import com.adobe.granite.resourceresolverhelper.ResourceResolverHelper;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.commons.ReferenceSearch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(value={FormsFoundationUtils.class})
@Component
@Properties(value={@Property(name="connectors.jsoninvoker", boolValue={true}), @Property(name="connectors.jsoninvoker.alias", value={"ff.FormsFoundationUtils"})})
public class FormsFoundationUtils {
    private static final Logger logger = LoggerFactory.getLogger(FormsFoundationUtils.class);
    @Reference
    private ResourceResolverHelper resourceResolverHelper;
    private static final Map<String, FormsAssetType> cmAssetTypeMap = new HashMap<String, FormsAssetType>();
    private static final List<String> supportedDAMDocumentFormats = new ArrayList<String>();
    private static Pattern ptrnAllDigits = Pattern.compile("^\\d+$");
    private static final String LCC_CLASSNAME = "lcc:className";
    private static final String DAM_ASSET_TYPE = "dam:Asset";
    private static final String NT_UNSTRUCTURED_TYPE = "nt:unstructured";
    private static final String SLING_FOLDER = "sling:Folder";
    private static final String CQ_TEMPLATE_TYPE = "cq:Template";
    private static final String SLING_RESOURCE_TYPE = "sling:resourceType";
    private static final String CQ_PAGE_TYPE = "cq:Page";
    private static final String COPY_STR = "-copy";
    private static final String COPY_STR_FOR_DD = "copy";
    public static final String STR_SLING_ORDERED_FOLDER = "sling:OrderedFolder";
    public static final String STR_NT_FOLDER = "nt:folder";
    public static final String CM_MIXIN = "cm:resource";
    public static final String FORM_ROOT_PATH = "/content/dam/formsanddocuments";
    public static final String FORM_PAGE_ROOT_PATH = "/content/forms/af";

    public FormsAssetType getAssetType(String assetId) throws FormsFoundationException {
        Node node = this.mapAssetIdToNode(assetId);
        return this.getAssetType(node);
    }

    public FormsAssetType getAssetType(Node node) throws FormsFoundationException {
        if (node == null) {
            throw new FormsFoundationException("AEM-FF-002", new Object[0]);
        }
        FormsAssetType assetType = null;
        try {
            if (node.isNodeType(NT_UNSTRUCTURED_TYPE)) {
                if (node.hasProperty(LCC_CLASSNAME)) {
                    String propValue = node.getProperty(LCC_CLASSNAME).getString();
                    assetType = cmAssetTypeMap.get(propValue);
                }
            } else if (node.isNodeType(DAM_ASSET_TYPE)) {
                if (node.hasNode("jcr:content")) {
                    if ((node = node.getNode("jcr:content")).hasProperty("xfaForm")) {
                        assetType = FormsAssetType.XDP;
                    } else if (node.hasProperty("pdfForm")) {
                        assetType = FormsAssetType.PDF;
                    } else if (node.hasProperty("lcResource")) {
                        assetType = FormsAssetType.FM_RESOURCE;
                    } else if (node.hasProperty("guide")) {
                        assetType = FormsAssetType.ADAPTIVE_FORM;
                    } else if (node.hasProperty("formset")) {
                        assetType = FormsAssetType.FORMSET;
                    } else if (node.hasProperty("affragment")) {
                        assetType = FormsAssetType.ADAPTIVE_FORM_FRAGMENT;
                    } else if (node.hasProperty("adaptivedocument")) {
                        assetType = FormsAssetType.ADAPTIVE_DOCUMENT;
                    } else if (node.hasProperty("theme")) {
                        assetType = FormsAssetType.THEME;
                    } else if (node.hasProperty("printForm")) {
                        assetType = FormsAssetType.PRINT_FORM;
                    } else if (node.hasProperty("metadata/dc:format")) {
                        String dcFormat = node.getProperty("metadata/dc:format").getString();
                        assetType = dcFormat.startsWith("image/") ? FormsAssetType.DAM_IMAGE : (supportedDAMDocumentFormats.contains(dcFormat) ? FormsAssetType.DAM_DOCUMENT : FormsAssetType.EXTERNAL);
                    } else if (node.hasProperty("type")) {
                        String type = node.getProperty("type").getString();
                        if (StringUtils.isNotEmpty(type)) {
                            try {
                                assetType = FormsAssetType.valueOf(type.toUpperCase());
                            }
                            catch (Exception exception) {}
                        }
                    } else {
                        assetType = FormsAssetType.EXTERNAL;
                    }
                }
            } else if (node.isNodeType(CQ_PAGE_TYPE)) {
                assetType = FormsAssetType.CQ_PAGE;
            } else if (node.isNodeType(SLING_FOLDER)) {
                assetType = FormsAssetType.FOLDER;
            } else if (node.isNodeType(CQ_TEMPLATE_TYPE)) {
                if (node.hasProperty("jcr:content/cq:templateType") && "/libs/settings/wcm/template-types/web-channel-page".equals(node.getProperty("jcr:content/cq:templateType").getString())) {
                    assetType = FormsAssetType.ADAPTIVE_DOCUMENT_TEMPLATE;
                } else if (node.hasProperty("initial/jcr:content/guideComponentType")) {
                    assetType = FormsAssetType.ADAPTIVE_FORM_TEMPLATE;
                }
            } else if (node.hasProperty(SLING_RESOURCE_TYPE) && "wcm/core/components/policy/policy".equals(node.getProperty(SLING_RESOURCE_TYPE).getString())) {
                assetType = FormsAssetType.WCM_CONTENT_POLICY;
            }
            if (assetType == null) {
                throw new FormsFoundationException("AEM-FF-005", new Object[]{node.getPath()});
            }
        }
        catch (FormsFoundationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsFoundationException(e);
        }
        return assetType;
    }

    public String[] getResolvedAssetTags(Node node) throws FormsFoundationException {
        if (node == null) {
            throw new FormsFoundationException("AEM-FF-002", new Object[0]);
        }
        String[] tags = null;
        try {
            FormsAssetType assetType = this.getAssetType(node);
            if (node.hasProperty(assetType.getTagsProperty())) {
                Value[] values = node.getProperty(assetType.getTagsProperty()).getValues();
                tags = new String[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tags[i] = values[i].getString();
                }
            }
        }
        catch (FormsFoundationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsFoundationException(e);
        }
        if (tags != null) {
            return this.resolveTags(tags);
        }
        return tags;
    }

    public String[] getResolvedAssetTags(String assetId) throws FormsFoundationException {
        Node node = this.mapAssetIdToNode(assetId);
        return this.getResolvedAssetTags(node);
    }

    public String[] resolveTags(String[] tagNames) throws FormsFoundationException {
        if (tagNames == null) {
            throw new FormsFoundationException("AEM-FF-002", new Object[0]);
        }
        TagManager tagManger = this.getTagManager();
        ArrayList<String> resolvedTags = new ArrayList<String>();
        for (int i = 0; i < tagNames.length; ++i) {
            Tag tag = tagManger.resolve(tagNames[i]);
            if (tag != null) {
                resolvedTags.add(tag.getPath());
                continue;
            }
            logger.warn("Tag named " + tagNames[i] + " does not exists.");
        }
        return resolvedTags.toArray(new String[resolvedTags.size()]);
    }

    private Node mapAssetIdToNode(String assetId) throws FormsFoundationException {
        Node node = null;
        try {
            if (assetId == null || assetId.trim().isEmpty()) {
                throw new FormsFoundationException("AEM-FF-002", new Object[0]);
            }
            Session session = this.getCurrentSession();
            if (!session.nodeExists(assetId)) {
                Object[] params = new Object[]{assetId};
                throw new FormsFoundationException("AEM-FF-004", params);
            }
            node = session.getNode(assetId);
        }
        catch (FormsFoundationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsFoundationException(e);
        }
        return node;
    }

    public Session getCurrentSession() throws FormsFoundationException {
        ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
        if (resolver == null) {
            throw new FormsFoundationException("AEM-FF-003", (Object[])null);
        }
        return resolver.adaptTo(Session.class);
    }

    public String getAssetTitle(String path) throws FormsFoundationException {
        String title = null;
        try {
            Node node = this.mapAssetIdToNode(path);
            FormsAssetType assetType = this.getAssetType(node);
            if (node.hasProperty(assetType.getTitleProperty())) {
                title = node.getProperty(assetType.getTitleProperty()).getValue().toString();
            }
        }
        catch (FormsFoundationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsFoundationException(e);
        }
        return title;
    }

    public boolean nodeExists(String assetName, String destinationPath) {
        boolean nodeExists = true;
        try {
            if (StringUtils.isEmpty(assetName)) {
                throw new FormsFoundationException("AEM-FF-002", new Object[0]);
            }
            if (StringUtils.isEmpty(destinationPath)) {
                throw new FormsFoundationException("AEM-FF-002", new Object[0]);
            }
            this.mapAssetIdToNode(destinationPath + "/" + assetName);
        }
        catch (FormsFoundationException e) {
            nodeExists = false;
            logger.debug("Exception occured in nodeExists function " + e);
        }
        return nodeExists;
    }

    private Map<String, String> findAssetPrefixAndSuffix(String name, String sourceAssetPath) throws FormsFoundationException {
        String suffix = null;
        String prefix = null;
        int indexOfSuffix = -1;
        Integer versionNumber = 0;
        FormsAssetType assetType = this.getAssetType(sourceAssetPath);
        String copy = assetType == FormsAssetType.DATA_DICTIONARY ? COPY_STR_FOR_DD : COPY_STR;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (name.lastIndexOf(copy) != -1) {
            indexOfSuffix = name.lastIndexOf(copy) + copy.length();
            prefix = name.substring(0, indexOfSuffix);
            if (name.length() > indexOfSuffix) {
                suffix = name.substring(indexOfSuffix);
                Matcher matcher = ptrnAllDigits.matcher(suffix);
                if (matcher.find()) {
                    versionNumber = Integer.parseInt(suffix);
                } else {
                    prefix = prefix + copy;
                }
            }
        } else {
            prefix = name + copy;
        }
        resultMap.put("prefix", prefix);
        resultMap.put("suffix", versionNumber.toString());
        return resultMap;
    }

    private String generateCopiedAssetName(String name, String path, String sourceAssetPath) throws FormsFoundationException {
        try {
            Session session = this.getCurrentSession();
            Node node = null;
            String prefix = null;
            String copiedAssetName = null;
            Map<Object, Object> nameInfoMap = new HashMap();
            int versionNumber = 0;
            if (!this.nodeExists(name, path)) {
                copiedAssetName = name;
            } else {
                node = session.getNode(path);
                if (node != null) {
                    Node childNode = null;
                    String resourceName = null;
                    String resourceSuffix = null;
                    int value = 0;
                    nameInfoMap = this.findAssetPrefixAndSuffix(name, sourceAssetPath);
                    prefix = (String)nameInfoMap.get("prefix");
                    versionNumber = Integer.parseInt((String)nameInfoMap.get("suffix"));
                    NodeIterator iterator = node.getNodes(prefix + "*");
                    while (iterator.hasNext()) {
                        childNode = iterator.nextNode();
                        resourceName = childNode.getName();
                        resourceSuffix = resourceName.substring(prefix.length());
                        Matcher matcher = ptrnAllDigits.matcher(resourceSuffix);
                        if (!matcher.find() || versionNumber >= (value = Integer.parseInt(resourceSuffix))) continue;
                        versionNumber = value;
                    }
                    copiedAssetName = prefix + ++versionNumber;
                }
            }
            return copiedAssetName;
        }
        catch (Exception e) {
            throw new FormsFoundationException(e);
        }
    }

    public Map<String, CopiedAssetInfo> generateCopiedAssetNames(String[] selectedItemsPath, String destinationFolderPath) throws FormsFoundationException {
        HashMap<String, Integer> assetNameMap = new HashMap<String, Integer>();
        String prefix = null;
        Map<Object, Object> nameInfoMap = new HashMap();
        int versionNumber = 0;
        HashMap<String, CopiedAssetInfo> copiedAssetInfoMap = new HashMap<String, CopiedAssetInfo>();
        CopiedAssetInfo copiedAssetInfo = null;
        try {
            if (selectedItemsPath == null || selectedItemsPath.length <= 0) {
                throw new FormsFoundationException("AEM-FF-002", new Object[0]);
            }
            if (StringUtils.isEmpty(destinationFolderPath)) {
                throw new FormsFoundationException("AEM-FF-002", new Object[0]);
            }
            for (String sourceAssetPath : selectedItemsPath) {
                String copiedAssetName;
                copiedAssetInfo = new CopiedAssetInfo();
                String sourceAssetName = this.mapAssetIdToNode(sourceAssetPath).getName();
                String assetTitle = this.getAssetTitle(sourceAssetPath);
                int version = 0;
                nameInfoMap = this.findAssetPrefixAndSuffix(sourceAssetName, sourceAssetPath);
                prefix = (String)nameInfoMap.get("prefix");
                if (assetNameMap.containsKey(prefix)) {
                    version = (Integer)assetNameMap.get(prefix) + 1;
                    copiedAssetName = prefix + version;
                    assetNameMap.put(prefix, version);
                } else {
                    copiedAssetName = this.generateCopiedAssetName(sourceAssetName, destinationFolderPath, sourceAssetPath);
                    if (copiedAssetName.equals(sourceAssetName)) {
                        prefix = copiedAssetName;
                        versionNumber = version;
                    } else {
                        nameInfoMap = this.findAssetPrefixAndSuffix(copiedAssetName, sourceAssetPath);
                        prefix = (String)nameInfoMap.get("prefix");
                        versionNumber = Integer.parseInt((String)nameInfoMap.get("suffix"));
                    }
                    assetNameMap.put(prefix, versionNumber);
                }
                copiedAssetInfo.setAssetName(copiedAssetName);
                copiedAssetInfo.setAssetTitle(assetTitle);
                copiedAssetInfoMap.put(sourceAssetPath, copiedAssetInfo);
            }
        }
        catch (FormsFoundationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsFoundationException(e);
        }
        return copiedAssetInfoMap;
    }

    public List<String> getChildAssetsPath(String folderPath, int depth, boolean includeChildFolderPath) throws FormsFoundationException {
        try {
            ArrayList<String> childNodePathList = new ArrayList();
            if (StringUtils.isEmpty(folderPath)) {
                throw new FormsFoundationException("AEM-FF-002", new Object[0]);
            }
            Node node = this.mapAssetIdToNode(folderPath);
            childNodePathList = this.listChildren(node, 0, depth, includeChildFolderPath);
            return childNodePathList;
        }
        catch (FormsFoundationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsFoundationException(e);
        }
    }

    private List<String> listChildren(Node node, int currentDepth, int desiredDepth, boolean includeChildFolderPath) throws FormsFoundationException {
        try {
            ArrayList<String> childNodePathList = new ArrayList<String>();
            String childNodePath = null;
            NodeIterator iterator = node.getNodes();
            ++currentDepth;
            Node childNode = null;
            while (iterator.hasNext()) {
                childNode = iterator.nextNode();
                if (childNode == null || currentDepth > desiredDepth && desiredDepth > 0) continue;
                childNodePath = childNode.getPath();
                if (childNode.isNodeType(DAM_ASSET_TYPE) || this.hasMixin(childNode, CM_MIXIN)) {
                    childNodePathList.add(childNodePath);
                    continue;
                }
                if (!childNode.isNodeType(STR_SLING_ORDERED_FOLDER) && !childNode.isNodeType(STR_NT_FOLDER) && !childNode.isNodeType(SLING_FOLDER)) continue;
                if (includeChildFolderPath) {
                    childNodePathList.add(childNodePath);
                }
                childNodePathList.addAll(this.listChildren(childNode, currentDepth, desiredDepth, includeChildFolderPath));
            }
            return childNodePathList;
        }
        catch (FormsFoundationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsFoundationException(e);
        }
    }

    private boolean hasMixin(Node node, String mixin) throws RepositoryException {
        if (node == null || mixin == null) {
            return false;
        }
        NodeType[] nodeTypes = node.getMixinNodeTypes();
        if (nodeTypes != null) {
            for (NodeType nodeType : nodeTypes) {
                if (!mixin.equals(nodeType.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public void updateReferences(String sourcePath, String destinationPath, String[] referencesPath) throws FormsFoundationException {
        try {
            if (sourcePath == null) {
                throw new FormsFoundationException("Source Path is null");
            }
            if (destinationPath == null) {
                throw new FormsFoundationException("Destination Path is null");
            }
            if (referencesPath != null && referencesPath.length > 0) {
                logger.info("Updating references");
                ArrayList<String> referencesList = new ArrayList<String>();
                for (String referencePath : referencesPath) {
                    if (referencePath.equals(sourcePath)) continue;
                    referencesList.add(referencePath);
                    FormsAssetType type = this.getAssetType(referencePath);
                    switch (type) {
                        case ADAPTIVE_DOCUMENT: 
                        case ADAPTIVE_FORM: 
                        case ADAPTIVE_FORM_FRAGMENT: {
                            referencesList.add(this.getCQPagePath(referencePath));
                        }
                    }
                }
                referencesList.add(destinationPath);
                ReferenceSearch refSearch = new ReferenceSearch();
                refSearch.adjustReferences(this.resourceResolverHelper.getResourceResolver(), sourcePath, destinationPath, referencesList.toArray(new String[0]));
            }
        }
        catch (FormsFoundationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsFoundationException(e);
        }
    }

    public String getCQPagePath(String assetPath) {
        assetPath = assetPath.replace(FORM_ROOT_PATH, FORM_PAGE_ROOT_PATH);
        return assetPath;
    }

    private TagManager getTagManager() throws FormsFoundationException {
        ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
        if (resolver == null) {
            throw new FormsFoundationException("AEM-FF-001", new String[]{"Resource resolever is null"});
        }
        return resolver.adaptTo(TagManager.class);
    }

    public String getRootPath(String assetPath) throws FormsFoundationException {
        String rootPath = "";
        FormsAssetType assetType = this.getAssetType(assetPath);
        if (assetType != null) {
            rootPath = assetType.getRootPath();
        }
        return rootPath;
    }

    public String getCorrespondingShadowNodePath(String assetPagePath) {
        return assetPagePath.replace(FORM_PAGE_ROOT_PATH, FORM_ROOT_PATH);
    }

    public String getContainingAssetPagePath(Page page) {
        Page parent = page;
        PageManager pm = page.getPageManager();
        String assetPath = null;
        while (parent != null && !Text.isDescendantOrEqual(assetPath = parent.getPath(), FORM_PAGE_ROOT_PATH)) {
            int idx = assetPath.lastIndexOf("/");
            String parentPath = null;
            if (idx >= 0) {
                parentPath = assetPath.substring(0, idx);
            }
            parent = pm.getContainingPage(parentPath);
        }
        return assetPath;
    }

    public void propagatePropertyToShadowNode(Page page, String propName, Object propValue, ResourceResolver resolver, boolean commit) throws FormsFoundationException {
        String assetPagePath = this.getContainingAssetPagePath(page);
        String assetContentPath = this.getCorrespondingShadowNodePath(assetPagePath) + "/" + "jcr:content";
        Resource assetContentResource = resolver.getResource(assetContentPath);
        ModifiableValueMap mvm = assetContentResource.adaptTo(ModifiableValueMap.class);
        mvm.put(propName, propValue);
        if (commit) {
            try {
                resolver.commit();
            }
            catch (Exception e) {
                logger.error("Error while committing with property change: " + propName + " = " + propValue + " at " + assetContentPath);
                throw new FormsFoundationException(e);
            }
        }
    }

    static {
        cmAssetTypeMap.put("com.adobe.icc.dbforms.obj.FragmentLayout", FormsAssetType.FRAGMENT_LAYOUT);
        cmAssetTypeMap.put("com.adobe.icc.dbforms.obj.Form", FormsAssetType.LETTER_LAYOUT);
        cmAssetTypeMap.put("com.adobe.icc.dbforms.obj.TextModule", FormsAssetType.TEXT);
        cmAssetTypeMap.put("com.adobe.icc.dbforms.obj.ListDataModule", FormsAssetType.LIST);
        cmAssetTypeMap.put("com.adobe.icc.dbforms.obj.ConditionalDataModule", FormsAssetType.CONDITION);
        cmAssetTypeMap.put("com.adobe.dct.transfer.DataDictionary", FormsAssetType.DATA_DICTIONARY);
        cmAssetTypeMap.put("com.adobe.icc.dbforms.obj.Letter", FormsAssetType.LETTER);
        cmAssetTypeMap.put("com.adobe.icc.dbforms.obj.Category", FormsAssetType.CATEGORY);
        cmAssetTypeMap.put("com.adobe.icc.dbforms.obj.ImageModule", FormsAssetType.IMAGE);
        cmAssetTypeMap.put("com.adobe.icc.dbforms.obj.ContentDataModule", FormsAssetType.CONTENT);
        supportedDAMDocumentFormats.add("application/pdf");
        supportedDAMDocumentFormats.add("application/vnd.ms-excel");
        supportedDAMDocumentFormats.add("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        supportedDAMDocumentFormats.add("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        supportedDAMDocumentFormats.add("application/vnd.ms-powerpoint");
        supportedDAMDocumentFormats.add("application/vnd.openxmlformats-officedocument.presentationml.presentation");
    }

    protected void bindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        this.resourceResolverHelper = resourceResolverHelper;
    }

    protected void unbindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        if (this.resourceResolverHelper == resourceResolverHelper) {
            this.resourceResolverHelper = null;
        }
    }
}

