/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.forms.foundation.service.util;

import com.adobe.forms.foundation.service.FormsFoundationException;
import com.adobe.forms.foundation.service.util.FormsFoundationUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(value={AssetUtils.class})
@Component
@Properties(value={@Property(name="connectors.jsoninvoker", boolValue={true}), @Property(name="connectors.jsoninvoker.alias", value={"ff.AssetUtils"})})
public class AssetUtils {
    private static final Logger log = LoggerFactory.getLogger(AssetUtils.class);
    @Reference
    FormsFoundationUtils formsFoundationUtils;
    private static final String CM_ROOT_PATH = "/content/apps/cm";
    private static final String FM_ROOT_PATH = "/content/dam/formsanddocuments";
    private static final String TEMPLATE_ROOT_PATH = "/conf";

    public String getDataSource(String path) throws FormsFoundationException {
        String dataSource = "";
        if (path != null && path.startsWith(CM_ROOT_PATH)) {
            log.info("Asset Type belongs to CM");
            dataSource = "fd/cm/ma/gui/components/admin/pagedatasource";
        }
        return dataSource;
    }

    public String getMillerColumnRenderer(String path) throws FormsFoundationException {
        String columnViewRenderer = "granite/ui/components/coral/foundation/form/pathfield/columnitem";
        if (path != null && path.startsWith(CM_ROOT_PATH)) {
            log.info("Asset Type belongs to CM");
            columnViewRenderer = "fd/cm/ma/gui/components/admin/childpagerenderer/childcolumnpage";
        } else if (path != null && path.startsWith(FM_ROOT_PATH)) {
            log.info("Asset Type belongs to FM");
            columnViewRenderer = "fd/fm/gui/components/admin/childasset/childcolumnpage";
        } else if (path != null && path.startsWith(TEMPLATE_ROOT_PATH)) {
            log.info("Asset Type belongs to Template");
            columnViewRenderer = "cq/gui/components/coral/common/form/templatefield/columnitem";
        }
        return columnViewRenderer;
    }

    public String getThumbnailRenderer(String path) throws FormsFoundationException {
        String thumbnailRenderer = "";
        if (path != null && path.startsWith(CM_ROOT_PATH)) {
            log.info("Asset Type belongs to CM");
            thumbnailRenderer = "fd/cm/ma/gui/components/admin/thumbnail";
        }
        return thumbnailRenderer;
    }

    protected void bindFormsFoundationUtils(FormsFoundationUtils formsFoundationUtils) {
        this.formsFoundationUtils = formsFoundationUtils;
    }

    protected void unbindFormsFoundationUtils(FormsFoundationUtils formsFoundationUtils) {
        if (this.formsFoundationUtils == formsFoundationUtils) {
            this.formsFoundationUtils = null;
        }
    }
}

