/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.forms.foundation.service.handlers;

import com.adobe.granite.confmgr.Conf;
import com.adobe.granite.omnisearch.commons.AbstractOmniSearchHandler;
import com.day.cq.search.Predicate;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.SearchResult;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Session;
import javax.jcr.observation.EventIterator;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public abstract class FormsAbstractOmniSearchHandler
extends AbstractOmniSearchHandler {
    private final String TYPE_PREDICATE_PARAMETER = "type";
    private final String PATH_PREDICATE_PARAMETER = "path";
    private final String HANDLER_SEARCH_PATHS_PREDICATE_PARAMETER = "handlerSearchPaths";
    protected final String OMNI_SEARCH_SUB_SERVICE_USER = "omnisearch-subservice";
    private static final Logger logger = LoggerFactory.getLogger(FormsAbstractOmniSearchHandler.class);
    @Reference
    private QueryBuilder queryBuilder;
    @Reference
    private ResourceResolverFactory resolverFactory;

    public SearchResult getResults(ResourceResolver resolver, Map predicateParameters, long limit, long offset) {
        Resource moduleConfig = this.getModuleConfig(resolver);
        if (moduleConfig == null) {
            return null;
        }
        PredicateGroup pathPredicateGroup = null;
        if (!predicateParameters.containsKey("type")) {
            predicateParameters.put("type", this.getResourceType());
        }
        if (!predicateParameters.containsKey("path")) {
            String[] paths = null;
            if (!predicateParameters.containsKey("handlerSearchPaths")) {
                ValueMap configValueMap = moduleConfig.adaptTo(ValueMap.class);
                paths = (String[])configValueMap.get("handlerSearchPaths", String[].class);
            }
            if (paths != null && paths.length > 0) {
                pathPredicateGroup = new PredicateGroup();
                pathPredicateGroup.setAllRequired(false);
                Predicate pathPredicate = null;
                for (int index = 0; index < paths.length; ++index) {
                    pathPredicate = new Predicate("path");
                    pathPredicate.set("path", paths[index]);
                    pathPredicateGroup.add(pathPredicate);
                }
            } else {
                predicateParameters.put("path", this.getDefaultSearchPath());
            }
        }
        try {
            PredicateGroup[] predicateGroup;
            PredicateGroup predicates = PredicateGroup.create(predicateParameters);
            if (pathPredicateGroup != null) {
                predicates.add(pathPredicateGroup);
            }
            if ((predicateGroup = this.getPredicates()) != null) {
                for (int i = 0; i < predicateGroup.length; ++i) {
                    if (predicateGroup[i] == null) continue;
                    predicates.add(predicateGroup[i]);
                }
            }
            Query query = this.queryBuilder.createQuery(predicates, resolver.adaptTo(Session.class));
            if (limit != 0L) {
                query.setHitsPerPage(limit);
            }
            if (offset != 0L) {
                query.setStart(offset);
            }
            SearchResult queryResult = query.getResult();
            return queryResult;
        }
        catch (Exception e) {
            logger.error("Error in generating search result", e);
            return null;
        }
    }

    @Override
    protected Resource getPredicateRootResource(ResourceResolver resolver) {
        Conf conf = resolver.getResource("/content").adaptTo(Conf.class);
        return conf.getItemResource(this.getPredicatePath());
    }

    private ResourceResolver getResourceResolver() throws LoginException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("sling.service.subservice", "omnisearch-subservice");
        return this.resolverFactory.getServiceResourceResolver(param);
    }

    @Override
    public void onEvent(EventIterator eventIterator) {
        try {
            this.init(this.getResourceResolver());
        }
        catch (Exception e) {
            logger.error("Error during updation", e);
        }
    }

    protected PredicateGroup[] getPredicates() {
        return null;
    }

    protected void activate(ComponentContext componentContext) throws LoginException {
        this.init(this.getResourceResolver());
    }

    protected void deactivate(ComponentContext componentContext) throws LoginException {
        this.destroy(this.getResourceResolver());
    }

    protected void bindQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    protected void unbindQueryBuilder(QueryBuilder queryBuilder) {
        if (this.queryBuilder == queryBuilder) {
            this.queryBuilder = null;
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }
}

