/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.forms.foundation.cloudconfig.migration;

import com.adobe.cq.cloudconfig.core.Constants;
import com.adobe.forms.foundation.migration.api.TaskContext;
import com.adobe.forms.foundation.migration.spi.MigrationTask;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;

public abstract class CloudServicesMigrator
extends MigrationTask {
    private static final String CLOUD_CONFIGURATION_GLOBAL_CONTAINER = "/conf/global";
    private static final String CLOUD_CONFIGURATION_BUCKET_PATH = "/conf/global/" + Constants.CLOUDCONFIG_BUCKET_PATH;
    private static final String MERGE_LIST = "mergeList";
    private Map<String, ConfigurationProperty> migrationMappings = new HashMap<String, ConfigurationProperty>();
    private ResourceResolver resourceResolver;

    protected abstract ResourceResolver getResourceResolver() throws LoginException;

    @Nonnull
    protected abstract String getCloudServiceName();

    @Nonnull
    protected abstract String getCloudConfigurationGroup();

    @Nonnull
    protected abstract String getLegacyConfigurationRootFolder();

    @Nonnull
    protected abstract String[] getResourcesRootFolders();

    protected void performPostMigrationUpdates(@Nonnull Resource configurationContainer) {
    }

    protected abstract void updateResource(@Nonnull Resource var1) throws PersistenceException;

    private Resource moveLegacyCloudServices(@Nonnull String legacyConfigurationRootFolder, @Nonnull String group) throws LoginException, PersistenceException, RepositoryException {
        Resource sourceContainer = this.resourceResolver.getResource(legacyConfigurationRootFolder);
        Resource destinationContainer = ResourceUtil.getOrCreateResource(this.resourceResolver, CLOUD_CONFIGURATION_BUCKET_PATH + "/" + group, "sling:Folder", "sling:Folder", false);
        ModifiableValueMap modifiableValueMap = destinationContainer.adaptTo(ModifiableValueMap.class);
        modifiableValueMap.put(MERGE_LIST, true);
        Session session = this.resourceResolver.adaptTo(Session.class);
        String destination = CLOUD_CONFIGURATION_BUCKET_PATH + "/" + group;
        Iterator<Resource> iterator = sourceContainer.listChildren();
        Integer confCount = 0;
        while (iterator.hasNext()) {
            Resource configuration = iterator.next();
            Integer n = confCount;
            Integer n2 = confCount = Integer.valueOf(confCount + 1);
            if (!configuration.isResourceType("cq:Page")) continue;
            String source = configuration.getPath();
            String name = configuration.getName();
            ConfigurationProperty configurationProperty = null;
            if (this.resourceResolver.getResource(destination + "/" + name) == null) {
                session.move(source, destination + "/" + name);
                configurationProperty = new ConfigurationProperty(CLOUD_CONFIGURATION_GLOBAL_CONTAINER, name);
            }
            this.migrationMappings.put(source, configurationProperty);
        }
        return destinationContainer;
    }

    private boolean isFolder(Resource resource) throws RepositoryException {
        Node node = resource.adaptTo(Node.class);
        return node.isNodeType("sling:Folder") || node.isNodeType("sling:OrderedFolder") || node.isNodeType("nt:folder");
    }

    private void updateResources(@Nonnull Resource root) throws PersistenceException, RepositoryException {
        if (this.isFolder(root)) {
            Iterator<Resource> iterator = root.listChildren();
            while (iterator.hasNext()) {
                Resource child = iterator.next();
                if (this.isFolder(child)) {
                    this.updateResources(child);
                    continue;
                }
                this.updateResource(child);
            }
        }
    }

    public final synchronized void migrateLegacyCloudServices(TaskContext taskContext) throws LoginException, PersistenceException, RepositoryException {
        taskContext.info("Migration of " + this.getCloudServiceName() + " configurations started.", new Object[0]);
        this.resourceResolver = this.getResourceResolver();
        String legacyCloudServicesRootFolder = this.getLegacyConfigurationRootFolder();
        String cloudConfigurationGroup = this.getCloudConfigurationGroup();
        Resource configurationContainer = this.moveLegacyCloudServices(legacyCloudServicesRootFolder, cloudConfigurationGroup);
        if (configurationContainer != null) {
            String[] resourceRootPaths;
            this.performPostMigrationUpdates(configurationContainer);
            for (String resourceRootPath : resourceRootPaths = this.getResourcesRootFolders()) {
                Resource root = this.resourceResolver.getResource(resourceRootPath);
                this.updateResources(root);
            }
        }
        this.resourceResolver.commit();
        this.resourceResolver.close();
        boolean warnings = false;
        Set<String> configurations = this.migrationMappings.keySet();
        for (String configuration : configurations) {
            ConfigurationProperty property = this.migrationMappings.get(configuration);
            if (property != null) {
                taskContext.info("Configuration at [" + configuration + "] is moved to [" + property.configurationContainer + "/" + Constants.CLOUDCONFIG_BUCKET_PATH + "/" + cloudConfigurationGroup + "/" + property.configurationName + "].", new Object[0]);
                continue;
            }
            warnings = true;
            taskContext.warn("Configuration at [" + configuration + "] could not be moved.", new Object[0]);
        }
        if (warnings) {
            taskContext.info("Migration of " + this.getCloudServiceName() + " configurations finished successfully with warnings.", new Object[0]);
        } else {
            taskContext.success("Migration of " + this.getCloudServiceName() + " configurations finished successfully without any warnings and errors.", new Object[0]);
        }
        this.migrationMappings.clear();
    }

    @Override
    public final void startTask(TaskContext taskContext) {
        try {
            this.migrateLegacyCloudServices(taskContext);
        }
        catch (RepositoryException | LoginException | PersistenceException e) {
            taskContext.error("Error during migration of " + this.getCloudServiceName() + " configurations", e);
        }
    }

    public final ConfigurationProperty getMigratedConfigurationPropertiesFor(@Nonnull String legacyConfigurationPath) {
        return this.migrationMappings.get(legacyConfigurationPath);
    }

    public class ConfigurationProperty {
        public String configurationContainer;
        public String configurationName;

        public ConfigurationProperty(String configurationContainer, String configurationName) {
            this.configurationContainer = configurationContainer;
            this.configurationName = configurationName;
        }
    }
}

