/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.math;

import com.adobe.agl.text.DecimalFormat;

public final class F2Dot14 {
    public static final int ZERO = 0;
    public static final int ONE = 16384;
    public static final int ONE_SIXTEENTH = 1024;
    private static final DecimalFormat df = new DecimalFormat("0.###");

    private static int clamp(long x) {
        if (x > 32767L) {
            return Short.MAX_VALUE;
        }
        if (x < -32768L) {
            return Short.MIN_VALUE;
        }
        return (int)x;
    }

    public static int multiply(int v1, int v2) {
        return F2Dot14.clamp(((long)v1 * (long)v2 >> 13) + 1L >> 1);
    }

    public static int square(int v) {
        return F2Dot14.multiply(v, v);
    }

    public static int fromDouble(double v) {
        return (int)(v * 16384.0);
    }

    public static double toDouble(int v) {
        return (double)v / 16384.0;
    }

    public static String toString(int v) {
        return df.format(F2Dot14.toDouble(v));
    }
}

