/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting.infontformatting;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.CharUtil;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTSelector;
import com.adobe.fontengine.font.opentype.OTSelectorOnElementAttribute;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.fontengine.font.opentype.Tag;
import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.ElementAttribute;
import com.adobe.fontengine.inlineformatting.infontformatting.GenericFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.InFontFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.LookupsCache;
import java.util.ArrayList;

abstract class IndicFormatter
extends GenericFormatter {
    private static final ElementAttribute indicShape = new ElementAttribute("indicShape");
    private static final OTSelector everywhere = new OTSelector();
    private static final OTSelector akhnSelector = new OTSelector(){

        public boolean isApplied(AttributedRun run, int position) {
            Object v = run.getElementStyle(position, indicShape);
            return v != Shape.explicitVirama && v != Shape.half;
        }
    };
    private static final OTSelector rphfSelector = new OTSelector(){

        public boolean isApplied(AttributedRun run, int position) {
            Object v = run.getElementStyle(position, indicShape);
            return v == Shape.rephCons || v == Shape.rephVowel;
        }
    };
    private static final OTSelector blwfSelector = new OTSelectorOnElementAttribute(indicShape, Shape.subjoins, true);
    private static final OTSelector pstfSelector = new OTSelectorOnElementAttribute(indicShape, Shape.postjoins, true);
    private static final OTSelector halfSelector = new OTSelector(){

        public boolean isApplied(AttributedRun run, int position) {
            Object v = run.getElementStyle(position, indicShape);
            return v != Shape.explicitVirama;
        }
    };
    static final int[] gsubFeatures = new int[]{Tag.feature_nukt, Tag.feature_akhn, Tag.feature_rphf, Tag.feature_blwf, Tag.feature_half, Tag.feature_vatu, Tag.feature_pres, Tag.feature_abvs, Tag.feature_blws, Tag.feature_psts, Tag.feature_haln, Tag.feature_pstf};
    static final int[] gposFeatures = new int[]{Tag.feature_abvm, Tag.feature_blwm, Tag.feature_dist};

    IndicFormatter() {
    }

    protected abstract int nukta();

    protected abstract int virama();

    protected abstract int splitVowelsAndNormalize(AttributedRun var1, int var2, int var3);

    protected abstract Position getPosition(int var1);

    protected abstract boolean isConsonant(int var1);

    protected abstract boolean hasNukta(int var1);

    protected abstract int removeNukta(int var1);

    protected abstract boolean isMark(int var1);

    protected abstract boolean isIndependentVowel(int var1);

    protected abstract Shape rephLike(int var1);

    protected abstract boolean subjoins(int var1);

    protected abstract boolean postjoins(int var1);

    protected abstract boolean postjoinsIndependentVowels(int var1);

    private int processAksaraMarks(AttributedRun run, int start, int limit, Aksara aksara) {
        aksara.firstMark = start;
        while (start < limit && this.isMark(run.elementAt(start))) {
            ++start;
        }
        aksara.limit = start;
        return start;
    }

    private int processAksaras(AttributedRun run, int start, int limit, OpenTypeFont font) throws InvalidFontException, UnsupportedFontException {
        Aksara aksara = new Aksara();
        while (start < limit) {
            aksara.reset();
            aksara.start = start;
            if (this.isConsonant(run.elementAt(start))) {
                while (start < limit && this.isConsonant(run.elementAt(start))) {
                    AksaraPart part = new AksaraPart();
                    part.shape = Shape.live;
                    if (this.hasNukta(run.elementAt(start))) {
                        part.nuktaCount = 1;
                        part.usv = this.removeNukta(run.elementAt(start));
                    } else {
                        part.nuktaCount = 0;
                        part.usv = run.elementAt(start);
                    }
                    ++start;
                    while (start < limit && this.nukta() == run.elementAt(start)) {
                        ++part.nuktaCount;
                        ++start;
                    }
                    if (start < limit && this.virama() == run.elementAt(start)) {
                        part.shape = Shape.dead;
                        if (++start < limit && 8205 == run.elementAt(start)) {
                            part.shape = Shape.half;
                            ++start;
                        } else if (start < limit && 8204 == run.elementAt(start)) {
                            part.shape = Shape.explicitVirama;
                            ++start;
                        }
                    }
                    aksara.parts.add(part);
                    if (part.shape != Shape.live) continue;
                    break;
                }
                if (aksara.parts.size() > 1) {
                    AksaraPart firstPart = (AksaraPart)aksara.parts.get(0);
                    Shape rephShape = this.rephLike(firstPart.usv);
                    if (rephShape != Shape.any && firstPart.shape == Shape.dead) {
                        firstPart.shape = rephShape;
                    }
                }
                for (int i = 1; i < aksara.parts.size(); ++i) {
                    AksaraPart part = (AksaraPart)aksara.parts.get(i);
                    AksaraPart prevPart = (AksaraPart)aksara.parts.get(i - 1);
                    if (!this.subjoins(part.usv) || part.shape != Shape.dead && part.shape != Shape.live || prevPart.shape != Shape.dead) continue;
                    if (part.shape == Shape.live) {
                        prevPart.shape = Shape.live;
                    }
                    part.shape = Shape.subjoins;
                }
                if (aksara.parts.size() > 1) {
                    AksaraPart part = (AksaraPart)aksara.parts.get(aksara.parts.size() - 1);
                    AksaraPart prevPart = (AksaraPart)aksara.parts.get(aksara.parts.size() - 2);
                    if (this.postjoins(part.usv) && (part.shape == Shape.dead || part.shape == Shape.live) && prevPart.shape == Shape.dead) {
                        if (part.shape == Shape.live) {
                            prevPart.shape = Shape.live;
                        }
                        part.shape = Shape.postjoins;
                    }
                }
                start = this.processAksaraMarks(run, start, limit, aksara);
            } else if (this.isIndependentVowel(run.elementAt(start))) {
                AksaraPart part = new AksaraPart();
                part.shape = Shape.live;
                part.usv = run.elementAt(start);
                part.nuktaCount = 0;
                aksara.parts.add(part);
                ++start;
                while (start + 1 < limit && this.virama() == run.elementAt(start) && this.postjoinsIndependentVowels(run.elementAt(start + 1))) {
                    part = new AksaraPart();
                    part.shape = Shape.postjoins;
                    part.usv = run.elementAt(start + 1);
                    part.nuktaCount = 0;
                    aksara.parts.add(part);
                    start += 2;
                }
                start = this.processAksaraMarks(run, start, limit, aksara);
            } else {
                AksaraPart part = new AksaraPart();
                part.shape = Shape.live;
                part.usv = run.elementAt(start);
                part.nuktaCount = 0;
                aksara.parts.add(part);
                aksara.firstMark = ++start;
                aksara.limit = start;
            }
            int newStart = aksara.toGlyphs(run, font);
            limit += newStart - start;
            start = newStart;
        }
        return limit;
    }

    protected int canRenderWithFont(OpenTypeFont font, AttributedRun run, int start, int limit, boolean notdefOk) throws InvalidFontException, UnsupportedFontException {
        int usvc;
        int gid;
        int graphemeLimit;
        int usv = run.elementAt(start);
        if (CharUtil.isControl(usv)) {
            return 1;
        }
        if (!CharUtil.isBase(usv) || start + 1 == limit || run.getElementStyle(start + 1, ElementAttribute.isGlyph) == Boolean.TRUE || !CharUtil.isCombining(run.elementAt(start + 1))) {
            int gid2 = font.getGlyphForChar(usv);
            return gid2 == 0 ? 0 : start + 1;
        }
        for (graphemeLimit = start + 1; graphemeLimit < limit && run.getElementStyle(graphemeLimit, ElementAttribute.isGlyph) == Boolean.FALSE && CharUtil.isCombining(run.elementAt(graphemeLimit)); ++graphemeLimit) {
        }
        boolean directMappingHasNotdef = false;
        int[] usvs = new int[graphemeLimit - start];
        int[] gids = new int[graphemeLimit - start];
        for (int i = start; i < graphemeLimit; ++i) {
            usvs[i - start] = run.elementAt(i);
            gid = font.getGlyphForChar(usvs[i - start]);
            if (gid == 0) {
                directMappingHasNotdef = true;
            }
            gids[i - start] = gid;
        }
        if (directMappingHasNotdef && (usvc = CharUtil.compose(usvs, 0, graphemeLimit - start)) != -1 && (gid = font.getGlyphForChar(usvc)) != 0) {
            return graphemeLimit - start;
        }
        if (notdefOk) {
            return graphemeLimit - start;
        }
        return 0;
    }

    protected boolean canFormatOT() {
        return true;
    }

    protected int formatOT(OpenTypeFont otFont, AttributedRun run, int start, int limit, boolean shouldKern) throws InvalidFontException, UnsupportedFontException {
        int scriptTag = IndicFormatter.getOTScriptTag((Integer)run.getElementStyle(start, InFontFormatter.scriptAttribute));
        int langTag = IndicFormatter.getOTLanguageTag((ULocale)run.getElementStyle(start, ElementAttribute.locale));
        limit = this.splitVowelsAndNormalize(run, start, limit);
        limit = this.processAksaras(run, start, limit, otFont);
        if (otFont.gsub != null) {
            int[][] gsubLookups = LookupsCache.resolveFeatureTag(otFont.gsub, scriptTag, langTag, gsubFeatures);
            limit = otFont.gsub.applyLookups(gsubLookups[0], run, start, limit, everywhere, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[1], run, start, limit, akhnSelector, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[2], run, start, limit, rphfSelector, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[3], run, start, limit, blwfSelector, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[11], run, start, limit, pstfSelector, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[4], run, start, limit, halfSelector, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[5], run, start, limit, everywhere, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[6], run, start, limit, everywhere, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[7], run, start, limit, everywhere, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[8], run, start, limit, everywhere, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[9], run, start, limit, everywhere, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[10], run, start, limit, everywhere, otFont.gdef);
        }
        this.posFromAdvanceWidth(run, otFont, start, limit);
        if (otFont.gpos != null) {
            int[][] gposLookups = LookupsCache.resolveFeatureTag(otFont.gpos, scriptTag, langTag, gposFeatures);
            limit = otFont.gpos.applyLookups(gposLookups[0], run, start, limit, everywhere, otFont.gdef);
            limit = otFont.gpos.applyLookups(gposLookups[1], run, start, limit, everywhere, otFont.gdef);
            limit = otFont.gpos.applyLookups(gposLookups[2], run, start, limit, everywhere, otFont.gdef);
        }
        return limit;
    }

    final class Aksara {
        public int start;
        public int firstMark;
        public int limit;
        public ArrayList parts;

        public Aksara() {
            this.reset();
        }

        public void reset() {
            this.parts = new ArrayList();
        }

        public int nbGlyphs() {
            int nbGlyphs = this.limit - this.firstMark;
            for (int i = 0; i < this.parts.size(); ++i) {
                nbGlyphs += ((AksaraPart)this.parts.get(i)).nbGlyphs();
            }
            return nbGlyphs;
        }

        public int addGlyph(int[] glyphIds, Shape[] glyphForms, int glyphCount, int ch, Shape shape, OpenTypeFont font) throws InvalidFontException, UnsupportedFontException {
            glyphIds[glyphCount] = font.getGlyphForChar(ch);
            glyphForms[glyphCount] = shape;
            return glyphCount + 1;
        }

        public int toGlyphs(AttributedRun run, OpenTypeFont font) throws InvalidFontException, UnsupportedFontException {
            int i;
            int i2;
            int[] glyphIds = new int[this.nbGlyphs()];
            Shape[] glyphForms = new Shape[glyphIds.length];
            int glyphCount = 0;
            for (int i3 = this.firstMark; i3 < this.limit; ++i3) {
                int usv = run.elementAt(i3);
                if (IndicFormatter.this.getPosition(usv) != Position.left) continue;
                glyphCount = this.addGlyph(glyphIds, glyphForms, glyphCount, usv, Shape.any, font);
            }
            AksaraPart firstPart = null;
            AksaraPart lastPart = null;
            for (i2 = 0; i2 < this.parts.size(); ++i2) {
                AksaraPart part = (AksaraPart)this.parts.get(i2);
                if (firstPart == null) {
                    firstPart = part;
                }
                lastPart = part;
                if (part.shape == Shape.rephCons || part.shape == Shape.rephVowel || part.shape == Shape.postjoins) continue;
                glyphCount = part.toGlyphs(glyphIds, glyphForms, glyphCount, font);
            }
            for (i2 = this.firstMark; i2 < this.limit; ++i2) {
                int usv = run.elementAt(i2);
                if (IndicFormatter.this.getPosition(usv) != Position.bottom) continue;
                glyphCount = this.addGlyph(glyphIds, glyphForms, glyphCount, usv, Shape.any, font);
            }
            for (i2 = this.firstMark; i2 < this.limit; ++i2) {
                int usv = run.elementAt(i2);
                if (IndicFormatter.this.getPosition(usv) != Position.topMatra) continue;
                glyphCount = this.addGlyph(glyphIds, glyphForms, glyphCount, usv, Shape.any, font);
            }
            if (firstPart.shape == Shape.rephCons) {
                glyphCount = firstPart.toGlyphs(glyphIds, glyphForms, glyphCount, font);
            }
            if (lastPart.shape == Shape.postjoins) {
                glyphCount = lastPart.toGlyphs(glyphIds, glyphForms, glyphCount, font);
            }
            for (i2 = this.firstMark; i2 < this.limit; ++i2) {
                int usv = run.elementAt(i2);
                if (IndicFormatter.this.getPosition(usv) != Position.rightMatra) continue;
                glyphCount = this.addGlyph(glyphIds, glyphForms, glyphCount, usv, Shape.any, font);
            }
            if (firstPart.shape == Shape.rephVowel) {
                glyphCount = firstPart.toGlyphs(glyphIds, glyphForms, glyphCount, font);
            }
            for (i2 = this.firstMark; i2 < this.limit; ++i2) {
                int usv = run.elementAt(i2);
                if (IndicFormatter.this.getPosition(usv) != Position.topOther) continue;
                glyphCount = this.addGlyph(glyphIds, glyphForms, glyphCount, usv, Shape.any, font);
            }
            for (i2 = this.firstMark; i2 < this.limit; ++i2) {
                int usv = run.elementAt(i2);
                if (IndicFormatter.this.getPosition(usv) != Position.rightOther) continue;
                glyphCount = this.addGlyph(glyphIds, glyphForms, glyphCount, usv, Shape.any, font);
            }
            int[] positions = new int[this.limit - this.start];
            for (i = 0; i < positions.length; ++i) {
                positions[i] = this.start + i;
            }
            run.replace(positions, glyphIds);
            run.setElementStyle(this.start, this.start + glyphIds.length, ElementAttribute.isGlyph, Boolean.TRUE);
            for (i = 0; i < glyphIds.length; ++i) {
                run.setElementStyle(this.start + i, indicShape, glyphForms[i]);
            }
            return this.start + glyphIds.length;
        }
    }

    final class AksaraPart {
        public int usv;
        public int nuktaCount;
        public Shape shape;

        AksaraPart() {
        }

        public int nbGlyphs() {
            return 1 + this.nuktaCount + (this.shape != Shape.live ? 1 : 0);
        }

        public int addGlyph(int[] glyphIds, Shape[] glyphForms, int glyphCount, int ch, Shape shape, OpenTypeFont font) throws InvalidFontException, UnsupportedFontException {
            glyphIds[glyphCount] = font.getGlyphForChar(ch);
            glyphForms[glyphCount] = shape;
            return glyphCount + 1;
        }

        public int toGlyphs(int[] glyphIds, Shape[] glyphForms, int glyphCount, OpenTypeFont font) throws InvalidFontException, UnsupportedFontException {
            glyphCount = this.addGlyph(glyphIds, glyphForms, glyphCount, this.usv, this.shape, font);
            for (int i = 0; i < this.nuktaCount; ++i) {
                glyphCount = this.addGlyph(glyphIds, glyphForms, glyphCount, IndicFormatter.this.nukta(), Shape.any, font);
            }
            if (this.shape != Shape.live) {
                glyphCount = this.addGlyph(glyphIds, glyphForms, glyphCount, IndicFormatter.this.virama(), this.shape, font);
            }
            return glyphCount;
        }
    }

    public static final class Position {
        private String name;
        public static final Position any = new Position("any");
        public static final Position left = new Position("left");
        public static final Position topMatra = new Position("topMatra");
        public static final Position topOther = new Position("topOther");
        public static final Position bottom = new Position("bottom");
        public static final Position rightMatra = new Position("rightMatra");
        public static final Position rightOther = new Position("rightOther");

        private Position(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static final class Shape {
        private String name;
        public static final Shape any = new Shape("any");
        public static final Shape live = new Shape("live");
        public static final Shape dead = new Shape("dead");
        public static final Shape half = new Shape("half");
        public static final Shape explicitVirama = new Shape("explicitVirama");
        public static final Shape rephCons = new Shape("rephCons");
        public static final Shape rephVowel = new Shape("rephVowel");
        public static final Shape vattu = new Shape("vattu");
        public static final Shape subjoins = new Shape("subjoins");
        public static final Shape postjoins = new Shape("postjoins");

        private Shape(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

