/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting.infontformatting;

import com.adobe.agl.lang.UScript;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.ElementAttribute;
import com.adobe.fontengine.inlineformatting.infontformatting.ArabicFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.BaseFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.BengaliFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.DevanagariFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.GenericFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.GlyphFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.GujaratiFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.GurmukhiFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.HanKanaFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.HangulFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.KannadaFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.LaoFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.OriyaFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.TamilFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.TeluguFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.ThaiFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.TibetanFormatter;
import java.util.HashSet;
import java.util.Set;

public final class InFontFormatter {
    private static final BaseFormatter[] scriptFormatters = new BaseFormatter[130];
    private static final BaseFormatter glyphFormatter = new GlyphFormatter();
    public static final ElementAttribute scriptAttribute;
    protected static final Set typographicSystem;
    protected static final Set fontAtts;

    private InFontFormatter() {
    }

    static void resolveScript(AttributedRun run, int first, int limit) {
        int ambientScriptNumber = 0;
        Integer ambientScript = null;
        int lastToFix = first - 1;
        for (int i = first; i < limit; ++i) {
            if (run.getElementStyle(i, ElementAttribute.isGlyph) == Boolean.TRUE) continue;
            int script = UScript.getScript(run.elementAt(i));
            if (script == 0 || script == 1) {
                if (ambientScript != null) {
                    run.setElementStyle(i, scriptAttribute, ambientScript);
                    continue;
                }
                lastToFix = i;
                continue;
            }
            if (script != ambientScriptNumber) {
                ambientScriptNumber = script;
                ambientScript = new Integer(script);
                if (lastToFix != first - 1) {
                    for (int k = first; k <= lastToFix; ++k) {
                        run.setElementStyle(k, scriptAttribute, ambientScript);
                    }
                    lastToFix = first - 1;
                }
            }
            run.setElementStyle(i, scriptAttribute, ambientScript);
        }
        if (lastToFix != first - 1) {
            for (int k = first; k <= lastToFix; ++k) {
                run.setElementStyle(k, scriptAttribute, new Integer(25));
            }
        }
    }

    public static int preFormat(AttributedRun run, int start, int limit) {
        while (start < limit) {
            int glyphLimit = run.getSubrunLimit(start, limit, ElementAttribute.isGlyph);
            boolean isGlyph = (Boolean)run.getElementStyle(start, ElementAttribute.isGlyph);
            if (isGlyph) {
                start = glyphLimit;
                continue;
            }
            InFontFormatter.resolveScript(run, start, glyphLimit);
            start = glyphLimit;
        }
        return limit;
    }

    public static int firstPass(AttributedRun run, int start, int limit) {
        while (start < limit) {
            int glyphLimit = run.getSubrunLimit(start, limit, ElementAttribute.isGlyph);
            boolean isGlyph = (Boolean)run.getElementStyle(start, ElementAttribute.isGlyph);
            if (isGlyph) {
                start = glyphLimit;
                continue;
            }
            while (start < glyphLimit) {
                int newScriptLimit;
                int scriptLimit = run.getSubrunLimit(start, glyphLimit, scriptAttribute);
                int script = (Integer)run.getElementStyle(start, scriptAttribute);
                start = newScriptLimit = scriptFormatters[script].firstPass(run, start, scriptLimit);
                glyphLimit += newScriptLimit - scriptLimit;
                limit += newScriptLimit - scriptLimit;
            }
        }
        return limit;
    }

    public static int canRenderWithFont(FontData font, AttributedRun run, int start, int limit) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        int script = (Integer)run.getElementStyle(start, scriptAttribute);
        return scriptFormatters[script].canRenderWithFont(font, run, start, limit);
    }

    public static int canRenderWithNotdef(AttributedRun run, int start, int limit) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        int script = (Integer)run.getElementStyle(start, scriptAttribute);
        return scriptFormatters[script].canRenderWithNotdef(run, start, limit);
    }

    public static int format(AttributedRun run, int start, int limit, boolean shouldKern) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        while (start < limit) {
            int newTypographicSystemLimit;
            int typographicSystemLimit = run.getSubrunLimit(start, limit, typographicSystem);
            boolean isGlyph = (Boolean)run.getElementStyle(start, ElementAttribute.isGlyph);
            if (isGlyph) {
                newTypographicSystemLimit = glyphFormatter.format(run, start, typographicSystemLimit, shouldKern);
            } else {
                int script = (Integer)run.getElementStyle(start, scriptAttribute);
                newTypographicSystemLimit = scriptFormatters[script].format(run, start, typographicSystemLimit, shouldKern);
            }
            start = newTypographicSystemLimit;
            limit += newTypographicSystemLimit - typographicSystemLimit;
        }
        return limit;
    }

    static {
        GenericFormatter genericFormatter = new GenericFormatter();
        for (int i = 0; i < scriptFormatters.length; ++i) {
            InFontFormatter.scriptFormatters[i] = genericFormatter;
        }
        InFontFormatter.scriptFormatters[2] = new ArabicFormatter();
        InFontFormatter.scriptFormatters[4] = new BengaliFormatter();
        InFontFormatter.scriptFormatters[10] = new DevanagariFormatter();
        InFontFormatter.scriptFormatters[15] = new GujaratiFormatter();
        InFontFormatter.scriptFormatters[16] = new GurmukhiFormatter();
        InFontFormatter.scriptFormatters[18] = new HangulFormatter();
        InFontFormatter.scriptFormatters[21] = new KannadaFormatter();
        InFontFormatter.scriptFormatters[24] = new LaoFormatter();
        InFontFormatter.scriptFormatters[31] = new OriyaFormatter();
        InFontFormatter.scriptFormatters[35] = new TamilFormatter();
        InFontFormatter.scriptFormatters[36] = new TeluguFormatter();
        InFontFormatter.scriptFormatters[38] = new ThaiFormatter();
        InFontFormatter.scriptFormatters[39] = new TibetanFormatter();
        HanKanaFormatter hanKanaFormatter = new HanKanaFormatter();
        InFontFormatter.scriptFormatters[20] = hanKanaFormatter;
        InFontFormatter.scriptFormatters[22] = hanKanaFormatter;
        InFontFormatter.scriptFormatters[54] = hanKanaFormatter;
        InFontFormatter.scriptFormatters[17] = hanKanaFormatter;
        scriptAttribute = new ElementAttribute("script");
        typographicSystem = new HashSet();
        typographicSystem.add(scriptAttribute);
        typographicSystem.add(ElementAttribute.locale);
        typographicSystem.add(ElementAttribute.isGlyph);
        fontAtts = new HashSet();
        fontAtts.add(ElementAttribute.font);
    }
}

