/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting.infontformatting;

import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.infontformatting.IndicFormatter;

final class DevanagariFormatter
extends IndicFormatter {
    DevanagariFormatter() {
    }

    protected int splitVowelsAndNormalize(AttributedRun run, int start, int limit) {
        while (start < limit) {
            int usv = run.elementAt(start);
            switch (usv) {
                case 2353: {
                    if (start + 1 >= limit || run.elementAt(start + 1) != 2381) break;
                    run.replace(new int[]{start, start + 1}, new int[]{2352, 2381, 8205});
                    ++limit;
                    start += 3;
                }
            }
            ++start;
        }
        return limit;
    }

    protected int nukta() {
        return 2364;
    }

    protected int virama() {
        return 2381;
    }

    protected boolean isConsonant(int usv) {
        return 2325 <= usv && usv <= 2361 || 2392 <= usv && usv <= 2399 || 9676 == usv;
    }

    protected boolean hasNukta(int usv) {
        return 2345 == usv || 2353 == usv || 2356 == usv || 2392 <= usv && usv <= 2399;
    }

    protected int removeNukta(int usv) {
        switch (usv) {
            case 2345: {
                return 2344;
            }
            case 2353: {
                return 2352;
            }
            case 2356: {
                return 2355;
            }
            case 2392: {
                return 2325;
            }
            case 2393: {
                return 2326;
            }
            case 2394: {
                return 2327;
            }
            case 2395: {
                return 2332;
            }
            case 2396: {
                return 2337;
            }
            case 2397: {
                return 2364;
            }
            case 2398: {
                return 2347;
            }
            case 2399: {
                return 2351;
            }
        }
        return usv;
    }

    protected boolean isMark(int usv) {
        return 2366 <= usv && usv <= 2380 || 2402 <= usv && usv <= 2403 || 2305 <= usv && usv <= 2307 || 2385 <= usv && usv <= 2388;
    }

    protected boolean isIndependentVowel(int usv) {
        return 2308 <= usv && usv <= 2324 || 2400 <= usv && usv <= 2401 || 9676 == usv;
    }

    protected IndicFormatter.Position getPosition(int usv) {
        switch (usv) {
            case 2367: {
                return IndicFormatter.Position.left;
            }
            case 2373: 
            case 2374: 
            case 2375: 
            case 2376: {
                return IndicFormatter.Position.topMatra;
            }
            case 2305: 
            case 2306: 
            case 2385: 
            case 2387: 
            case 2388: {
                return IndicFormatter.Position.topOther;
            }
            case 2369: 
            case 2370: 
            case 2371: 
            case 2372: 
            case 2386: 
            case 2402: 
            case 2403: {
                return IndicFormatter.Position.bottom;
            }
            case 2366: 
            case 2368: 
            case 2377: 
            case 2378: 
            case 2379: 
            case 2380: {
                return IndicFormatter.Position.rightMatra;
            }
            case 2307: {
                return IndicFormatter.Position.rightOther;
            }
        }
        return IndicFormatter.Position.any;
    }

    protected IndicFormatter.Shape rephLike(int usv) {
        if (usv == 2352) {
            return IndicFormatter.Shape.rephVowel;
        }
        return IndicFormatter.Shape.any;
    }

    protected boolean subjoins(int usv) {
        return usv == 2352;
    }

    protected boolean postjoins(int usv) {
        return false;
    }

    protected boolean postjoinsIndependentVowels(int usv) {
        return false;
    }
}

