/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.postscript;

import com.adobe.fontengine.font.postscript.SubArrays;
import com.adobe.fontengine.font.postscript.TokenType;
import com.adobe.fontengine.font.postscript.Tokenizer;

public final class Token {
    public TokenType tokenType = TokenType.kOPERATOR;
    public byte[] buff = new byte[256];
    public int tokenLength = 0;

    Token() {
    }

    public boolean matches(byte[] tokenToFind) {
        return this.tokenLength == tokenToFind.length && SubArrays.arrayCompare(this.buff, 0, tokenToFind, 0, tokenToFind.length);
    }

    public boolean isEOL() {
        return this.tokenLength == 1 && this.buff[0] == -1;
    }

    public String stringTokenToString(int startPos, int endPos) {
        char[] chars = new char[endPos - startPos];
        for (int i = startPos; i < endPos; ++i) {
            chars[i - startPos] = (char)this.buff[i];
        }
        return new String(chars);
    }

    public int convertInteger(int pos) {
        boolean neg;
        int base = 10;
        int value = 0;
        boolean bl = neg = this.buff[pos] == 45;
        if (Tokenizer.isSign(this.buff[pos])) {
            ++pos;
        }
        do {
            if (this.buff[pos] == 35) {
                base = value;
                value = 0;
                continue;
            }
            value = value * base + Tokenizer.digit[this.buff[pos]];
        } while (++pos < this.tokenLength && (Tokenizer.digit[this.buff[pos]] != 99 || this.buff[pos] == 35));
        return neg ? -value : value;
    }
}

