/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.cff.AutoColor;
import com.adobe.fontengine.font.cff.NonOverlappingOutlineConsumer;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ZoneHint {
    static final int kBotZoneBaseline = 0;
    static final int kBotZoneBaseline5 = 1;
    static final int kBotZoneBaseline6 = 2;
    static final int kBotZoneDescender = 3;
    static final int kBotZoneColon = 4;
    static final int kTopZoneCapHeight = 5;
    static final int kTopZoneAscender = 6;
    static final int kTopZonexHeight = 7;
    static final int kTopZoneijHeight = 8;
    static final int kTopZoneHeight5 = 9;
    static final int kTopZoneHeight6 = 10;
    static final int kTopZoneColon = 11;
    static final int kZoneNone = 12;
    static final int kBotZoneFirst = 0;
    static final int kTopZoneFirst = 5;
    static final int kBotZoneLast = 4;
    static final int kTopZoneLast = 11;
    static final int kBotZoneCount = 5;
    static final int kTopZoneCount = 7;
    static final double kMaxZoneHeight = 36.0;
    static final int kBlueFuzz = 0;
    static final double kDefaultBlueShift = 7.0;
    static final int kStrayCountDenom = 3;
    private Zone mVStems = new Zone(12);
    private Zone mHStems = new Zone(12);
    private Zone[] mTopZones = new Zone[7];
    private Zone[] mBotZones = new Zone[5];
    private ArrayList mTopZonesSorted;
    private ArrayList mBotZonesSorted;
    boolean mTopZoneWasSet;
    boolean mBotZoneWasSet;
    private int mCharTopExtreme;
    private int mCharBotExtreme;
    private int mScaledMaxZoneHeight;
    private int[] mTopZoneData;
    private int[] mBotZoneData;
    private int[] mBlueValues;
    private int[] mOtherBlues;
    private int mBlueFuzz;
    private double mBlueShift;
    private double mStdVStem;
    private double mStdHStem;
    private double mBlueScale;
    private static final ZoneTestChar[] gZoneTestCharList = new ZoneTestChar[]{new ZoneTestChar('.', 12, 0), new ZoneTestChar(':', 11, 4), new ZoneTestChar(';', 11, 4), new ZoneTestChar('0', 9, 2), new ZoneTestChar('1', 10, 2), new ZoneTestChar('2', 10, 2), new ZoneTestChar('3', 9, 1), new ZoneTestChar('4', 9, 1), new ZoneTestChar('5', 9, 1), new ZoneTestChar('6', 10, 2), new ZoneTestChar('7', 9, 1), new ZoneTestChar('8', 10, 2), new ZoneTestChar('9', 9, 1), new ZoneTestChar('A', 5, 0), new ZoneTestChar('B', 5, 0), new ZoneTestChar('C', 5, 0), new ZoneTestChar('D', 5, 0), new ZoneTestChar('E', 5, 0), new ZoneTestChar('F', 5, 0), new ZoneTestChar('G', 5, 0), new ZoneTestChar('H', 5, 0), new ZoneTestChar('I', 5, 0), new ZoneTestChar('J', 5, 12), new ZoneTestChar('K', 5, 0), new ZoneTestChar('L', 5, 0), new ZoneTestChar('M', 5, 0), new ZoneTestChar('N', 5, 0), new ZoneTestChar('O', 5, 0), new ZoneTestChar('P', 5, 0), new ZoneTestChar('Q', 5, 12), new ZoneTestChar('R', 5, 0), new ZoneTestChar('S', 5, 0), new ZoneTestChar('T', 5, 0), new ZoneTestChar('U', 5, 0), new ZoneTestChar('V', 5, 0), new ZoneTestChar('W', 5, 0), new ZoneTestChar('X', 5, 0), new ZoneTestChar('Y', 5, 0), new ZoneTestChar('Z', 5, 0), new ZoneTestChar('a', 7, 0), new ZoneTestChar('b', 6, 0), new ZoneTestChar('c', 7, 0), new ZoneTestChar('d', 6, 0), new ZoneTestChar('e', 7, 0), new ZoneTestChar('f', 6, 0), new ZoneTestChar('g', 7, 3), new ZoneTestChar('h', 6, 0), new ZoneTestChar('i', 8, 0), new ZoneTestChar('j', 8, 3), new ZoneTestChar('k', 6, 0), new ZoneTestChar('l', 6, 0), new ZoneTestChar('m', 7, 0), new ZoneTestChar('n', 7, 0), new ZoneTestChar('o', 7, 0), new ZoneTestChar('p', 7, 3), new ZoneTestChar('q', 7, 3), new ZoneTestChar('r', 7, 0), new ZoneTestChar('s', 7, 0), new ZoneTestChar('t', 12, 0), new ZoneTestChar('u', 7, 0), new ZoneTestChar('v', 7, 0), new ZoneTestChar('w', 7, 0), new ZoneTestChar('x', 7, 0), new ZoneTestChar('y', 7, 3), new ZoneTestChar('z', 7, 0)};

    public ZoneHint(OpenTypeFont font) throws InvalidFontException, UnsupportedFontException {
        int stemMode;
        int i;
        double unitsPerEm = font.getUnitsPerEmX();
        this.mScaledMaxZoneHeight = (int)(36.0 * unitsPerEm / 1000.0);
        AutoColor autoColor = new AutoColor(null, unitsPerEm, 14, false, true, null, null);
        NonOverlappingOutlineConsumer noc = new NonOverlappingOutlineConsumer(autoColor, unitsPerEm);
        for (i = 0; i < 7; ++i) {
            this.mTopZones[i] = new Zone(5 + i);
        }
        for (i = 0; i < 5; ++i) {
            this.mBotZones[i] = new Zone(0 + i);
        }
        for (i = 0; i < gZoneTestCharList.length; ++i) {
            ZoneTestChar curChar = gZoneTestCharList[i];
            int curGID = font.getGlyphForChar(curChar.mCode);
            if (curGID <= 0) continue;
            try {
                this.mCharBotExtreme = Integer.MAX_VALUE;
                this.mCharTopExtreme = Integer.MAX_VALUE;
                this.mBotZoneWasSet = false;
                this.mTopZoneWasSet = false;
                double width = font.getHorizontalAdvance(i);
                autoColor.newGlyph(curGID, width, curChar.mCode);
                font.getGlyphOutline(curGID, noc, 2);
                int[] rawData = autoColor.reportZones();
                int j = 0;
                while (j < rawData.length) {
                    int type = rawData[j++];
                    switch (type) {
                        case 0: {
                            int right = rawData[j++];
                            int left = rawData[j++];
                            this.addVStem(right, left, curChar);
                            break;
                        }
                        case 1: {
                            int top = rawData[j++];
                            int bottom = rawData[j++];
                            this.addHStem(top, bottom, curChar);
                            break;
                        }
                        case 2: {
                            int top = rawData[j++];
                            int bottom = rawData[j++];
                            this.addCharExtreme(top, bottom);
                            break;
                        }
                        case 3: {
                            int top = rawData[j++];
                            int bottom = rawData[j++];
                            this.addCharZone(top, bottom, curChar);
                            break;
                        }
                        case 4: {
                            j += 2;
                        }
                    }
                }
                if (curChar.mTopZone < 11 && !this.mTopZoneWasSet && this.mCharTopExtreme != Integer.MAX_VALUE) {
                    this.mTopZones[curChar.mTopZone - 5].addValue(this.mCharTopExtreme);
                }
                if (curChar.mBotZone >= 4 || this.mBotZoneWasSet || this.mCharBotExtreme == Integer.MAX_VALUE) continue;
                this.mBotZones[curChar.mBotZone - 0].addValue(this.mCharBotExtreme);
                continue;
            }
            catch (InvalidGlyphException e) {
                // empty catch block
            }
        }
        this.mTopZonesSorted = this.sortZones(this.mTopZones);
        this.mBotZonesSorted = this.sortZones(this.mBotZones);
        Zone baseZone = this.findZone(this.mBotZonesSorted, 0);
        if (baseZone != null) {
            int i2;
            int maxZoneHeight = 0;
            this.mTopZoneData = new int[this.mTopZonesSorted.size() * 2];
            for (i2 = 0; i2 < this.mTopZonesSorted.size(); ++i2) {
                Zone zone = (Zone)this.mTopZonesSorted.get(i2);
                if (zone.getHeight() > maxZoneHeight) {
                    maxZoneHeight = zone.getHeight();
                }
                this.mTopZoneData[i2 * 2] = zone.mMinValue;
                this.mTopZoneData[i2 * 2 + 1] = zone.mMaxValue;
            }
            this.mBotZoneData = new int[this.mBotZonesSorted.size() * 2];
            for (i2 = 0; i2 < this.mBotZonesSorted.size(); ++i2) {
                Zone zone = (Zone)this.mBotZonesSorted.get(i2);
                if (zone.getHeight() > maxZoneHeight) {
                    maxZoneHeight = zone.getHeight();
                }
                this.mBotZoneData[i2 * 2] = zone.mMinValue;
                this.mBotZoneData[i2 * 2 + 1] = zone.mMaxValue;
            }
            this.mBlueValues = new int[this.mTopZoneData.length + 2];
            this.mBlueValues[0] = baseZone.mMinValue;
            this.mBlueValues[1] = baseZone.mMaxValue;
            for (i2 = 0; i2 < this.mTopZoneData.length; ++i2) {
                this.mBlueValues[i2 + 2] = this.mTopZoneData[i2];
            }
            this.mOtherBlues = new int[this.mBotZoneData.length - 2];
            int j = 0;
            for (i2 = 0; i2 < this.mBotZonesSorted.size(); ++i2) {
                Zone zone = (Zone)this.mBotZonesSorted.get(i2);
                if (zone == baseZone) continue;
                this.mOtherBlues[j++] = zone.mMinValue;
                this.mOtherBlues[j++] = zone.mMaxValue;
            }
            if (maxZoneHeight > 0) {
                this.mBlueScale = 1.0 / (double)maxZoneHeight * 0.8;
            }
            if (unitsPerEm != 1000.0) {
                this.mBlueShift = 7.0 * unitsPerEm / 1000.0;
            }
            this.mBlueFuzz = 0;
        }
        if ((stemMode = this.mVStems.getMode()) == Integer.MAX_VALUE) {
            stemMode = (int)(this.mVStems.getAverage() + 0.5);
        }
        this.mStdVStem = stemMode;
        stemMode = this.mHStems.getMode();
        if (stemMode == Integer.MAX_VALUE) {
            stemMode = (int)(this.mHStems.getAverage() + 0.5);
        }
        this.mStdHStem = stemMode;
    }

    ArrayList sortZones(Zone[] zoneList) {
        int i;
        ArrayList<Zone> result = new ArrayList<Zone>();
        block0: for (i = 0; i < zoneList.length; ++i) {
            Zone zone = zoneList[i];
            if (zoneList[i].mNumValues == 0) continue;
            for (int j = 0; j <= result.size(); ++j) {
                if (j != result.size() && zone.mMinValue > ((Zone)result.get((int)j)).mMinValue) continue;
                result.add(j, zone);
                continue block0;
            }
        }
        i = 0;
        while (i < result.size()) {
            boolean incZone = true;
            Zone zone1 = (Zone)result.get(i);
            if (i + 1 < result.size()) {
                Zone zone2 = (Zone)result.get(i + 1);
                if (zone1.mMaxValue + 0 + 1 >= zone2.mMinValue || zone1.mMinValue + this.mScaledMaxZoneHeight >= zone2.mMaxValue) {
                    for (Integer iValue : zone2.mHistValueList.keySet()) {
                        Integer iCount = (Integer)zone2.mHistValueList.get(iValue);
                        zone1.addValue(iValue, iCount);
                    }
                    if (zone1.mZoneType > zone2.mZoneType) {
                        zone1.mZoneType = zone2.mZoneType;
                    }
                    result.remove(i + 1);
                    incZone = false;
                }
            }
            for (int strayCount = zone1.mNumValues / 3; zone1.getHeight() > this.mScaledMaxZoneHeight && strayCount > 0; --strayCount) {
                double midPoint;
                double average = zone1.getAverage();
                if (average >= (midPoint = (double)(zone1.mMinValue + zone1.mMaxValue) / 2.0)) {
                    zone1.removeValue(zone1.mMinValue);
                    continue;
                }
                zone1.removeValue(zone1.mMaxValue);
            }
            if (zone1.getHeight() > this.mScaledMaxZoneHeight) {
                result.remove(i);
                incZone = false;
            }
            if (!incZone) continue;
            ++i;
        }
        return result;
    }

    Zone findZone(ArrayList zoneArray, int zoneType) {
        for (int i = 0; i < zoneArray.size(); ++i) {
            Zone zone = (Zone)zoneArray.get(i);
            if (zone.mZoneType != zoneType) continue;
            return zone;
        }
        return null;
    }

    public int[] getTopZones() {
        return this.mTopZoneData != null ? this.mTopZoneData : new int[]{};
    }

    public int[] getBottomZones() {
        return this.mBotZoneData != null ? this.mBotZoneData : new int[]{};
    }

    public double[] getBlueValues() {
        int len;
        int n = len = this.mBlueValues != null ? this.mBlueValues.length : 0;
        if (len != 0) {
            double[] retVal = new double[len];
            for (int i = 0; i < len; ++i) {
                retVal[i] = this.mBlueValues[i];
            }
            return retVal;
        }
        return null;
    }

    public double[] getOtherBlues() {
        int len;
        int n = len = this.mOtherBlues != null ? this.mOtherBlues.length : 0;
        if (len != 0) {
            double[] retVal = new double[len];
            for (int i = 0; i < len; ++i) {
                retVal[i] = this.mOtherBlues[i];
            }
            return retVal;
        }
        return null;
    }

    public int getBlueFuzz() {
        return this.mBlueFuzz;
    }

    public double getBlueShift() {
        return this.mBlueShift;
    }

    public double getStdVStem() {
        return this.mStdVStem;
    }

    public double getStdHStem() {
        return this.mStdHStem;
    }

    public double getBlueScale() {
        return this.mBlueScale;
    }

    private void addVStem(int right, int left, ZoneTestChar testChar) {
        if (testChar.mCode >= 'a' && testChar.mCode <= 'z') {
            this.mVStems.addValue(right - left);
        }
    }

    private void addHStem(int top, int bottom, ZoneTestChar testChar) {
        int diff = top - bottom;
        this.mHStems.addValue(top - bottom);
    }

    private void addCharExtreme(int top, int bottom) {
        this.mCharTopExtreme = top;
        this.mCharBotExtreme = bottom;
    }

    private void addCharZone(int top, int bottom, ZoneTestChar testChar) {
        if (testChar.mTopZone != 12 && (this.mCharTopExtreme == Integer.MAX_VALUE || top + this.mScaledMaxZoneHeight >= this.mCharTopExtreme)) {
            this.mTopZones[testChar.mTopZone - 5].addValue(top);
            this.mTopZoneWasSet = true;
        }
        if (testChar.mBotZone != 12 && (this.mCharBotExtreme == Integer.MAX_VALUE || bottom - this.mScaledMaxZoneHeight <= this.mCharBotExtreme)) {
            this.mBotZones[testChar.mBotZone - 0].addValue(bottom);
            this.mBotZoneWasSet = true;
        }
    }

    private static final class ZoneTestChar {
        final char mCode;
        final int mTopZone;
        final int mBotZone;

        private ZoneTestChar(char code, int topZone, int botZone) {
            this.mCode = code;
            this.mTopZone = topZone;
            this.mBotZone = botZone;
        }
    }

    private final class Zone {
        int mZoneType;
        int mNumValues;
        int mMaxValue;
        int mMinValue;
        HashMap mHistValueList = new HashMap();

        Zone(int zoneType) {
            this.mZoneType = zoneType;
        }

        void addValue(int value) {
            this.addValue(value, 1);
        }

        void addValue(int value, int increment) {
            Integer iValue = new Integer(value);
            Integer iCount = (Integer)this.mHistValueList.get(iValue);
            int count = iCount != null ? iCount : 0;
            this.mHistValueList.put(iValue, new Integer(count + increment));
            this.setMinMaxWithValue(value);
            this.mNumValues += increment;
        }

        void removeValue(int value) {
            Integer iValue = new Integer(value);
            Integer iCount = (Integer)this.mHistValueList.get(iValue);
            if (iCount != null) {
                int count = iCount;
                if (--count == 0) {
                    this.mHistValueList.remove(iValue);
                    if (value == this.mMinValue || value == this.mMaxValue) {
                        this.mMaxValue = 0;
                        this.mMinValue = 0;
                        Iterator iter = this.mHistValueList.keySet().iterator();
                        boolean first = true;
                        while (iter.hasNext()) {
                            iValue = (Integer)iter.next();
                            if (first) {
                                this.mMinValue = this.mMaxValue = iValue.intValue();
                                first = false;
                            }
                            this.setMinMaxWithValue(iValue);
                        }
                    }
                } else {
                    this.mHistValueList.put(iValue, new Integer(count));
                }
                --this.mNumValues;
            }
        }

        int getMode() {
            int value = 0;
            int valueCount = 0;
            int count = 0;
            for (Integer iValue : this.mHistValueList.keySet()) {
                Integer iCount = (Integer)this.mHistValueList.get(iValue);
                if (iCount > count) {
                    value = iValue;
                    count = iCount;
                    valueCount = 1;
                    continue;
                }
                if (iCount != count) continue;
                ++valueCount;
            }
            if (valueCount <= 1) {
                return count == 1 ? Integer.MAX_VALUE : value;
            }
            int[] valueList = new int[valueCount];
            int n = 0;
            for (Integer iValue : this.mHistValueList.keySet()) {
                int i;
                Integer iCount = (Integer)this.mHistValueList.get(iValue);
                if (iCount != count) continue;
                for (i = 0; i < n && iValue >= valueList[i]; ++i) {
                }
                System.arraycopy(valueList, i, valueList, i + 1, n - i);
                valueList[i] = iValue;
                ++n;
            }
            return valueList[valueCount / 2];
        }

        double getAverage() {
            double total = 0.0;
            for (Integer iValue : this.mHistValueList.keySet()) {
                Integer iCount = (Integer)this.mHistValueList.get(iValue);
                total += (double)(iValue * iCount);
            }
            return total / (double)this.mNumValues;
        }

        void setMinMaxWithValue(int value) {
            if (this.mNumValues == 0 || value > this.mMaxValue) {
                this.mMaxValue = value;
            }
            if (this.mNumValues == 0 || value < this.mMinValue) {
                this.mMinValue = value;
            }
        }

        int getHeight() {
            return this.mMaxValue - this.mMinValue;
        }
    }
}

