/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.BitmapConsumer;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.Scaler;
import com.adobe.fontengine.font.ScalerDebugger;
import com.adobe.fontengine.font.ScanConverter;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.fontengine.font.opentype.TTInterpreter;
import com.adobe.fontengine.font.opentype.TTOutline;

public class TTScaler
implements Scaler {
    protected final OpenTypeFont font;
    protected final TTInterpreter interpreter;
    protected final ScanConverter scanConverter;
    double pointSize = Double.NaN;
    double ppemX = Double.NaN;
    double ppemY = Double.NaN;
    double dX = Double.NaN;
    double dY = Double.NaN;
    Matrix em2px = null;
    boolean gridfit;
    protected ScalerDebugger debugger;

    public TTScaler(OpenTypeFont font, ScanConverter scanConverter) throws InvalidFontException, UnsupportedFontException {
        this.font = font;
        if (font.maxp == null || font.maxp.getTableMajorVersion() < 1) {
            throw new InvalidFontException("need maxp table with major version at least 1");
        }
        if (font.head == null) {
            throw new InvalidFontException("need a head table");
        }
        this.interpreter = new TTInterpreter(font.maxp.getMaxStorage(), font.maxp.getMaxStackElements(), font.cvt == null ? 0 : font.cvt.getNbEntries(), font.cvt == null ? null : font.cvt.getData(), font.maxp.getMaxFunctionDefs(), font.maxp.getMaxTwilightPoints());
        this.scanConverter = scanConverter;
        this.interpreter.setUnitsPerEm(font.head.getUnitsPerEm());
        if (font.fpgm != null) {
            OTByteArray fpgm = font.fpgm.getData();
            this.interpreter.runFpgm(fpgm, 0, fpgm.getSize());
        }
    }

    public void setScale(double pointSize, double ppemX, double ppemY, double dX, double dY) throws InvalidFontException, UnsupportedFontException {
        this.pointSize = pointSize;
        this.ppemX = ppemX;
        this.ppemY = ppemY;
        this.dX = dX;
        this.dY = dY;
        this.gridfit = true;
        this.em2px = new Matrix(ppemX, 0.0, 0.0, ppemY, dX, dY);
        this.interpreter.setScaling(pointSize, ppemX, ppemY, dX, dY);
        if (this.font.prep != null) {
            OTByteArray prep = this.font.prep.getData();
            this.interpreter.runPrep(prep, 0, prep.getSize());
        } else {
            this.interpreter.runPrep(null, 0, 0);
        }
    }

    public void getOutline(int gid, OutlineConsumer outlineConsumer) throws UnsupportedFontException, InvalidFontException {
        TTOutline outline = this.font.glyf.createTTOutline(this.font, gid);
        outline.scale(this.font.head.getUnitsPerEm(), this.em2px);
        if (this.gridfit) {
            outline.instruct(this.interpreter);
        }
        outline.translate();
        outline.toConsumer(outlineConsumer);
    }

    public void getBitmap(int gid, BitmapConsumer bitmapConsumer) throws UnsupportedFontException, InvalidFontException {
        TTOutline outline = this.font.glyf.createTTOutline(this.font, gid);
        outline.scale(this.font.head.getUnitsPerEm(), this.em2px);
        if (this.gridfit) {
            outline.instruct(this.interpreter);
        }
        outline.translate();
        this.scanConverter.setScanType(outline.getScanType());
        outline.toConsumer2(this.scanConverter.getOutlineConsumer2());
        this.scanConverter.getBitmap(bitmapConsumer);
    }

    public void setDebugger(ScalerDebugger debugger) {
        this.debugger = debugger;
        this.interpreter.setDebugger(debugger);
        if (this.scanConverter != null) {
            this.scanConverter.setDebugger(debugger);
        }
    }
}

