/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.Glyf;
import com.adobe.fontengine.font.opentype.Hmtx;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import java.util.ArrayList;
import java.util.List;

final class TTParser {
    List points = new ArrayList();
    List endPoints = new ArrayList();
    public static final int EXACT_PATH = 1;
    public static final int APPROX_PATH = 2;

    TTParser() {
    }

    private void getSimpleGlyph(Glyf glyf, int index, int numContours) throws InvalidFontException {
        if (numContours == 0) {
            return;
        }
        int startNumPoints = this.points.size();
        int lastEndPoint = 0;
        for (int i = 0; i < numContours; ++i) {
            int thisEndPoint = glyf.glyf.data.getuint16(index);
            index += 2;
            if (thisEndPoint < lastEndPoint) {
                throw new InvalidGlyphException("endpoints in a simple TT glyph must be increasing");
            }
            lastEndPoint = thisEndPoint;
            this.endPoints.add(new Integer(thisEndPoint + startNumPoints));
        }
        int numPoints = (Integer)this.endPoints.get(this.endPoints.size() - 1) + 1 - startNumPoints;
        index += glyf.glyf.data.getuint16(index) + 2;
        for (int i = 0; i < numPoints; ++i) {
            Coord coord = new Coord();
            this.points.add(coord);
            coord.flags = glyf.glyf.data.getuint8(index++);
            if ((coord.flags & 8) == 0) continue;
            int flags = coord.flags;
            int numRepeats = glyf.glyf.data.getuint8(index++);
            while (numRepeats-- > 0) {
                coord = new Coord();
                this.points.add(coord);
                coord.flags = flags;
                ++i;
            }
        }
        int x = 0;
        for (int i = 0; i < numPoints; ++i) {
            Coord coord = (Coord)this.points.get(i + startNumPoints);
            if ((coord.flags & 2) != 0) {
                x = (coord.flags & 0x10) == 0 ? (int)((short)(x - glyf.glyf.data.getuint8(index++))) : (int)((short)(x + glyf.glyf.data.getuint8(index++)));
            } else if ((coord.flags & 0x10) == 0) {
                x = (short)(x + glyf.glyf.data.getint16(index));
                index += 2;
            }
            coord.x = x;
        }
        int y = 0;
        for (int i = 0; i < numPoints; ++i) {
            Coord coord = (Coord)this.points.get(i + startNumPoints);
            if ((coord.flags & 4) != 0) {
                y = (coord.flags & 0x20) == 0 ? (int)((short)(y - glyf.glyf.data.getuint8(index++))) : (int)((short)(y + glyf.glyf.data.getuint8(index++)));
            } else if ((coord.flags & 0x20) == 0) {
                y = (short)(y + glyf.glyf.data.getint16(index));
                index += 2;
            }
            coord.y = y;
        }
    }

    private int getCompositeGlyph(Glyf glyf, int index, int thisGid) throws UnsupportedFontException, InvalidFontException {
        int metricsGid = thisGid;
        while (true) {
            double d;
            double a;
            int y;
            int x;
            boolean translate;
            Matrix transMatrix = null;
            int flags = glyf.glyf.data.getuint16(index);
            int gid = glyf.glyf.data.getuint16(index += 2);
            index += 2;
            boolean bl = translate = (flags & 2) != 0;
            if ((flags & 1) != 0) {
                if (translate) {
                    x = glyf.glyf.data.getint16(index);
                    y = glyf.glyf.data.getint16(index + 2);
                } else {
                    x = glyf.glyf.data.getuint16(index);
                    y = glyf.glyf.data.getuint16(index + 2);
                }
                index += 4;
            } else {
                if (translate) {
                    x = glyf.glyf.data.getint8(index);
                    y = glyf.glyf.data.getint8(index + 1);
                } else {
                    x = glyf.glyf.data.getuint8(index);
                    y = glyf.glyf.data.getuint8(index + 1);
                }
                index += 2;
            }
            if ((flags & 8) != 0) {
                a = (double)glyf.glyf.data.getint16(index) / 16384.0;
                index += 2;
                transMatrix = new Matrix(a, 0.0, 0.0, a, 0.0, 0.0);
            } else if ((flags & 0x80) != 0) {
                a = (double)glyf.glyf.data.getint16(index) / 16384.0;
                double b = (double)glyf.glyf.data.getint16(index += 2) / 16384.0;
                double c = (double)glyf.glyf.data.getint16(index += 2) / 16384.0;
                d = (double)glyf.glyf.data.getint16(index += 2) / 16384.0;
                index += 2;
                transMatrix = new Matrix(a, b, c, d, 0.0, 0.0);
            } else if ((flags & 0x40) != 0) {
                a = (double)glyf.glyf.data.getint16(index) / 16384.0;
                d = (double)glyf.glyf.data.getint16(index + 2) / 16384.0;
                transMatrix = new Matrix(a, 0.0, 0.0, d, 0.0, 0.0);
                index += 4;
            }
            if ((flags & 0x200) != 0) {
                metricsGid = gid;
            }
            int firstCoordToTransform = this.points.size();
            int savedPosInGlyfTable = index;
            index = glyf.getGlyphLocation(gid);
            if (glyf.getGlyphLocation(gid + 1) != index) {
                Coord coord;
                int i;
                int numberOfContours = glyf.glyf.data.getint16(index);
                index += 10;
                if (numberOfContours < 0) {
                    metricsGid = this.getCompositeGlyph(glyf, index, gid);
                } else {
                    this.getSimpleGlyph(glyf, index, numberOfContours);
                }
                if (!translate) {
                    Coord first = (Coord)this.points.get(x);
                    Coord second = (Coord)this.points.get(y + firstCoordToTransform);
                    x = first.x - second.x;
                    y = first.y - second.y;
                }
                if (transMatrix != null) {
                    for (i = firstCoordToTransform; i < this.points.size(); ++i) {
                        coord = (Coord)this.points.get(i);
                        int origX = coord.x;
                        coord.x = (int)Math.round(transMatrix.applyToXYGetX(coord.x, coord.y) + (double)x);
                        coord.y = (int)Math.round(transMatrix.applyToXYGetY(origX, coord.y) + (double)y);
                    }
                } else if (x != 0 || y != 0) {
                    for (i = firstCoordToTransform; i < this.points.size(); ++i) {
                        coord = (Coord)this.points.get(i);
                        coord.x += x;
                        coord.y += y;
                    }
                }
            }
            if ((flags & 0x20) == 0) {
                return metricsGid;
            }
            index = savedPosInGlyfTable;
        }
    }

    private void adjustPointsBySideBearing(int gid, Hmtx hmtx, int xMin) throws InvalidFontException {
        int lsb = hmtx.getLeftSideBearing(gid);
        int xScale = lsb - xMin;
        if (xScale != 0) {
            for (Coord c : this.points) {
                c.x += xScale;
            }
        }
    }

    private void addCurve(Coord[] pnts, OutlineConsumer consumer) {
        consumer.curveto(Math.round((double)(pnts[0].x + 2 * pnts[1].x) / 3.0), Math.round((double)(pnts[0].y + 2 * pnts[1].y) / 3.0), Math.round((double)(2 * pnts[1].x + pnts[2].x) / 3.0), Math.round((double)(2 * pnts[1].y + pnts[2].y) / 3.0), pnts[2].x, pnts[2].y);
    }

    private boolean combinePair(Coord[] pnts, OutlineConsumer consumer) {
        double d1;
        double d0;
        double sr;
        double absq;
        double a = pnts[3].y - pnts[1].y;
        double b = pnts[1].x - pnts[3].x;
        if ((a != 0.0 || pnts[1].y != pnts[2].y) && (b != 0.0 || pnts[1].x != pnts[2].x) && (absq = a * a + b * b) != 0.0 && (sr = a * (double)(pnts[2].x - pnts[1].x) + b * (double)(pnts[2].y - pnts[1].y)) * sr / absq < 1.0 && a * (double)(pnts[0].x - pnts[1].x) + b * (double)(pnts[0].y - pnts[1].y) < 0.0 == a * (double)(pnts[4].x - pnts[1].x) + b * (double)(pnts[4].y - pnts[1].y) < 0.0 && (d0 = (double)((pnts[2].x - pnts[0].x) * (pnts[2].x - pnts[0].x) + (pnts[2].y - pnts[0].y) * (pnts[2].y - pnts[0].y))) <= 3.0 * (d1 = (double)((pnts[4].x - pnts[2].x) * (pnts[4].x - pnts[2].x) + (pnts[4].y - pnts[2].y) * (pnts[4].y - pnts[2].y))) && d1 <= 3.0 * d0) {
            consumer.curveto(Math.round((double)(4 * pnts[1].x - pnts[0].x) / 3.0), Math.round((double)(4 * pnts[1].y - pnts[0].y) / 3.0), Math.round((double)(4 * pnts[3].x - pnts[4].x) / 3.0), Math.round((double)(4 * pnts[3].y - pnts[4].y) / 3.0), pnts[4].x, pnts[4].y);
            pnts[0].setXY(pnts[4]);
            return true;
        }
        this.addCurve(pnts, consumer);
        pnts[0].setXY(pnts[2]);
        pnts[1].setXY(pnts[3]);
        pnts[2].setXY(pnts[4]);
        return false;
    }

    private void emitContoursApproxPath(OutlineConsumer consumer) {
        Coord[] p = new Coord[6];
        for (int i = 0; i < 6; ++i) {
            p[i] = new Coord();
        }
        int startOfContour = 0;
        for (int contour = 0; contour < this.endPoints.size(); ++contour) {
            int endOfContour = (Integer)this.endPoints.get(contour);
            if (startOfContour >= endOfContour) {
                startOfContour = endOfContour + 1;
                continue;
            }
            Coord current = null;
            int state = 0;
            int numOfCoords = endOfContour - startOfContour + 1;
            Coord begin = (Coord)this.points.get(startOfContour);
            Coord end = (Coord)this.points.get(endOfContour);
            int currentIndex = startOfContour;
            if ((begin.flags & 1) != 0) {
                current = begin;
                p[0].setXY(current);
            } else if ((end.flags & 1) != 0) {
                current = end;
                currentIndex = endOfContour;
                p[0].setXY(current);
            } else {
                current = end;
                currentIndex = endOfContour;
                ++numOfCoords;
                p[0].setXYAtMidPoint(begin, end);
            }
            consumer.moveto(p[0].x, p[0].y);
            while (numOfCoords > 0) {
                --numOfCoords;
                if (current == end) {
                    current = begin;
                    currentIndex = startOfContour;
                } else {
                    current = (Coord)this.points.get(++currentIndex);
                }
                if ((current.flags & 1) != 0) {
                    switch (state) {
                        case 0: {
                            if (numOfCoords <= 0) break;
                            consumer.lineto(current.x, current.y);
                            p[0].setXY(current);
                            break;
                        }
                        case 1: {
                            p[2].setXY(current);
                            state = 3;
                            break;
                        }
                        case 2: {
                            p[4].setXY(current);
                            state = this.combinePair(p, consumer) ? 0 : 3;
                            break;
                        }
                        case 3: {
                            this.addCurve(p, consumer);
                            if (numOfCoords > 0) {
                                consumer.lineto(current.x, current.y);
                                p[0].setXY(current);
                            }
                            state = 0;
                            break;
                        }
                        case 4: {
                            p[4].setXY(current);
                            state = this.combinePair(p, consumer) ? 0 : 3;
                        }
                    }
                    continue;
                }
                switch (state) {
                    case 0: {
                        p[1].setXY(current);
                        state = 1;
                        break;
                    }
                    case 1: {
                        p[3].setXY(current);
                        p[2].setXYAtMidPoint(p[1], p[3]);
                        state = 2;
                        break;
                    }
                    case 2: {
                        p[5].setXY(current);
                        p[4].setXYAtMidPoint(p[3], p[5]);
                        if (this.combinePair(p, consumer)) {
                            p[1].setXY(p[5]);
                            state = 1;
                            break;
                        }
                        p[3].setXY(p[5]);
                        state = 4;
                        break;
                    }
                    case 3: {
                        p[3].setXY(current);
                        state = 4;
                        break;
                    }
                    case 4: {
                        p[5].setXY(current);
                        p[4].setXYAtMidPoint(p[3], p[5]);
                        if (this.combinePair(p, consumer)) {
                            p[1].setXY(p[5]);
                            state = 1;
                            break;
                        }
                        p[3].setXY(p[5]);
                        state = 2;
                    }
                }
            }
            switch (state) {
                case 2: {
                    p[3].setXY(current);
                    p[2].setXYAtMidPoint(p[1], p[3]);
                }
                case 3: 
                case 4: {
                    this.addCurve(p, consumer);
                }
            }
            startOfContour = endOfContour + 1;
        }
        consumer.endchar();
    }

    private void emitContoursExactPath(OutlineConsumer consumer) {
        int startOfContour = 0;
        for (int contour = 0; contour < this.endPoints.size(); ++contour) {
            int currentIndex;
            double x1 = 0.0;
            double y1 = 0.0;
            int endOfContour = (Integer)this.endPoints.get(contour);
            if (startOfContour >= endOfContour) {
                startOfContour = endOfContour + 1;
                continue;
            }
            int start = startOfContour;
            boolean onCurveStartNotFound = true;
            Coord current = null;
            Coord next = null;
            while (onCurveStartNotFound && start < endOfContour) {
                current = (Coord)this.points.get(start);
                if ((current.flags & 1) != 0) {
                    consumer.moveto(current.x, current.y);
                    onCurveStartNotFound = false;
                    continue;
                }
                ++start;
            }
            if (onCurveStartNotFound) {
                Coord c2 = (Coord)this.points.get(endOfContour);
                start = startOfContour;
                current = (Coord)this.points.get(start);
                consumer.moveto((double)(current.x + c2.x) / 2.0, (double)(current.y + c2.y) / 2.0);
                x1 = (double)(c2.x + 5 * current.x) / 6.0;
                y1 = (double)(c2.y + 5 * current.y) / 6.0;
            }
            int nextIndex = currentIndex = start;
            do {
                if (nextIndex++ == endOfContour) {
                    nextIndex = startOfContour;
                }
                next = (Coord)this.points.get(nextIndex);
                if ((current.flags & 1) != 0) {
                    if ((next.flags & 1) != 0) {
                        consumer.lineto(next.x, next.y);
                    } else {
                        x1 = next.x;
                        y1 = next.y;
                    }
                } else if ((next.flags & 1) != 0) {
                    consumer.curveto(x1, y1, next.x, next.y);
                } else {
                    consumer.curveto(x1, y1, (double)(current.x + next.x) / 2.0, (double)(current.y + next.y) / 2.0);
                    x1 = next.x;
                    y1 = next.y;
                }
                currentIndex = nextIndex;
                current = (Coord)this.points.get(currentIndex);
            } while (nextIndex != start);
            startOfContour = endOfContour + 1;
        }
        consumer.endchar();
    }

    private void emitContours(OutlineConsumer consumer, int pathType) {
        int startOfContour = 0;
        for (int contour = 0; contour < this.endPoints.size(); ++contour) {
            int endOfContour = (Integer)this.endPoints.get(contour);
            if (startOfContour >= endOfContour) {
                startOfContour = endOfContour + 1;
                continue;
            }
            int lastPoint = endOfContour;
            for (int swapLocation = endOfContour + startOfContour + 1 - lastPoint; lastPoint > swapLocation; --lastPoint, ++swapLocation) {
                Object swapObj = this.points.set(swapLocation, this.points.get(lastPoint));
                this.points.set(lastPoint, swapObj);
            }
            startOfContour = endOfContour + 1;
        }
        if (pathType == 1) {
            this.emitContoursExactPath(consumer);
        } else {
            this.emitContoursApproxPath(consumer);
        }
    }

    void parse(OpenTypeFont font, int gid, OutlineConsumer consumer, int pathType) throws UnsupportedFontException, InvalidGlyphException {
        int indexIntoData;
        Glyf glyf = font.glyf;
        this.points.clear();
        this.endPoints.clear();
        try {
            indexIntoData = glyf.getGlyphLocation(gid);
        }
        catch (InvalidFontException e) {
            consumer.endchar();
            return;
        }
        try {
            int xMin;
            int numberOfContours;
            try {
                if (glyf.getGlyphLocation(gid + 1) == indexIntoData) {
                    consumer.endchar();
                    return;
                }
                numberOfContours = glyf.glyf.data.getint16(indexIntoData);
            }
            catch (InvalidFontException e) {
                consumer.endchar();
                return;
            }
            int metricsGID = gid;
            indexIntoData += 10;
            if (font.head == null) {
                throw new InvalidFontException("OpenType font with 'glyf' table needs a 'head' table");
            }
            consumer.setMatrix(new Matrix(1.0 / (double)font.head.getUnitsPerEm(), 0.0, 0.0, 1.0 / (double)font.head.getUnitsPerEm(), 0.0, 0.0));
            if (numberOfContours < 0) {
                metricsGID = this.getCompositeGlyph(glyf, indexIntoData, gid);
                xMin = glyf.glyf.data.getint16(glyf.getGlyphLocation(metricsGID) + 2);
            } else {
                this.getSimpleGlyph(glyf, indexIntoData, numberOfContours);
                xMin = glyf.glyf.data.getint16(indexIntoData - 8);
            }
            this.adjustPointsBySideBearing(metricsGID, font.hmtx, xMin);
            this.emitContours(consumer, pathType);
        }
        catch (InvalidFontException e) {
            throw new InvalidGlyphException(e);
        }
    }

    void parse(OpenTypeFont font, int gid, OutlineConsumer consumer) throws UnsupportedFontException, InvalidGlyphException {
        this.parse(font, gid, consumer, 1);
    }

    private static class Coord {
        int x;
        int y;
        int flags;

        private Coord() {
        }

        private void setXY(Coord c) {
            this.x = c.x;
            this.y = c.y;
        }

        private void setXYAtMidPoint(Coord a, Coord b) {
            this.x = (int)Math.round((double)(a.x + b.x) / 2.0);
            this.y = (int)Math.round((double)(a.y + b.y) / 2.0);
        }

        public String toString() {
            String fStr = (this.flags & 1) != 0 ? "OnCurve" : "OffCurve";
            return "(" + this.x + "," + this.y + ") flags: " + fStr;
        }
    }
}

