/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.EmbeddingPermission;
import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.LineMetrics;
import com.adobe.fontengine.font.Permission;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.Table;
import java.io.IOException;
import java.util.Map;

public final class Os2
extends Table {
    protected Os2(FontByteArray buffer) throws IOException, InvalidFontException, UnsupportedFontException {
        super(buffer);
    }

    public int getTableVersion() throws InvalidFontException {
        return this.data.getuint16(0);
    }

    public int getWeightClass() throws InvalidFontException {
        return this.data.getuint16(4);
    }

    public int getWidthClass() throws InvalidFontException {
        return this.data.getuint16(6);
    }

    public int panoseIndicatesProportional() throws InvalidFontException {
        int family = this.data.getint8(32);
        int data = this.data.getint8(35);
        if (family == 0 || data == 0) {
            return -1;
        }
        switch (family) {
            case 2: 
            case 4: {
                return data == 9 ? 0 : 1;
            }
            case 3: 
            case 5: {
                return data == 3 ? 0 : 1;
            }
        }
        return -1;
    }

    public int getSelection() throws InvalidFontException {
        return this.data.getuint16(62);
    }

    public int getFirstChar() throws InvalidFontException {
        return this.data.getuint16(64);
    }

    public int getLastChar() throws InvalidFontException {
        return this.data.getuint16(66);
    }

    public int getTypoAscender() throws InvalidFontException {
        return this.data.getint16(68);
    }

    public int getTypoDescender() throws InvalidFontException {
        return this.data.getint16(70);
    }

    public int getTypoLineGap() throws InvalidFontException {
        return this.data.getint16(72);
    }

    public int getWinAscent() throws InvalidFontException {
        return this.data.getuint16(74);
    }

    public int getWinDescent() throws InvalidFontException {
        return this.data.getuint16(76);
    }

    public LineMetrics getLineMetrics() throws UnsupportedFontException, InvalidFontException {
        return new LineMetrics(this.getTypoAscender(), this.getTypoDescender(), this.getTypoLineGap());
    }

    public long getVendor() throws InvalidFontException {
        return this.data.getuint32(58);
    }

    public int getxHeight() throws InvalidFontException {
        if (this.getTableVersion() < 2) {
            return Integer.MAX_VALUE;
        }
        return this.data.getint16(86);
    }

    public int getCapHeight() throws InvalidFontException {
        if (this.getTableVersion() < 2) {
            return Integer.MAX_VALUE;
        }
        return this.data.getint16(88);
    }

    public boolean supportsUnicodeRange(UnicodeRange cp) throws InvalidFontException {
        if (this.getTableVersion() < cp.firstVersion) {
            return false;
        }
        if (this.getTableVersion() > cp.lastVersion) {
            return false;
        }
        long l = this.data.getuint32(42 + cp.offset);
        return (l & (long)cp.mask) != 0L;
    }

    public boolean supportsCodePage(CodePage cp) throws InvalidFontException {
        if (this.getTableVersion() < cp.firstVersion) {
            return false;
        }
        long l = this.data.getuint32(78 + cp.offset);
        return (l & (long)cp.mask) != 0L;
    }

    int getRawFSType() throws InvalidFontException {
        return this.data.getuint16(8);
    }

    public Permission getEmbeddingPermission() throws InvalidFontException {
        int fsType = this.getRawFSType();
        return EmbeddingPermission.interpretFSType(fsType);
    }

    public EmbeddingPermission.SubsettingRestriction getEmbeddingSubsettingRestriction() throws InvalidFontException {
        if (this.getTableVersion() < 2) {
            return EmbeddingPermission.SubsettingRestriction.UNKNOWN_SUBSETTING_RESTRICTION;
        }
        int fsType = this.getRawFSType();
        if ((fsType & 0x100) != 0) {
            return EmbeddingPermission.SubsettingRestriction.FULL_FONT_ONLY;
        }
        return EmbeddingPermission.SubsettingRestriction.SUBSETTING_OK;
    }

    public EmbeddingPermission.OutlineRestriction getEmbeddingOutlineRestriction() throws InvalidFontException {
        if (this.getTableVersion() < 2) {
            return EmbeddingPermission.OutlineRestriction.UNKNOWN_OUTLINE_RESTRICTION;
        }
        int fsType = this.getRawFSType();
        if ((fsType & 0x200) != 0) {
            return EmbeddingPermission.OutlineRestriction.BITMAP_ONLY;
        }
        return EmbeddingPermission.OutlineRestriction.OUTLINES_OK;
    }

    public void subsetAndStream(Subset subset, Map tables) {
        OTByteArray.OTByteArrayBuilder newData = OTByteArray.getOTByteArrayBuilderInstance(this.data);
        tables.put(new Integer(1330851634), newData);
    }

    public void stream(Map tables) {
        OTByteArray.OTByteArrayBuilder newData = this.getDataAsByteArray();
        tables.put(new Integer(1330851634), newData);
    }

    public static final class CodePage {
        public final int offset;
        public final int mask;
        public final int firstVersion;
        public static final CodePage CP_1252_LATIN_1 = new CodePage(0, 1);
        public static final CodePage CP_1250_LATIN_2_EE = new CodePage(1, 1);
        public static final CodePage CP_1251_CYRILLIC = new CodePage(2, 1);
        public static final CodePage CP_1253_GREEK = new CodePage(3, 1);
        public static final CodePage CP_1254_TURKISH = new CodePage(4, 1);
        public static final CodePage CP_1255_HEBREW = new CodePage(5, 1);
        public static final CodePage CP_1256_ARABIC = new CodePage(6, 1);
        public static final CodePage CP_1257_BALTIC = new CodePage(7, 1);
        public static final CodePage CP_1258_VIETNAMESE = new CodePage(8, 2);
        public static final CodePage CP_874_THAI = new CodePage(16, 1);
        public static final CodePage CP_932_JAPANESE = new CodePage(17, 1);
        public static final CodePage CP_936_CHINESE_SIMPLIFIED = new CodePage(18, 1);
        public static final CodePage CP_949_KOREAN_WANSUNG = new CodePage(19, 1);
        public static final CodePage CP_950_CHINESE_TRADITIONAL = new CodePage(20, 1);
        public static final CodePage CP_1361_KOREAN_JOHAB = new CodePage(21, 1);
        public static final CodePage CP_MAC_ROMAN = new CodePage(29, 2);
        public static final CodePage CP_OEM = new CodePage(30, 1);
        public static final CodePage CP_SYMBOL = new CodePage(31, 1);
        public static final CodePage CP_869_IBM_GREEK = new CodePage(48, 1);
        public static final CodePage CP_866_MSDOS_RUSSIAN = new CodePage(49, 1);
        public static final CodePage CP_865_MSDOS_NORDIC = new CodePage(50, 1);
        public static final CodePage CP_864_ARABIC = new CodePage(51, 1);
        public static final CodePage CP_863_MSDOS_CANADIAN = new CodePage(52, 1);
        public static final CodePage CP_862_HEBREW = new CodePage(53, 1);
        public static final CodePage CP_861_MSDOS_ICELANDIC = new CodePage(54, 1);
        public static final CodePage CP_860_MSDOS_PORTUGUESE = new CodePage(55, 1);
        public static final CodePage CP_857_IBM_TURKISH = new CodePage(56, 1);
        public static final CodePage CP_855_IBM_CYRILLIC = new CodePage(57, 1);
        public static final CodePage CP_852_LATIN_2 = new CodePage(58, 1);
        public static final CodePage CP_775_MSDOS_BALTIC = new CodePage(59, 1);
        public static final CodePage CP_737_GREEK = new CodePage(60, 1);
        public static final CodePage CP_708_ARABIC = new CodePage(61, 1);
        public static final CodePage CP_850_WE_LATIN_1 = new CodePage(62, 1);
        public static final CodePage CP_437_US = new CodePage(63, 1);

        private CodePage(int bit, int firstVersion) {
            this.offset = 4 * (bit / 32);
            this.mask = 1 << bit % 32;
            this.firstVersion = firstVersion;
        }
    }

    public static final class UnicodeRange {
        public final int offset;
        public final int mask;
        public final int firstVersion;
        public final int lastVersion;
        public static final UnicodeRange BASIC_LATIN = new UnicodeRange(0, 1);
        public static final UnicodeRange LATIN_1_SUPPLEMENT = new UnicodeRange(1, 1);
        public static final UnicodeRange LATIN_EXTENDED_A = new UnicodeRange(2, 1);
        public static final UnicodeRange LATIN_EXTENDED_B = new UnicodeRange(3, 1);
        public static final UnicodeRange IPA_EXTENSIONS = new UnicodeRange(4, 1);
        public static final UnicodeRange SPACING_MODIFIER_LETTERS = new UnicodeRange(5, 1);
        public static final UnicodeRange COMBINING_DIACRITICAL_MARKS = new UnicodeRange(6, 1);
        public static final UnicodeRange GREEK = new UnicodeRange(7, 1);
        public static final UnicodeRange GREEK_SYMBOLS_AND_COPTIC = new UnicodeRange(8, 1, 1);
        public static final UnicodeRange CYRILLIC = new UnicodeRange(9, 1);
        public static final UnicodeRange ARMENIAN = new UnicodeRange(10, 1);
        public static final UnicodeRange HEBREW = new UnicodeRange(10, 1);
        public static final UnicodeRange HEBREW_EXTENDED = new UnicodeRange(12, 1, 1);
        public static final UnicodeRange ARABIC = new UnicodeRange(13, 1);
        public static final UnicodeRange ARABIC_EXTENDED = new UnicodeRange(14, 1, 1);
        public static final UnicodeRange DEVANAGARI = new UnicodeRange(15, 1);
        public static final UnicodeRange BENGALI = new UnicodeRange(16, 1);
        public static final UnicodeRange GURMUKHI = new UnicodeRange(17, 1);
        public static final UnicodeRange GUJARATI = new UnicodeRange(18, 1);
        public static final UnicodeRange ORIYA = new UnicodeRange(19, 1);
        public static final UnicodeRange TAMIL = new UnicodeRange(20, 1);
        public static final UnicodeRange TELUGU = new UnicodeRange(21, 1);
        public static final UnicodeRange KANNADA = new UnicodeRange(22, 1);
        public static final UnicodeRange MALAYALAM = new UnicodeRange(23, 1);
        public static final UnicodeRange THAI = new UnicodeRange(24, 1);
        public static final UnicodeRange LAO = new UnicodeRange(25, 1);
        public static final UnicodeRange GEORGIAN = new UnicodeRange(26, 1);
        public static final UnicodeRange GEORGIAN_EXTENDED = new UnicodeRange(27, 1, 1);
        public static final UnicodeRange HANGUL_JAMO = new UnicodeRange(28, 1);
        public static final UnicodeRange LATIN_EXTENDED_ADDITIONAL = new UnicodeRange(29, 1);
        public static final UnicodeRange GREEK_EXTENDED = new UnicodeRange(30, 1);
        public static final UnicodeRange GENERAL_PUNCTUATION = new UnicodeRange(31, 1);
        public static final UnicodeRange SUPERSCRIPTS_AND_SUSCRIPTS = new UnicodeRange(32, 1);
        public static final UnicodeRange CURRENCY_SYMBOLS = new UnicodeRange(33, 1);
        public static final UnicodeRange COMBINING_DIACRITICAL_MARKS_FOR_SYMBOLS = new UnicodeRange(34, 1);
        public static final UnicodeRange LETTERLIKE_SYMBOLS = new UnicodeRange(35, 1);
        public static final UnicodeRange NUMBER_FORMS = new UnicodeRange(36, 1);
        public static final UnicodeRange ARROWS = new UnicodeRange(37, 1);
        public static final UnicodeRange MATHEMATICAL_OPERATORS = new UnicodeRange(38, 1);
        public static final UnicodeRange MISCELLANEOUS_TECHNICAL = new UnicodeRange(39, 1);
        public static final UnicodeRange CONTROL_PICTURES = new UnicodeRange(40, 1);
        public static final UnicodeRange OPTICAL_CHARACTER_RECOGNITION = new UnicodeRange(41, 1);
        public static final UnicodeRange ENCLOSED_ALPHANUMERICS = new UnicodeRange(42, 1);
        public static final UnicodeRange BOX_DRAWING = new UnicodeRange(43, 1);
        public static final UnicodeRange BLOCK_ELEMENTS = new UnicodeRange(44, 1);
        public static final UnicodeRange GEOMETRIC_SHAPES = new UnicodeRange(45, 1);
        public static final UnicodeRange MISCELLANEOUS_SYMBOLS = new UnicodeRange(46, 1);
        public static final UnicodeRange DINGBATS = new UnicodeRange(47, 1);
        public static final UnicodeRange CJK_SYMBOLS_AND_PUNCTUATION = new UnicodeRange(48, 1);
        public static final UnicodeRange HIRAGANA = new UnicodeRange(49, 1);
        public static final UnicodeRange KATAKANA = new UnicodeRange(50, 1);
        public static final UnicodeRange BOPOMOFO = new UnicodeRange(51, 1);
        public static final UnicodeRange HANGUL_COMPATIBILITY_JAMO = new UnicodeRange(52, 1);
        public static final UnicodeRange CJK_MISCELLANEOUS = new UnicodeRange(53, 1, 2);
        public static final UnicodeRange ENCLOSED_CJK_LETTERS_AND_MONTHS = new UnicodeRange(54, 1);
        public static final UnicodeRange CJK_COMPATIBILITY = new UnicodeRange(55, 1);
        public static final UnicodeRange HANGUL_SYLLABLES = new UnicodeRange(56, 1);
        public static final UnicodeRange SURROGATES = new UnicodeRange(57, 2);
        public static final UnicodeRange CJK_UNIFIED_IDEOGRAPHS = new UnicodeRange(59, 1);
        public static final UnicodeRange PRIVATE_USE_AREA = new UnicodeRange(60, 1);
        public static final UnicodeRange CJK_COMPATIBILITY_IDEOGRAPHS = new UnicodeRange(61, 1);
        public static final UnicodeRange ALPHABETIC_PRESENTATION_FORMS = new UnicodeRange(62, 1);
        public static final UnicodeRange ARABIC_PRESENTATION_FORMS_A = new UnicodeRange(63, 1);
        public static final UnicodeRange COMBINING_HALF_MARKS = new UnicodeRange(64, 1);
        public static final UnicodeRange CJK_COMPATIBILITY_FORMS = new UnicodeRange(65, 1);
        public static final UnicodeRange SMALL_FORM_VARIANTS = new UnicodeRange(66, 1);
        public static final UnicodeRange ARABIC_PRESENTATION_FORMS_B = new UnicodeRange(67, 1);
        public static final UnicodeRange HALFWIDTH_AND_FULLWIDTH_FORMS = new UnicodeRange(68, 1);
        public static final UnicodeRange SPECIALS = new UnicodeRange(69, 1);
        public static final UnicodeRange TIBETAN = new UnicodeRange(70, 2);
        public static final UnicodeRange SYRIAC = new UnicodeRange(71, 2);
        public static final UnicodeRange THAANA = new UnicodeRange(72, 2);
        public static final UnicodeRange SINHALA = new UnicodeRange(73, 2);
        public static final UnicodeRange MYANMAR = new UnicodeRange(74, 2);
        public static final UnicodeRange ETHIOPIC = new UnicodeRange(75, 2);
        public static final UnicodeRange CHEROKEE = new UnicodeRange(76, 2);
        public static final UnicodeRange UNIFIED_CANADIAN_SYLLABICS = new UnicodeRange(77, 2);
        public static final UnicodeRange OGHAM = new UnicodeRange(78, 2);
        public static final UnicodeRange RUNIC = new UnicodeRange(79, 2);
        public static final UnicodeRange KHMER = new UnicodeRange(80, 2);
        public static final UnicodeRange MONGOLIAN = new UnicodeRange(81, 2);
        public static final UnicodeRange BRAILLE = new UnicodeRange(82, 2);
        public static final UnicodeRange YI = new UnicodeRange(83, 2);
        public static final UnicodeRange TAGALOG_HANUNOO_BUHID_TAGBANWA = new UnicodeRange(84, 3);
        public static final UnicodeRange OLD_ITALIC = new UnicodeRange(85, 3);
        public static final UnicodeRange GOTHIC = new UnicodeRange(86, 3);
        public static final UnicodeRange DESERET = new UnicodeRange(87, 3);
        public static final UnicodeRange MUSICAL_SYMBOLS = new UnicodeRange(88, 3);
        public static final UnicodeRange MATHEMATICAL_ALPHANUMERIC_SYMBOLS = new UnicodeRange(89, 3);
        public static final UnicodeRange PRIVATE_USE_SUPPLEMENTARY = new UnicodeRange(90, 3);
        public static final UnicodeRange VARIATION_SELECTORS = new UnicodeRange(91, 3);
        public static final UnicodeRange TAGS = new UnicodeRange(92, 3);

        private UnicodeRange(int bit, int firstVersion, int lastVersion) {
            this.offset = 4 * (bit / 32);
            this.mask = 1 << bit % 32;
            this.firstVersion = firstVersion;
            this.lastVersion = lastVersion;
        }

        private UnicodeRange(int bit, int firstVersion) {
            this(bit, firstVersion, Integer.MAX_VALUE);
        }
    }

    public static interface SelectionBits {
        public static final int italic = 1;
        public static final int underscore = 2;
        public static final int negative = 4;
        public static final int outlined = 8;
        public static final int strikeout = 16;
        public static final int bold = 32;
        public static final int regular = 64;
    }
}

