/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.Table;
import java.io.IOException;
import java.util.Map;

public final class Maxp
extends Table {
    protected Maxp(FontByteArray buffer) throws UnsupportedFontException, InvalidFontException, IOException {
        super(buffer);
        if (buffer.getSize() < 6) {
            throw new InvalidFontException("'maxp' table must be at least 6 bytes (actual = " + buffer.getSize() + ")");
        }
        int majorVersion = this.getTableMajorVersion();
        switch (majorVersion) {
            case 0: {
                int minorVersion = this.getTableMinorVersion();
                if (minorVersion >= 20480) break;
                throw new UnsupportedFontException("'maxp' table version " + majorVersion + "." + minorVersion + " are not supported");
            }
            case 1: {
                break;
            }
            default: {
                throw new UnsupportedFontException("'maxp' table major version " + majorVersion + " are not supported");
            }
        }
    }

    public int getTableMajorVersion() throws InvalidFontException {
        return this.data.getuint16(0);
    }

    public int getTableMinorVersion() throws InvalidFontException {
        return this.data.getuint16(2);
    }

    public int getNumGlyphs() throws InvalidFontException {
        return this.data.getuint16(4);
    }

    public int getMaxTwilightPoints() throws InvalidFontException {
        if (this.getTableMajorVersion() >= 1) {
            return this.data.getuint16(16);
        }
        throw new InvalidFontException("no maxTwilightPoins for fonts with maxp.major = 0");
    }

    public int getMaxStorage() throws InvalidFontException {
        if (this.getTableMajorVersion() >= 1) {
            return this.data.getuint16(18);
        }
        throw new InvalidFontException("no maxStorage for fonts with maxp.major = 0");
    }

    public int getMaxFunctionDefs() throws InvalidFontException {
        if (this.getTableMajorVersion() >= 1) {
            return this.data.getuint16(20);
        }
        throw new InvalidFontException("no maxFunctionDefs for fonts with maxp.major = 0");
    }

    public int getMaxStackElements() throws InvalidFontException {
        if (this.getTableMajorVersion() >= 1) {
            return this.data.getuint16(24);
        }
        throw new InvalidFontException("no maxStackElements for fonts with maxp.major = 0");
    }

    public void subsetAndStreamForCFF(int numGlyphs, Map tables) {
        OTByteArray.OTByteArrayBuilder newData = OTByteArray.getOTByteArrayBuilderInstance(6);
        newData.setuint32(0, 20480);
        newData.setuint16(4, numGlyphs);
        tables.put(new Integer(1835104368), newData);
    }

    public void subsetAndStream(Subset subset, Map tables) {
        OTByteArray.OTByteArrayBuilder newData = OTByteArray.getOTByteArrayBuilderInstance(this.data);
        newData.setuint16(4, subset.getNumGlyphs());
        tables.put(new Integer(1835104368), newData);
    }

    public void stream(Map tables) {
        OTByteArray.OTByteArrayBuilder newData = this.getDataAsByteArray();
        tables.put(new Integer(1835104368), newData);
    }
}

