/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.Table;
import java.io.IOException;
import java.util.Map;

public final class Ltsh
extends Table {
    protected Ltsh(FontByteArray buffer) throws IOException, InvalidFontException, UnsupportedFontException {
        super(buffer);
    }

    public int getYPels(int gid) throws InvalidFontException {
        int numGlyphs = this.data.getuint16(2);
        if (gid < numGlyphs) {
            return this.data.getuint8(4 + gid);
        }
        return 1;
    }

    public void subsetAndStream(Subset subset, Map tables) throws InvalidFontException {
        OTByteArray.OTByteArrayBuilder newData = OTByteArray.getOTByteArrayBuilderInstance(subset.getNumGlyphs() * 4);
        newData.setuint16(0, 0);
        newData.setuint16(2, subset.getNumGlyphs());
        int offset = 4;
        for (int i = 0; i < subset.getNumGlyphs(); ++i) {
            int fullGid = subset.getFullGid(i);
            newData.setuint8(offset, this.getYPels(fullGid));
            ++offset;
        }
        tables.put(new Integer(1280594760), newData);
    }
}

