/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.SubsetDefaultImpl;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.LayoutTable;
import com.adobe.fontengine.font.opentype.LayoutTableSubsetter;
import com.adobe.fontengine.font.opentype.LookupTable;
import com.adobe.fontengine.font.opentype.OTByteArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

abstract class LookupTableSubsetter
extends LayoutTableSubsetter {
    protected final int origNumGlyphs;
    private int dummyLookupId = -1;

    LookupTableSubsetter(LayoutTable origTable, OTByteArray.OTByteArrayBuilder builder, int numGlyphs) {
        super(origTable, builder);
        this.origNumGlyphs = numGlyphs;
    }

    abstract void gatherCoveragesForSubtable(int var1, int var2, int var3, Integer var4, Map var5, Map var6, Subset var7) throws InvalidFontException, UnsupportedFontException;

    abstract int getExtensionSubtableSize();

    abstract int writeSubtable(int var1, int var2, Map var3, int var4, Subset var5, LookupSubset var6) throws InvalidFontException, UnsupportedFontException;

    abstract void patchSubtableCoverage(int var1, int var2, Map var3, int var4) throws InvalidFontException;

    abstract int getExtensionLookupType();

    abstract int writeExtensionSubtable(int var1, int var2);

    abstract void patchExtensionOffset(int var1, int var2);

    abstract int getReferencedLookupType(int var1) throws InvalidFontException;

    abstract int getReferencedSubtableOffset(int var1) throws InvalidFontException, UnsupportedFontException;

    abstract boolean mustKeepFeature(int var1) throws InvalidFontException;

    protected void gatherCoverages(int lookupIndex, Map coverages, Map extensionCoverages, Subset subset, List subtablesToKeep) throws InvalidFontException, UnsupportedFontException {
        int lookupListOffset = ((LookupTable)this.origTable).getLookupListOffset();
        int offset = this.origTable.data.getOffset(lookupListOffset, 2 + 2 * lookupIndex);
        for (int i = 0; i < subtablesToKeep.size(); ++i) {
            int lookupType = this.origTable.data.getuint16(offset);
            Integer subtable = (Integer)subtablesToKeep.get(i);
            int stOffset = this.origTable.data.getOffset(offset, 6 + 2 * subtable);
            this.gatherCoveragesForSubtable(stOffset, lookupType, lookupIndex, subtable, coverages, extensionCoverages, subset);
        }
    }

    private void moveCoveragesForLookup(int origLookupId, Map fromCoverages, Map toCoverages) {
        for (Integer origCoverageOffset : fromCoverages.keySet()) {
            NewCoverage extensionCopy;
            NewCoverage newCoverage = (NewCoverage)fromCoverages.get(origCoverageOffset);
            Integer oLID = new Integer(origLookupId);
            if (!newCoverage.referringOrigLookups.containsKey(oLID)) continue;
            if (toCoverages.containsKey(origCoverageOffset)) {
                extensionCopy = (NewCoverage)toCoverages.get(origCoverageOffset);
                extensionCopy.referringOrigLookups.put(oLID, newCoverage.referringOrigLookups.get(oLID));
            } else {
                extensionCopy = new NewCoverage();
                extensionCopy.glyphCount = newCoverage.glyphCount;
                extensionCopy.newCoverage = newCoverage.newCoverage;
                extensionCopy.referringOrigLookups.put(oLID, newCoverage.referringOrigLookups.get(oLID));
                toCoverages.put(origCoverageOffset, extensionCopy);
            }
            newCoverage.referringOrigLookups.remove(oLID);
        }
    }

    protected static void addToCoveragesMap(LayoutTable origTable, int absoluteCoverageOffset, Map coverages, int lookupIndex, Integer stIndex, Subset subset) throws InvalidFontException, UnsupportedFontException {
        Integer coverageOffsetInteger = new Integer(absoluteCoverageOffset);
        if (!coverages.containsKey(coverageOffsetInteger)) {
            NewCoverage newCoverage = new NewCoverage();
            HashSet<Integer> subtables = new HashSet<Integer>();
            subtables.add(stIndex);
            newCoverage.referringOrigLookups.put(new Integer(lookupIndex), subtables);
            LayoutTableSubsetter.CoverageGenerator generator = LayoutTableSubsetter.CoverageGenerator.newInstance(origTable, absoluteCoverageOffset, subset);
            newCoverage.newCoverage = generator.generateCoverage().toOTByteArray();
            newCoverage.glyphCount = generator.numGlyphsFound;
            coverages.put(coverageOffsetInteger, newCoverage);
        } else {
            NewCoverage newCoverage = (NewCoverage)coverages.get(coverageOffsetInteger);
            Integer lookup = new Integer(lookupIndex);
            if (newCoverage.referringOrigLookups.containsKey(lookup)) {
                Set referringSubtables = (Set)newCoverage.referringOrigLookups.get(lookup);
                referringSubtables.add(stIndex);
            } else {
                HashSet<Integer> subtables = new HashSet<Integer>();
                subtables.add(stIndex);
                newCoverage.referringOrigLookups.put(new Integer(lookupIndex), subtables);
            }
        }
    }

    private int getLookupOffset(int origLLOffset, int origLookupID) throws InvalidFontException {
        return this.origTable.data.getOffset(origLLOffset, 2 + 2 * origLookupID);
    }

    private void patchCoverages(int origLLOffset, int origLookupID, List subtablesToKeep, List newSubtableOffsets, Map regularCoverages) throws InvalidFontException {
        int origLookupOffset = this.getLookupOffset(origLLOffset, origLookupID);
        int lookupType = this.origTable.data.getuint16(origLookupOffset);
        for (int i = 0; i < subtablesToKeep.size(); ++i) {
            int subtable = (Integer)subtablesToKeep.get(i);
            this.patchSubtableCoverage(this.origTable.data.getOffset(origLookupOffset, 6 + 2 * subtable), (Integer)newSubtableOffsets.get(i), regularCoverages, lookupType);
        }
    }

    private void patchExtensionCoverages(int origLookupOffset, List subtablesToKeep, List newSubtableOffsets, Map extensionCoverages) throws InvalidFontException, UnsupportedFontException {
        for (int i = 0; i < subtablesToKeep.size(); ++i) {
            int subtable = (Integer)subtablesToKeep.get(i);
            int origExtensionSTOffset = this.origTable.data.getOffset(origLookupOffset, 6 + 2 * subtable);
            int lookupType = this.origTable.data.getuint16(origLookupOffset);
            if (lookupType == this.getExtensionLookupType()) {
                lookupType = this.getReferencedLookupType(origExtensionSTOffset);
                origExtensionSTOffset = this.getReferencedSubtableOffset(origExtensionSTOffset);
            }
            this.patchSubtableCoverage(origExtensionSTOffset, (Integer)newSubtableOffsets.get(i), extensionCoverages, lookupType);
        }
    }

    private int writeLookup(int newLookupOffset, Map newCoverages, int origLookupOffset, List subtablesToKeep, Subset subset, List newSubtableOffsets, LookupSubset lookupSubset) throws InvalidFontException, UnsupportedFontException {
        int subtableCount = subtablesToKeep.size();
        int size = 6 + 2 * subtableCount;
        this.builder.ensureCapacity(newLookupOffset + size);
        int lookupType = this.origTable.data.getuint16(origLookupOffset);
        this.builder.setuint16(newLookupOffset, lookupType);
        this.builder.setuint16(newLookupOffset + 2, this.origTable.data.getuint16(origLookupOffset + 2));
        this.builder.setuint16(newLookupOffset + 4, subtableCount);
        for (int i = 0; i < subtableCount; ++i) {
            int subtable = (Integer)subtablesToKeep.get(i);
            this.builder.setuint16(newLookupOffset + 6 + 2 * i, size);
            newSubtableOffsets.add(i, new Integer(newLookupOffset + size));
            size += this.writeSubtable(this.origTable.data.getOffset(origLookupOffset, 6 + 2 * subtable), newLookupOffset + size, newCoverages, lookupType, subset, lookupSubset);
        }
        return size;
    }

    private int writeLookupAsExtension(int newLookupOffset, int origLookupOffset, List subtablesToKeep, List newSubtableOffsets) throws InvalidFontException, UnsupportedFontException {
        int subtableCount = subtablesToKeep.size();
        int size = 6 + 2 * subtableCount;
        int lookupType = this.origTable.data.getuint16(origLookupOffset);
        boolean lookupIsExtension = lookupType == this.getExtensionLookupType();
        this.builder.setuint16(newLookupOffset, this.getExtensionLookupType());
        this.builder.setuint16(newLookupOffset + 2, this.origTable.data.getuint16(origLookupOffset + 2));
        this.builder.setuint16(newLookupOffset + 4, subtableCount);
        for (int i = 0; i < subtableCount; ++i) {
            int subtable = (Integer)subtablesToKeep.get(i);
            this.builder.setuint16(newLookupOffset + 6 + 2 * i, size);
            newSubtableOffsets.add(i, new Integer(newLookupOffset + size));
            if (lookupIsExtension) {
                size += this.writeSubtable(this.origTable.data.getOffset(origLookupOffset, 6 + 2 * subtable), newLookupOffset + size, null, lookupType, null, null);
                continue;
            }
            size += this.writeExtensionSubtable(newLookupOffset + size, lookupType);
        }
        return size;
    }

    private int writeExtensionSubtables(int newExtensionStartOffset, List newSubtableOffsets, Map newCoverages, int origLookupOffset, List subtablesToKeep, Subset subset, LookupSubset lookupSubset, int origLookupType, int origLookupID) throws InvalidFontException, UnsupportedFontException {
        int extensionSubtablesSize = 0;
        for (int i = 0; i < subtablesToKeep.size(); ++i) {
            int extensionSubtableOffset = (Integer)newSubtableOffsets.get(i);
            int origSTOffset = this.origTable.data.getOffset(origLookupOffset, 6 + 2 * (Integer)subtablesToKeep.get(i));
            this.patchExtensionOffset(extensionSubtableOffset, newExtensionStartOffset + extensionSubtablesSize);
            newSubtableOffsets.set(i, new Integer(newExtensionStartOffset + extensionSubtablesSize));
            int subLookupType = origLookupType;
            if (origLookupType == this.getExtensionLookupType()) {
                subLookupType = this.getReferencedLookupType(origSTOffset);
                origSTOffset = this.getReferencedSubtableOffset(origSTOffset);
            }
            extensionSubtablesSize += this.writeSubtable(origSTOffset, newExtensionStartOffset + extensionSubtablesSize, newCoverages, subLookupType, subset, lookupSubset);
            for (Integer origCoverageOffset : newCoverages.keySet()) {
                NewCoverage newCoverage = (NewCoverage)newCoverages.get(origCoverageOffset);
                if (newCoverage.getMaxReferringOrigLookup() != origLookupID || newCoverage.getMaxSubtable(origLookupID) != ((Integer)subtablesToKeep.get(i)).intValue()) continue;
                newCoverage.newOffset = newExtensionStartOffset + extensionSubtablesSize;
                extensionSubtablesSize += this.writeByteArrayAtOffset(newExtensionStartOffset + extensionSubtablesSize, newCoverage.newCoverage);
            }
        }
        return extensionSubtablesSize;
    }

    private int writeDummyLookup(int newDummyOffset) {
        this.builder.ensureCapacity(newDummyOffset + 6);
        this.builder.setuint16(newDummyOffset, 0);
        this.builder.setuint16(newDummyOffset + 2, 0);
        this.builder.setuint16(newDummyOffset + 2, 0);
        return 6;
    }

    protected int buildLookupList(int origLLOffset, int newLLOffset, LookupSubset lookupToKeep, Subset subset) throws InvalidFontException, UnsupportedFontException {
        int subsetLookup;
        int i;
        int llSize = 2 + 2 * lookupToKeep.getNumGlyphs() + (this.dummyLookupId == -1 ? 0 : 2);
        HashMap regularCoverages = new HashMap();
        HashMap extensionCoverages = new HashMap();
        this.builder.ensureCapacity(newLLOffset + llSize);
        this.builder.setuint16(newLLOffset, lookupToKeep.getNumGlyphs() + (this.dummyLookupId == -1 ? 0 : 1));
        int subtableCount = 0;
        for (int i2 = 0; i2 < lookupToKeep.getNumGlyphs(); ++i2) {
            List subtablesToKeep = lookupToKeep.getSubtables(lookupToKeep.getFullGid(i2));
            subtableCount += subtablesToKeep.size();
            this.gatherCoverages(lookupToKeep.getFullGid(i2), regularCoverages, extensionCoverages, subset, subtablesToKeep);
        }
        int coverageSize = 0;
        for (Object key : regularCoverages.keySet()) {
            NewCoverage thisCoverage = (NewCoverage)regularCoverages.get(key);
            coverageSize += thisCoverage.newCoverage.getSize();
        }
        int subtablesWritten = 0;
        int spaceTaken = 0;
        List[] newSubtableOffsets = new List[lookupToKeep.getNumGlyphs()];
        ArrayList<Integer> extensionList = new ArrayList<Integer>();
        for (i = 0; i < lookupToKeep.getNumGlyphs(); ++i) {
            newSubtableOffsets[i] = new ArrayList();
            List subtablesToKeep = lookupToKeep.getSubtables(lookupToKeep.getFullGid(i));
            int originalLookupOffset = this.getLookupOffset(origLLOffset, lookupToKeep.getFullGid(i));
            this.builder.setuint16(newLLOffset + 2 + 2 * i, llSize);
            if (this.origTable.data.getuint16(originalLookupOffset) == this.getExtensionLookupType()) {
                extensionList.add(new Integer(i));
            }
            int thisLookupSize = this.writeLookup(newLLOffset + llSize, regularCoverages, originalLookupOffset, subtablesToKeep, subset, newSubtableOffsets[i], lookupToKeep);
            int thisNumSubtables = subtablesToKeep.size();
            int roomNeeded = spaceTaken + thisLookupSize + (lookupToKeep.getNumGlyphs() - (i + 1)) * 6 + (this.dummyLookupId == -1 ? 0 : 6) + (subtableCount - (subtablesWritten + thisNumSubtables)) * (this.getExtensionSubtableSize() + 2) + coverageSize;
            if (roomNeeded > maxOffset) break;
            subtablesWritten += thisNumSubtables;
            spaceTaken += thisLookupSize;
            llSize += thisLookupSize;
        }
        if (i < lookupToKeep.getNumGlyphs()) {
            while (i < lookupToKeep.getNumGlyphs()) {
                newSubtableOffsets[i] = new ArrayList();
                int originalLookupOffset = this.getLookupOffset(origLLOffset, lookupToKeep.getFullGid(i));
                List subtablesToKeep = lookupToKeep.getSubtables(lookupToKeep.getFullGid(i));
                this.builder.setuint16(newLLOffset + 2 + 2 * i, llSize);
                llSize += this.writeLookupAsExtension(newLLOffset + llSize, originalLookupOffset, subtablesToKeep, newSubtableOffsets[i]);
                extensionList.add(new Integer(i));
                this.moveCoveragesForLookup(lookupToKeep.getFullGid(i), regularCoverages, extensionCoverages);
                ++i;
            }
        }
        for (Integer origCoverageOffset : regularCoverages.keySet()) {
            NewCoverage newCoverage = (NewCoverage)regularCoverages.get(origCoverageOffset);
            if (newCoverage.referringOrigLookups.isEmpty()) continue;
            newCoverage.newOffset = newLLOffset + llSize;
            llSize += this.writeByteArrayAtOffset(newLLOffset + llSize, newCoverage.newCoverage);
        }
        for (i = 0; i < newSubtableOffsets.length; ++i) {
            if (extensionList.contains(new Integer(i))) continue;
            this.patchCoverages(origLLOffset, lookupToKeep.getFullGid(i), lookupToKeep.getSubtables(lookupToKeep.getFullGid(i)), newSubtableOffsets[i], regularCoverages);
        }
        if (this.dummyLookupId != -1) {
            this.builder.setuint16(newLLOffset + 2 + 2 * this.dummyLookupId, llSize);
            llSize += this.writeDummyLookup(newLLOffset + llSize);
        }
        for (i = 0; i < extensionList.size(); ++i) {
            subsetLookup = (Integer)extensionList.get(i);
            List subtablesToKeep = lookupToKeep.getSubtables(lookupToKeep.getFullGid(subsetLookup));
            int originalLookupOffset = this.getLookupOffset(origLLOffset, lookupToKeep.getFullGid(subsetLookup));
            int origLookupType = this.origTable.data.getuint16(originalLookupOffset);
            llSize += this.writeExtensionSubtables(newLLOffset + llSize, newSubtableOffsets[subsetLookup], extensionCoverages, originalLookupOffset, subtablesToKeep, subset, lookupToKeep, origLookupType, lookupToKeep.getFullGid(subsetLookup));
        }
        for (i = 0; i < extensionList.size(); ++i) {
            subsetLookup = (Integer)extensionList.get(i);
            int originalLookupOffset = this.getLookupOffset(origLLOffset, lookupToKeep.getFullGid(subsetLookup));
            List subtablesToKeep = lookupToKeep.getSubtables(lookupToKeep.getFullGid(subsetLookup));
            this.patchExtensionCoverages(originalLookupOffset, subtablesToKeep, newSubtableOffsets[subsetLookup], extensionCoverages);
        }
        return llSize;
    }

    OTByteArray.OTByteArrayBuilder subsetAndStream(TreeMap lookupToKeep, Subset subset) throws InvalidFontException, UnsupportedFontException {
        int origFLOffset = this.origTable.data.getOffset(0, 6);
        LookupSubset lookupSubset = new LookupSubset(lookupToKeep, this.origTable.data.getuint16(((LookupTable)this.origTable).getLookupListOffset()));
        FeatureSubset featureSubset = new FeatureSubset(this, this.origTable.data, origFLOffset, lookupToKeep);
        this.builder.setuint32(0, 65536);
        int origOffset = this.origTable.data.getOffset(0, 4);
        int gsubSize = 10;
        this.builder.setuint16(4, gsubSize);
        gsubSize += this.buildScriptList(origOffset, gsubSize, featureSubset, lookupSubset);
        this.builder.setuint16(6, gsubSize);
        gsubSize += this.buildFeatureList(origFLOffset, gsubSize, featureSubset, lookupSubset);
        origOffset = this.origTable.data.getOffset(0, 8);
        this.builder.setuint16(8, gsubSize);
        this.buildLookupList(origOffset, gsubSize, lookupSubset, subset);
        return this.builder;
    }

    private int buildScriptList(int origSLOffset, int newSLOffset, FeatureSubset featuresToKeep, LookupSubset lookupToKeep) throws InvalidFontException, UnsupportedFontException {
        int origScriptCount = this.origTable.data.getuint16(origSLOffset);
        int slSize = 2;
        this.builder.ensureCapacity(newSLOffset + (slSize += origScriptCount * 6));
        this.builder.setuint16(newSLOffset, origScriptCount);
        for (int i = 0; i < origScriptCount; ++i) {
            for (int k = 0; k < 4; ++k) {
                this.builder.setuint8(newSLOffset + 2 + 6 * i + k, this.origTable.data.getint8(origSLOffset + 2 + 6 * i + k));
            }
            this.builder.setuint16(newSLOffset + 2 + 6 * i + 4, slSize);
            slSize += this.writeScript(this.origTable.data.getOffset(origSLOffset, 2 + 6 * i + 4), featuresToKeep, newSLOffset + slSize, lookupToKeep);
        }
        return slSize;
    }

    private int writeScript(int origScriptOffset, FeatureSubset featuresToKeep, int newScriptOffset, LookupSubset lookupToKeep) throws InvalidFontException, UnsupportedFontException {
        int scriptSize = 0;
        int origLangSysCount = this.origTable.data.getuint16(origScriptOffset + 2);
        this.builder.ensureCapacity(newScriptOffset + (scriptSize += 4 + origLangSysCount * 6));
        this.builder.setuint16(newScriptOffset + 2, origLangSysCount);
        int origDefaultLangSysOffset = this.origTable.data.getOffset(origScriptOffset, 0);
        if (origDefaultLangSysOffset != 0) {
            this.builder.setuint16(newScriptOffset, scriptSize);
            scriptSize += this.writeLangSys(origDefaultLangSysOffset, featuresToKeep, newScriptOffset + scriptSize, lookupToKeep);
        } else {
            this.builder.setuint16(newScriptOffset, 0);
        }
        for (int i = 0; i < origLangSysCount; ++i) {
            this.builder.setuint16(newScriptOffset + 4 + 6 * i + 4, scriptSize);
            for (int k = 0; k < 4; ++k) {
                this.builder.setuint8(newScriptOffset + 4 + 6 * i + k, this.origTable.data.getint8(origScriptOffset + 4 + 6 * i + k));
            }
            scriptSize += this.writeLangSys(this.origTable.data.getOffset(origScriptOffset, 4 + 6 * i + 4), featuresToKeep, newScriptOffset + scriptSize, lookupToKeep);
        }
        return scriptSize;
    }

    private int writeLangSys(int origLSOffset, FeatureSubset featuresToKeep, int newLSOffset, LookupSubset lookupToKeep) throws InvalidFontException, UnsupportedFontException {
        int origFeatureCount = this.origTable.data.getuint16(origLSOffset + 4);
        ArrayList<Integer> featureToKeepList = new ArrayList<Integer>();
        int langSysSize = 0;
        for (int i = 0; i < origFeatureCount; ++i) {
            int featureIndex = this.origTable.data.getuint16(origLSOffset + 6 + 2 * i);
            if (featuresToKeep.getExistingSubsetGid(featureIndex) == -1) continue;
            featureToKeepList.add(new Integer(i));
        }
        this.builder.ensureCapacity(newLSOffset + (langSysSize += 6 + 2 * featureToKeepList.size()));
        this.builder.setuint16(newLSOffset, 0);
        int requiredFeature = this.origTable.data.getuint16(origLSOffset + 2);
        if (requiredFeature != 65535 && featuresToKeep.getExistingSubsetGid(requiredFeature) != -1) {
            this.builder.setuint16(newLSOffset + 2, featuresToKeep.getExistingSubsetGid(requiredFeature));
        } else {
            this.builder.setuint16(newLSOffset + 2, 65535);
        }
        this.builder.setuint16(newLSOffset + 4, featureToKeepList.size());
        for (int i = 0; i < featureToKeepList.size(); ++i) {
            int j = (Integer)featureToKeepList.get(i);
            int featureIndex = this.origTable.data.getuint16(origLSOffset + 6 + 2 * j);
            int newFeatureIndex = featuresToKeep.getExistingSubsetGid(featureIndex);
            this.builder.setuint16(newLSOffset + 6 + 2 * i, newFeatureIndex);
        }
        return langSysSize;
    }

    private int buildFeatureList(int origFLOffset, int newFLOffset, FeatureSubset featuresToKeep, LookupSubset lookupSubset) throws InvalidFontException {
        int flSize = 2 + 6 * featuresToKeep.getNumGlyphs();
        this.builder.ensureCapacity(newFLOffset + flSize);
        this.builder.setuint16(newFLOffset, featuresToKeep.getNumGlyphs());
        for (int i = 0; i < featuresToKeep.getNumGlyphs(); ++i) {
            int origFeature = featuresToKeep.getFullGid(i);
            for (int j = 0; j < 4; ++j) {
                this.builder.setuint8(newFLOffset + 2 + 6 * i + j, this.origTable.data.getint8(origFLOffset + 2 + 6 * origFeature + j));
            }
            this.builder.setuint16(newFLOffset + 2 + 6 * i + 4, flSize);
            flSize += this.writeFeature(this.origTable.data.getOffset(origFLOffset, 2 + 6 * origFeature + 4), newFLOffset + flSize, lookupSubset);
        }
        return flSize;
    }

    private int writeFeature(int origFeatOffset, int newFeatOffset, LookupSubset lookupSubset) throws InvalidFontException {
        int featureSize = 0;
        int origLookupCount = this.origTable.data.getuint16(origFeatOffset + 2);
        int newLookupCount = 0;
        for (int i = 0; i < origLookupCount; ++i) {
            int origLookupIndex = this.origTable.data.getuint16(origFeatOffset + 4 + 2 * i);
            if (lookupSubset.getExistingSubsetGid(origLookupIndex) == -1) continue;
            ++newLookupCount;
        }
        if (origLookupCount > 0 && newLookupCount == 0) {
            ++newLookupCount;
            if (this.dummyLookupId == -1) {
                this.dummyLookupId = lookupSubset.getNumGlyphs();
            }
        }
        this.builder.ensureCapacity(newFeatOffset + (featureSize += 4 + 2 * newLookupCount));
        this.builder.setuint16(newFeatOffset, 0);
        this.builder.setuint16(newFeatOffset + 2, newLookupCount);
        int j = 0;
        for (int i = 0; i < origLookupCount; ++i) {
            int origLookupIndex = this.origTable.data.getuint16(origFeatOffset + 4 + 2 * i);
            int newLookupIndex = lookupSubset.getExistingSubsetGid(origLookupIndex);
            if (newLookupIndex == -1) continue;
            this.builder.setuint16(newFeatOffset + 4 + 2 * j, newLookupIndex);
            ++j;
        }
        if (origLookupCount > 0 && newLookupCount == 0) {
            this.builder.setuint16(newFeatOffset + 4, this.dummyLookupId);
        }
        return featureSize;
    }

    protected static void patchCoverageAtOffset(LayoutTable origTable, OTByteArray.OTByteArrayBuilder builder, int origSTOffset, int newSTOffset, int coverageDelta, Map coverageInfo) throws InvalidFontException {
        Integer coverageOffset = new Integer(origTable.data.getOffset(origSTOffset, coverageDelta));
        NewCoverage coverage = (NewCoverage)coverageInfo.get(coverageOffset);
        if (coverage.newOffset - newSTOffset > 65535) {
            throw new RuntimeException("New coverage offset is out of range!");
        }
        if (coverage.newOffset < newSTOffset) {
            throw new RuntimeException("New coverage written out before subtable!");
        }
        builder.setuint16(newSTOffset + coverageDelta, coverage.newOffset - newSTOffset);
    }

    static class LookupSubset
    extends SubsetDefaultImpl {
        final TreeMap lookupsToKeep;

        LookupSubset(TreeMap lookupsToKeep, int origLookupCount) throws InvalidFontException, UnsupportedFontException {
            super(origLookupCount, true);
            this.lookupsToKeep = lookupsToKeep;
            for (Integer lookup : lookupsToKeep.keySet()) {
                this.getSubsetGid(lookup);
            }
        }

        List getSubtables(int origGID) {
            return (List)this.lookupsToKeep.get(new Integer(origGID));
        }
    }

    static class FeatureSubset
    extends SubsetDefaultImpl {
        FeatureSubset(LookupTableSubsetter subsetter, OTByteArray origTable, int origFeatureListOffset, Map lookupsToKeep) throws InvalidFontException, UnsupportedFontException {
            super(origTable.getuint16(origFeatureListOffset), true);
            int count = origTable.getuint16(origFeatureListOffset);
            for (int i = 0; i < count; ++i) {
                int origFeatureOffset = origTable.getOffset(origFeatureListOffset, 2 + 6 * i + 4);
                if (!this.featureContainsLookups(origTable, origFeatureOffset, lookupsToKeep) && !subsetter.mustKeepFeature(origFeatureListOffset + 2 + 6 * i)) continue;
                this.getSubsetGid(i);
            }
        }

        private boolean featureContainsLookups(OTByteArray origTable, int origFeatureOffset, Map lookupsToKeep) throws InvalidFontException {
            int lookupCount = origTable.getuint16(origFeatureOffset + 2);
            for (int i = 0; i < lookupCount; ++i) {
                int index = origTable.getuint16(origFeatureOffset + 4 + 2 * i);
                if (!lookupsToKeep.containsKey(new Integer(index))) continue;
                return true;
            }
            return false;
        }
    }

    protected static class NewCoverage {
        int newOffset = -1;
        OTByteArray newCoverage = null;
        int glyphCount = 0;
        Map referringOrigLookups = new HashMap();

        protected NewCoverage() {
        }

        int getMaxReferringOrigLookup() {
            Iterator iter = this.referringOrigLookups.keySet().iterator();
            int max = 0;
            while (iter.hasNext()) {
                int thisLookup = (Integer)iter.next();
                if (max >= thisLookup) continue;
                max = thisLookup;
            }
            return max;
        }

        int getMaxSubtable(int lookup) {
            Set subtables = (Set)this.referringOrigLookups.get(new Integer(lookup));
            int max = 0;
            Iterator iter = subtables.iterator();
            while (iter.hasNext()) {
                int theValue = (Integer)iter.next();
                if (max >= theValue) continue;
                max = theValue;
            }
            return max;
        }
    }

    static interface LookupSubtableGenerator {
        public int writeSubtable() throws InvalidFontException, UnsupportedFontException;
    }
}

