/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.Gdef;
import com.adobe.fontengine.font.opentype.Table;
import java.io.IOException;

public abstract class LayoutTable
extends Table {
    protected LayoutTable(FontByteArray buffer) throws IOException, InvalidFontException, UnsupportedFontException {
        super(buffer);
    }

    protected boolean lookupFlagCovers(int lookupFlag, Gdef gdef, int glyphID) throws InvalidFontException {
        if (glyphID == -1) {
            return false;
        }
        if ((lookupFlag & 0xE) != 0) {
            if (gdef == null) {
                throw new InvalidFontException("lookupflag value requires a GDEF table, which is absent");
            }
            int glyphClass = gdef.getGlyphClass(glyphID);
            if ((lookupFlag & 2) != 0 && glyphClass == 1 || (lookupFlag & 4) != 0 && glyphClass == 2 || (lookupFlag & 8) != 0 && glyphClass == 3) {
                return true;
            }
        }
        if ((lookupFlag & 0xFF00) != 0) {
            int markClass;
            if (gdef == null) {
                throw new InvalidFontException("lookupflag value requires a GDEF table, which is absent");
            }
            if (gdef.getGlyphClass(glyphID) == 3 && (lookupFlag & 0xFF00) >> 8 != (markClass = gdef.getMarkAttachClass(glyphID))) {
                return true;
            }
        }
        return false;
    }

    private void iterateClassFormat1(int classDefOffset, int numGlyphs, ClassConsumer consumer, int theClass) throws InvalidFontException, UnsupportedFontException {
        int index;
        int start = this.data.getuint16(classDefOffset + 2);
        int end = start + this.data.getuint16(classDefOffset + 4);
        if (theClass == 0 || theClass == -1) {
            for (index = 0; index < start; ++index) {
                if (consumer.glyph(index, 0)) continue;
                return;
            }
        }
        for (index = start; index < end; ++index) {
            int thisClass = this.data.getuint16(classDefOffset + 6 + 2 * (index - start));
            if (thisClass != theClass && theClass != -1 || consumer.glyph(index, thisClass)) continue;
            return;
        }
        if (theClass == 0 || theClass == -1) {
            for (index = end; index < numGlyphs; ++index) {
                if (consumer.glyph(index, 0)) continue;
                return;
            }
        }
    }

    private void iterateClassFormat2(int classDefOffset, int numGlyphs, ClassConsumer consumer, int theClass) throws InvalidFontException, UnsupportedFontException {
        int start;
        int index = 0;
        int numRanges = this.data.getuint16(classDefOffset + 2);
        if (theClass == 0 || theClass == -1) {
            if (numRanges == 0) {
                while (index < numGlyphs) {
                    if (consumer.glyph(index++, 0)) continue;
                    return;
                }
                return;
            }
            start = this.data.getuint16(classDefOffset + 4);
            while (index < start) {
                if (consumer.glyph(index++, 0)) continue;
                return;
            }
        }
        for (int i = 0; i < numRanges; ++i) {
            int thisClass = this.data.getuint16(classDefOffset + 4 + 6 * i + 4);
            int end = this.data.getuint16(classDefOffset + 4 + 6 * i + 2);
            if (thisClass == theClass || theClass == -1) {
                start = this.data.getuint16(classDefOffset + 4 + 6 * i);
                end = this.data.getuint16(classDefOffset + 4 + 6 * i + 2);
                for (index = start; index <= end; ++index) {
                    if (consumer.glyph(index, thisClass)) continue;
                    return;
                }
            }
            index = end + 1;
            if (theClass != 0 && theClass != -1) continue;
            end = i == numRanges - 1 ? numGlyphs : this.data.getuint16(classDefOffset + 4 + 6 * (i + 1));
            while (index < end) {
                if (consumer.glyph(index++, 0)) continue;
                return;
            }
        }
    }

    void iterateClass(int classDefOffset, int numGlyphs, ClassConsumer consumer, int theClass) throws InvalidFontException, UnsupportedFontException {
        int format = this.data.getuint16(classDefOffset);
        switch (format) {
            case 1: {
                this.iterateClassFormat1(classDefOffset, numGlyphs, consumer, theClass);
                break;
            }
            case 2: {
                this.iterateClassFormat2(classDefOffset, numGlyphs, consumer, theClass);
                break;
            }
            default: {
                throw new InvalidFontException("Invalid class def format (" + format + ")");
            }
        }
    }

    private void iterateFormat1Coverage(int coverageOffset, Subset glyphsToInclude, CoverageConsumer consumer) throws InvalidFontException, UnsupportedFontException {
        int numGlyphs = this.data.getuint16(coverageOffset + 2);
        for (int currentGlyph = 0; currentGlyph < numGlyphs; ++currentGlyph) {
            int g = this.data.getuint16(coverageOffset + 4 + 2 * currentGlyph);
            if (glyphsToInclude != null && glyphsToInclude.getExistingSubsetGid(g) == -1 || consumer.glyphInfo(g, currentGlyph)) continue;
            return;
        }
    }

    private void iterateFormat2Coverage(int coverageOffset, Subset glyphsToInclude, CoverageConsumer consumer) throws InvalidFontException, UnsupportedFontException {
        int rangeCount = this.data.getuint16(coverageOffset + 2);
        int currentRange = 0;
        int indicesInRange = rangeCount > 0 ? this.data.getuint16(coverageOffset + 4 + 2) - this.data.getuint16(coverageOffset + 4) + 1 : 0;
        for (int indexInRange = 0; indexInRange < indicesInRange || currentRange < rangeCount - 1; ++indexInRange) {
            int coverageIndex;
            if (indexInRange == indicesInRange) {
                indexInRange = 0;
                indicesInRange = this.data.getuint16(coverageOffset + 4 + 6 * ++currentRange + 2) - this.data.getuint16(coverageOffset + 4 + 6 * currentRange) + 1;
            }
            int gid = this.data.getuint16(coverageOffset + 4 + 6 * currentRange) + indexInRange;
            if (glyphsToInclude != null && glyphsToInclude.getExistingSubsetGid(gid) == -1 || consumer.glyphInfo(gid, coverageIndex = this.data.getuint16(coverageOffset + 4 + 6 * currentRange + 4) + indexInRange)) continue;
            return;
        }
    }

    void iterateCoverage(int coverageOffset, Subset glyphsToInclude, CoverageConsumer consumer) throws InvalidFontException, UnsupportedFontException {
        int format = this.data.getuint16(coverageOffset);
        switch (format) {
            case 1: {
                this.iterateFormat1Coverage(coverageOffset, glyphsToInclude, consumer);
                break;
            }
            case 2: {
                this.iterateFormat2Coverage(coverageOffset, glyphsToInclude, consumer);
                break;
            }
            default: {
                throw new InvalidFontException("Invalid coverage format " + format);
            }
        }
    }

    protected int getCoverageIndex(int glyphID, int coverageOffset) throws InvalidFontException {
        if (glyphID == -1) {
            return -1;
        }
        int format = this.data.getuint16(coverageOffset);
        switch (format) {
            case 1: {
                int min = 0;
                int max = this.data.getuint16(coverageOffset + 2) - 1;
                while (min <= max) {
                    int mid = (min + max) / 2;
                    int g = this.data.getuint16(coverageOffset + 4 + 2 * mid);
                    if (glyphID < g) {
                        max = mid - 1;
                        continue;
                    }
                    if (g < glyphID) {
                        min = mid + 1;
                        continue;
                    }
                    return mid;
                }
                return -1;
            }
            case 2: {
                int min = 0;
                int max = this.data.getuint16(coverageOffset + 2) - 1;
                while (min <= max) {
                    int mid = (min + max) / 2;
                    int start = this.data.getuint16(coverageOffset + 4 + 6 * mid);
                    int stop = this.data.getuint16(coverageOffset + 4 + 6 * mid + 2);
                    if (glyphID < start) {
                        max = mid - 1;
                        continue;
                    }
                    if (stop < glyphID) {
                        min = mid + 1;
                        continue;
                    }
                    return this.data.getuint16(coverageOffset + 4 + 6 * mid + 4) + (glyphID - start);
                }
                return -1;
            }
        }
        throw new InvalidFontException("invalid coverage format (" + format + ")");
    }

    protected int getClassIndex(int glyphID, int classdefOffset) throws InvalidFontException {
        if (glyphID == -1) {
            return -1;
        }
        int format = this.data.getuint16(classdefOffset);
        switch (format) {
            case 1: {
                int startGlyph = this.data.getuint16(classdefOffset + 2);
                int glyphCount = this.data.getuint16(classdefOffset + 4);
                if (startGlyph <= glyphID && glyphID < startGlyph + glyphCount) {
                    return this.data.getuint16(classdefOffset + 6 + (glyphID - startGlyph) * 2);
                }
                return 0;
            }
            case 2: {
                int rangeCount = this.data.getuint16(classdefOffset + 2);
                int min = 0;
                int max = rangeCount - 1;
                while (min <= max) {
                    int mid = (min + max) / 2;
                    int start = this.data.getuint16(classdefOffset + 4 + mid * 6);
                    int stop = this.data.getuint16(classdefOffset + 4 + mid * 6 + 2);
                    if (glyphID < start) {
                        max = mid - 1;
                        continue;
                    }
                    if (stop < glyphID) {
                        min = mid + 1;
                        continue;
                    }
                    return this.data.getuint16(classdefOffset + 4 + mid * 6 + 4);
                }
                return 0;
            }
        }
        throw new InvalidFontException("invalid classdef format (" + format + ")");
    }

    static interface CoverageConsumer {
        public boolean glyphInfo(int var1, int var2) throws InvalidFontException, UnsupportedFontException;
    }

    static interface ClassConsumer {
        public boolean glyph(int var1, int var2) throws UnsupportedFontException, InvalidFontException;
    }
}

