/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.Table;
import java.io.IOException;
import java.util.Map;

public final class Head
extends Table {
    protected Head(FontByteArray buffer) throws IOException, InvalidFontException, UnsupportedFontException {
        super(buffer);
        if (buffer.getSize() < 46) {
            throw new InvalidFontException("'head' table must be at least 46 bytes");
        }
        int majorVersion = this.getTableMajorVersion();
        if (majorVersion != 1) {
            throw new UnsupportedFontException("'head' tables with major version " + majorVersion + " are not supported");
        }
    }

    public int getTableMajorVersion() throws InvalidFontException {
        return this.data.getuint16(0);
    }

    public int getTableMinorVersion() throws InvalidFontException {
        return this.data.getuint16(2);
    }

    protected long checksum() throws InvalidFontException {
        return this.checksum(12, this.data.getSize(), this.checksum(0, 8, 0L));
    }

    public boolean isConverted() throws InvalidFontException {
        return (this.data.getuint16(16) & 0x1000) != 0;
    }

    public int getUnitsPerEm() throws InvalidFontException {
        return this.data.getuint16(18);
    }

    public int getIndexToLocFormat() throws InvalidFontException {
        return this.data.getint16(50);
    }

    public boolean isItalic() throws InvalidFontException {
        return (this.data.getuint16(44) & 2) != 0;
    }

    public int getXMin() throws InvalidFontException {
        return this.data.getint16(36);
    }

    public int getYMin() throws InvalidFontException {
        return this.data.getint16(38);
    }

    public int getXMax() throws InvalidFontException {
        return this.data.getint16(40);
    }

    public int getYMax() throws InvalidFontException {
        return this.data.getint16(42);
    }

    public Rect getFontBBox() throws InvalidFontException {
        return new Rect(this.getXMin(), this.getYMin(), this.getXMax(), this.getYMax());
    }

    public OTByteArray.OTByteArrayBuilder subsetAndStream(Subset subset, Map tables) {
        OTByteArray.OTByteArrayBuilder newData = OTByteArray.getOTByteArrayBuilderInstance(this.data);
        newData.setint16(50, 1);
        tables.put(new Integer(1751474532), newData);
        return newData;
    }

    public OTByteArray.OTByteArrayBuilder stream(Map tables) {
        OTByteArray.OTByteArrayBuilder newData = this.getDataAsByteArray();
        tables.put(new Integer(1751474532), newData);
        return newData;
    }

    static final void clearChecksumAdjust(OTByteArray.OTByteArrayBuilder data) {
        data.setuint32(8, 0);
    }

    static final void setChecksumAdjust(OTByteArray.OTByteArrayBuilder data, long l) {
        data.setuint32(8, (int)l);
    }
}

