/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.agl.charset.CharsetEncoderICU;
import com.adobe.agl.text.UTF16;
import com.adobe.fontengine.CharsetUtil;
import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.SubsetDefaultImpl;
import com.adobe.fontengine.font.SubsetSimpleTrueType;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.Table;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderMalfunctionError;
import java.nio.charset.CoderResult;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class Cmap
extends Table {
    protected final int unicodeSubtableOffset;
    protected final int oldUnicodeSubtableOffset;
    protected final NonUnicodeCmap[] nonUnicodeSubtableIndices;
    protected final int symbolSubtableOffset;
    protected int paddingByte = 0;

    protected Cmap(FontByteArray buffer) throws IOException, InvalidFontException, UnsupportedFontException {
        super(buffer);
        int offset = this.probe(3, 10);
        this.unicodeSubtableOffset = offset != -1 ? offset : ((offset = this.probe(0, 4)) != -1 ? offset : ((offset = this.probe(3, 1)) != -1 ? offset : ((offset = this.probe(0, 3)) != -1 ? offset : -1)));
        offset = this.probe(0, 2);
        this.oldUnicodeSubtableOffset = offset != -1 ? offset : ((offset = this.probe(0, 1)) != -1 ? offset : ((offset = this.probe(0, 0)) != -1 ? offset : -1));
        offset = this.probe(3, 0);
        if (offset != -1) {
            this.symbolSubtableOffset = offset;
            this.paddingByte = this.computeSymbolPad(this.symbolSubtableOffset);
        } else {
            this.symbolSubtableOffset = -1;
        }
        ArrayList<NonUnicodeCmap> v = new ArrayList<NonUnicodeCmap>();
        offset = this.probe(3, 2);
        if (offset != -1) {
            v.add(new NonUnicodeCmap(offset, "windows-932"));
        }
        if ((offset = this.probe(3, 3)) != -1) {
            v.add(new NonUnicodeCmap(offset, "windows-936"));
        }
        if ((offset = this.probe(3, 4)) != -1) {
            v.add(new NonUnicodeCmap(offset, "windows-950"));
        }
        if ((offset = this.probe(3, 5)) != -1) {
            v.add(new NonUnicodeCmap(offset, "windows-949"));
        }
        if ((offset = this.probe(3, 6)) != -1) {
            v.add(new NonUnicodeCmap(offset, "ms1361"));
        }
        if ((offset = this.probe(1, 0)) != -1) {
            v.add(new NonUnicodeCmap(offset, "MacRoman"));
        }
        if ((offset = this.probe(1, 1)) != -1) {
            v.add(new NonUnicodeCmap(offset, "MacJapanese"));
        }
        if ((offset = this.probe(1, 2)) != -1) {
            v.add(new NonUnicodeCmap(offset, "MacChineseTraditional"));
        }
        if ((offset = this.probe(1, 3)) != -1) {
            v.add(new NonUnicodeCmap(offset, "MacKorean"));
        }
        if ((offset = this.probe(1, 4)) != -1) {
            v.add(new NonUnicodeCmap(offset, "MacArabic"));
        }
        if ((offset = this.probe(1, 5)) != -1) {
            v.add(new NonUnicodeCmap(offset, "MacHebrew"));
        }
        if ((offset = this.probe(1, 6)) != -1) {
            v.add(new NonUnicodeCmap(offset, "MacGreek"));
        }
        if ((offset = this.probe(1, 7)) != -1) {
            v.add(new NonUnicodeCmap(offset, "MacCyrillic"));
        }
        if ((offset = this.probe(1, 8)) != -1) {
            v.add(new NonUnicodeCmap(offset, "MacSymbol"));
        }
        if ((offset = this.probe(1, 21)) != -1) {
            v.add(new NonUnicodeCmap(offset, "MacThai"));
        }
        if ((offset = this.probe(1, 25)) != -1) {
            v.add(new NonUnicodeCmap(offset, "MacChineseSimplified"));
        }
        this.nonUnicodeSubtableIndices = v.toArray(new NonUnicodeCmap[0]);
    }

    private int computeSymbolPad(int stOffset) throws UnsupportedFontException, InvalidFontException {
        int[] possiblePadding = new int[]{61440, 61696, 61952, 0};
        for (int i = 0; i < possiblePadding.length; ++i) {
            int gid = this.getMapping(stOffset, 97 + possiblePadding[i]);
            if (gid == 0) continue;
            return possiblePadding[i];
        }
        int code = this.getLowestMappedCode(stOffset);
        if (code >= 61440 && code < 62208) {
            return code & 0xFF00;
        }
        return 0;
    }

    public int probe(int platformID, int encodingID) throws InvalidFontException, UnsupportedFontException {
        int numTables = this.data.getuint16(2);
        for (int i = 0; i < numTables; ++i) {
            int p = this.data.getuint16(4 + 8 * i + 0);
            int e = this.data.getuint16(4 + 8 * i + 2);
            if (p != platformID || e != encodingID) continue;
            return this.data.getuint32asint(4 + 8 * i + 4, "Offset to cmap subtable is big");
        }
        return -1;
    }

    public boolean isSymbolic() throws UnsupportedFontException, InvalidFontException {
        return this.symbolSubtableOffset != -1;
    }

    public void enumerateCmaps(CmapSelector selector) throws UnsupportedFontException, InvalidFontException {
        int numTables = this.data.getuint16(2);
        block14: for (int i = 0; i < numTables; ++i) {
            int p = this.data.getuint16(4 + 8 * i + 0);
            int e = this.data.getuint16(4 + 8 * i + 2);
            switch (p) {
                case 1: {
                    switch (e) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 21: 
                        case 25: {
                            selector.cmapFound(p, e, i);
                        }
                    }
                    continue block14;
                }
                case 3: {
                    switch (e) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 10: {
                            selector.cmapFound(p, e, i);
                        }
                    }
                    continue block14;
                }
                case 0: {
                    switch (e) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            selector.cmapFound(p, e, i);
                        }
                    }
                }
            }
        }
    }

    public int getCmapSubtableIndex(int platformId, int encodingId) throws InvalidFontException {
        int numTables = this.data.getuint16(2);
        for (int i = 0; i < numTables; ++i) {
            int p = this.data.getuint16(4 + 8 * i + 0);
            int e = this.data.getuint16(4 + 8 * i + 2);
            if (p != platformId || e != encodingId) continue;
            return i;
        }
        return -1;
    }

    int removeSymbolModifier(int usv) throws UnsupportedFontException, InvalidFontException {
        int topByte;
        if (this.symbolSubtableOffset != -1 && (topByte = usv & 0xFF00) == this.paddingByte) {
            return usv & 0xFF;
        }
        return usv;
    }

    public int unicodeChar2glyph(int usv) throws UnsupportedFontException, InvalidFontException {
        if (this.symbolSubtableOffset != -1) {
            int m = this.getMapping(this.symbolSubtableOffset, usv);
            if (m == 0 && 0 <= usv && usv <= 255) {
                m = this.getMapping(this.symbolSubtableOffset, this.paddingByte | usv);
            }
            return m;
        }
        if (this.unicodeSubtableOffset != -1) {
            if (usv == 65535) {
                return 0;
            }
            return this.getMapping(this.unicodeSubtableOffset, usv);
        }
        if (this.nonUnicodeSubtableIndices != null) {
            return this.getNonUnicodeMapping(usv);
        }
        return 0;
    }

    public int coolTypeUnicodeChar2glyph(int usv) throws UnsupportedFontException, InvalidFontException {
        if (this.unicodeSubtableOffset != -1) {
            return this.getMapping(this.unicodeSubtableOffset, usv);
        }
        if (this.oldUnicodeSubtableOffset != -1) {
            return this.getMapping(this.oldUnicodeSubtableOffset, usv);
        }
        if (this.symbolSubtableOffset != -1) {
            int m = this.getMapping(this.symbolSubtableOffset, usv);
            if (m == 0 && 0 <= usv && usv <= 255) {
                m = this.getMapping(this.symbolSubtableOffset, this.paddingByte | usv);
            }
            return m;
        }
        if (this.nonUnicodeSubtableIndices != null) {
            return this.getNonUnicodeMapping(usv);
        }
        return 0;
    }

    int getNonUnicodeMapping(int usv) throws UnsupportedFontException, InvalidFontException {
        char[] c = new char[2];
        UTF16.append(c, 0, usv);
        CharBuffer cb = CharBuffer.wrap(c, 0, c[1] == '\u0000' ? 1 : 2);
        ByteBuffer bb = ByteBuffer.allocate(10);
        for (NonUnicodeCmap cmap : this.nonUnicodeSubtableIndices) {
            try {
                CoderResult coderResult;
                CharsetEncoder encoder = cmap.getCharsetEncoder();
                if (encoder == null) {
                    int gid = this.getMapping(cmap.subtableOffset, usv);
                    if (gid == 0) continue;
                    return gid;
                }
                if (!encoder.canEncode((char)usv) || (coderResult = CharsetUtil.encodeLoopNoExceptions(cb, bb, encoder)).isError()) continue;
                if (bb.position() == 1) {
                    int cp = bb.get(0) & 0xFF;
                    return this.getMapping(cmap.subtableOffset, cp);
                }
                if (bb.position() != 2) continue;
                int cp = (bb.get(0) & 0xFF) << 8 | bb.get(1) & 0xFF;
                return this.getMapping(cmap.subtableOffset, cp);
            }
            catch (UnsupportedCharsetException e) {
            }
            catch (IllegalCharsetNameException e) {
                // empty catch block
            }
        }
        return 0;
    }

    public int char2glyph(int ch, int index) throws UnsupportedFontException, InvalidFontException {
        int o = this.data.getuint32asint(4 + 8 * index + 4, "Offset to cmap subtable is big");
        return this.getMapping(o, ch);
    }

    public int getLowestMappedCode(int stOffset) throws UnsupportedFontException, InvalidFontException {
        int format = this.data.getuint16(stOffset);
        switch (format) {
            case 0: {
                return this.getLowestMappedCodeFormat0(stOffset);
            }
            case 2: {
                return this.getLowestMappedCodeFormat2(stOffset);
            }
            case 4: {
                return this.getLowestMappedCodeFormat4(stOffset);
            }
            case 6: {
                return this.getLowestMappedCodeFormat6(stOffset);
            }
            case 8: {
                return this.getLowestMappedCodeFormat8(stOffset);
            }
            case 10: {
                return this.getLowestMappedCodeFormat10(stOffset);
            }
            case 12: {
                return this.getLowestMappedCodeFormat12(stOffset);
            }
        }
        throw new UnsupportedFontException("cmap subtable format " + format);
    }

    public int getHighestMappedCode(int stOffset, boolean max2bytes) throws UnsupportedFontException, InvalidFontException {
        int format = this.data.getuint16(stOffset);
        switch (format) {
            case 0: {
                return this.getHighestMappedCodeFormat0(stOffset);
            }
            case 2: {
                return this.getHighestMappedCodeFormat2(stOffset);
            }
            case 4: {
                return this.getHighestMappedCodeFormat4(stOffset);
            }
            case 6: {
                return this.getHighestMappedCodeFormat6(stOffset);
            }
            case 8: {
                return this.getHighestMappedCodeFormat8(stOffset, max2bytes);
            }
            case 10: {
                return this.getHighestMappedCodeFormat10(stOffset, max2bytes);
            }
            case 12: {
                return this.getHighestMappedCodeFormat12(stOffset, max2bytes);
            }
        }
        throw new UnsupportedFontException("cmap subtable format " + format);
    }

    public int getMapping(int stOffset, int charCode) throws UnsupportedFontException, InvalidFontException {
        int format = this.data.getuint16(stOffset);
        switch (format) {
            case 0: {
                return this.getMappingFormat0(stOffset, charCode);
            }
            case 2: {
                return this.getMappingFormat2(stOffset, charCode);
            }
            case 4: {
                return this.getMappingFormat4(stOffset, charCode);
            }
            case 6: {
                return this.getMappingFormat6(stOffset, charCode);
            }
            case 8: {
                return this.getMappingFormat8(stOffset, charCode);
            }
            case 10: {
                return this.getMappingFormat10(stOffset, charCode);
            }
            case 12: {
                return this.getMappingFormat12(stOffset, charCode);
            }
        }
        throw new UnsupportedFontException("cmap subtable format " + format);
    }

    public int getOffset(int subtableIndex) throws InvalidFontException, UnsupportedFontException {
        return this.data.getuint32asint(4 + subtableIndex * 8 + 4, "Offset to cmap subtable is big");
    }

    public int[] glyph2char(int numGlyphs, int index) throws UnsupportedFontException, InvalidFontException {
        int[] map = new int[numGlyphs];
        for (int i = 0; i < numGlyphs; ++i) {
            map[i] = -1;
        }
        int o = this.data.getuint32asint(4 + 8 * index + 4, "Offset to cmap subtable is big");
        int format = this.data.getuint16(o);
        switch (format) {
            case 0: {
                this.getInvertedMappingFormat0(map, o);
                break;
            }
            case 2: {
                this.getInvertedMappingFormat2(map, o);
                break;
            }
            case 4: {
                this.getInvertedMappingFormat4(map, o);
                break;
            }
            case 6: {
                this.getInvertedMappingFormat6(map, o);
                break;
            }
            case 8: {
                this.getInvertedMappingFormat8(map, o);
                break;
            }
            case 10: {
                this.getInvertedMappingFormat10(map, o);
                break;
            }
            case 12: {
                this.getInvertedMappingFormat12(map, o);
                break;
            }
            default: {
                throw new UnsupportedFontException("cmap subtable format " + format);
            }
        }
        return map;
    }

    protected int getLowestMappedCodeFormat0(int stOffset) throws InvalidFontException {
        int nbCodes = this.data.getuint16(stOffset + 2) - 6 - 1;
        for (int currentCode = 0; currentCode < nbCodes; ++currentCode) {
            int glyphid = this.data.getuint8(stOffset + 6 + currentCode);
            if (glyphid <= 0) continue;
            return currentCode;
        }
        return nbCodes;
    }

    protected int getHighestMappedCodeFormat0(int stOffset) throws InvalidFontException {
        for (int nbCodes = this.data.getuint16(stOffset + 2) - 6 - 1; nbCodes >= 0; --nbCodes) {
            int glyphid = this.data.getuint8(stOffset + 6 + nbCodes);
            if (glyphid <= 0) continue;
            return nbCodes;
        }
        return 0;
    }

    protected int getMappingFormat0(int stOffset, int charCode) throws InvalidFontException {
        int nbCodes = this.data.getuint16(stOffset + 2) - 6;
        if (0 <= charCode && charCode < nbCodes) {
            return this.data.getuint8(stOffset + 6 + charCode);
        }
        return 0;
    }

    protected void getInvertedMappingFormat0(int[] map, int stOffset) throws InvalidFontException {
        int nbCodes = this.data.getuint16(stOffset + 2) - 6;
        int charCode = 0;
        while (charCode < nbCodes) {
            int gid = this.data.getuint8(stOffset + 6 + charCode);
            map[gid] = charCode++;
        }
    }

    protected int getLowestMappedCodeFormat2(int stOffset) throws InvalidFontException {
        int subHeaderOffset;
        int subHeaderKey;
        int key;
        for (key = 0; key <= 255; ++key) {
            subHeaderKey = this.data.getuint16(stOffset + 6 + 2 * key) / 8;
            subHeaderOffset = stOffset + 518 + 8 * subHeaderKey;
            int firstCode = this.data.getuint16(subHeaderOffset);
            int lastCode = this.data.getuint16(subHeaderOffset + 2) + firstCode - 1;
            if (firstCode > key || key > lastCode) continue;
            int idDelta = this.data.getuint16(subHeaderOffset + 4);
            int idRange = this.data.getuint16(subHeaderOffset + 6);
            int glyphIndexOffset = subHeaderOffset + 6 + idRange;
            int g = this.data.getuint16(glyphIndexOffset + 2 * (key - firstCode));
            if (g == 0 || (g = (g + idDelta) % 65536) == 0) continue;
            return key;
        }
        for (key = 1; key <= 255; ++key) {
            int currentCode;
            subHeaderKey = this.data.getuint16(stOffset + 6 + 2 * key) / 8;
            subHeaderOffset = stOffset + 518 + 8 * subHeaderKey;
            int firstCode = currentCode = this.data.getuint16(subHeaderOffset);
            int lastCode = this.data.getuint16(subHeaderOffset + 2) + currentCode - 1;
            while (currentCode <= lastCode) {
                int idDelta = this.data.getuint16(subHeaderOffset + 4);
                int idRange = this.data.getuint16(subHeaderOffset + 6);
                int glyphIndexOffset = subHeaderOffset + 6 + idRange;
                int g = this.data.getuint16(glyphIndexOffset + 2 * (currentCode - firstCode));
                if (g != 0 && (g = (g + idDelta) % 65536) != 0) {
                    return key << 8 | currentCode;
                }
                ++currentCode;
            }
        }
        return 0;
    }

    protected int getHighestMappedCodeFormat2(int stOffset) throws InvalidFontException {
        int g;
        int glyphIndexOffset;
        int idRange;
        int idDelta;
        int firstCode;
        int subHeaderOffset;
        int subHeaderKey;
        int key;
        for (key = 255; key > 0; --key) {
            subHeaderKey = this.data.getuint16(stOffset + 6 + 2 * key) / 8;
            subHeaderOffset = stOffset + 518 + 8 * subHeaderKey;
            firstCode = this.data.getuint16(subHeaderOffset);
            for (int currentCode = this.data.getuint16(subHeaderOffset + 2) + firstCode - 1; firstCode <= currentCode; --currentCode) {
                idDelta = this.data.getuint16(subHeaderOffset + 4);
                idRange = this.data.getuint16(subHeaderOffset + 6);
                glyphIndexOffset = subHeaderOffset + 6 + idRange;
                g = this.data.getuint16(glyphIndexOffset + 2 * (currentCode - firstCode));
                if (g == 0 || (g = (g + idDelta) % 65536) == 0) continue;
                return key << 8 | currentCode;
            }
        }
        for (key = 255; key >= 0; --key) {
            subHeaderKey = this.data.getuint16(stOffset + 6 + 2 * key) / 8;
            subHeaderOffset = stOffset + 518 + 8 * subHeaderKey;
            firstCode = this.data.getuint16(subHeaderOffset);
            int lastCode = this.data.getuint16(subHeaderOffset + 2) + firstCode - 1;
            if (firstCode > key || key > lastCode) continue;
            idDelta = this.data.getuint16(subHeaderOffset + 4);
            idRange = this.data.getuint16(subHeaderOffset + 6);
            glyphIndexOffset = subHeaderOffset + 6 + idRange;
            g = this.data.getuint16(glyphIndexOffset + 2 * (key - firstCode));
            if (g == 0 || (g = (g + idDelta) % 65536) == 0) continue;
            return key;
        }
        return 0;
    }

    protected int getMappingFormat2(int stOffset, int charCode) throws InvalidFontException {
        int highByte = charCode >> 8 & 0xFF;
        int lowByte = charCode & 0xFF;
        int headerIndexByte = highByte == 0 && this.data.getuint16(stOffset + 6 + 2 * lowByte) == 0 ? lowByte : highByte;
        int glyphIndexArrayIndexByte = lowByte;
        int subHeaderKey = this.data.getuint16(stOffset + 6 + 2 * headerIndexByte) / 8;
        int subHeaderOffset = stOffset + 518 + 8 * subHeaderKey;
        int firstCode = this.data.getuint16(subHeaderOffset);
        int entryCount = this.data.getuint16(subHeaderOffset + 2);
        if (glyphIndexArrayIndexByte < firstCode || firstCode + entryCount <= glyphIndexArrayIndexByte) {
            return 0;
        }
        int idDelta = this.data.getuint16(subHeaderOffset + 4);
        int idRange = this.data.getuint16(subHeaderOffset + 6);
        int glyphIndexOffset = subHeaderOffset + 6 + idRange;
        int g = this.data.getuint16(glyphIndexOffset + 2 * (glyphIndexArrayIndexByte - firstCode));
        if (g == 0) {
            return 0;
        }
        return (g + idDelta) % 65536;
    }

    protected void getInvertedMappingFormat2(int[] map, int stOffset) throws InvalidFontException {
        for (int firstByte = 0; firstByte <= 255; ++firstByte) {
            int subHeaderIndex = this.data.getuint16(stOffset + 6 + 2 * firstByte) / 8;
            int subHeaderOffset = stOffset + 518 + subHeaderIndex * 8;
            int firstCode = this.data.getuint16(subHeaderOffset);
            int entryCount = this.data.getuint16(subHeaderOffset + 2);
            int idDelta = this.data.getuint16(subHeaderOffset + 4);
            int idRange = this.data.getuint16(subHeaderOffset + 6);
            int glyphIndexOffset = subHeaderOffset + 6 + idRange;
            if (subHeaderIndex == 0) {
                int g = this.data.getuint16(glyphIndexOffset + 2 * (firstByte - firstCode));
                if (g == 0) continue;
                map[(g + idDelta) % 65536] = firstByte;
                continue;
            }
            for (int secondByte = firstCode; secondByte < firstCode + entryCount; ++secondByte) {
                int g = this.data.getuint16(glyphIndexOffset + 2 * (secondByte - firstCode));
                if (g == 0) continue;
                map[(g + idDelta) % 65536] = (firstByte << 8) + secondByte;
            }
        }
    }

    protected int getLowestMappedCodeFormat4(int stOffset) throws InvalidFontException {
        int segCount = this.data.getuint16(stOffset + 6) / 2;
        int currentGroup = segCount - 1;
        for (currentGroup = 0; currentGroup <= segCount - 1; ++currentGroup) {
            try {
                int currentCode;
                int firstCode = currentCode = this.data.getuint16(stOffset + 16 + 2 * segCount + 2 * currentGroup);
                int lastCode = this.data.getuint16(stOffset + 14 + 2 * currentGroup);
                while (currentCode <= lastCode) {
                    try {
                        int gid;
                        int gid2;
                        int idRangeOffset = this.data.getuint16(stOffset + 16 + 6 * segCount + 2 * currentGroup);
                        int idDelta = this.data.getint16(stOffset + 16 + 4 * segCount + 2 * currentGroup);
                        if (idRangeOffset == 0 && (gid2 = currentCode + idDelta & 0xFFFF) != 0) {
                            return currentCode;
                        }
                        int offset = stOffset + 16 + 6 * segCount + 2 * currentGroup + idRangeOffset + 2 * (currentCode - firstCode);
                        int glyphIdArrayValue = this.data.getuint16(offset);
                        if (glyphIdArrayValue != 0 && (gid = glyphIdArrayValue + idDelta & 0xFFFF) != 0) {
                            return currentCode;
                        }
                    }
                    catch (InvalidFontException e) {
                        // empty catch block
                    }
                    ++currentCode;
                }
                continue;
            }
            catch (InvalidFontException e) {
                // empty catch block
            }
        }
        return 0;
    }

    protected int getHighestMappedCodeFormat4(int stOffset) throws InvalidFontException {
        int segCount = this.data.getuint16(stOffset + 6) / 2;
        for (int currentGroup = segCount - 1; 0 <= currentGroup; --currentGroup) {
            try {
                int startCode = this.data.getuint16(stOffset + 16 + 2 * segCount + 2 * currentGroup);
                for (int currentCode = this.data.getuint16(stOffset + 14 + 2 * currentGroup); currentCode >= startCode; --currentCode) {
                    try {
                        int gid;
                        int gid2;
                        int idRangeOffset = this.data.getuint16(stOffset + 16 + 6 * segCount + 2 * currentGroup);
                        int idDelta = this.data.getint16(stOffset + 16 + 4 * segCount + 2 * currentGroup);
                        if (idRangeOffset == 0 && (gid2 = currentCode + idDelta & 0xFFFF) != 0) {
                            return currentCode;
                        }
                        int offset = stOffset + 16 + 6 * segCount + 2 * currentGroup + idRangeOffset + 2 * (currentCode - startCode);
                        int glyphIdArrayValue = this.data.getuint16(offset);
                        if (glyphIdArrayValue == 0 || (gid = glyphIdArrayValue + idDelta & 0xFFFF) == 0) continue;
                        return currentCode;
                    }
                    catch (InvalidFontException e) {
                        // empty catch block
                    }
                }
                continue;
            }
            catch (InvalidFontException e) {
                // empty catch block
            }
        }
        return 0;
    }

    protected int getMappingFormat4(int stOffset, int charCode) {
        try {
            int segCount = this.data.getuint16(stOffset + 6) / 2;
            int min = 0;
            int max = segCount - 1;
            while (min <= max) {
                int s = (min + max) / 2;
                int startCount = this.data.getuint16(stOffset + 16 + 2 * segCount + 2 * s);
                int endCount = this.data.getuint16(stOffset + 14 + 2 * s);
                if (charCode < startCount) {
                    max = s - 1;
                    continue;
                }
                if (endCount < charCode) {
                    min = s + 1;
                    continue;
                }
                int idRangeOffset = this.data.getuint16(stOffset + 16 + 6 * segCount + 2 * s);
                int idDelta = this.data.getint16(stOffset + 16 + 4 * segCount + 2 * s);
                if (idRangeOffset == 0) {
                    return charCode + idDelta & 0xFFFF;
                }
                int offset = stOffset + 16 + 6 * segCount + 2 * s + idRangeOffset + 2 * (charCode - startCount);
                int glyphIdArrayValue = this.data.getuint16(offset);
                if (glyphIdArrayValue == 0) {
                    return 0;
                }
                return glyphIdArrayValue + idDelta & 0xFFFF;
            }
            return 0;
        }
        catch (InvalidFontException e) {
            return 0;
        }
    }

    protected void getInvertedMappingFormat4(int[] map, int stOffset) throws InvalidFontException {
        int segCount = this.data.getuint16(stOffset + 6) / 2;
        for (int s = 0; s < segCount; ++s) {
            int startCount = this.data.getuint16(stOffset + 16 + 2 * segCount + 2 * s);
            int endCount = this.data.getuint16(stOffset + 14 + 2 * s);
            int idRangeOffsetOffset = stOffset + 16 + 6 * segCount + 2 * s;
            int idRangeOffset = this.data.getuint16(idRangeOffsetOffset);
            int idDelta = this.data.getint16(stOffset + 16 + 4 * segCount + 2 * s);
            for (int c = startCount; c <= endCount; ++c) {
                int glyphID;
                if (idRangeOffset == 0) {
                    int glyphID2 = c + idDelta & 0xFFFF;
                    if (glyphID2 == 0 || glyphID2 >= map.length) continue;
                    map[glyphID2] = c;
                    continue;
                }
                int offset = stOffset + 16 + 6 * segCount + 2 * s + idRangeOffset + 2 * (c - startCount);
                int glyphIdArrayValue = this.data.getuint16(offset);
                if (glyphIdArrayValue == 0 || (glyphID = glyphIdArrayValue + idDelta & 0xFFFF) == 0 || glyphID >= map.length) continue;
                map[glyphID] = c;
            }
        }
    }

    protected int getLowestMappedCodeFormat6(int stOffset) throws InvalidFontException {
        int currentCode;
        int firstCode = currentCode = this.data.getuint16(stOffset + 6);
        int lastCode = this.data.getuint16(stOffset + 8) + currentCode - 1;
        while (currentCode <= lastCode) {
            int gid = this.data.getuint16(stOffset + 10 + (currentCode - firstCode) * 2);
            if (gid != 0) {
                return currentCode;
            }
            ++currentCode;
        }
        return 0;
    }

    protected int getHighestMappedCodeFormat6(int stOffset) throws InvalidFontException {
        int firstCode = this.data.getuint16(stOffset + 6);
        for (int currentCode = this.data.getuint16(stOffset + 8) + firstCode - 1; firstCode <= currentCode; --currentCode) {
            int gid = this.data.getuint16(stOffset + 10 + (currentCode - firstCode) * 2);
            if (gid == 0) continue;
            return currentCode;
        }
        return 0;
    }

    protected int getMappingFormat6(int stOffset, int charCode) throws InvalidFontException {
        int firstCode = this.data.getuint16(stOffset + 6);
        int entryCount = this.data.getuint16(stOffset + 8);
        if (firstCode <= charCode && charCode < firstCode + entryCount) {
            return this.data.getuint16(stOffset + 10 + (charCode - firstCode) * 2);
        }
        return 0;
    }

    protected void getInvertedMappingFormat6(int[] map, int stOffset) throws InvalidFontException {
        int firstCode = this.data.getuint16(stOffset + 6);
        int entryCount = this.data.getuint16(stOffset + 8);
        for (int i = 0; i < entryCount; ++i) {
            int code;
            map[this.data.getuint16((int)(stOffset + 10 + i * 2))] = code = firstCode + i;
        }
    }

    protected int getLowestMappedCodeFormat8(int stOffset) throws UnsupportedFontException, InvalidFontException {
        int nGroups = this.data.getuint32asint(stOffset + 8204, "cmap subtable, format 8, nGroups is big");
        int lastCode = 65535;
        for (int currentGroup = 0; currentGroup < nGroups; ++currentGroup) {
            int firstCode = this.data.getuint32asint(stOffset + 8208 + 12 * currentGroup, "cmap subtable, format 8, startCharCode is big");
            lastCode = this.data.getuint32asint(stOffset + 8208 + 12 * currentGroup + 4, "cmap subtable, format 8, endCharCode is big");
            for (int currentCode = firstCode; currentCode <= lastCode; ++currentCode) {
                int gid = this.data.getuint32asint(stOffset + 8208 + 12 * currentGroup + 8, "cmap subtable, format 8, startGlyphID is big") + currentCode - firstCode;
                if (gid == 0 || currentCode > 65535) continue;
                return currentCode;
            }
        }
        return lastCode;
    }

    protected int getHighestMappedCodeFormat8(int stOffset, boolean max2bytes) throws UnsupportedFontException, InvalidFontException {
        int nGroups = this.data.getuint32asint(stOffset + 8204, "cmap subtable, format 8, nGroups is big");
        for (int currentGroup = nGroups - 1; 0 <= currentGroup; --currentGroup) {
            int startCharCode = this.data.getuint32asint(stOffset + 8208 + 12 * currentGroup, "cmap subtable, format 8, startCharCode is big");
            for (int currentCharCode = this.data.getuint32asint(stOffset + 8208 + 12 * currentGroup + 4, "cmap subtable, format 8, endCharCode is big"); currentCharCode >= startCharCode; --currentCharCode) {
                int gid = this.data.getuint32asint(stOffset + 8208 + 12 * currentGroup + 8, "cmap subtable, format 8, startGlyphID is big") + currentCharCode - startCharCode;
                if (gid == 0 || max2bytes && currentCharCode > 65535) continue;
                return currentCharCode;
            }
        }
        return 0;
    }

    protected int getMappingFormat8(int stOffset, int charCode) throws UnsupportedFontException, InvalidFontException {
        int nGroups = this.data.getuint32asint(stOffset + 8204, "cmap subtable, format 8, nGroups is big");
        int min = 0;
        int max = nGroups - 1;
        while (min <= max) {
            int s = (min + max) / 2;
            int startCharCode = this.data.getuint32asint(stOffset + 8208 + 12 * s, "cmap subtable, format 8, startCharCode is big");
            int endCharCode = this.data.getuint32asint(stOffset + 8208 + 12 * s + 4, "cmap subtable, format 8, endCharCode is big");
            if (charCode < startCharCode) {
                max = s - 1;
                continue;
            }
            if (endCharCode < charCode) {
                min = s + 1;
                continue;
            }
            int startGlyphID = this.data.getuint32asint(stOffset + 8208 + 12 * s + 8, "cmap subtable, format 8, startGlyphID is big");
            return charCode - startCharCode + startGlyphID;
        }
        return 0;
    }

    protected void getInvertedMappingFormat8(int[] map, int stOffset) throws UnsupportedFontException, InvalidFontException {
        int nGroups = this.data.getuint32asint(stOffset + 8204, "cmap subtable, format 8, nGroups is big");
        for (int g = 0; g < nGroups; ++g) {
            int startCharCode = this.data.getuint32asint(stOffset + 8208 + 12 * g, "cmap subtable, format 8, startCharCode is big");
            int endCharCode = this.data.getuint32asint(stOffset + 8208 + 12 * g + 4, "cmap subtable, format 8, endCharCode is big");
            int startGlyphId = this.data.getuint32asint(stOffset + 8208 + 12 * g + 8, "cmap subtable, format 8, startGlyphID is big");
            for (int c = startCharCode; c <= endCharCode; ++c) {
                map[startGlyphId + c - startCharCode] = c;
            }
        }
    }

    protected int getLowestMappedCodeFormat10(int stOffset) throws InvalidFontException, UnsupportedFontException {
        int firstCode = this.data.getuint32asint(stOffset + 12, "cmap subtable, format 10, startCharCode is big");
        int lastCode = this.data.getuint32asint(stOffset + 16, "cmap subtable, format 10, numChars is big") + firstCode - 1;
        for (int currentCode = firstCode; currentCode <= lastCode; ++currentCode) {
            int glyphID = this.data.getuint16(stOffset + 20 + 2 * (currentCode - firstCode));
            if (glyphID <= 0) continue;
            return currentCode;
        }
        return lastCode;
    }

    protected int getHighestMappedCodeFormat10(int stOffset, boolean max2bytes) throws InvalidFontException, UnsupportedFontException {
        int startCharCode = this.data.getuint32asint(stOffset + 12, "cmap subtable, format 10, startCharCode is big");
        int numChars = this.data.getuint32asint(stOffset + 16, "cmap subtable, format 10, numChars is big");
        for (int charCode = startCharCode + numChars - 1; startCharCode <= charCode; --charCode) {
            int glyphID = this.data.getuint16(stOffset + 20 + 2 * (charCode - startCharCode));
            if (glyphID <= 0 || max2bytes && charCode > 65535) continue;
            return charCode;
        }
        return 0;
    }

    protected int getMappingFormat10(int stOffset, int charCode) throws UnsupportedFontException, InvalidFontException {
        int startCharCode = this.data.getuint32asint(stOffset + 12, "cmap subtable, format 10, startCharCode is big");
        int numChars = this.data.getuint32asint(stOffset + 16, "cmap subtable, format 10, numChars is big");
        if (startCharCode <= charCode && charCode < startCharCode + numChars) {
            return this.data.getuint16(stOffset + 20 + 2 * (charCode - startCharCode));
        }
        return 0;
    }

    protected void getInvertedMappingFormat10(int[] map, int stOffset) throws UnsupportedFontException, InvalidFontException {
        int startCharCode = this.data.getuint32asint(stOffset + 12, "cmap subtable, format 10, startCharCode is big");
        int numChars = this.data.getuint32asint(stOffset + 16, "cmap subtable, format 10, numChars is big");
        for (int c = startCharCode; c < startCharCode + numChars; ++c) {
            map[this.data.getuint16((int)(stOffset + 20 + 2 * (c - startCharCode)))] = c;
        }
    }

    protected int getLowestMappedCodeFormat12(int stOffset) throws InvalidFontException, UnsupportedFontException {
        int nGroups = (int)this.data.getuint32(stOffset + 12);
        int lastCode = 65535;
        for (int currentGroup = 0; currentGroup < nGroups; ++currentGroup) {
            int firstCode = (int)this.data.getuint32(stOffset + 16 + 12 * currentGroup);
            lastCode = (int)this.data.getuint32(stOffset + 16 + 12 * currentGroup + 4);
            for (int currentCode = firstCode; currentCode <= lastCode; ++currentCode) {
                int startGlyphID = (int)this.data.getuint32(stOffset + 16 + 12 * currentGroup + 8);
                if ((startGlyphID += currentCode - firstCode) <= 0) continue;
                return currentCode;
            }
        }
        return lastCode;
    }

    protected int getHighestMappedCodeFormat12(int stOffset, boolean max2bytes) throws InvalidFontException, UnsupportedFontException {
        int nGroups = (int)this.data.getuint32(stOffset + 12);
        for (int currentGroup = nGroups - 1; 0 <= currentGroup; --currentGroup) {
            int startCharCode = (int)this.data.getuint32(stOffset + 16 + 12 * currentGroup);
            for (int currentCharCode = (int)this.data.getuint32(stOffset + 16 + 12 * currentGroup + 4); currentCharCode >= startCharCode; --currentCharCode) {
                int startGlyphID = (int)this.data.getuint32(stOffset + 16 + 12 * currentGroup + 8);
                if ((startGlyphID += currentCharCode - startCharCode) <= 0 || max2bytes && currentCharCode > 65535) continue;
                return currentCharCode;
            }
        }
        return 0;
    }

    protected int getMappingFormat12(int stOffset, int charCode) throws InvalidFontException {
        int nGroups = (int)this.data.getuint32(stOffset + 12);
        int min = 0;
        int max = nGroups - 1;
        while (min <= max) {
            int s = (min + max) / 2;
            int startCharCode = (int)this.data.getuint32(stOffset + 16 + 12 * s);
            int endCharCode = (int)this.data.getuint32(stOffset + 16 + 12 * s + 4);
            if (charCode < startCharCode) {
                max = s - 1;
                continue;
            }
            if (endCharCode < charCode) {
                min = s + 1;
                continue;
            }
            int startGlyphID = (int)this.data.getuint32(stOffset + 16 + 12 * s + 8);
            return startGlyphID + (charCode - startCharCode);
        }
        return 0;
    }

    protected void getInvertedMappingFormat12(int[] map, int stOffset) throws InvalidFontException {
        int nGroups = (int)this.data.getuint32(stOffset + 12);
        for (int g = 0; g < nGroups; ++g) {
            int startCharCode = (int)this.data.getuint32(stOffset + 16 + 12 * g);
            int endCharCode = (int)this.data.getuint32(stOffset + 16 + 12 * g + 4);
            int startGlyphID = (int)this.data.getuint32(stOffset + 16 + 12 * g + 8);
            for (int c = startCharCode; c <= endCharCode; ++c) {
                map[startGlyphID + (c - startCharCode)] = c;
            }
        }
    }

    public void subsetAndStream(Subset subset, SubsetSimpleTrueType ttSubset, Map tables) throws UnsupportedFontException, InvalidFontException {
        int curEntry;
        int platSpecID;
        if (ttSubset == null) {
            return;
        }
        int platformID = ttSubset.getPlatformID();
        int offset = this.probe(platformID, platSpecID = ttSubset.getPlatformSpecificID());
        if (offset < 0) {
            throw new UnsupportedFontException("Unsupported cmap ID");
        }
        int format = this.data.getuint16(offset);
        if (format != 0 && format != 4 && format != 12) {
            throw new UnsupportedFontException("Unsupported cmap format");
        }
        if (format == 12) {
            format = 4;
        }
        ArrayList<MapElement> mapList = new ArrayList<MapElement>();
        int index = this.offsetToIndex(offset);
        int[] cps = ttSubset.getCodePoints();
        for (int i = 0; i < cps.length; ++i) {
            int cp = cps[i];
            int gid = this.char2glyph(cp, index);
            int subsetGid = subset.getExistingSubsetGid(gid);
            if (subsetGid <= 0) {
                throw new InvalidFontException("Subset does not contain required codepoint");
            }
            MapElement element = new MapElement(cp, subsetGid);
            mapList.add(element);
        }
        if (mapList.size() == 0) {
            return;
        }
        MapElement lastElem = (MapElement)mapList.get(0);
        if (lastElem.mCodePoint > 65535) {
            format = 12;
        }
        int i = 1;
        while (i < mapList.size()) {
            MapElement thisElem = (MapElement)mapList.get(i);
            if (thisElem.mCodePoint == lastElem.mCodePoint) {
                mapList.remove(i);
                continue;
            }
            if (thisElem.mCodePoint > 65535) {
                format = 12;
            }
            lastElem = thisElem;
            ++i;
        }
        OTByteArray.OTByteArrayBuilder cmapData = OTByteArray.getOTByteArrayBuilderInstance(Math.max(1024, mapList.size() * 32));
        cmapData.setuint16(0, 0);
        cmapData.setuint16(2, 1);
        int curOffset = 4;
        cmapData.setuint16(curOffset, platformID);
        cmapData.setuint16(curOffset + 2, platSpecID);
        cmapData.setuint32(curOffset + 4, curOffset + 8);
        int baseOffset = curOffset += 8;
        ArrayList<MapSegment> segList = new ArrayList<MapSegment>();
        int anchor = 0;
        lastElem = (MapElement)mapList.get(anchor);
        if (format == 0) {
            cmapData.setuint16(curOffset, 0);
            cmapData.setuint16(curOffset + 2, 262);
            cmapData.setuint16(curOffset + 4, 0);
            cmapData.setuint8((curOffset += 6) + 255, 0);
            for (int i2 = 0; i2 < mapList.size(); ++i2) {
                MapElement elem = (MapElement)mapList.get(i2);
                cmapData.setuint8(curOffset + elem.mCodePoint, elem.mGlyphID);
            }
        } else if (format == 4) {
            MapElement elem;
            MapSegment seg;
            int ordered = 0;
            if (((MapElement)mapList.get((int)(mapList.size() - 1))).mCodePoint != 65535) {
                mapList.add(new MapElement(65535, 0));
            }
            while (curEntry < mapList.size()) {
                MapElement curElem = (MapElement)mapList.get(curEntry);
                if (curElem.mCodePoint == lastElem.mCodePoint + 1) {
                    if (curElem.mGlyphID == lastElem.mGlyphID + 1) {
                        if (++ordered > 3 && ordered < curEntry - anchor) {
                            segList.add(new MapSegment(anchor, curEntry - ordered, false));
                            anchor = curEntry - ordered;
                        }
                    } else {
                        if (ordered > 3) {
                            segList.add(new MapSegment(anchor, curEntry, true));
                            anchor = curEntry;
                        }
                        ordered = 0;
                    }
                } else {
                    segList.add(new MapSegment(anchor, curEntry, curEntry - anchor == ordered + 1));
                    anchor = curEntry;
                    ordered = 0;
                }
                lastElem = curElem;
                ++curEntry;
            }
            segList.add(new MapSegment(anchor, curEntry, curEntry - anchor == ordered + 1));
            cmapData.setuint16(curOffset, 4);
            int nSegs = segList.size();
            cmapData.setuint16(curOffset + 4, 0);
            cmapData.setuint16(curOffset + 6, nSegs * 2);
            int nBits = 0;
            while (nSegs != 0) {
                nSegs >>= 1;
                ++nBits;
            }
            nSegs = segList.size();
            cmapData.setuint16(curOffset + 8, 1 << nBits);
            cmapData.setuint16(curOffset + 10, nBits - 1);
            cmapData.setuint16(curOffset + 12, nSegs * 2 - (1 << nBits));
            curOffset += 14;
            for (index = 0; index < nSegs; ++index) {
                seg = (MapSegment)segList.get(index);
                elem = (MapElement)mapList.get(seg.mEndIndex - 1);
                cmapData.setuint16(curOffset + index * 2, elem.mCodePoint);
            }
            cmapData.setuint16(curOffset += index * 2, 0);
            curOffset += 2;
            for (index = 0; index < nSegs; ++index) {
                seg = (MapSegment)segList.get(index);
                elem = (MapElement)mapList.get(seg.mFirstIndex);
                cmapData.setuint16(curOffset + index * 2, elem.mCodePoint);
            }
            curOffset += index * 2;
            for (index = 0; index < nSegs; ++index) {
                seg = (MapSegment)segList.get(index);
                offset = 0;
                if (seg.mOrdered) {
                    elem = (MapElement)mapList.get(seg.mFirstIndex);
                    offset = elem.mGlyphID - (short)elem.mCodePoint;
                }
                cmapData.setuint16(curOffset + index * 2, offset);
            }
            int gidArrayBase = (curOffset += index * 2) + index * 2;
            int gidArrayIndex = 0;
            for (index = 0; index < nSegs; ++index) {
                MapSegment seg2 = (MapSegment)segList.get(index);
                offset = 0;
                if (!seg2.mOrdered) {
                    offset = (nSegs - index + gidArrayIndex) * 2;
                    for (int i3 = seg2.mFirstIndex; i3 < seg2.mEndIndex; ++i3) {
                        MapElement elem2 = (MapElement)mapList.get(i3);
                        cmapData.setuint16(gidArrayBase + gidArrayIndex * 2, elem2.mGlyphID);
                        ++gidArrayIndex;
                    }
                }
                cmapData.setuint16(curOffset + index * 2, offset);
            }
            cmapData.setuint16(baseOffset + 2, gidArrayBase + gidArrayIndex * 2 - baseOffset);
        } else {
            for (curEntry = 1; curEntry < mapList.size(); ++curEntry) {
                MapElement curElem = (MapElement)mapList.get(curEntry);
                if (curElem.mCodePoint != lastElem.mCodePoint + 1 || curElem.mGlyphID != lastElem.mGlyphID + 1) {
                    segList.add(new MapSegment(anchor, curEntry, true));
                    anchor = curEntry;
                }
                lastElem = curElem;
            }
            segList.add(new MapSegment(anchor, curEntry, true));
            int nSegs = segList.size();
            cmapData.setuint16(curOffset, 12);
            cmapData.setuint16(curOffset + 2, 0);
            cmapData.setuint32(curOffset + 4, 16 + nSegs * 12);
            cmapData.setuint32(curOffset + 8, 0);
            cmapData.setuint32(curOffset + 12, nSegs);
            curOffset += 16;
            for (index = 0; index < nSegs; ++index) {
                MapSegment seg = (MapSegment)segList.get(index);
                MapElement firstElem = (MapElement)mapList.get(seg.mFirstIndex);
                MapElement endElem = (MapElement)mapList.get(seg.mEndIndex - 1);
                cmapData.setuint32(curOffset + index * 12, firstElem.mCodePoint);
                cmapData.setuint32(curOffset + index * 12 + 4, endElem.mCodePoint);
                cmapData.setuint32(curOffset + index * 12 + 8, firstElem.mGlyphID);
            }
        }
        tables.put(new Integer(1668112752), cmapData);
    }

    public void subsetAndStreamForSWF(TreeSet codePoints, Subset subset, Map tables, boolean includeVariationCmap) throws UnsupportedFontException, InvalidFontException {
        Iterator iter = codePoints.iterator();
        boolean bmpOnly = true;
        int numberOfSubtables = 1;
        OTByteArray.OTByteArrayBuilder builder = OTByteArray.getOTByteArrayBuilderInstance();
        int firstSubtableSize = 0;
        if (includeVariationCmap) {
            numberOfSubtables = 2;
        }
        while (iter.hasNext()) {
            if ((Integer)iter.next() <= 65535) continue;
            bmpOnly = false;
            break;
        }
        builder.ensureCapacity(4 + 8 * numberOfSubtables);
        builder.setuint16(0, 0);
        builder.setuint16(2, numberOfSubtables);
        int offsetToFirst = 4 + 8 * numberOfSubtables;
        if (bmpOnly) {
            builder.setuint16(4, 3);
            builder.setuint16(6, this.symbolSubtableOffset != -1 ? 0 : 1);
            builder.setuint32(8, offsetToFirst);
            firstSubtableSize = this.writeFormat4Subtable(builder, offsetToFirst, codePoints, subset, this.paddingByte);
        } else {
            builder.setuint16(4, 3);
            builder.setuint16(6, 10);
            builder.setuint32(8, offsetToFirst);
            firstSubtableSize = this.writeFormat12Subtable(builder, offsetToFirst, codePoints, subset);
        }
        if (includeVariationCmap) {
            builder.setuint16(12, 0);
            builder.setuint16(14, 5);
            builder.setuint32(16, offsetToFirst + firstSubtableSize);
            firstSubtableSize = this.writeFormat14Subtable(builder, offsetToFirst + firstSubtableSize, codePoints, subset, this.probe(0, 5));
        }
        tables.put(new Integer(1668112752), builder);
    }

    private int computeCodePointToEmit(int cp, int symbolPad) {
        if (symbolPad == 0) {
            return cp;
        }
        return symbolPad | cp & 0xFF;
    }

    private int writeFormat4Subtable(OTByteArray.OTByteArrayBuilder builder, int offset, TreeSet codepoints, Subset subset, int symbolPad) throws UnsupportedFontException, InvalidFontException {
        Iterator iter = codepoints.iterator();
        int lastCP = 0;
        ArrayList<SegmentInfo> segmentList = new ArrayList<SegmentInfo>();
        SegmentInfo currentSegment = null;
        boolean addTerminalSegment = true;
        if (iter.hasNext()) {
            lastCP = (Integer)iter.next();
            currentSegment = new SegmentInfo();
            currentSegment.startCode = lastCP;
            int thisGid = subset.getExistingSubsetGid(this.unicodeChar2glyph(lastCP));
            currentSegment.idDelta = thisGid - this.computeCodePointToEmit(lastCP, symbolPad);
            segmentList.add(currentSegment);
            if (lastCP == 65535) {
                addTerminalSegment = false;
            }
        }
        while (iter.hasNext()) {
            int thisGid;
            int cp = (Integer)iter.next();
            if (cp == 65535) {
                addTerminalSegment = false;
            }
            if (cp != lastCP + 1) {
                currentSegment.endCode = lastCP;
                currentSegment = new SegmentInfo();
                currentSegment.startCode = cp;
                thisGid = subset.getExistingSubsetGid(this.unicodeChar2glyph(cp));
                currentSegment.idDelta = thisGid - this.computeCodePointToEmit(cp, symbolPad);
                segmentList.add(currentSegment);
            } else if (currentSegment.canUseIDDelta && (thisGid = subset.getExistingSubsetGid(this.unicodeChar2glyph(cp))) - this.computeCodePointToEmit(cp, symbolPad) != currentSegment.idDelta) {
                currentSegment.canUseIDDelta = false;
            }
            lastCP = cp;
        }
        if (currentSegment != null) {
            currentSegment.endCode = lastCP;
        }
        int segmentCount = segmentList.size();
        if (addTerminalSegment) {
            ++segmentCount;
        }
        int subtableSize = 16 + 8 * segmentCount;
        builder.ensureCapacity(offset + subtableSize);
        builder.setuint16(offset, 4);
        builder.setuint16(offset + 4, 0);
        builder.setuint16(offset + 6, segmentCount * 2);
        int entrySelector = (int)Math.floor(Cmap.log2(segmentCount));
        int searchRange = 2 * (int)Math.pow(2.0, entrySelector);
        builder.setuint16(offset + 8, searchRange);
        builder.setuint16(offset + 10, entrySelector);
        builder.setuint16(offset + 12, 2 * segmentCount - searchRange);
        builder.setuint16(offset + 14 + segmentCount * 2, 0);
        int currGlyphOffset = 0;
        for (int i = 0; i < segmentList.size(); ++i) {
            currentSegment = (SegmentInfo)segmentList.get(i);
            builder.setuint16(offset + 14 + 2 * i, this.computeCodePointToEmit(currentSegment.endCode, symbolPad));
            builder.setuint16(offset + 16 + 2 * segmentCount + 2 * i, this.computeCodePointToEmit(currentSegment.startCode, symbolPad));
            builder.setint16(offset + 16 + 4 * segmentCount + 2 * i, currentSegment.canUseIDDelta ? currentSegment.idDelta : 0);
            builder.setuint16(offset + 16 + 6 * segmentCount + 2 * i, currentSegment.canUseIDDelta ? 0 : (currGlyphOffset + segmentCount - i) * 2);
            if (currentSegment.canUseIDDelta) continue;
            builder.ensureCapacity(offset + 16 + 8 * segmentCount + 2 * (currGlyphOffset + currentSegment.endCode - currentSegment.startCode + 1));
            int j = currentSegment.startCode;
            while (j <= currentSegment.endCode) {
                int thisGid = subset.getExistingSubsetGid(this.unicodeChar2glyph(j));
                builder.setuint16(offset + 16 + 8 * segmentCount + 2 * currGlyphOffset, thisGid);
                ++j;
                ++currGlyphOffset;
            }
        }
        if (addTerminalSegment) {
            builder.setuint16(offset + 14 + 2 * segmentList.size(), 65535);
            builder.setuint16(offset + 16 + 4 * segmentCount - 2, 65535);
            builder.setuint16(offset + 16 + 6 * segmentCount - 2, 1);
            builder.setuint16(offset + 16 + 8 * segmentCount - 2, 0);
        }
        builder.setuint16(offset + 2, subtableSize += 2 * currGlyphOffset);
        if (subtableSize >= 65536) {
            throw new UnsupportedFontException("Format 4 cmap subtable is too big for format");
        }
        return subtableSize;
    }

    private static double log2(double d) {
        return Math.log(d) / Math.log(2.0);
    }

    private int writeFormat12Subtable(OTByteArray.OTByteArrayBuilder builder, int offset, TreeSet codepoints, Subset subset) throws UnsupportedFontException, InvalidFontException {
        Iterator iter = codepoints.iterator();
        int lastCP = 0;
        int lastGID = 0;
        int numGroups = 0;
        int tableSize = 16;
        builder.ensureCapacity(offset + tableSize);
        if (iter.hasNext()) {
            lastCP = (Integer)iter.next();
            lastGID = subset.getExistingSubsetGid(this.unicodeChar2glyph(lastCP));
            builder.ensureCapacity(offset + (tableSize += 12));
            builder.setuint32(offset + 16 + 12 * numGroups, lastCP);
            builder.setuint32(offset + 16 + 12 * numGroups + 8, lastGID);
            ++numGroups;
        }
        while (iter.hasNext()) {
            int cp = (Integer)iter.next();
            int gid = subset.getExistingSubsetGid(this.unicodeChar2glyph(cp));
            if (cp != lastCP + 1 || gid != lastGID + 1) {
                builder.setuint32(offset + 16 + 12 * (numGroups - 1) + 4, lastCP);
                builder.ensureCapacity(offset + (tableSize += 12));
                builder.setuint32(offset + 16 + 12 * numGroups, cp);
                builder.setuint32(offset + 16 + 12 * numGroups + 8, gid);
                ++numGroups;
            }
            lastCP = cp;
            lastGID = gid;
        }
        if (numGroups > 0) {
            builder.setuint32(offset + 16 + 12 * (numGroups - 1) + 4, lastCP);
        }
        builder.setuint16(offset, 12);
        builder.setuint16(offset + 2, 0);
        builder.setuint32(offset + 4, tableSize);
        builder.setuint32(offset + 8, 0);
        builder.setuint32(offset + 12, numGroups);
        return tableSize;
    }

    void iterateFormat14(int stOffset, Format14Consumer consumer) throws UnsupportedFontException, InvalidFontException {
        int numVarSelectorRecords = this.data.getuint32asint(stOffset + 6, "Only 2^31 selectors supported");
        for (int i = 0; i < numVarSelectorRecords; ++i) {
            int gid;
            int uv;
            int j;
            int numUVRanges;
            boolean stopThisIteration = false;
            int variationSelector = this.data.getuint24(stOffset + 10 + 11 * i);
            int uvsOffset = this.data.getuint32asint(stOffset + 10 + 11 * i + 3, "Only 2^31 offsets supported");
            if (uvsOffset != 0) {
                numUVRanges = this.data.getuint32asint(uvsOffset += stOffset, "Only 2^31 UV ranges supported");
                for (j = 0; j < numUVRanges; ++j) {
                    int startUV = this.data.getuint24(uvsOffset + 4 + 4 * j);
                    int addlCount = this.data.getuint8(uvsOffset + 4 + 4 * j + 3);
                    for (int k = 0; k <= addlCount; ++k) {
                        if (consumer.defaultUV(variationSelector, startUV + k)) continue;
                        stopThisIteration = true;
                        break;
                    }
                    if (stopThisIteration) break;
                }
            }
            if ((uvsOffset = this.data.getuint32asint(stOffset + 10 + 11 * i + 7, "Only 2^31 offsets supported")) == 0) continue;
            numUVRanges = this.data.getuint32asint(uvsOffset += stOffset, "Only 2^31 UV ranges supported");
            for (j = 0; j < numUVRanges && consumer.nonDefaultUV(variationSelector, uv = this.data.getuint24(uvsOffset + 4 + 5 * j), gid = this.data.getuint16(uvsOffset + 4 + 5 * j + 3)); ++j) {
            }
        }
    }

    private int writeFormat14Subtable(OTByteArray.OTByteArrayBuilder builder, int offset, TreeSet codepoints, Subset subset, int originalOffset) throws UnsupportedFontException, InvalidFontException {
        Format14Writer writer = new Format14Writer(subset, codepoints, builder, offset);
        this.iterateFormat14(originalOffset, writer);
        writer.writeSubtable();
        return writer.stSize;
    }

    boolean gatherPossibleMappings(Iterator inputCPs, Set harvestedCPs, Subset harvestedGids) throws UnsupportedFontException, InvalidFontException {
        while (inputCPs.hasNext()) {
            Integer cp = (Integer)inputCPs.next();
            int gid = this.unicodeChar2glyph(cp);
            if (gid == 0) continue;
            harvestedCPs.add(cp);
            harvestedGids.getSubsetGid(gid);
        }
        int variationSubtableOffset = this.probe(0, 5);
        if (variationSubtableOffset != -1) {
            Format14Harvester harvester = new Format14Harvester(harvestedCPs, harvestedGids);
            this.iterateFormat14(variationSubtableOffset, harvester);
            for (Integer cp : harvester.variationUVs) {
                int gid = this.unicodeChar2glyph(cp);
                if (gid == 0) continue;
                harvestedCPs.add(cp);
                harvestedGids.getSubsetGid(gid);
            }
            return harvester.variationSequencesFound;
        }
        return false;
    }

    public void stream(Map tables) {
        OTByteArray.OTByteArrayBuilder newData = this.getDataAsByteArray();
        tables.put(new Integer(1668112752), newData);
    }

    private int generateRequiredCmap(OTByteArray.OTByteArrayBuilder builder, int stOffset, int numGlyphs) throws UnsupportedFontException, InvalidFontException {
        if (this.nonUnicodeSubtableIndices.length == 0) {
            throw new UnsupportedFontException("Could not generate required cmap subtables");
        }
        TreeSet<Integer> newCmap = new TreeSet<Integer>();
        for (int j = 0; j < this.nonUnicodeSubtableIndices.length; ++j) {
            if (this.nonUnicodeSubtableIndices[j].charsetName.equals("MacSymbol")) {
                if (this.nonUnicodeSubtableIndices.length != 1) continue;
                throw new UnsupportedFontException("Cannot generate a required cmap");
            }
            Charset cs = null;
            try {
                cs = CharsetUtil.forNameICU(this.nonUnicodeSubtableIndices[j].charsetName);
            }
            catch (UnsupportedCharsetException e) {
                throw new UnsupportedFontException("Could not generate required cmap subtables", e);
            }
            catch (IllegalCharsetNameException e) {
                throw new UnsupportedFontException("Could not generate required cmap subtables", e);
            }
            CharsetDecoder decoder = cs.newDecoder();
            int maxChar = this.getHighestMappedCode(this.nonUnicodeSubtableIndices[j].subtableOffset, false);
            int minChar = this.getLowestMappedCode(this.nonUnicodeSubtableIndices[j].subtableOffset);
            int index = this.offsetToIndex(this.nonUnicodeSubtableIndices[j].subtableOffset);
            CharBuffer targetChars = CharBuffer.allocate(1);
            ByteBuffer bb = ByteBuffer.allocate(2);
            boolean warnOnFailedConversion = false;
            for (int i = minChar; i <= maxChar; ++i) {
                bb.rewind();
                targetChars.rewind();
                int glyphId = this.char2glyph(i, index);
                if (glyphId == 0) continue;
                if (i < 256) {
                    bb.put((byte)(i & 0xFF));
                } else if (i < 65536) {
                    bb.put((byte)(i >> 8));
                    bb.put((byte)(i & 0xFF));
                } else {
                    throw new UnsupportedFontException("Only 2-byte encodings supported");
                }
                bb.rewind();
                CoderResult coderResult = null;
                try {
                    coderResult = CharsetUtil.decodeLoopNoExceptions(bb, targetChars, decoder);
                }
                catch (IllegalStateException e) {
                }
                catch (CoderMalfunctionError e) {
                    // empty catch block
                }
                if (coderResult.isError()) continue;
                targetChars.rewind();
                newCmap.add(new Integer(targetChars.get()));
            }
        }
        return this.writeFormat4Subtable(builder, stOffset, newCmap, new SubsetDefaultImpl(numGlyphs, false), 0);
    }

    private int copySubtable(OTByteArray.OTByteArrayBuilder builder, int stOffset, int originalSTOffset) throws InvalidFontException, UnsupportedFontException {
        int length;
        int origFormat = this.data.getuint16(originalSTOffset);
        switch (origFormat) {
            case 0: 
            case 2: 
            case 4: 
            case 6: {
                length = this.data.getuint16(originalSTOffset + 2);
                break;
            }
            case 8: 
            case 10: {
                length = this.data.getuint32asint(originalSTOffset + 4, "Only signed int length cmap subtables supported");
                break;
            }
            case 12: {
                length = 16 + 12 * this.data.getuint32asint(originalSTOffset + 12, "Only signed int length cmap subtables supported");
                break;
            }
            case 14: {
                length = this.data.getuint32asint(originalSTOffset + 2, "Only signed int length cmap subtables supported");
                break;
            }
            default: {
                throw new UnsupportedFontException("Unsupported cmap format: " + origFormat);
            }
        }
        try {
            builder.replace(stOffset, this.data, originalSTOffset, length);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            builder.replace(stOffset, this.data, originalSTOffset, this.data.getSize() - originalSTOffset);
        }
        return length;
    }

    public void streamForSWF(Map tables, int numGlyphs) throws UnsupportedFontException, InvalidFontException {
        SWFCmapSelector selector = new SWFCmapSelector();
        this.enumerateCmaps(selector);
        int encodingRecordOffset = 4;
        int numTables = selector.cmapsToKeep.size() + (selector.foundRequiredCmap ? 0 : 1);
        int stOffset = encodingRecordOffset + 8 * numTables;
        OTByteArray.OTByteArrayBuilder builder = OTByteArray.getOTByteArrayBuilderInstance(stOffset);
        builder.setuint16(0, 0);
        if (!selector.foundRequiredCmap) {
            builder.setuint16(encodingRecordOffset, 3);
            builder.setuint16(encodingRecordOffset + 2, 1);
            builder.setuint32(encodingRecordOffset + 4, stOffset);
            encodingRecordOffset += 8;
            stOffset += this.generateRequiredCmap(builder, stOffset, numGlyphs);
        }
        for (SWFCmapSelector.CmapInfo cmapInfo : selector.cmapsToKeep) {
            int length = this.copySubtable(builder, stOffset, cmapInfo.offset);
            if (length > 0) {
                builder.setuint16(encodingRecordOffset, cmapInfo.platformId);
                builder.setuint16(encodingRecordOffset + 2, cmapInfo.platformEncoding);
                builder.setuint32(encodingRecordOffset + 4, stOffset);
                stOffset += length;
                encodingRecordOffset += 8;
                continue;
            }
            --numTables;
        }
        builder.setuint16(2, numTables);
        tables.put(new Integer(1668112752), builder);
    }

    int offsetToIndex(int offset) throws InvalidFontException {
        int nTables = this.data.getuint16(2);
        for (int i = 0; i < nTables; ++i) {
            if ((long)offset != this.data.getuint32(4 + i * 8 + 4)) continue;
            return i;
        }
        return -1;
    }

    private final class MapSegment {
        int mFirstIndex;
        int mEndIndex;
        boolean mOrdered;

        MapSegment(int firstIndex, int endIndex, boolean ordered) {
            this.mFirstIndex = firstIndex;
            this.mEndIndex = endIndex;
            this.mOrdered = ordered;
        }
    }

    private final class MapElement
    implements Comparable {
        int mCodePoint;
        int mGlyphID;

        MapElement(int cp, int gid) {
            this.mCodePoint = cp;
            this.mGlyphID = gid;
        }

        public int compareTo(Object obj) {
            return this.mCodePoint - ((MapElement)obj).mCodePoint;
        }
    }

    private class SWFCmapSelector
    implements CmapSelector {
        boolean foundRequiredCmap = false;
        List cmapsToKeep = new ArrayList();

        private SWFCmapSelector() {
        }

        private boolean alreadyOneWithThisOffset(int offset) {
            for (CmapInfo info : this.cmapsToKeep) {
                if (info.offset != offset) continue;
                return true;
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void cmapFound(int platformID, int platformEncoding, int index) throws InvalidFontException, UnsupportedFontException {
            block15: {
                int offset = Cmap.this.getOffset(index);
                switch (platformID) {
                    case 0: {
                        switch (platformEncoding) {
                            case 3: {
                                if (this.alreadyOneWithThisOffset(offset)) break;
                                this.foundRequiredCmap = true;
                                this.cmapsToKeep.add(new CmapInfo(platformID, platformEncoding, offset));
                                return;
                            }
                            case 4: {
                                if (this.alreadyOneWithThisOffset(offset)) break;
                                this.foundRequiredCmap = true;
                                this.cmapsToKeep.add(new CmapInfo(platformID, platformEncoding, offset));
                                return;
                            }
                            case 5: {
                                this.cmapsToKeep.add(new CmapInfo(platformID, platformEncoding, offset));
                            }
                        }
                        return;
                    }
                    case 3: {
                        switch (platformEncoding) {
                            case 0: 
                            case 1: {
                                if (this.alreadyOneWithThisOffset(offset)) return;
                                this.foundRequiredCmap = true;
                                this.cmapsToKeep.add(new CmapInfo(platformID, platformEncoding, offset));
                                break block15;
                            }
                            case 10: {
                                if (this.alreadyOneWithThisOffset(offset)) return;
                                this.foundRequiredCmap = true;
                                this.cmapsToKeep.add(new CmapInfo(platformID, platformEncoding, offset));
                            }
                        }
                    }
                }
            }
        }

        class CmapInfo {
            final int platformId;
            final int platformEncoding;
            final int offset;

            CmapInfo(int platformId, int platformEncoding, int offset) {
                this.platformId = platformId;
                this.platformEncoding = platformEncoding;
                this.offset = offset;
            }
        }
    }

    private static class Format14Harvester
    implements Format14Consumer {
        private final Set harvestedCPs;
        private final Subset harvestedGids;
        final Set variationUVs;
        boolean variationSequencesFound = false;

        public Format14Harvester(Set harvestedCPs, Subset harvestedGids) {
            this.harvestedCPs = harvestedCPs;
            this.harvestedGids = harvestedGids;
            this.variationUVs = new HashSet();
        }

        public boolean defaultUV(int variationSelector, int uv) {
            if (this.harvestedCPs.contains(new Integer(uv))) {
                this.variationUVs.add(new Integer(variationSelector));
                this.variationSequencesFound = true;
                return false;
            }
            return true;
        }

        public boolean nonDefaultUV(int variationSelector, int uv, int gid) throws UnsupportedFontException, InvalidFontException {
            if (this.harvestedCPs.contains(new Integer(uv))) {
                Integer vs = new Integer(variationSelector);
                if (!this.variationUVs.contains(vs)) {
                    this.variationUVs.add(vs);
                    this.variationSequencesFound = true;
                }
                this.harvestedGids.getSubsetGid(gid);
            }
            return true;
        }
    }

    private static class Format14Writer
    implements Format14Consumer {
        private final Subset subset;
        private final Set codepoints;
        private final OTByteArray.OTByteArrayBuilder builder;
        private final int newSTOffset;
        private Integer lastVS = new Integer(-1);
        private Map vsToUnicode = new LinkedHashMap();
        int stSize = 0;

        Format14Writer(Subset subset, Set codepoints, OTByteArray.OTByteArrayBuilder builder, int newSTOffset) {
            this.subset = subset;
            this.codepoints = codepoints;
            this.builder = builder;
            this.newSTOffset = newSTOffset;
        }

        public boolean defaultUV(int variationSelector, int uv) {
            if (this.codepoints.contains(new Integer(uv))) {
                ArrayList<UVAndGid> uvList;
                if (this.lastVS != variationSelector) {
                    this.lastVS = new Integer(variationSelector);
                }
                if ((uvList = (ArrayList<UVAndGid>)this.vsToUnicode.get(this.lastVS)) == null) {
                    uvList = new ArrayList<UVAndGid>();
                }
                UVAndGid uvAndGid = new UVAndGid(uv, -1);
                uvList.add(uvAndGid);
                this.vsToUnicode.put(this.lastVS, uvList);
            }
            return true;
        }

        public boolean nonDefaultUV(int variationSelector, int uv, int gid) {
            if (this.codepoints.contains(new Integer(uv))) {
                ArrayList<UVAndGid> uvList;
                if (this.lastVS != variationSelector) {
                    this.lastVS = new Integer(variationSelector);
                }
                if ((uvList = (ArrayList<UVAndGid>)this.vsToUnicode.get(this.lastVS)) == null) {
                    uvList = new ArrayList<UVAndGid>();
                }
                UVAndGid uvAndGid = new UVAndGid(uv, gid);
                uvList.add(uvAndGid);
                this.vsToUnicode.put(this.lastVS, uvList);
            }
            return true;
        }

        void writeSubtable() throws UnsupportedFontException, InvalidFontException {
            this.stSize = 10 + 11 * this.vsToUnicode.size();
            this.builder.ensureCapacity(this.newSTOffset + this.stSize);
            this.builder.setuint16(this.newSTOffset, 14);
            this.builder.setuint32(this.newSTOffset + 6, this.vsToUnicode.size());
            int i = 0;
            for (Integer vs : this.vsToUnicode.keySet()) {
                int thisSize = 0;
                List uvAndGidList = (List)this.vsToUnicode.get(vs);
                thisSize = this.writeDefaultUVSTable(this.newSTOffset + this.stSize, uvAndGidList);
                this.builder.setuint24(this.newSTOffset + 10 + 11 * i, vs);
                this.builder.setuint32(this.newSTOffset + 10 + 11 * i + 3, thisSize == 0 ? 0 : this.stSize);
                this.stSize += thisSize;
                thisSize = this.writeNonDefaultUVSTable(this.newSTOffset + this.stSize, uvAndGidList);
                this.builder.setuint32(this.newSTOffset + 10 + 11 * i + 7, thisSize == 0 ? 0 : this.stSize);
                this.stSize += thisSize;
                ++i;
            }
            this.builder.setuint32(this.newSTOffset + 2, this.stSize);
        }

        private int writeDefaultUVSTable(int newOffset, List uvAndGidList) {
            int lastUV = -1;
            int numUVRanges = 0;
            Iterator iter = uvAndGidList.iterator();
            int thisRangeCount = 0;
            while (iter.hasNext()) {
                UVAndGid uvAndGid = (UVAndGid)iter.next();
                if (uvAndGid.gid != -1) break;
                if (lastUV + 1 != uvAndGid.uv) {
                    this.builder.ensureCapacity(newOffset + 4 + 4 * (numUVRanges + 1));
                    if (numUVRanges > 0) {
                        this.builder.setuint8(newOffset + 4 + 4 * (numUVRanges - 1) + 3, thisRangeCount);
                    }
                    this.builder.setuint24(newOffset + 4 + 4 * numUVRanges, uvAndGid.uv);
                    thisRangeCount = 0;
                    ++numUVRanges;
                    continue;
                }
                ++thisRangeCount;
            }
            if (numUVRanges > 0) {
                this.builder.setuint8(newOffset + 4 + 4 * (numUVRanges - 1) + 3, thisRangeCount);
                this.builder.setuint32(newOffset, numUVRanges);
                return 4 + 4 * numUVRanges;
            }
            return 0;
        }

        private int writeNonDefaultUVSTable(int newOffset, List uvAndGidList) throws UnsupportedFontException, InvalidFontException {
            int numUVRanges = 0;
            for (UVAndGid uvAndGid : uvAndGidList) {
                if (uvAndGid.gid == -1) continue;
                this.builder.ensureCapacity(newOffset + 4 + 5 * (numUVRanges + 1));
                this.builder.setuint24(newOffset + 4 + 5 * numUVRanges, uvAndGid.uv);
                this.builder.setuint16(newOffset + 4 + 5 * numUVRanges + 3, this.subset.getExistingSubsetGid(uvAndGid.gid));
                ++numUVRanges;
            }
            if (numUVRanges > 0) {
                this.builder.setuint32(newOffset, numUVRanges);
                return 4 + 5 * numUVRanges;
            }
            return 0;
        }

        static class UVAndGid {
            int uv;
            int gid;

            UVAndGid(int uv, int gid) {
                this.uv = uv;
                this.gid = gid;
            }
        }
    }

    static interface Format14Consumer {
        public boolean defaultUV(int var1, int var2);

        public boolean nonDefaultUV(int var1, int var2, int var3) throws UnsupportedFontException, InvalidFontException;
    }

    private class SegmentInfo {
        boolean canUseIDDelta = true;
        int idDelta;
        int startCode;
        int endCode;

        private SegmentInfo() {
        }
    }

    static class NonUnicodeCmap {
        final int subtableOffset;
        final String charsetName;
        Charset charset = null;

        public NonUnicodeCmap(int subtableOffset, String charsetName) {
            this.subtableOffset = subtableOffset;
            this.charsetName = charsetName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CharsetEncoder getCharsetEncoder() throws UnsupportedCharsetException, IllegalCharsetNameException {
            if (this.charset == null && this.charsetName != null) {
                NonUnicodeCmap nonUnicodeCmap = this;
                synchronized (nonUnicodeCmap) {
                    if (this.charset == null && this.charsetName != null) {
                        this.charset = CharsetUtil.forNameICU(this.charsetName);
                    }
                }
            }
            CharsetEncoder encoder = null;
            if (this.charset != null && (encoder = this.charset.newEncoder()) instanceof CharsetEncoderICU) {
                ((CharsetEncoderICU)encoder).setFallbackUsed(true);
            }
            return encoder;
        }
    }

    public static interface CmapSelector {
        public void cmapFound(int var1, int var2, int var3) throws InvalidFontException, UnsupportedFontException;
    }

    public static final class MacEncodingID {
        public static final int ROMAN = 0;
        public static final int JAPANESE = 1;
        public static final int CHINESE_TRADITIONAL = 2;
        public static final int KOREAN = 3;
        public static final int ARABIC = 4;
        public static final int HEBREW = 5;
        public static final int GREEK = 6;
        public static final int RUSSIAN = 7;
        public static final int RSYMBOL = 8;
        public static final int DEVANAGARI = 9;
        public static final int GURMUKHI = 10;
        public static final int GUJARATI = 11;
        public static final int ORIYA = 12;
        public static final int BENGALI = 13;
        public static final int TAMIL = 14;
        public static final int TELUGU = 15;
        public static final int KANNADA = 16;
        public static final int MALAYALAM = 17;
        public static final int SINHALESE = 18;
        public static final int BURMESE = 19;
        public static final int KHMER = 20;
        public static final int THAI = 21;
        public static final int LAOTIAN = 22;
        public static final int GEORGIAN = 23;
        public static final int ARMENIAN = 24;
        public static final int CHINESE_SIMPLIFIED = 25;
        public static final int TIBETAN = 26;
        public static final int MONGOLIAN = 27;
        public static final int GEEZ = 28;
        public static final int SLAVIC = 29;
        public static final int VIETNAMESE = 30;
        public static final int SINDHI = 31;
        public static final int UNINTERPRETED = 32;
    }

    public static final class MS_EncodingID {
        public static final int SYMBOL = 0;
        public static final int UNICODE_BMP = 1;
        public static final int SHIFTJIS = 2;
        public static final int PRC = 3;
        public static final int BIG5 = 4;
        public static final int WANSUNG = 5;
        public static final int JOHAB = 6;
        public static final int UNICODE_FULL = 10;
    }

    public static final class UnicodeEncodingID {
        public static final int ID_1_0 = 0;
        public static final int ID_1_1 = 1;
        public static final int ID_10646_1993 = 2;
        public static final int ID_2_0_BMP = 3;
        public static final int ID_2_0_FULL = 4;
        public static final int UNI_VARIATION_SEQ = 5;
    }

    public static final class PlatformID {
        public static final int UNICODE = 0;
        public static final int MACINTOSH = 1;
        public static final int ISO = 2;
        public static final int MICROSOFT = 3;
        public static final int CUSTOM = 4;
    }
}

