/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.mac;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.mac.FONDResourceHandler;
import com.adobe.fontengine.font.mac.ResourceFontData;
import com.adobe.fontengine.font.mac.sfntResourceHandler;
import com.adobe.fontengine.font.mac.versResourceHandler;
import com.adobe.fontengine.fontmanagement.ResourceFont;
import com.adobe.internal.io.ExtendedDataInputStream;
import com.adobe.internal.mac.resource.ResourceParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class FontFactory {
    private static final String RESOURCE_FORK_EXTENSION = "/..namedfork/rsrc";
    private static final String DFONT_SUFFIX = ".dfont";
    public static final int UNKNOWN = 0;
    public static final int RESOURCE_FORK_FONT = 1;
    public static final int DATA_FORK_FONT = 2;
    private static final String[] SCRIPTID_TO_ULOCALE = new String[]{"en", "ja", "zh-Hant", "ko", "ar", "he", "el", "ru", "MacSymbol", "hi", "pa", "gu", null, null, null, null, null, null, null, null, null, "th", null, null, null, "zh-Hans", null, null, null, "MacCentralEuropean", null, null, null};

    public static FontData load(URL url, int type, int fontID, int fondID) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        ResourceFontData rsrcFontData = null;
        ResourceParser parser = new ResourceParser();
        FONDResourceHandler handlerFOND = new FONDResourceHandler();
        versResourceHandler handlervers = new versResourceHandler();
        sfntResourceHandler handlersfnt = new sfntResourceHandler(fontID);
        parser.addHandler(handlerFOND);
        parser.addHandler(handlervers);
        parser.addHandler(handlersfnt);
        try {
            parser.setURL(url);
            parser.parse();
        }
        catch (IOException e) {
            throw new FontLoadingException(e);
        }
        Map<Integer, sfntResourceHandler.SfntResource> sfntMap = handlersfnt.getResources();
        Set<FONDResourceHandler.Association> associationSet = handlerFOND.getAssociations();
        for (FONDResourceHandler.Association association : associationSet) {
            Font font;
            sfntResourceHandler.SfntResource resource;
            if (fondID != association.getFondID() || fontID != association.getFontID() || (resource = sfntMap.get(fontID)) == null || (font = resource.getFont()) == null) continue;
            rsrcFontData = new ResourceFontData(((FontImpl)font).getFontData(), FontFactory.scriptCodeToCharset(resource.getScriptCode()), association.getName(), resource.getName(), association.isBold(), association.isItalic());
            break;
        }
        return rsrcFontData;
    }

    public static ResourceFont[] load(URL url, int type) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        ResourceParser parser = new ResourceParser();
        FONDResourceHandler handlerFOND = new FONDResourceHandler();
        versResourceHandler handlervers = new versResourceHandler();
        sfntResourceHandler handlersfnt = new sfntResourceHandler();
        parser.addHandler(handlerFOND);
        parser.addHandler(handlervers);
        parser.addHandler(handlersfnt);
        try {
            if (type == 1) {
                url = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile() + RESOURCE_FORK_EXTENSION);
            }
            parser.setURL(url);
            parser.parse();
        }
        catch (IOException e) {
            throw new FontLoadingException(e);
        }
        Map<Integer, sfntResourceHandler.SfntResource> sfntMap = handlersfnt.getResources();
        Set<FONDResourceHandler.Association> associationSet = handlerFOND.getAssociations();
        ArrayList<ResourceFont> fonts = new ArrayList<ResourceFont>();
        for (FONDResourceHandler.Association association : associationSet) {
            Font font;
            int sfntID = association.getFontID();
            sfntResourceHandler.SfntResource resource = sfntMap.get(sfntID);
            if (resource == null || (font = resource.getFont()) == null) continue;
            ResourceFontData rsrcFontData = new ResourceFontData(((FontImpl)font).getFontData(), FontFactory.scriptCodeToCharset(resource.getScriptCode()), association.getName(), resource.getName(), association.isBold(), association.isItalic());
            ResourceFont rsrcFont = new ResourceFont(url, type, sfntID, association.getFondID(), rsrcFontData);
            fonts.add(rsrcFont);
        }
        ResourceFont[] a = new ResourceFont[fonts.size()];
        return fonts.toArray(a);
    }

    public static int getNumBytesNeededToIdentify() {
        return 16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int isResourceFont(byte[] bytes, URL url) throws IOException {
        InputStream rsrcStream = null;
        int streamType = 0;
        try {
            long mapLength;
            long dataLength;
            long mapOffset;
            long dataOffset;
            rsrcStream = FontFactory.getDataResourceFontStream(url);
            if (rsrcStream != null) {
                streamType = 2;
            } else {
                rsrcStream = FontFactory.getResourceStream(url);
                if (rsrcStream != null) {
                    streamType = 1;
                }
            }
            if (rsrcStream == null) {
                int n = 0;
                return n;
            }
            try {
                ExtendedDataInputStream dis = new ExtendedDataInputStream(rsrcStream);
                dataOffset = dis.readUnsignedInt();
                mapOffset = dis.readUnsignedInt();
                dataLength = dis.readUnsignedInt();
                mapLength = dis.readUnsignedInt();
            }
            catch (Exception e) {
                int n = 0;
                if (rsrcStream != null) {
                    rsrcStream.close();
                }
                return n;
            }
            if (mapOffset > dataOffset && mapOffset < dataOffset + dataLength || dataOffset > mapOffset && dataOffset < mapOffset + mapLength) {
                int n = 0;
                return n;
            }
            int n = streamType;
            return n;
        }
        finally {
            if (rsrcStream != null) {
                rsrcStream.close();
            }
        }
    }

    private static InputStream getResourceStream(URL url) throws IOException {
        URL rsrcURL = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile() + RESOURCE_FORK_EXTENSION);
        InputStream rsrcStream = null;
        try {
            rsrcStream = rsrcURL.openStream();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return rsrcStream;
    }

    private static InputStream getDataResourceFontStream(URL url) throws IOException {
        InputStream rsrcStream = null;
        String file = url.getFile();
        if (file.endsWith(DFONT_SUFFIX)) {
            rsrcStream = url.openStream();
        }
        return rsrcStream;
    }

    static final ULocale scriptCodeToCharset(int script) {
        String locale = SCRIPTID_TO_ULOCALE[script = Math.min(script, SCRIPTID_TO_ULOCALE.length - 1)];
        if (locale == null) {
            locale = SCRIPTID_TO_ULOCALE[0];
        }
        return new ULocale(locale);
    }
}

