/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.cff.Type2ConsumerDefaultImpl;

class Type2UnhintedRedirector
extends Type2ConsumerDefaultImpl {
    protected double x;
    protected double y;
    private boolean pathStarted;
    private double pathStartX;
    private double pathStartY;
    protected OutlineConsumer outlineConsumer;

    Type2UnhintedRedirector() {
    }

    void reset(OutlineConsumer outlineConsumer) {
        this.outlineConsumer = outlineConsumer;
        this.x = 0.0;
        this.y = 0.0;
        this.pathStarted = false;
    }

    void startPathIfNeeded(double x, double y) {
        if (!this.pathStarted) {
            this.pathStarted = true;
            this.pathStartX = x;
            this.pathStartY = y;
        }
    }

    public void endchar(double[] stack, int stackDepth) {
        if (this.pathStarted && (Double.compare(this.x, this.pathStartX) != 0 || Double.compare(this.y, this.pathStartY) != 0)) {
            this.outlineConsumer.lineto(this.pathStartX, this.pathStartY);
        }
        this.outlineConsumer.endchar();
        this.pathStarted = false;
    }

    public void rmoveto(double[] stack, int stackDepth) {
        this.pathStarted = false;
        this.x += stack[stackDepth - 2];
        this.y += stack[stackDepth - 1];
        this.outlineConsumer.moveto(this.x, this.y);
    }

    public void hmoveto(double[] stack, int stackDepth) {
        this.pathStarted = false;
        this.x += stack[stackDepth - 1];
        this.outlineConsumer.moveto(this.x, this.y);
    }

    public void vmoveto(double[] stack, int stackDepth) {
        this.pathStarted = false;
        this.y += stack[stackDepth - 1];
        this.outlineConsumer.moveto(this.x, this.y);
    }

    public void moveto(double[] stack, int stackDepth) {
        this.pathStarted = false;
        this.x = stack[stackDepth - 2];
        this.y = stack[stackDepth - 1];
        this.outlineConsumer.moveto(this.x, this.y);
    }

    public void rlineto(double[] stack, int stackDepth) {
        for (int i = 0; i < stackDepth; i += 2) {
            this.startPathIfNeeded(this.x, this.y);
            this.x += stack[i];
            this.y += stack[i + 1];
            this.outlineConsumer.lineto(this.x, this.y);
        }
    }

    public void hlineto(double[] stack, int stackDepth) {
        for (int i = 0; i < stackDepth; ++i) {
            if (i % 2 == 0) {
                this.startPathIfNeeded(this.x, this.y);
                this.x += stack[i];
                this.outlineConsumer.lineto(this.x, this.y);
                continue;
            }
            this.startPathIfNeeded(this.x, this.y);
            this.y += stack[i];
            this.outlineConsumer.lineto(this.x, this.y);
        }
    }

    public void vlineto(double[] stack, int stackDepth) {
        for (int i = 0; i < stackDepth; ++i) {
            if (i % 2 == 1) {
                this.startPathIfNeeded(this.x, this.y);
                this.x += stack[i];
                this.outlineConsumer.lineto(this.x, this.y);
                continue;
            }
            this.startPathIfNeeded(this.x, this.y);
            this.y += stack[i];
            this.outlineConsumer.lineto(this.x, this.y);
        }
    }

    public void rrcurveto(double[] stack, int stackDepth) {
        for (int i = 0; i < stackDepth; i += 6) {
            this.startPathIfNeeded(this.x, this.y);
            this.x += stack[i];
            this.y += stack[i + 1];
            double x2 = this.x;
            double y2 = this.y;
            this.x += stack[i + 2];
            this.y += stack[i + 3];
            double x3 = this.x;
            double y3 = this.y;
            this.x += stack[i + 4];
            this.y += stack[i + 5];
            this.outlineConsumer.curveto(x2, y2, x3, y3, this.x, this.y);
        }
    }

    public void hhcurveto(double[] stack, int stackDepth) {
        int i = 0;
        double x1 = this.x;
        double y1 = this.y;
        if (stackDepth % 2 == 1) {
            this.y += stack[i++];
        }
        while (i < stackDepth) {
            this.x += stack[i++];
            double x2 = this.x;
            double y2 = this.y;
            this.x += stack[i++];
            this.y += stack[i++];
            double x3 = this.x;
            double y3 = this.y;
            this.x += stack[i++];
            this.startPathIfNeeded(x1, y1);
            this.outlineConsumer.curveto(x2, y2, x3, y3, this.x, this.y);
            x1 = this.x;
            y1 = this.y;
        }
    }

    public void hvcurveto(double[] stack, int stackDepth) {
        int i = 0;
        double x1 = this.x;
        double y1 = this.y;
        if (stackDepth % 8 == 4 || stackDepth % 8 == 5) {
            this.x += stack[i++];
            double x2 = this.x;
            double y2 = this.y;
            this.x += stack[i++];
            this.y += stack[i++];
            double x3 = this.x;
            double y3 = this.y;
            this.y += stack[i++];
            if (i + 1 == stackDepth) {
                this.x += stack[i++];
            }
            this.startPathIfNeeded(x1, y1);
            this.outlineConsumer.curveto(x2, y2, x3, y3, this.x, this.y);
            x1 = this.x;
            y1 = this.y;
            while (i + 8 <= stackDepth) {
                this.y += stack[i++];
                x2 = this.x;
                y2 = this.y;
                this.x += stack[i++];
                this.y += stack[i++];
                x3 = this.x;
                y3 = this.y;
                this.x += stack[i++];
                this.startPathIfNeeded(x1, y1);
                this.outlineConsumer.curveto(x2, y2, x3, y3, this.x, this.y);
                x1 = this.x;
                y1 = this.y;
                this.x += stack[i++];
                x2 = this.x;
                y2 = this.y;
                this.x += stack[i++];
                this.y += stack[i++];
                x3 = this.x;
                y3 = this.y;
                this.y += stack[i++];
                if (i + 1 == stackDepth) {
                    this.x += stack[i++];
                }
                this.startPathIfNeeded(x1, y1);
                this.outlineConsumer.curveto(x2, y2, x3, y3, this.x, this.y);
                x1 = this.x;
                y1 = this.y;
            }
        } else {
            while (i + 8 <= stackDepth) {
                this.x += stack[i++];
                double x2 = this.x;
                double y2 = this.y;
                this.x += stack[i++];
                this.y += stack[i++];
                double x3 = this.x;
                double y3 = this.y;
                this.y += stack[i++];
                this.startPathIfNeeded(x1, y1);
                this.outlineConsumer.curveto(x2, y2, x3, y3, this.x, this.y);
                x1 = this.x;
                y1 = this.y;
                this.y += stack[i++];
                x2 = this.x;
                y2 = this.y;
                this.x += stack[i++];
                this.y += stack[i++];
                x3 = this.x;
                y3 = this.y;
                this.x += stack[i++];
                if (i + 1 == stackDepth) {
                    this.y += stack[i++];
                }
                this.startPathIfNeeded(x1, y1);
                this.outlineConsumer.curveto(x2, y2, x3, y3, this.x, this.y);
                x1 = this.x;
                y1 = this.y;
            }
        }
    }

    public void rcurveline(double[] stack, int stackDepth) {
        int i = 0;
        double x1 = this.x;
        double y1 = this.y;
        while (i + 6 <= stackDepth) {
            this.x += stack[i++];
            this.y += stack[i++];
            double x2 = this.x;
            double y2 = this.y;
            this.x += stack[i++];
            this.y += stack[i++];
            double x3 = this.x;
            double y3 = this.y;
            this.x += stack[i++];
            this.y += stack[i++];
            this.startPathIfNeeded(x1, y1);
            this.outlineConsumer.curveto(x2, y2, x3, y3, this.x, this.y);
            x1 = this.x;
            y1 = this.y;
        }
        this.x += stack[i++];
        this.y += stack[i++];
        this.startPathIfNeeded(x1, y1);
        this.outlineConsumer.lineto(this.x, this.y);
    }

    public void rlinecurve(double[] stack, int stackDepth) {
        int i = 0;
        double x1 = this.x;
        double y1 = this.y;
        while (i + 6 < stackDepth) {
            this.x += stack[i++];
            this.y += stack[i++];
            this.startPathIfNeeded(x1, y1);
            this.outlineConsumer.lineto(this.x, this.y);
            x1 = this.x;
            y1 = this.y;
        }
        this.x += stack[i++];
        this.y += stack[i++];
        double x2 = this.x;
        double y2 = this.y;
        this.x += stack[i++];
        this.y += stack[i++];
        double x3 = this.x;
        double y3 = this.y;
        this.x += stack[i++];
        this.y += stack[i++];
        this.startPathIfNeeded(x1, y1);
        this.outlineConsumer.curveto(x2, y2, x3, y3, this.x, this.y);
    }

    public void vvcurveto(double[] stack, int stackDepth) {
        int i = 0;
        double x1 = this.x;
        double y1 = this.y;
        if (stackDepth % 2 == 1) {
            this.x += stack[i++];
        }
        while (i < stackDepth) {
            this.y += stack[i++];
            double x2 = this.x;
            double y2 = this.y;
            this.x += stack[i++];
            this.y += stack[i++];
            double x3 = this.x;
            double y3 = this.y;
            this.y += stack[i++];
            this.startPathIfNeeded(x1, y1);
            this.outlineConsumer.curveto(x2, y2, x3, y3, this.x, this.y);
            x1 = this.x;
            y1 = this.y;
        }
    }

    public void vhcurveto(double[] stack, int stackDepth) {
        int i = 0;
        double x1 = this.x;
        double y1 = this.y;
        if (stackDepth % 8 == 4 || stackDepth % 8 == 5) {
            this.y += stack[i++];
            double x2 = this.x;
            double y2 = this.y;
            this.x += stack[i++];
            this.y += stack[i++];
            double x3 = this.x;
            double y3 = this.y;
            this.x += stack[i++];
            if (i + 1 == stackDepth) {
                this.y += stack[i++];
            }
            this.startPathIfNeeded(x1, y1);
            this.outlineConsumer.curveto(x2, y2, x3, y3, this.x, this.y);
            x1 = this.x;
            y1 = this.y;
            while (i + 8 <= stackDepth) {
                this.x += stack[i++];
                x2 = this.x;
                y2 = this.y;
                this.x += stack[i++];
                this.y += stack[i++];
                x3 = this.x;
                y3 = this.y;
                this.y += stack[i++];
                this.startPathIfNeeded(x1, y1);
                this.outlineConsumer.curveto(x2, y2, x3, y3, this.x, this.y);
                x1 = this.x;
                y1 = this.y;
                this.y += stack[i++];
                x2 = this.x;
                y2 = this.y;
                this.x += stack[i++];
                this.y += stack[i++];
                x3 = this.x;
                y3 = this.y;
                this.x += stack[i++];
                if (i + 1 == stackDepth) {
                    this.y += stack[i++];
                }
                this.startPathIfNeeded(x1, y1);
                this.outlineConsumer.curveto(x2, y2, x3, y3, this.x, this.y);
                x1 = this.x;
                y1 = this.y;
            }
        } else {
            while (i + 8 <= stackDepth) {
                this.y += stack[i++];
                double x2 = this.x;
                double y2 = this.y;
                this.x += stack[i++];
                this.y += stack[i++];
                double x3 = this.x;
                double y3 = this.y;
                this.x += stack[i++];
                this.startPathIfNeeded(x1, y1);
                this.outlineConsumer.curveto(x2, y2, x3, y3, this.x, this.y);
                x1 = this.x;
                y1 = this.y;
                this.x += stack[i++];
                x2 = this.x;
                y2 = this.y;
                this.x += stack[i++];
                this.y += stack[i++];
                x3 = this.x;
                y3 = this.y;
                this.y += stack[i++];
                if (i + 1 == stackDepth) {
                    this.x += stack[i++];
                }
                this.startPathIfNeeded(x1, y1);
                this.outlineConsumer.curveto(x2, y2, x3, y3, this.x, this.y);
                x1 = this.x;
                y1 = this.y;
            }
        }
    }

    public void hflex(double[] stack, int stackDepth) {
        double y1;
        int i = 0;
        double x1 = this.x;
        double starty = y1 = this.y;
        this.x += stack[i++];
        double x2 = this.x;
        double y2 = this.y;
        this.x += stack[i++];
        this.y += stack[i++];
        double x3 = this.x;
        double y3 = this.y;
        this.x += stack[i++];
        this.startPathIfNeeded(x1, y1);
        this.outlineConsumer.curveto(x2, y2, x3, y3, this.x, this.y);
        x1 = this.x;
        y1 = this.y;
        this.x += stack[i++];
        x2 = this.x;
        y2 = this.y;
        this.x += stack[i++];
        x3 = this.x;
        y3 = starty;
        this.x += stack[i++];
        this.y = starty;
        this.startPathIfNeeded(x1, y1);
        this.outlineConsumer.curveto(x2, y2, x3, y3, this.x, starty);
    }

    public void flex(double[] stack, int stackDepth) {
        int i = 0;
        double x1 = this.x;
        double y1 = this.y;
        this.x += stack[i++];
        this.y += stack[i++];
        double x2 = this.x;
        double y2 = this.y;
        this.x += stack[i++];
        this.y += stack[i++];
        double x3 = this.x;
        double y3 = this.y;
        this.x += stack[i++];
        this.y += stack[i++];
        this.startPathIfNeeded(x1, y1);
        this.outlineConsumer.curveto(x2, y2, x3, y3, this.x, this.y);
        x1 = this.x;
        y1 = this.y;
        this.x += stack[i++];
        this.y += stack[i++];
        x2 = this.x;
        y2 = this.y;
        this.x += stack[i++];
        this.y += stack[i++];
        x3 = this.x;
        y3 = this.y;
        this.x += stack[i++];
        this.y += stack[i++];
        this.startPathIfNeeded(x1, y1);
        this.outlineConsumer.curveto(x2, y2, x3, y3, this.x, this.y);
    }

    public void hflex1(double[] stack, int stackDepth) {
        double y1;
        int i = 0;
        double x1 = this.x;
        double startY = y1 = this.y;
        this.x += stack[i++];
        this.y += stack[i++];
        double x2 = this.x;
        double y2 = this.y;
        this.x += stack[i++];
        this.y += stack[i++];
        double x3 = this.x;
        double y3 = this.y;
        this.x += stack[i++];
        this.startPathIfNeeded(x1, y1);
        this.outlineConsumer.curveto(x2, y2, x3, y3, this.x, this.y);
        x1 = this.x;
        y1 = this.y;
        this.x += stack[i++];
        x2 = this.x;
        y2 = this.y;
        this.x += stack[i++];
        this.y += stack[i++];
        x3 = this.x;
        y3 = this.y;
        this.x += stack[i++];
        this.y = startY;
        this.startPathIfNeeded(x1, y1);
        this.outlineConsumer.curveto(x2, y2, x3, y3, this.x, this.y);
    }

    public void flex1(double[] stack, int stackDepth) {
        int i = 0;
        double startx = this.x;
        double starty = this.y;
        double x1 = this.x;
        double y1 = this.y;
        this.x += stack[i++];
        this.y += stack[i++];
        double x2 = this.x;
        double y2 = this.y;
        this.x += stack[i++];
        this.y += stack[i++];
        double x3 = this.x;
        double y3 = this.y;
        this.x += stack[i++];
        this.y += stack[i++];
        this.startPathIfNeeded(x1, y1);
        this.outlineConsumer.curveto(x2, y2, x3, y3, this.x, this.y);
        x1 = this.x;
        y1 = this.y;
        this.x += stack[i++];
        this.y += stack[i++];
        x2 = this.x;
        y2 = this.y;
        this.x += stack[i++];
        this.y += stack[i++];
        x3 = this.x;
        y3 = this.y;
        if (Math.abs(this.x - startx) > Math.abs(this.y - starty)) {
            this.x += stack[i++];
            this.y = starty;
        } else {
            this.y += stack[i++];
            this.x = startx;
        }
        this.startPathIfNeeded(x1, y1);
        this.outlineConsumer.curveto(x2, y2, x3, y3, this.x, this.y);
    }
}

