/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.fontengine.FontEngineException;
import com.adobe.fontengine.font.Font;

public abstract class FontException
extends FontEngineException {
    static final long serialVersionUID = 1L;
    protected Font invalidFont = null;

    public FontException() {
    }

    public FontException(Font font) {
        this.invalidFont = font;
    }

    public FontException(String message) {
        super(message);
    }

    public FontException(String message, Font font) {
        super(message);
        this.invalidFont = font;
    }

    public FontException(String message, Throwable cause) {
        super(message, cause);
    }

    public FontException(String message, Throwable cause, Font font) {
        super(message, cause);
        this.invalidFont = font;
    }

    public FontException(Throwable cause) {
        super(cause);
    }

    public FontException(Throwable cause, Font font) {
        super(cause);
        this.invalidFont = font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font getFont() {
        FontException fontException = this;
        synchronized (fontException) {
            return this.invalidFont;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initFont(Font font) {
        FontException fontException = this;
        synchronized (fontException) {
            if (this.invalidFont != null) {
                throw new IllegalStateException("Can't overwrite font");
            }
            this.invalidFont = font;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        FontException fontException = this;
        synchronized (fontException) {
            return super.toString() + (this.invalidFont == null ? "" : " : " + this.invalidFont.toString());
        }
    }
}

