/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.fp.util;

import com.adobe.fd.fp.config.FormsPortalDraftsandSubmissionConfigService;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryUtils {
    private static final Logger log = LoggerFactory.getLogger(RepositoryUtils.class);
    private static final String STR_SLING_ORDERED_FOLDER = "sling:OrderedFolder";
    private static final String STR_GUIDE_NAME = "guideName";
    private static final String STR_SUBMIT = "submit";
    private static final String STR_TEMP = "temp";
    private static final String STR_DRAFT = "drafts";
    public static final String METADATA_NODE_NAME = "metadata";
    public static final String JCR_CONTENT_NODE_NAME = "jcr:content";
    public static final String RENDITIONS_NODE_NAME = "renditions";
    public static final String ORIGINAL_RENDITION_NODE_NAME = "original";
    public static final String GUIDE_CONTAINER_NODE_NAME = "guideContainer";
    private static RepositoryUtils repositoryUtils = null;
    private FormsPortalDraftsandSubmissionConfigService draftsAndSubmissionConfiguration;

    private RepositoryUtils(FormsPortalDraftsandSubmissionConfigService draftsAndSubmissionConfigObject) {
        this.draftsAndSubmissionConfiguration = draftsAndSubmissionConfigObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RepositoryUtils getInstance(FormsPortalDraftsandSubmissionConfigService draftsAndSubmissionConfigObject) {
        if (repositoryUtils == null) {
            Class<RepositoryUtils> clazz = RepositoryUtils.class;
            synchronized (RepositoryUtils.class) {
                if (repositoryUtils != null) return repositoryUtils;
                repositoryUtils = new RepositoryUtils(draftsAndSubmissionConfigObject);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return repositoryUtils;
            }
        }
        if (RepositoryUtils.repositoryUtils.draftsAndSubmissionConfiguration == draftsAndSubmissionConfigObject) return repositoryUtils;
        Class<RepositoryUtils> clazz = RepositoryUtils.class;
        synchronized (RepositoryUtils.class) {
            if (RepositoryUtils.repositoryUtils.draftsAndSubmissionConfiguration == draftsAndSubmissionConfigObject) return repositoryUtils;
            repositoryUtils = new RepositoryUtils(draftsAndSubmissionConfigObject);
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return repositoryUtils;
        }
    }

    public Node getRootNode(Session session) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException {
        Node portalRootNode = null;
        portalRootNode = !session.nodeExists(this.draftsAndSubmissionConfiguration.getFormsPortalRoot()) ? session.getRootNode().addNode(this.draftsAndSubmissionConfiguration.getFormsPortalRoot().substring(1), STR_SLING_ORDERED_FOLDER) : session.getNode(this.draftsAndSubmissionConfiguration.getFormsPortalRoot());
        return portalRootNode;
    }

    public Node getUserNode(String userName, boolean create, Session session) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException, UnsupportedEncodingException {
        Node userNode;
        block8: {
            userNode = null;
            String encodedUserName = URLEncoder.encode(userName, "UTF-8");
            String defaultUserNode = this.draftsAndSubmissionConfiguration.getFormsPortalRoot() + "/" + userName;
            String encodedUserNode = this.draftsAndSubmissionConfiguration.getFormsPortalRoot() + "/" + encodedUserName;
            try {
                if (session.nodeExists(defaultUserNode)) {
                    userNode = session.getNode(defaultUserNode);
                } else if (session.nodeExists(encodedUserNode)) {
                    userNode = session.getNode(encodedUserNode);
                } else if (create) {
                    Node fpRootNode = this.getRootNode(session);
                    userNode = fpRootNode.addNode(encodedUserName, STR_SLING_ORDERED_FOLDER);
                }
            }
            catch (Exception e) {
                log.trace("Error while retrieving node path " + defaultUserNode, e);
                if (session.nodeExists(encodedUserNode)) {
                    userNode = session.getNode(encodedUserNode);
                }
                if (!create) break block8;
                Node fpRootNode = this.getRootNode(session);
                userNode = fpRootNode.addNode(encodedUserName, STR_SLING_ORDERED_FOLDER);
            }
        }
        return userNode;
    }

    public Node getUserGuideNode(Node node, String guideName, boolean create) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        Node userGuideNode = null;
        if (!node.hasNode(guideName)) {
            if (create) {
                userGuideNode = node.addNode(guideName);
                userGuideNode.setProperty(STR_GUIDE_NAME, guideName);
            }
        } else {
            userGuideNode = node.getNode(guideName);
        }
        return userGuideNode;
    }

    public Node getChildNode(Node node, String nodeName, String nodeType, boolean create) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        Node childNode = null;
        if (node != null) {
            if (node.hasNode(nodeName)) {
                childNode = node.getNode(nodeName);
            } else if (create) {
                childNode = node.addNode(nodeName, nodeType);
            }
        }
        return childNode;
    }

    public Node getSubmitRootNode(Node userNode, boolean create) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException {
        Node submitRootNode = null;
        if (userNode != null) {
            if (!userNode.hasNode(STR_SUBMIT)) {
                if (create) {
                    submitRootNode = userNode.addNode(STR_SUBMIT, STR_SLING_ORDERED_FOLDER);
                }
            } else {
                submitRootNode = userNode.getNode(STR_SUBMIT);
            }
        }
        return submitRootNode;
    }

    public Node getTempRootNode(Node userNode, boolean create) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException {
        Node submitRootNode = null;
        if (userNode != null) {
            if (!userNode.hasNode(STR_TEMP)) {
                if (create) {
                    submitRootNode = userNode.addNode(STR_TEMP, STR_SLING_ORDERED_FOLDER);
                }
            } else {
                submitRootNode = userNode.getNode(STR_TEMP);
            }
        }
        return submitRootNode;
    }

    public Node getDraftsRootNode(Node userNode, boolean create) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        Node draftsRootNode = null;
        if (userNode != null) {
            if (!userNode.hasNode(STR_DRAFT)) {
                if (create) {
                    draftsRootNode = userNode.addNode(STR_DRAFT, STR_SLING_ORDERED_FOLDER);
                }
            } else {
                draftsRootNode = userNode.getNode(STR_DRAFT);
            }
        }
        return draftsRootNode;
    }

    public Node getMetadataNode(Node formNode, boolean create) throws RepositoryException, ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException {
        Node metadataNode = null;
        Node contentNode = this.getContentNode(formNode, create);
        if (contentNode != null) {
            if (!contentNode.hasNode(METADATA_NODE_NAME)) {
                if (create) {
                    metadataNode = contentNode.addNode(METADATA_NODE_NAME, "{http://www.jcp.org/jcr/nt/1.0}unstructured");
                }
            } else {
                metadataNode = contentNode.getNode(METADATA_NODE_NAME);
            }
        }
        return metadataNode;
    }

    public Node getContentNode(Node formNode, boolean create) throws RepositoryException, ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException {
        Node contentNode = null;
        if (!formNode.hasNode(JCR_CONTENT_NODE_NAME)) {
            if (create) {
                contentNode = formNode.addNode(JCR_CONTENT_NODE_NAME, "{http://www.jcp.org/jcr/nt/1.0}unstructured");
            }
        } else {
            contentNode = formNode.getNode(JCR_CONTENT_NODE_NAME);
        }
        return contentNode;
    }

    public Node getRenditionNode(Node formNode, boolean create) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException {
        Node renditionNode = null;
        Node contentNode = this.getContentNode(formNode, create);
        if (contentNode != null) {
            if (!contentNode.hasNode(RENDITIONS_NODE_NAME)) {
                if (create) {
                    renditionNode = contentNode.addNode(RENDITIONS_NODE_NAME, "{http://www.jcp.org/jcr/nt/1.0}folder");
                }
            } else {
                renditionNode = contentNode.getNode(RENDITIONS_NODE_NAME);
            }
        }
        return renditionNode;
    }

    public Node getOriginalRenditionNode(Node formNode, boolean create) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException {
        Node origRenditionNode = null;
        Node renditionNode = this.getRenditionNode(formNode, create);
        if (renditionNode != null) {
            if (!renditionNode.hasNode(ORIGINAL_RENDITION_NODE_NAME)) {
                if (create) {
                    origRenditionNode = renditionNode.addNode(ORIGINAL_RENDITION_NODE_NAME, "{http://www.jcp.org/jcr/nt/1.0}file");
                }
            } else {
                origRenditionNode = renditionNode.getNode(ORIGINAL_RENDITION_NODE_NAME);
            }
        }
        return origRenditionNode;
    }

    public Node getOriginalRenditionContentNode(Node formNode, boolean create) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException {
        Node origRenditionContentNode = null;
        Node origRenditionNode = this.getOriginalRenditionNode(formNode, create);
        if (origRenditionNode != null) {
            if (!origRenditionNode.hasNode(JCR_CONTENT_NODE_NAME)) {
                if (create) {
                    origRenditionContentNode = origRenditionNode.addNode(JCR_CONTENT_NODE_NAME, "{http://www.jcp.org/jcr/nt/1.0}resource");
                }
            } else {
                origRenditionContentNode = origRenditionNode.getNode(JCR_CONTENT_NODE_NAME);
            }
        }
        return origRenditionContentNode;
    }

    public Node getGuideContainerNode(Node guideNode) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException {
        NodeIterator nItr;
        Node guideContainerNode = null;
        Node originalRenditionContentNode = this.getOriginalRenditionContentNode(guideNode, false);
        if (originalRenditionContentNode != null && (nItr = originalRenditionContentNode.getNodes(GUIDE_CONTAINER_NODE_NAME)).hasNext()) {
            guideContainerNode = nItr.nextNode();
        }
        return guideContainerNode;
    }

    public String findParentCQPage(String currentNodePath, Session session) throws RepositoryException {
        String parentCQPage = null;
        if (session.nodeExists(currentNodePath)) {
            Node currentNode = session.getNode(currentNodePath);
            while (!currentNode.isNodeType("rep:root")) {
                if (currentNode.isNodeType("cq:Page")) {
                    parentCQPage = currentNode.getPath();
                    break;
                }
                currentNode = currentNode.getParent();
            }
        }
        return parentCQPage;
    }
}

