/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.fp.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyUtils {
    private static final Logger log = LoggerFactory.getLogger(PropertyUtils.class);

    public static void setBinaryValue(Node currentNode, String propertyName, Object propObj, ValueFactory factory) throws Exception {
        if (propObj instanceof InputStream) {
            InputStream inStream = (InputStream)propObj;
            currentNode.setProperty(propertyName, factory.createBinary(inStream));
        } else if (propObj instanceof Byte[]) {
            Byte[] bytes = (Byte[])propObj;
            byte[] smallByte = new byte[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                smallByte[i] = bytes[i];
            }
            ByteArrayInputStream byteStream = new ByteArrayInputStream(smallByte);
            currentNode.setProperty(propertyName, factory.createBinary(byteStream));
        } else if (propObj instanceof byte[]) {
            byte[] bytes = (byte[])propObj;
            ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
            currentNode.setProperty(propertyName, factory.createBinary(byteStream));
        } else if (propObj instanceof String) {
            byte[] bytes = ((String)propObj).getBytes("UTF-8");
            ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
            currentNode.setProperty(propertyName, factory.createBinary(byteStream));
        }
    }

    public static Object getPropertyValue(Property property) throws Exception {
        Object propValue = null;
        switch (property.getType()) {
            case 2: {
                propValue = PropertyUtils.getBinaryValue(property);
                break;
            }
            case 6: {
                propValue = PropertyUtils.getBooleanValue(property);
                break;
            }
            case 5: {
                propValue = PropertyUtils.getDateValue(property);
                break;
            }
            case 12: {
                propValue = PropertyUtils.getDecimalValue(property);
                break;
            }
            case 4: {
                propValue = PropertyUtils.getDoubleValue(property);
                break;
            }
            case 3: {
                propValue = PropertyUtils.getLongValue(property);
                break;
            }
            case 1: {
                propValue = PropertyUtils.getStringValue(property);
                break;
            }
            case 8: {
                propValue = PropertyUtils.getPathValue(property);
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            default: {
                log.warn("Unable to find the property type for " + property.getName());
                propValue = PropertyUtils.getStringValue(property);
            }
        }
        return propValue;
    }

    private static Object getBooleanValue(Property property) throws Exception {
        Serializable propValue = null;
        if (property.isMultiple()) {
            Value[] values;
            ArrayList<Boolean> valueList = new ArrayList<Boolean>();
            propValue = valueList;
            for (Value value : values = property.getValues()) {
                if (value == null) continue;
                valueList.add(value.getBoolean());
            }
        } else {
            propValue = property.getBoolean();
        }
        return propValue;
    }

    private static Object getStringValue(Property property) throws Exception {
        Object propValue = null;
        if (property.isMultiple()) {
            Value[] values;
            ArrayList<String> valueList = new ArrayList<String>();
            propValue = valueList;
            for (Value value : values = property.getValues()) {
                if (value == null) continue;
                valueList.add(value.getString());
            }
        } else {
            propValue = property.getString();
        }
        return propValue;
    }

    private static Object getPathValue(Property property) throws Exception {
        Object propValue = null;
        if (property.isMultiple()) {
            Value[] values;
            ArrayList<String> valueList = new ArrayList<String>();
            propValue = valueList;
            for (Value value : values = property.getValues()) {
                if (value == null) continue;
                valueList.add(value.getString());
            }
        } else {
            propValue = property.getString();
        }
        return propValue;
    }

    private static Object getDateValue(Property property) throws Exception {
        Serializable propValue = null;
        if (property.isMultiple()) {
            Value[] values;
            ArrayList<Date> valueList;
            propValue = valueList = new ArrayList<Date>();
            for (Value value : values = property.getValues()) {
                if (value == null || value.getDate() == null) continue;
                valueList.add(value.getDate().getTime());
            }
        } else if (property.getDate() != null) {
            propValue = property.getDate().getTimeInMillis();
        }
        return propValue;
    }

    private static Object getDoubleValue(Property property) throws Exception {
        Serializable propValue = null;
        if (property.isMultiple()) {
            Value[] values;
            ArrayList<Double> valueList = new ArrayList<Double>();
            propValue = valueList;
            for (Value value : values = property.getValues()) {
                valueList.add(value.getDouble());
            }
        } else {
            propValue = property.getDouble();
        }
        return propValue;
    }

    private static Object getDecimalValue(Property property) throws Exception {
        Serializable propValue = null;
        if (property.isMultiple()) {
            Value[] values;
            ArrayList<BigDecimal> valueList = new ArrayList<BigDecimal>();
            propValue = valueList;
            for (Value value : values = property.getValues()) {
                valueList.add(value.getDecimal());
            }
        } else {
            propValue = property.getDecimal();
        }
        return propValue;
    }

    private static Object getLongValue(Property property) throws Exception {
        Serializable propValue = null;
        if (property.isMultiple()) {
            Value[] values;
            ArrayList<Long> valueList = new ArrayList<Long>();
            propValue = valueList;
            for (Value value : values = property.getValues()) {
                valueList.add(value.getLong());
            }
        } else {
            propValue = property.getLong();
        }
        return propValue;
    }

    private static Object getBinaryValue(Property property) throws Exception {
        Object propValue = null;
        if (property.isMultiple()) {
            Value[] values;
            ArrayList<byte[]> valueList = new ArrayList<byte[]>();
            propValue = valueList;
            for (Value value : values = property.getValues()) {
                InputStream inStream;
                Binary binary = value.getBinary();
                if (binary == null || (inStream = binary.getStream()) == null) continue;
                byte[] bytes = new byte[inStream.available()];
                inStream.read(bytes);
                inStream.close();
                valueList.add(bytes);
            }
        } else {
            InputStream inStream;
            Binary binary = property.getBinary();
            if (binary != null && (inStream = binary.getStream()) != null) {
                byte[] bytes = new byte[inStream.available()];
                inStream.read(bytes);
                inStream.close();
                propValue = bytes;
            }
        }
        return propValue;
    }

    private static Object getBinaryValueAsStream(Property property) throws Exception {
        Object propValue = null;
        if (property.isMultiple()) {
            Value[] values;
            ArrayList<InputStream> valueList = new ArrayList<InputStream>();
            propValue = valueList;
            for (Value value : values = property.getValues()) {
                InputStream inStream;
                Binary binary = value.getBinary();
                if (binary == null || (inStream = binary.getStream()) == null) continue;
                valueList.add(inStream);
            }
        } else {
            InputStream inStream;
            Binary binary = property.getBinary();
            if (binary != null && (inStream = binary.getStream()) != null) {
                propValue = inStream;
            }
        }
        return propValue;
    }
}

