/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.fp.util;

import com.adobe.fd.fp.exception.FormsPortalException;
import com.adobe.fd.fp.util.PropertyUtils;
import com.day.cq.replication.AgentIdFilter;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationOptions;
import com.day.cq.replication.Replicator;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalUtils {
    private static BundleContext bundleContext;
    private static final Logger log;
    public static final List<String> attachment_Url_Prefix_List;

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    public static void setBundleContext(BundleContext context) {
        bundleContext = context;
    }

    public static Session getFnDServiceUserSession(SlingRepository repository) throws LoginException, RepositoryException {
        Session session = repository.loginService(null, null);
        return session;
    }

    public static ResourceResolver getFnDServiceResolver(ResourceResolverFactory resolverFactory) throws org.apache.sling.api.resource.LoginException {
        return resolverFactory.getServiceResourceResolver(null);
    }

    public static void reverseReplicate(Session session, String path, ReplicationActionType replAction, Replicator replicator, String[] outBoxIDs) throws FormsPortalException, LoginException, ReplicationException {
        try {
            ReplicationOptions rop = new ReplicationOptions();
            AgentIdFilter filter = new AgentIdFilter(outBoxIDs);
            rop.setFilter(filter);
            replicator.replicate(session, replAction, path, rop);
        }
        catch (ReplicationException e) {
            throw new FormsPortalException(e);
        }
    }

    public static void replicate(Session session, String path, ReplicationActionType replAction, Replicator replicator) throws FormsPortalException, LoginException, ReplicationException {
        replicator.replicate(session, replAction, path);
    }

    public static Object getService(Class<?> c, String filter) throws Exception {
        Object result = null;
        BundleContext bc = PortalUtils.getBundleContext();
        if (c.equals(BundleContext.class)) {
            result = bc;
        } else {
            ServiceReference[] ref = bc.getServiceReferences(c.getName(), filter);
            if (ref != null) {
                result = bc.getService(ref[0]);
            } else {
                ServiceReference serviceRef = bc.getServiceReference(c.getName());
                if (serviceRef != null) {
                    result = bc.getService(serviceRef);
                }
            }
        }
        return result;
    }

    public static String getRequestParamValue(SlingHttpServletRequest req, String param) {
        String paramValue = null;
        if (req.getParameter(param) != null) {
            paramValue = req.getParameter(param);
        } else if (req.getAttribute(param) != null) {
            paramValue = req.getAttribute(param).toString();
        }
        return paramValue;
    }

    public static String createUrlFromParams(String url, Map<String, String> params) {
        try {
            boolean firsParameterAdded = url.indexOf("?") != -1;
            for (Map.Entry<String, String> param : params.entrySet()) {
                String paramValue = param.getValue();
                String key = param.getKey();
                if (paramValue == null) continue;
                if (!firsParameterAdded) {
                    url = url + "?" + URLEncoder.encode(key, "utf-8") + "=" + URLEncoder.encode(paramValue, "utf-8");
                    firsParameterAdded = true;
                    continue;
                }
                url = url + "&" + URLEncoder.encode(key, "utf-8") + "=" + URLEncoder.encode(paramValue, "utf-8");
            }
        }
        catch (Exception e) {
            log.error("Error occured while creating url with parameters provided", e);
        }
        return url;
    }

    public static JSONObject updateAttachmentMap(String id, String fileAttachmentMap, String type) {
        try {
            JSONObject fileJson = new JSONObject(fileAttachmentMap);
            Iterator<String> somExpressionItr = fileJson.keys();
            while (somExpressionItr.hasNext()) {
                StringBuffer attachmentUrlList = null;
                String somKey = somExpressionItr.next();
                String stringifiedAttachmentKey = fileJson.getString(somKey);
                String[] attachmentUrlArray = null;
                if (!stringifiedAttachmentKey.equals("null")) {
                    attachmentUrlArray = stringifiedAttachmentKey.split("\n");
                }
                if (attachmentUrlArray != null) {
                    attachmentUrlList = PortalUtils.updateAttachmentListUrl(attachmentUrlArray, type, id);
                }
                if (attachmentUrlList == null || attachmentUrlList.length() <= 0) continue;
                attachmentUrlList.replace(attachmentUrlList.lastIndexOf("\n"), attachmentUrlList.lastIndexOf("\n") + 1, "");
                fileJson.put(somKey, attachmentUrlList.toString());
            }
            return fileJson;
        }
        catch (Exception e) {
            log.error("Failed to update the attachment url's for submission read only viewing", e);
            return null;
        }
    }

    public static String getGuideContainerPathFromFormPath(String formPath) {
        String guideContainerPath = null;
        if (!StringUtils.isEmpty(formPath) && formPath.startsWith("/content/dam/formsanddocuments")) {
            guideContainerPath = "/content/forms/af" + formPath.substring(formPath.indexOf("/content/dam/formsanddocuments") + "/content/dam/formsanddocuments".length()) + "/" + "jcr:content" + "/guideContainer";
        }
        return guideContainerPath;
    }

    public static void updatePropertiesOnNode(Map<String, Object> propertiesMap, Node node) throws RepositoryException {
        for (Map.Entry<String, Object> prop : propertiesMap.entrySet()) {
            Object propValue = prop.getValue();
            String key = prop.getKey();
            if (propValue instanceof String) {
                node.setProperty(key, prop.getValue().toString());
                continue;
            }
            if (propValue instanceof String[]) {
                String[] propValArr = (String[])propValue;
                node.setProperty(key, propValArr);
                continue;
            }
            if (propValue instanceof Integer) {
                Integer propValInt = (Integer)propValue;
                node.setProperty(key, propValInt.intValue());
                continue;
            }
            if (propValue instanceof Double) {
                Double propValDbl = (Double)propValue;
                node.setProperty(key, propValDbl);
                continue;
            }
            if (propValue instanceof Date) {
                Date propValDate = (Date)propValue;
                Calendar cal = Calendar.getInstance();
                cal.setTime(propValDate);
                node.setProperty(key, cal);
                continue;
            }
            if (propValue instanceof Boolean) {
                Boolean propValBool = (Boolean)propValue;
                node.setProperty(key, propValBool);
                continue;
            }
            if (propValue != null) continue;
            node.setProperty(key, (String)null);
        }
    }

    public static boolean isDorAssociated(String formType, Node metadataNode) throws Exception {
        String formModel = "";
        boolean hasXdpRef = false;
        boolean hasDor = false;
        if (metadataNode != null) {
            String dorType;
            if (metadataNode.hasProperty("formmodel")) {
                formModel = (String)PropertyUtils.getPropertyValue(metadataNode.getProperty("formmodel"));
            }
            boolean bl = hasXdpRef = "formtemplates".equals(formModel) && metadataNode.hasProperty("xdpRef");
            if (metadataNode.hasProperty("dorType") && ("select".equals(dorType = metadataNode.getProperty("dorType").getString()) && metadataNode.hasProperty("dorTemplateRef") || "generate".equals(dorType))) {
                hasDor = true;
            }
        }
        return formType != null && formType.equals("mf") || hasXdpRef || hasDor;
    }

    public static String getAttachmentContentTypeKey(String attachmentKey) {
        return attachmentKey + "%2FcontentType";
    }

    public static Map<String, Object> convertJsonToMap(JSONObject json) throws JSONException {
        HashMap<String, Object> resultMap = null;
        if (json != null) {
            resultMap = new HashMap<String, Object>();
            Iterator<String> itr = json.keys();
            while (itr.hasNext()) {
                String key = itr.next();
                resultMap.put(key, json.get(key));
            }
        }
        return resultMap;
    }

    public static String getSignConfigFromGuideContainer(String guideContainerPath, Session session) throws RepositoryException {
        String signConfig = null;
        if (!StringUtils.isEmpty(guideContainerPath) && session != null) {
            if (session.nodeExists(guideContainerPath)) {
                Node containerNode = session.getNode(guideContainerPath);
                if (containerNode.hasNode("signerInfo")) {
                    Node signersInfoNode = containerNode.getNode("signerInfo");
                    if (signersInfoNode.hasProperty("signConfigPath")) {
                        signConfig = signersInfoNode.getProperty("signConfigPath").getString();
                    } else {
                        log.warn("Cannot retrieve sign config as container node " + guideContainerPath + " does not contains it.");
                    }
                } else {
                    log.warn("Cannot retrieve sign config as container node " + guideContainerPath + " does not info about signers.");
                }
            } else {
                log.warn("Cannot retrieve sign config as container node " + guideContainerPath + " does not exists.");
            }
        }
        return signConfig;
    }

    public static StringBuffer updateAttachmentListUrl(String[] attachmentUrlArray, String type, String currentId) {
        StringBuffer attachmentUrlList = new StringBuffer();
        for (String attachmentUrl : attachmentUrlArray) {
            String attachmentKey = null;
            if (attachmentUrl.indexOf("fp.attach.jsp") != -1) {
                String suffix = attachmentUrl.substring(attachmentUrl.indexOf("fp.attach.jsp") + "fp.attach.jsp".length() + 1);
                if (!StringUtils.isEmpty(suffix)) {
                    int index = suffix.indexOf("/") != -1 ? suffix.indexOf("/") : suffix.length();
                    String identifier = suffix.substring(0, index);
                    String id = null;
                    if (attachment_Url_Prefix_List.contains(identifier)) {
                        int prev_Index = index;
                        index = suffix.indexOf("/", index + 1) != -1 ? suffix.indexOf("/", index + 1) : suffix.length();
                        id = suffix.substring(prev_Index + 1, index);
                    } else {
                        id = identifier;
                    }
                    if (id != null && !id.isEmpty()) {
                        attachmentKey = suffix.substring(index + 1, suffix.length());
                    }
                }
            } else {
                attachmentKey = attachmentUrl;
            }
            switch (type) {
                case "submission": {
                    attachmentUrlList.append("/content/forms/portal/render.fp.attach.jsp/submission/" + currentId + "/" + attachmentKey);
                    break;
                }
                case "draft": {
                    attachmentUrlList.append("/content/forms/portal/render.fp.attach.jsp/" + currentId + "/" + attachmentKey);
                    break;
                }
                case "pendingSign": {
                    attachmentUrlList.append("/content/forms/portal/render.fp.attach.jsp/pendingSign/" + currentId + "/" + attachmentKey);
                }
            }
            attachmentUrlList.append("\n");
        }
        return attachmentUrlList;
    }

    public static String[] getArrayFromJsonArray(JSONArray jsonArray) throws JSONException {
        String[] result = null;
        if (jsonArray != null) {
            int resultLength = jsonArray.length();
            result = new String[resultLength];
            for (int i = 0; i < resultLength; ++i) {
                result[i] = jsonArray.getString(i);
            }
        }
        return result;
    }

    static {
        log = LoggerFactory.getLogger(PortalUtils.class);
        attachment_Url_Prefix_List = Arrays.asList("submission", "pendingSign");
    }
}

