/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.fp.util;

import com.adobe.fd.fp.common.PortalUtilsComponent;
import com.adobe.fd.fp.config.FormsPortalDraftsandSubmissionConfigService;
import com.adobe.fd.fp.exception.FormsPortalException;
import com.adobe.fd.fp.service.FPKeyGeneratorService;
import com.adobe.fd.fp.util.PortalUtils;
import com.adobe.fd.fp.util.PropertyUtils;
import com.adobe.fd.fp.util.RepositoryUtils;
import com.adobe.granite.resourceresolverhelper.ResourceResolverHelper;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.Replicator;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public abstract class DataBaseService {
    private final Logger logger = LoggerFactory.getLogger(DataBaseService.class);
    @Reference
    protected ResourceResolverHelper resourceResolverHelper;
    @Reference
    protected FormsPortalDraftsandSubmissionConfigService draftsandSubmissionConfiguration;
    @Reference
    protected SlingRepository slingRepository;
    @Reference
    protected SlingSettingsService slingSettingService;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected FPKeyGeneratorService fpKeyGeneratorService;
    @Reference
    protected Replicator replicator;
    @Reference
    protected PortalUtilsComponent portalUtilsComponent;
    protected String instanceType;

    protected String saveDataInternal(byte[] data, String ownerName) throws FormsPortalException {
        RepositoryUtils repUtils = RepositoryUtils.getInstance(this.draftsandSubmissionConfiguration);
        Session sysUserSession = null;
        try {
            sysUserSession = PortalUtils.getFnDServiceUserSession(this.slingRepository);
            Node userNode = repUtils.getUserNode(this.getUserName(sysUserSession, ownerName), true, sysUserSession);
            Node submissionFolder = repUtils.getChildNode(userNode, this.instanceType, "sling:OrderedFolder", true);
            Node dataFolder = repUtils.getChildNode(submissionFolder, "data", "sling:OrderedFolder", true);
            String id = this.fpKeyGeneratorService.getUniqueId();
            Node dataNode = repUtils.getChildNode(dataFolder, id, "{http://www.jcp.org/jcr/nt/1.0}unstructured", true);
            PropertyUtils.setBinaryValue(dataNode, "jcr:data", data, sysUserSession.getValueFactory());
            this.updateLastModified(dataNode);
            sysUserSession.save();
            if (this.slingSettingService.getRunModes().contains("publish")) {
                PortalUtils.reverseReplicate(sysUserSession, dataNode.getPath().toString(), ReplicationActionType.ACTIVATE, this.replicator, this.draftsandSubmissionConfiguration.getFormsPortalOutboxes());
            }
            String string = dataNode.getPath().toString();
            return string;
        }
        catch (FormsPortalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsPortalException(e);
        }
        finally {
            if (sysUserSession != null) {
                sysUserSession.logout();
            }
        }
    }

    protected String updateDataInternal(String userDataID, byte[] data) throws FormsPortalException {
        if (StringUtils.isEmpty(userDataID)) {
            throw new FormsPortalException("ALC-FMP-001-016");
        }
        boolean isAnonymous = false;
        Session currentSession = null;
        try {
            currentSession = this.resourceResolverHelper.getResourceResolverAs(Session.class);
            Node currentInstanceUserdataNode = currentSession.getNode(userDataID);
            PropertyUtils.setBinaryValue(currentInstanceUserdataNode, "jcr:data", data, currentSession.getValueFactory());
            this.updateLastModified(currentInstanceUserdataNode);
            currentSession.save();
            if (this.slingSettingService.getRunModes().contains("publish")) {
                PortalUtils.reverseReplicate(currentSession, currentInstanceUserdataNode.getPath().toString(), ReplicationActionType.ACTIVATE, this.replicator, this.draftsandSubmissionConfiguration.getFormsPortalOutboxes());
            }
            if (isAnonymous) {
                return "\"" + currentInstanceUserdataNode.getPath() + ".html\"";
            }
            return currentInstanceUserdataNode.getPath().toString();
        }
        catch (FormsPortalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsPortalException(e);
        }
    }

    protected byte[] getDataInternal(String userDataID) throws FormsPortalException {
        Session sysUserSession = null;
        try {
            sysUserSession = PortalUtils.getFnDServiceUserSession(this.slingRepository);
            Node dataNode = sysUserSession.getNode(userDataID);
            if (dataNode != null) {
                InputStream is = null;
                if (dataNode.hasProperty("jcr:data")) {
                    is = dataNode.getProperty("jcr:data").getBinary().getStream();
                } else if (dataNode.hasNode("jcr:content")) {
                    Node jcrDataNode = dataNode.getNode("jcr:content");
                    is = jcrDataNode.getProperty("jcr:data").getBinary().getStream();
                } else {
                    throw new FormsPortalException("ALC-FMP-001-021");
                }
                BufferedInputStream bis = new BufferedInputStream(is);
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                int result = bis.read();
                while (result != -1) {
                    byte b = (byte)result;
                    buf.write(b);
                    result = bis.read();
                }
                byte[] byArray = buf.toByteArray();
                return byArray;
            }
            try {
                throw new FormsPortalException("ALC-FMP-001-021");
            }
            catch (FormsPortalException e) {
                throw e;
            }
            catch (Exception e) {
                throw new FormsPortalException(e);
            }
        }
        finally {
            sysUserSession.logout();
        }
    }

    protected boolean deleteDataInternal(String userDataID) throws FormsPortalException {
        boolean status;
        block12: {
            status = false;
            boolean isAnonymous = this.portalUtilsComponent.isLoginAnonymous();
            Session currentSession = this.resourceResolverHelper.getResourceResolverAs(Session.class);
            String userName = this.resourceResolverHelper.getResourceResolver().getUserID();
            Session sysUserSession = null;
            if (StringUtils.isEmpty(userDataID)) {
                throw new FormsPortalException("ALC-FMP-001-016");
            }
            try {
                sysUserSession = PortalUtils.getFnDServiceUserSession(this.slingRepository);
                if (isAnonymous && userDataID.startsWith("/content/forms/fp/" + userName)) {
                    currentSession = sysUserSession;
                }
                RepositoryUtils repUtils = RepositoryUtils.getInstance(this.draftsandSubmissionConfiguration);
                Node userNode = repUtils.getUserNode(userName, false, currentSession);
                if ((sysUserSession.getUserID().equals(userName) || userNode != null) && currentSession.nodeExists(userDataID)) {
                    if (this.slingSettingService.getRunModes().contains("publish")) {
                        PortalUtils.reverseReplicate(sysUserSession, userDataID, ReplicationActionType.DELETE, this.replicator, this.draftsandSubmissionConfiguration.getFormsPortalOutboxes());
                    } else {
                        PortalUtils.replicate(sysUserSession, userDataID, ReplicationActionType.DELETE, this.replicator);
                    }
                    currentSession.getNode(userDataID).remove();
                    currentSession.save();
                    status = true;
                    break block12;
                }
                throw new FormsPortalException("ALC-FMP-001-013");
            }
            catch (FormsPortalException e) {
                throw e;
            }
            catch (Exception e) {
                throw new FormsPortalException(e);
            }
            finally {
                if (sysUserSession != null) {
                    sysUserSession.logout();
                }
            }
        }
        return status;
    }

    protected String saveAttachmentInternal(byte[] attachmentBytes, String ownerName) throws FormsPortalException {
        RepositoryUtils repUtils = RepositoryUtils.getInstance(this.draftsandSubmissionConfiguration);
        Session sysUserSession = null;
        try {
            sysUserSession = PortalUtils.getFnDServiceUserSession(this.slingRepository);
            Node userNode = null;
            userNode = repUtils.getUserNode(this.getUserName(sysUserSession, ownerName), true, sysUserSession);
            Node submitFolder = repUtils.getChildNode(userNode, this.instanceType, "sling:OrderedFolder", true);
            Node attachmentRootFolder = repUtils.getChildNode(submitFolder, "attachments", "sling:OrderedFolder", true);
            String currentAttachmentNodeName = this.fpKeyGeneratorService.getUniqueId();
            Node currentAttachmentNode = attachmentRootFolder.addNode(currentAttachmentNodeName, "{http://www.jcp.org/jcr/nt/1.0}unstructured");
            PropertyUtils.setBinaryValue(currentAttachmentNode, "jcr:data", attachmentBytes, sysUserSession.getValueFactory());
            String attachmentNodePath = currentAttachmentNode.getPath().toString();
            sysUserSession.save();
            if (this.slingSettingService.getRunModes().contains("publish")) {
                PortalUtils.reverseReplicate(sysUserSession, currentAttachmentNode.getPath().toString(), ReplicationActionType.ACTIVATE, this.replicator, this.draftsandSubmissionConfiguration.getFormsPortalOutboxes());
            }
            String string = attachmentNodePath;
            return string;
        }
        catch (FormsPortalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsPortalException(e);
        }
        finally {
            if (sysUserSession != null) {
                sysUserSession.logout();
            }
        }
    }

    public boolean deleteAttachment(String attachmentID) throws FormsPortalException {
        return this.deleteDataInternal(attachmentID);
    }

    public byte[] getAttachment(String attachmentID) throws FormsPortalException {
        return this.getDataInternal(attachmentID);
    }

    protected void updateLastModified(Node node) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Calendar lastModified = Calendar.getInstance();
        node.setProperty("jcr:lastModified", lastModified);
    }

    private String getUserName(Session sysUserSession, String userName) throws FormsPortalException {
        String currentUserName = this.resourceResolverHelper.getResourceResolver().getUserID();
        if (currentUserName.equals(sysUserSession.getUserID())) {
            currentUserName = userName;
        }
        return currentUserName;
    }

    protected void bindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        this.resourceResolverHelper = resourceResolverHelper;
    }

    protected void unbindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        if (this.resourceResolverHelper == resourceResolverHelper) {
            this.resourceResolverHelper = null;
        }
    }

    protected void bindDraftsandSubmissionConfiguration(FormsPortalDraftsandSubmissionConfigService formsPortalDraftsandSubmissionConfigService) {
        this.draftsandSubmissionConfiguration = formsPortalDraftsandSubmissionConfigService;
    }

    protected void unbindDraftsandSubmissionConfiguration(FormsPortalDraftsandSubmissionConfigService formsPortalDraftsandSubmissionConfigService) {
        if (this.draftsandSubmissionConfiguration == formsPortalDraftsandSubmissionConfigService) {
            this.draftsandSubmissionConfiguration = null;
        }
    }

    protected void bindSlingRepository(SlingRepository slingRepository) {
        this.slingRepository = slingRepository;
    }

    protected void unbindSlingRepository(SlingRepository slingRepository) {
        if (this.slingRepository == slingRepository) {
            this.slingRepository = null;
        }
    }

    protected void bindSlingSettingService(SlingSettingsService slingSettingsService) {
        this.slingSettingService = slingSettingsService;
    }

    protected void unbindSlingSettingService(SlingSettingsService slingSettingsService) {
        if (this.slingSettingService == slingSettingsService) {
            this.slingSettingService = null;
        }
    }

    protected void bindFpKeyGeneratorService(FPKeyGeneratorService fPKeyGeneratorService) {
        this.fpKeyGeneratorService = fPKeyGeneratorService;
    }

    protected void unbindFpKeyGeneratorService(FPKeyGeneratorService fPKeyGeneratorService) {
        if (this.fpKeyGeneratorService == fPKeyGeneratorService) {
            this.fpKeyGeneratorService = null;
        }
    }

    protected void bindReplicator(Replicator replicator) {
        this.replicator = replicator;
    }

    protected void unbindReplicator(Replicator replicator) {
        if (this.replicator == replicator) {
            this.replicator = null;
        }
    }

    protected void bindPortalUtilsComponent(PortalUtilsComponent portalUtilsComponent) {
        this.portalUtilsComponent = portalUtilsComponent;
    }

    protected void unbindPortalUtilsComponent(PortalUtilsComponent portalUtilsComponent) {
        if (this.portalUtilsComponent == portalUtilsComponent) {
            this.portalUtilsComponent = null;
        }
    }
}

