/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.fp.exception;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormsPortalException
extends Exception {
    private static final long serialVersionUID = -7363820328483991171L;
    private final Logger log = LoggerFactory.getLogger(FormsPortalException.class);
    private static final ResourceBundle RESOURCES = ResourceBundle.getBundle("errorMessages");
    private String code;
    private Object[] messageArgs;

    public FormsPortalException() {
    }

    public FormsPortalException(String code) {
        this.code = code;
    }

    public FormsPortalException(String code, Object[] args) {
        this.code = code;
        this.messageArgs = args;
    }

    public FormsPortalException(Throwable cause) {
        super(cause);
    }

    public FormsPortalException(String code, Throwable cause) {
        super(cause);
        this.code = code;
    }

    public FormsPortalException(String code, Throwable cause, Object[] args) {
        super(cause);
        this.code = code;
        this.messageArgs = args;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getMessage() {
        String message = null;
        try {
            if (this.code == null) {
                return super.getMessage();
            }
            String messageString = RESOURCES.getString(this.code);
            message = this.messageArgs != null ? this.fastFormat(messageString, this.messageArgs) : messageString;
        }
        catch (Exception e) {
            this.log.error("Exception caught in fetching error message ", e);
        }
        return this.code + (message == null ? "" : ": " + message);
    }

    public Object[] getMessageArgs() {
        return this.messageArgs;
    }

    public void setMessageArgs(Object[] messageArgs) {
        if (messageArgs != null) {
            this.messageArgs = Arrays.copyOf(messageArgs, messageArgs.length);
        }
    }

    protected String fastFormat(String msg, Object[] args) {
        try {
            if (args == null || args.length == 0) {
                return msg;
            }
            StringBuffer res = new StringBuffer();
            int pos = 0;
            int cursor = 0;
            int len = msg.length();
            while (cursor < len) {
                char c;
                if ((c = msg.charAt(cursor++)) == '{') {
                    String numStr;
                    int paramNum;
                    int loc = cursor;
                    while (cursor < len && msg.charAt(cursor) != '}') {
                        ++cursor;
                    }
                    if (cursor >= len) break;
                    if ((paramNum = Integer.parseInt(numStr = msg.substring(loc, cursor++))) >= args.length) continue;
                    res.append(msg.substring(pos, loc - 1));
                    if (args[paramNum] == null) {
                        res.append("null");
                    } else {
                        res.append(args[paramNum].toString());
                    }
                    pos = cursor;
                    continue;
                }
                if (c != '\'' || cursor >= len) continue;
                res.append(msg.substring(pos, cursor - 1));
                pos = cursor;
                c = msg.charAt(cursor++);
                if (c == '\'') {
                    res.append(c);
                } else {
                    while (cursor < len) {
                        if (msg.charAt(cursor++) != '\'') continue;
                        if (cursor >= len || msg.charAt(cursor) != '\'') break;
                        res.append(msg.substring(pos, cursor++));
                        pos = cursor;
                    }
                    int n = --cursor;
                    ++cursor;
                    res.append(msg.substring(pos, n));
                }
                pos = cursor;
            }
            if (pos < len) {
                res.append(msg.substring(pos, len));
            }
            return res.toString();
        }
        catch (NumberFormatException e) {
            this.log.debug("Ignore exception", e);
            return MessageFormat.format(msg, args);
        }
    }
}

